/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesiga_parser
(
  /* system */
  input  wire         rst_n,
  input  wire         clk,
  
  /* control */
  input  wire         enable,
  output reg          captured,
 
  input  wire [ 1:0]  lsig_length_mod3,
  input  wire         hesiga2_is_qbpsk,
  
  /* byte stream */
  output reg          bd_ready,
  input  wire [ 7:0]  bd_data,
  input  wire         bd_last,
  input  wire         bd_valid,
  
  /* parameters */
  output reg  [ 3:0]  format,
  output reg          beamchange,
  output reg          uplink,
  output reg  [ 3:0]  mcs,
  output reg  [ 2:0]  nbpsc,
  output reg  [ 1:0]  cr,
  output reg          dcm,
  output reg  [ 5:0]  bss_color,
  output reg  [ 3:0]  spatial_reuse1,
  output reg  [ 3:0]  spatial_reuse2,
  output reg  [ 3:0]  spatial_reuse3,
  output reg  [ 3:0]  spatial_reuse4,
  output reg  [ 2:0]  bandwidth,
  output reg  [ 2:0]  ru_len,
  output reg  [ 1:0]  gi_type,
  output reg  [ 1:0]  ltf_type,
  output reg  [ 2:0]  nsts,
  output reg  [ 2:0]  nheltf,
  output reg  [ 6:0]  txop,
  output reg          fec,
  output reg          extra,
  output reg          stbc,
  output reg          beamformed,
  output reg  [ 1:0]  a,
  output reg          pedisamb,
  output reg          doppler,
  output reg          midamble,
  
  output reg  [ 2:0]  sigb_mcs,
  output reg  [ 2:0]  sigb_nbpsc,
  output reg  [ 1:0]  sigb_cr,
  output reg  [ 7:0]  sigb_ndbps,
  output reg          sigb_dcm,
  output reg          sigb_compression,
  output reg  [ 2:0]  sigb_compression_nuser,
  output reg  [ 4:0]  sigb_nsym,              /* deciaml 0(compression), 1-16 */
  
  output reg          invalid_crc
  
);
  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  localparam  HE_SU=4'd5,
              HE_MU=4'd6,
              HE_ER_SU=4'd7,
              HE_TB=4'd8;
              
  localparam  GI_800=2'd1,
              GI_1600=2'd2,
              GI_3200=2'd3;            

  localparam  HELTF_1X=2'd0,
              HELTF_2X=2'd1,
              HELTF_4X=2'd2;            
 
  localparam  NSS_1=3'd0,
              NSS_2=3'd1,
              NSS_3=3'd2,
              NSS_4=3'd3,
              NSS_5=3'd4,
              NSS_6=3'd5,
              NSS_7=3'd6, 
              NSS_8=3'd7; 
 
  localparam  NSTS_1=3'd0,
              NSTS_2=3'd1,
              NSTS_3=3'd2,
              NSTS_4=3'd3,
              NSTS_5=3'd4,
              NSTS_6=3'd5,
              NSTS_7=3'd6, 
              NSTS_8=3'd7; 
  
  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5,
              RU_2X996=3'd6;
              
  /*****************************************************************************
  * CAPTURE
  *****************************************************************************/
  reg [55:0]  field;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready <= 1'b0;
      captured <= 1'b0;
      field    <= 56'b0;
    end
    else if(!enable)
    begin
      bd_ready <= 1'b0;
      captured <= 1'b0;
      field    <= 56'b0;
    end
    else
    begin
      /* capture */                     
      if(!captured)          
      begin   
        bd_ready <= 1'b1;
        if(bd_valid)
        begin                          
          field <= {bd_data,field[55:8]}; 
          if(bd_last)
            captured <= 1'b1;
        end                 
      end
      else
      begin
        bd_ready <= 1'b0;
      end
    end
  end

  /*****************************************************************************
  * HE_SU HE_ER_SU 
  *****************************************************************************/
  wire        su_beamchange;
  wire        su_uplink;
  wire [ 3:0] su_mcs;
  wire        su_dcm;
  wire [ 5:0] su_bss_color;
  wire        su_reserved14;
  wire [ 3:0] su_spatial_reuse;
  wire [ 1:0] su_bandwidth;
  reg  [ 1:0] su_gi_type;
  reg  [ 1:0] su_ltf_type;  
  reg  [ 2:0] su_nsts;  
  reg  [ 2:0] su_nheltf;  
  wire [ 6:0] su_txop;  
  wire        su_fec;  
  wire        su_extra;  
  wire        su_stbc;  
  wire        su_beamformed;  
  wire [ 1:0] su_a;  
  wire        su_pedisamb;  
  wire        su_doppler;  
  reg         su_midamble;
 
  assign su_beamchange       = field[1];
  assign su_uplink           = field[2];
  assign su_mcs              = field[6:3];
  assign su_dcm              = field[7];
  assign su_bss_color        = field[13:8];
  assign su_reserved14       = field[14];
  assign su_spatial_reuse    = field[18:15];
  assign su_bandwidth        = field[20:19];
  
  always @(*)
  begin
    case(field[22:21])
      2'd0:    {su_gi_type, su_ltf_type}   = {    GI_800, HELTF_1X};
      2'd1:    {su_gi_type, su_ltf_type}   = {    GI_800, HELTF_2X};
      2'd2:    {su_gi_type, su_ltf_type}   = {   GI_1600, HELTF_2X};
      default: if(su_dcm && su_stbc)
                 {su_gi_type, su_ltf_type} = {  GI_800, HELTF_4X};
               else
                 {su_gi_type, su_ltf_type} = { GI_3200, HELTF_4X};
    endcase
  end
  
  always @(*)
  begin
    if(!su_doppler)
    begin
      su_midamble = 1'b0;
      su_nsts     = field[25:23];  
      case(field[25:23])
        NSTS_1:  su_nheltf = 3'd0;
        NSTS_2:  su_nheltf = 3'd1;
        NSTS_3:  su_nheltf = 3'd3;
        NSTS_4:  su_nheltf = 3'd3;
        NSTS_5:  su_nheltf = 3'd5;
        NSTS_6:  su_nheltf = 3'd5;
        NSTS_7:  su_nheltf = 3'd7;
        default: su_nheltf = 3'd7;
      endcase
    end
    else
    begin
      su_midamble = field[25];
      su_nsts     = {1'b0,field[24:23]};
      case({1'b0,field[24:23]})
        NSTS_1:  su_nheltf = 3'd0;
        NSTS_2:  su_nheltf = 3'd1;
        NSTS_3:  su_nheltf = 3'd3;
        default: su_nheltf = 3'd3;
      endcase
    end
  end
  
  assign su_txop             = field[32:26];   
  assign su_fec              = field[33];      
  assign su_extra            = field[34];      
  assign su_stbc             = field[35];      
  assign su_beamformed       = field[36];      
  assign su_a                = field[38:37];   
  assign su_pedisamb         = field[39];      
  assign su_doppler          = field[41];      

  /*****************************************************************************
  * HE_MU
  *****************************************************************************/
  wire        mu_uplink;
  wire [ 2:0] mu_sigb_mcs;
  wire        mu_sigb_dcm;
  wire [ 5:0] mu_bss_color;
  wire [ 3:0] mu_spatial_reuse;
  wire [ 2:0] mu_bandwidth;
  wire [ 3:0] mu_sigb_nsym_nuser;
  wire        mu_sigb_compression;
  reg  [ 1:0] mu_gi_type; 
  reg  [ 1:0] mu_ltf_type; 
  wire        mu_doppler;
  reg         mu_midamble;
  wire [ 6:0] mu_txop;
  wire        mu_reserved33;
  reg  [ 2:0] mu_nheltf;
  wire        mu_extra;
  wire        mu_stbc;
  wire [ 1:0] mu_a;
  wire        mu_pedisamb;
  
  assign mu_uplink           = field[0];
  assign mu_sigb_mcs         = field[3:1];
  assign mu_sigb_dcm         = field[4];
  assign mu_bss_color        = field[10:5];
  assign mu_spatial_reuse    = field[14:11];
  assign mu_bandwidth        = field[17:15];
  assign mu_sigb_nsym_nuser  = field[21:18];
  assign mu_sigb_compression = field[22];
  
  always @(*)
  begin
    case(field[24:23])
      2'd0:    {mu_gi_type, mu_ltf_type} = {    GI_800, HELTF_4X};
      2'd1:    {mu_gi_type, mu_ltf_type} = {    GI_800, HELTF_2X};
      2'd2:    {mu_gi_type, mu_ltf_type} = {   GI_1600, HELTF_2X};
      default: {mu_gi_type, mu_ltf_type} = {   GI_3200, HELTF_4X};
    endcase
  end

  assign mu_doppler          = field[25];
  assign mu_txop             = field[32:26];
  assign mu_reserved33       = field[33];
  always @(*)
  begin
    if(!mu_doppler)
    begin
      mu_midamble = 1'b0;
      case(field[36:34])
        3'd0:     mu_nheltf = 3'd0;
        3'd1:     mu_nheltf = 3'd1;
        3'd2:     mu_nheltf = 3'd3;
        3'd3:     mu_nheltf = 3'd5;
        default:  mu_nheltf = 3'd7;
      endcase
    end
    else
    begin
      mu_midamble = field[36];
      case(field[35:34])
        2'd0:     mu_nheltf = 3'd0;
        2'd1:     mu_nheltf = 3'd1;
        default:  mu_nheltf = 3'd3;
      endcase
    end
  end
  
  assign mu_extra            = field[37];     
  assign mu_stbc             = field[38];     
  assign mu_a                = field[40:39];   
  assign mu_pedisamb         = field[41];     

  /*****************************************************************************
  * HE_TB
  *****************************************************************************/
  wire [ 5:0] tb_bss_color;      
  wire [ 3:0] tb_spatial_reuse1;
  wire [ 3:0] tb_spatial_reuse2; 
  wire [ 3:0] tb_spatial_reuse3; 
  wire [ 3:0] tb_spatial_reuse4; 
  wire [ 1:0] tb_bandwidth;      
  wire [ 6:0] tb_txop;           
 
  assign tb_bss_color        = field[ 6: 1];      
  assign tb_spatial_reuse1   = field[10: 7];      
  assign tb_spatial_reuse2   = field[14:11];      
  assign tb_spatial_reuse3   = field[18:15];      
  assign tb_spatial_reuse4   = field[22:19];      
  assign tb_bandwidth        = field[25:24];  
  assign tb_txop             = field[32:26];  

  /*****************************************************************************
  * MUX
  *****************************************************************************/
  reg  [ 4:0] mu_sigb_compression_nsym;
 
  always @(*)
  begin
    format                 = 5'd0;
    beamchange             = 1'b0;
    uplink                 = 1'b0;
    mcs                    = 4'b0;
    dcm                    = 1'b0;
    bss_color              = 6'b0;
    spatial_reuse1         = 4'b0;
    spatial_reuse2         = 4'b0;
    spatial_reuse3         = 4'b0;
    spatial_reuse4         = 4'b0;
    bandwidth              = 3'b0;
    ru_len                 = 3'd0;
    gi_type                = 2'b0;
    ltf_type               = 2'b0;
    nsts                   = 3'b0;
    nheltf                 = 3'b0;
    txop                   = 7'b0;
    fec                    = 1'b0;
    extra                  = 1'b0;
    stbc                   = 1'b0;
    beamformed             = 1'b0;
    a                      = 2'b0;
    pedisamb               = 1'b0;
    doppler                = 1'b0;
    midamble               = 1'b0;
    sigb_mcs               = 3'b0;
    sigb_dcm               = 1'b0;
    sigb_compression       = 1'b0;
    sigb_compression_nuser = 3'b0;
    sigb_nsym              = 5'b0;
    
    if(lsig_length_mod3==2'd1 && field[0])
    begin
      /* HE_SU */
      format           = HE_SU;
      beamchange       = su_beamchange;
      uplink           = su_uplink;
      mcs              = su_mcs;
      dcm              = su_dcm & ~su_stbc;
      bss_color        = su_bss_color;
      spatial_reuse1   = su_spatial_reuse;
      case(su_bandwidth)
        2'd0:    { bandwidth, ru_len} = {3'd0,   RU_242};
        2'd1:    { bandwidth, ru_len} = {3'd1,   RU_484};
        2'd2:    { bandwidth, ru_len} = {3'd2,   RU_996}; 
        default: { bandwidth, ru_len} = {3'd3, RU_2X996};
      endcase
      gi_type          = su_gi_type;
      ltf_type         = su_ltf_type;
      nsts             = su_nsts;
      nheltf           = su_nheltf;
      txop             = su_txop;
      fec              = su_fec;
      extra            = su_extra;
      stbc             = su_stbc & ~su_dcm;
      beamformed       = su_beamformed;
      a                = su_a;
      pedisamb         = su_pedisamb;
      doppler          = su_doppler;
      midamble         = su_midamble;
    end
    else if(lsig_length_mod3==2'd2 && hesiga2_is_qbpsk)
    begin
      /* HE_ER_SU */
      format           = HE_ER_SU;
      beamchange       = su_beamchange;
      uplink           = su_uplink;
      mcs              = su_mcs;
      dcm              = su_dcm & ~su_stbc;
      bss_color        = su_bss_color;
      spatial_reuse1   = su_spatial_reuse;
      case(su_bandwidth)
        2'd0:    { bandwidth, ru_len} = {3'd0,   RU_242};
        2'd1:    { bandwidth, ru_len} = {3'd1,   RU_484};
        2'd2:    { bandwidth, ru_len} = {3'd2,   RU_996}; 
        default: { bandwidth, ru_len} = {3'd3, RU_2X996};
      endcase
      gi_type          = su_gi_type;
      ltf_type         = su_ltf_type;
      nsts             = su_nsts;
      nheltf           = su_nheltf;
      txop             = su_txop;
      fec              = su_fec;
      extra            = su_extra;
      stbc             = su_stbc & ~su_dcm;
      beamformed       = su_beamformed;
      a                = su_a;
      pedisamb         = su_pedisamb;
      doppler          = su_doppler;
      midamble         = su_midamble;
    end
    else if(lsig_length_mod3==2'd1)
    begin
      /* HE_TB */
      format           = HE_TB;
      bss_color        = tb_bss_color;
      spatial_reuse1   = tb_spatial_reuse1;
      spatial_reuse2   = tb_spatial_reuse2;
      spatial_reuse3   = tb_spatial_reuse3;
      spatial_reuse4   = tb_spatial_reuse4;
      bandwidth        = {1'b0,tb_bandwidth};
      txop             = tb_txop;
    end
    else
    begin 
      /* HE_MU */
      format                 = HE_MU;
      uplink                 = mu_uplink;
      sigb_mcs               = mu_sigb_mcs;  
      sigb_dcm               = mu_sigb_dcm;
      bss_color              = mu_bss_color;
      spatial_reuse1         = mu_spatial_reuse;
      bandwidth              = mu_bandwidth;
      sigb_compression       = mu_sigb_compression;
      if(mu_sigb_compression)
      begin
        sigb_compression_nuser = mu_sigb_nsym_nuser[2:0];
        sigb_nsym              = mu_sigb_compression_nsym;
      end
      else
      begin
        sigb_compression_nuser = 3'd0;
        sigb_nsym              = {1'b0,mu_sigb_nsym_nuser}+5'd1;
      end
      gi_type          = mu_gi_type;
      ltf_type         = mu_ltf_type;
      doppler          = mu_doppler;
      midamble         = mu_midamble;
      txop             = mu_txop;
      nheltf           = mu_nheltf;
      extra            = mu_extra;     
      stbc             = mu_stbc;     
      a                = mu_a;   
      pedisamb         = mu_pedisamb;
    end     
  end
 
  /*****************************************************************************
  * MCS
  *****************************************************************************/
  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;  

  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
              
  always @(*)
  begin
    case(su_mcs)
      4'd0:   {nbpsc, cr} = {NBPSC_1,  CR_12};
      4'd1:   {nbpsc, cr} = {NBPSC_2,  CR_12};
      4'd2:   {nbpsc, cr} = {NBPSC_2,  CR_34};
      4'd3:   {nbpsc, cr} = {NBPSC_4,  CR_12};
      4'd4:   {nbpsc, cr} = {NBPSC_4,  CR_34};
      4'd5:   {nbpsc, cr} = {NBPSC_6,  CR_23};
      4'd6:   {nbpsc, cr} = {NBPSC_6,  CR_34};
      4'd7:   {nbpsc, cr} = {NBPSC_6,  CR_56};
      4'd8:   {nbpsc, cr} = {NBPSC_8,  CR_34};
      4'd9:   {nbpsc, cr} = {NBPSC_8,  CR_56};
      4'd10:  {nbpsc, cr} = {NBPSC_10, CR_34};
      default:{nbpsc, cr} = {NBPSC_10, CR_56};
    endcase
    case({mu_sigb_dcm,mu_sigb_mcs})
      {1'b0,3'd0}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_1,  CR_12, 8'd26  };
      {1'b0,3'd1}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_2,  CR_12, 8'd52  };
      {1'b0,3'd2}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_2,  CR_34, 8'd78  };
      {1'b0,3'd3}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_4,  CR_12, 8'd104 };
      {1'b0,3'd4}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_4,  CR_34, 8'd156 };
      {1'b0,3'd5}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_6,  CR_23, 8'd208 };
      
      {1'b1,3'd0}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_1,  CR_12, 8'd13  };
      {1'b1,3'd1}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_2,  CR_12, 8'd26  };
      {1'b1,3'd2}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_2,  CR_34, 8'd39  };
      {1'b1,3'd3}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_4,  CR_12, 8'd52  };
      {1'b1,3'd4}:   {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_4,  CR_34, 8'd78  };
      default:       {sigb_nbpsc, sigb_cr, sigb_ndbps} = {NBPSC_6,  CR_23, 8'd104 };
    endcase
  end
 
 
  /*****************************************************************************
  * SIGB_NSYM WITH COMPRESSION
  *****************************************************************************/
  localparam  LEN_31=3'd0,
              LEN_52=3'd1,
              LEN_83=3'd2,
              LEN_104=3'd3,
              LEN_135=3'd4,
              LEN_156=3'd5,
              LEN_187=3'd6,
              LEN_208=3'd7;
  
  reg  [ 2:0] mu_sigb_fieldlen;
  reg  [29:0] mu_sigb_nsym_lut;       
  
  always @(*)
  begin
    /* longest channel content */
    if(mu_bandwidth==3'd0)
    begin
      case(mu_sigb_nsym_nuser)                 /* nuser    ch0 fieldlen  ch1 fieldlen */
        4'd0:    mu_sigb_fieldlen = LEN_31;    /* 1 user    31           na           */ 
        4'd1:    mu_sigb_fieldlen = LEN_52;    /* 2 user  1*52           na           */ 
        4'd2:    mu_sigb_fieldlen = LEN_83;    /* 3 user  1*52+31        na           */
        4'd3:    mu_sigb_fieldlen = LEN_104;   /* 4 user  2*52           na           */
        4'd4:    mu_sigb_fieldlen = LEN_135;   /* 5 user  2*52+31        na           */
        4'd5:    mu_sigb_fieldlen = LEN_156;   /* 6 user  3*52           na           */
        4'd6:    mu_sigb_fieldlen = LEN_187;   /* 7 user  3*52+31        na           */
        default: mu_sigb_fieldlen = LEN_208;   /* 8 user  4*52           na           */
      endcase
    end
    else
    begin
      case(mu_sigb_nsym_nuser)
        4'd0:    mu_sigb_fieldlen = LEN_31;     /* 1 user    31          0            */ 
        4'd1:    mu_sigb_fieldlen = LEN_31;     /* 2 user    31          31           */ 
        4'd2:    mu_sigb_fieldlen = LEN_52;     /* 3 user  1*52          31           */
        4'd3:    mu_sigb_fieldlen = LEN_52;     /* 4 user  1*52        1*52           */
        4'd4:    mu_sigb_fieldlen = LEN_83;     /* 5 user  1*52+31     1*52           */
        4'd5:    mu_sigb_fieldlen = LEN_83;     /* 6 user  1*52+31     1*52+31        */
        4'd6:    mu_sigb_fieldlen = LEN_104;    /* 7 user  2*52        1*52+31        */
        default: mu_sigb_fieldlen = LEN_104;    /* 8 user  2*52        2*52           */
      endcase
    end
    
    /* sigb_nsym table               mcs=    5     4     3     2     1     0 */
    case({mu_sigb_fieldlen,mu_sigb_dcm}) 
      { LEN_31, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd1, 5'd1, 5'd0, 5'd2, 5'd3};
      { LEN_52, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd1, 5'd1, 5'd0, 5'd2, 5'd4};
      { LEN_83, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd2, 5'd2, 5'd0, 5'd4, 5'd7};
      {LEN_104, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd2, 5'd2, 5'd0, 5'd4, 5'd8};
      {LEN_135, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd2, 5'd3, 5'd0, 5'd6,5'd11};
      {LEN_156, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd2, 5'd3, 5'd0, 5'd6,5'd12};
      {LEN_187, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd3, 5'd4, 5'd0, 5'd8,5'd15};
      {LEN_208, 1'd1}: mu_sigb_nsym_lut = { 5'd0, 5'd3, 5'd4, 5'd0, 5'd8,5'd16};
   
      { LEN_31, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd1, 5'd1, 5'd1, 5'd2}; 
      { LEN_52, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd1, 5'd1, 5'd1, 5'd2}; 
      { LEN_83, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd1, 5'd2, 5'd2, 5'd4}; 
      {LEN_104, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd1, 5'd2, 5'd2, 5'd4}; 
      {LEN_135, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd2, 5'd2, 5'd3, 5'd6}; 
      {LEN_156, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd1, 5'd2, 5'd2, 5'd3, 5'd6}; 
      {LEN_187, 1'd0}: mu_sigb_nsym_lut = { 5'd1, 5'd2, 5'd2, 5'd3, 5'd4, 5'd8}; 
      default:         mu_sigb_nsym_lut = { 5'd1, 5'd2, 5'd2, 5'd3, 5'd4, 5'd8}; 
    endcase

    /* sigb nsym  versus  mcs */
    case(mu_sigb_mcs)
      3'd0:    mu_sigb_compression_nsym = mu_sigb_nsym_lut[ 4: 0];
      3'd1:    mu_sigb_compression_nsym = mu_sigb_nsym_lut[ 9: 5];
      3'd2:    mu_sigb_compression_nsym = mu_sigb_nsym_lut[14:10];
      3'd3:    mu_sigb_compression_nsym = mu_sigb_nsym_lut[19:15];
      3'd4:    mu_sigb_compression_nsym = mu_sigb_nsym_lut[24:20];
      default: mu_sigb_compression_nsym = mu_sigb_nsym_lut[29:25];
    endcase
      
  end

  /*****************************************************************************
  * CRC
  *****************************************************************************/
  always @(*)
  begin:b_crc
    integer   i;
    reg [7:0] v;
    v=8'hff;
    for(i=0;i<42;i=i+1) 
      v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
    invalid_crc = (~{v[4],v[5],v[6],v[7]}) != field[45:42];
  end  
  
endmodule
`default_nettype wire
