/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesigb_common_dec
(
  input  wire [ 2:0]  bandwidth,
  input  wire [36:0]  field,
  
  output reg  [ 5:0]  field_length,
  output reg  [ 2:0]  nrualloc,
  output reg  [ 7:0]  rualloc0,
  output reg  [ 7:0]  rualloc1,
  output reg  [ 7:0]  rualloc2,
  output reg  [ 7:0]  rualloc3,
  output reg          center,
  output reg          invalid_crc
);

  always @(*)
  begin:b_sigb_common_field_decoder

    integer   i;
    reg [7:0] v;
    
    v  = 8'hff;
    case(bandwidth)
      /*************************************************************************
      * 20M, 40M HE MU PPDU
      *************************************************************************/
      3'd0,3'd1:
      begin
        nrualloc     = 3'd1;
        field_length = 6'd18;
        rualloc0     = field[7:0];
        rualloc1     = 8'd0;
        rualloc2     = 8'd0;
        rualloc3     = 8'd0; 
        center       = 1'b0;
        for(i=0;i<8;i=i+1) v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
        invalid_crc  = ~{v[4],v[5],v[6],v[7]} != field[11:8];
      end
      /*************************************************************************
      * 80M HE MU PPD 
      *************************************************************************/
      3'd2,3'd4,3'd5:
      begin
        nrualloc     = 3'd2;
        field_length = 6'd27;
        rualloc0     = field[ 7: 0];
        rualloc1     = field[15: 8];
        rualloc2     = 8'd0;
        rualloc3     = 8'd0; 
        center       = field[16];
        for(i=0;i<17;i=i+1) v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
        invalid_crc  = ~{v[4],v[5],v[6],v[7]} != field[20:17];
      end
      /*************************************************************************
      * 160M,80+80M HE MU PPD 
      *************************************************************************/
      default:
      begin
        nrualloc     = 3'd4;
        field_length = 6'd43;
        rualloc0 = field[ 7: 0];
        rualloc1 = field[15: 8];
        rualloc2 = field[23:16];
        rualloc3 = field[31:24];
        center   = field[32];
        for(i=0;i<33;i=i+1) v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
        invalid_crc = ~{v[4],v[5],v[6],v[7]} != field[36:33];
      end
    endcase
  end

endmodule
`default_nettype wire
