/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesigb_parser
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,

  /* configuration */
  input  wire [ 2:0] mdmcfg_conf_primary,
  input  wire [ 1:0] mdmcfg_conf_bw,
  
  /* control */
  input  wire        enable,
  input  wire        compression,
  input  wire [ 2:0] compression_nuser,
  
  input  wire [ 2:0] frame_bandwidth,
  output reg         ch0_done,
  output reg         ch1_done,
 
  /* byte stream */
  output reg         bd_ready,
  input  wire [ 7:0] bd_data,
  input  wire        bd_last,
  input  wire        bd_valid,
  
  /* data path control */
  output reg         bd_ch0_field_start,
  output reg         bd_ch1_field_start,
  output reg  [ 5:0] bd_field_length,
  
  /* user info */
  output wire        user_valid,
  output wire [10:0] staid,
  output wire        ru_segment,
  output wire [ 2:0] ru_len,
  output wire [ 5:0] ru_index,
  output wire [ 3:0] ru_nuser,
  output wire [ 2:0] ru_user,
  output wire        beamformed,
  output wire [ 3:0] mcs,
  output wire [ 2:0] nbpsc,
  output wire [ 1:0] cr,
  output wire        dcm,
  output wire        fec,
  output wire [ 2:0] nsts,
  output wire [ 2:0] nsts_prev,
  output wire [ 2:0] nsts_tot
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  localparam  IDLE=4'd0,
              
              FETCH_CH0_COMMON=4'd1,
              SUM_CH0_NUSER=4'd2,
              FETCH_CH0_UBLOCK=4'd3,
              DECODE_CH0_USER=4'd4,
             
              FETCH_CH1_COMMON=4'd5,
              SUM_CH1_NUSER=4'd6,
              FETCH_CH1_UBLOCK=4'd7,
              DECODE_CH1_USER=4'd8,
           
              DONE=4'd9;

  /* fsm */
  reg  [ 3:0] state;
  reg         field_run;
  
  /* bit field */
  reg  [51:0] field;
  reg         field_captured;
  
  /* general counter */
  wire [ 2:0] n_count;
  reg  [ 2:0] count;
  
  /* pointer on the current content channel */
  reg         ch_ptr;
  wire [ 2:0] n_rualloc_ptr;
  reg  [ 1:0] rualloc_ptr;
  wire        center;
  
  /* number of users within a channel content */
  wire [ 7:0] n_ch0_nuser, n_ch1_nuser;    
  reg  [ 7:0] ch0_nuser, ch1_nuser;
  
  /* user pointer within the channel content */
  reg  [ 7:0] ch0_user_ptr, ch1_user_ptr; 
  wire [ 7:0] n_ch0_user_ptr, n_ch1_user_ptr; 
 
  /* number of user within the rualloc byte [0-16]*/
  reg  [ 4:0] ch0_rualloc0_nuser, ch1_rualloc0_nuser;   
  reg  [ 4:0] ch0_rualloc1_nuser, ch1_rualloc1_nuser;   
  reg  [ 4:0] ch0_rualloc2_nuser, ch1_rualloc2_nuser;   
  reg  [ 4:0] ch0_rualloc3_nuser, ch1_rualloc3_nuser;   
  
  /* position of the user within the rualloc byte [0-16] */
  reg  [ 4:0] ch0_rualloc_user_ptr, ch1_rualloc_user_ptr;
 
  /* common fields registers  */
  reg  [ 2:0] ch0_nrualloc, ch1_nrualloc;
  reg  [ 7:0] ch0_rualloc0, ch1_rualloc0; 
  reg  [ 7:0] ch0_rualloc1, ch1_rualloc1; 
  reg  [ 7:0] ch0_rualloc2, ch1_rualloc2; 
  reg  [ 7:0] ch0_rualloc3, ch1_rualloc3;
  reg         ch0_center,   ch1_center;
 
  /* common field decoder */
  wire [ 5:0] dec_common_field_length;
  wire [ 2:0] dec_common_nrualloc;
  wire [ 7:0] dec_common_rualloc0; 
  wire [ 7:0] dec_common_rualloc1;
  wire [ 7:0] dec_common_rualloc2; 
  wire [ 7:0] dec_common_rualloc3;
  wire        dec_common_center;
  wire        dec_common_invalid_crc;
  
  /* rualloc bytes decoder */
  wire [ 4:0] dec_rualloc_nuser;
  wire [ 3:0] dec_rualloc_ru_nuser;
  wire        dec_rualloc_ru_segment;
  wire [ 2:0] dec_rualloc_ru_len;
  wire [ 5:0] dec_rualloc_ru_index;
  wire [ 2:0] dec_rualloc_ru_user; 
  
  /* user block decoder */
  wire        dec_ublock_invalid_crc;

  assign n_count             = count              + 3'd1;
 
  assign n_rualloc_ptr       = {1'b0,rualloc_ptr} + 3'd1;
  
  assign n_ch0_nuser         = ch0_nuser    + {3'b0,dec_rualloc_nuser};
  assign n_ch1_nuser         = ch1_nuser    + {3'b0,dec_rualloc_nuser};

  assign n_ch0_user_ptr      = ch0_user_ptr + 8'd1;
  assign n_ch1_user_ptr      = ch1_user_ptr + 8'd1;

  /* number of users within the current user block  [0,1]    */
  wire   ch0_ublock_nuser;   
  wire   ch1_ublock_nuser;    
  
  /* determine if the last user block contains 1 or 2 user field */
  assign ch0_ublock_nuser = !ch0_nuser[0] || !(ch0_nuser[7:1] == ch0_user_ptr[7:1]);
  assign ch1_ublock_nuser = !ch1_nuser[0] || !(ch1_nuser[7:1] == ch1_user_ptr[7:1]);

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready             <= 1'b0;
      bd_ch0_field_start   <= 1'b0;
      bd_ch1_field_start   <= 1'b0;
      bd_field_length      <= 6'd0;
     
      state                <= IDLE;
      field                <= 52'b0;
      field_run            <= 1'b0;
      field_captured       <= 1'b0;
      count                <= 3'd0;
      ch_ptr               <= 1'b0;
      rualloc_ptr          <= 2'b0;
      
      ch0_user_ptr         <= 8'b0;
      ch0_nuser            <= 8'b0;
      ch0_rualloc_user_ptr <= 5'd0;
      ch0_nrualloc         <= 3'd0;
      ch0_rualloc0         <= 8'd0;
      ch0_rualloc1         <= 8'd0;
      ch0_rualloc2         <= 8'd0;
      ch0_rualloc3         <= 8'd0;
      ch0_rualloc0_nuser   <= 8'd0;
      ch0_rualloc1_nuser   <= 8'd0;
      ch0_rualloc2_nuser   <= 8'd0;
      ch0_rualloc3_nuser   <= 8'd0;
      ch0_center           <= 1'b0;
      ch0_done             <= 1'b0;
     
      ch1_user_ptr         <= 8'b0;
      ch1_nuser            <= 8'b0;
      ch1_rualloc_user_ptr <= 5'd0;
      ch1_nrualloc         <= 3'd0;
      ch1_rualloc0         <= 8'd0;
      ch1_rualloc1         <= 8'd0;
      ch1_rualloc2         <= 8'd0;
      ch1_rualloc3         <= 8'd0;
      ch1_rualloc0_nuser   <= 8'd0;
      ch1_rualloc1_nuser   <= 8'd0;
      ch1_rualloc2_nuser   <= 8'd0;
      ch1_rualloc3_nuser   <= 8'd0;
      ch1_center           <= 1'b0;
      ch1_done             <= 1'b0;
    end                  
    else if(!enable)
    begin
      bd_ready             <= 1'b0;
      bd_ch0_field_start   <= 1'b0;
      bd_ch1_field_start   <= 1'b0;
      bd_field_length      <= 6'd0;
     
      state                <= IDLE;
      field                <= 52'b0;
      field_run            <= 1'b0;
      field_captured       <= 1'b0;
      count                <= 3'd0;
      ch_ptr               <= 1'b0;
      rualloc_ptr          <= 2'b0;
      
      ch0_user_ptr         <= 8'b0;
      ch0_nuser            <= 8'b0;
      ch0_rualloc_user_ptr <= 5'd0;
      ch0_nrualloc         <= 3'd0;
      ch0_rualloc0         <= 8'd0;
      ch0_rualloc1         <= 8'd0;
      ch0_rualloc2         <= 8'd0;
      ch0_rualloc3         <= 8'd0;
      ch0_rualloc0_nuser   <= 8'd0;
      ch0_rualloc1_nuser   <= 8'd0;
      ch0_rualloc2_nuser   <= 8'd0;
      ch0_rualloc3_nuser   <= 8'd0;
      ch0_center           <= 1'b0;
      ch0_done             <= 1'b0;
     
      ch1_user_ptr         <= 8'b0;
      ch1_nuser            <= 8'b0;
      ch1_rualloc_user_ptr <= 5'd0;
      ch1_nrualloc         <= 3'd0;
      ch1_rualloc0         <= 8'd0;
      ch1_rualloc1         <= 8'd0;
      ch1_rualloc2         <= 8'd0;
      ch1_rualloc3         <= 8'd0;
      ch1_rualloc0_nuser   <= 8'd0;
      ch1_rualloc1_nuser   <= 8'd0;
      ch1_rualloc2_nuser   <= 8'd0;
      ch1_rualloc3_nuser   <= 8'd0;
      ch1_center           <= 1'b0;
      ch1_done             <= 1'b0;
    end
    else
    begin
      /*************************************************************************
      * CAPTURE
      *************************************************************************/
      if(bd_ready && bd_valid && (!ch0_done || !ch1_done))
      begin
        count <= n_count;
        case(count)
          3'd0:    field <= {44'b0,             bd_data};
          3'd1:    field <= {36'b0, bd_data,field[ 7:0]};
          3'd2:    field <= {28'b0, bd_data,field[15:0]};
          3'd3:    field <= {20'b0, bd_data,field[23:0]};
          3'd4:    field <= {12'b0, bd_data,field[31:0]};
          3'd5:    field <= { 4'b0, bd_data,field[39:0]};
          default: field <= {  bd_data[3:0],field[47:0]};
        endcase
        if(bd_last)
          field_captured <= 1'b1;
      end
      
      /*************************************************************************
      * FSM
      *************************************************************************/
      bd_ch0_field_start <= 1'b0;
      bd_ch1_field_start <= 1'b0;
      
      case(state)
        /***********************************************************************
        * IDLE
        ***********************************************************************/
        IDLE:
        begin
          bd_ready     <= 1'b1;
          ch0_user_ptr <= 8'd0;
          ch1_user_ptr <= 8'd0;
          
          ch0_rualloc1 <= 8'd0;
          ch0_rualloc2 <= 8'd0;
          ch0_rualloc3 <= 8'd0;
          ch0_center   <= 1'b0;
          
          if(!compression)
          begin
            if(frame_bandwidth==2'd0)
            begin
              /* HEMU20, only ch0 available */
              state    <= FETCH_CH0_COMMON;
              ch1_done <= 1'b1;
            end
            else if(mdmcfg_conf_bw==2'd0)
            begin
              /* hEMU>20 and CONF_BW=20, select channel cotnent according primary */
              if(!mdmcfg_conf_primary[0])
              begin
                /* ch0 in primary */
                state    <= FETCH_CH0_COMMON;
                ch1_done <= 1'b1;
              end
              else
              begin
                /* ch1 in primary */
                state    <= FETCH_CH1_COMMON;
                ch0_done <= 1'b1;
              end 
            end
            else
            begin
              /* both channel content available */
              state    <= FETCH_CH0_COMMON;
            end
          end
          else
          begin
            /* NO COMMNON FIELD PRESENT */
            if(frame_bandwidth==3'd0)
            begin
              ch0_rualloc0_nuser <= 5'd0;
              case(compression_nuser)
                3'd0:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd1};
                3'd1:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd2};
                3'd2:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd3};
                3'd3:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd4};
                3'd4:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd5};
                3'd5:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd6};
                3'd6:    {ch1_nuser,ch0_nuser} <= {8'd0, 8'd7};
                default: {ch1_nuser,ch0_nuser} <= {8'd0, 8'd8};
              endcase
            end
            else
            begin
              case(compression_nuser)
                3'd0:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd0, 8'd1, 5'd1};
                3'd1:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd1, 8'd1, 5'd1};
                3'd2:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd1, 8'd2, 5'd2};
                3'd3:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd2, 8'd2, 5'd2};
                3'd4:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd2, 8'd3, 5'd3};
                3'd5:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd3, 8'd3, 5'd3};
                3'd6:    {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd3, 8'd4, 5'd4};
                default: {ch1_nuser,ch0_nuser,ch0_rualloc0_nuser} <= {8'd4, 8'd4, 5'd4};
              endcase
            end
            
            ch0_nrualloc <= 3'd1;
            case(frame_bandwidth)
              3'd0:    ch0_rualloc0 <= {5'b11000,compression_nuser};
              3'd1:    ch0_rualloc0 <= {5'b11001,compression_nuser};
              default: ch0_rualloc0 <= {5'b11010,compression_nuser};
            endcase
            ch0_rualloc1       <= 8'h71;
            ch0_rualloc2       <= 8'h71;
            ch0_rualloc3       <= 8'h71;
            ch0_rualloc1_nuser <= 5'd0;
            ch0_rualloc2_nuser <= 5'd0;
            ch0_rualloc3_nuser <= 5'd0;
           
            ch1_nrualloc <= 3'd1;
            case(frame_bandwidth)
              3'd0:    ch1_rualloc0 <= {5'b11000,compression_nuser};
              3'd1:    ch1_rualloc0 <= {5'b11001,compression_nuser};
              default: ch1_rualloc0 <= {5'b11010,compression_nuser};
            endcase
            ch1_rualloc1       <= 8'h71;
            ch1_rualloc2       <= 8'h71;
            ch1_rualloc3       <= 8'h71;
            ch1_rualloc0_nuser <= 5'd0;
            ch1_rualloc1_nuser <= 5'd0;
            ch1_rualloc2_nuser <= 5'd0;
            ch1_rualloc3_nuser <= 5'd0;
            
            rualloc_ptr        <= 2'd0;
            field_run          <= 1'b0;
            ch_ptr             <= 1'b0;
            state              <= FETCH_CH0_UBLOCK;
            
          end
        end
        /***********************************************************************
        * FETCH_CH0_COMMON: fetch and extract channel content common field 
        ***********************************************************************/
        FETCH_CH0_COMMON:
        begin
          if(!field_run)
          begin
            count              <= 3'd0;
            field_captured     <= 1'b0;
            bd_field_length    <= dec_common_field_length;
            bd_ch0_field_start <= 1'b1;
            field_run          <= 1'b1;
            ch_ptr             <= 1'b0;
          end
          else if(field_captured)
          begin
            field_run      <= 1'b0;
            field_captured <= 1'b0;
            ch0_nrualloc   <= dec_common_nrualloc;
            ch0_rualloc0   <= dec_common_rualloc0;
            ch0_rualloc1   <= dec_common_rualloc1;
            ch0_rualloc2   <= dec_common_rualloc2;
            ch0_rualloc3   <= dec_common_rualloc3;
            ch0_center     <= dec_common_center;
            ch0_done       <= dec_common_invalid_crc;
            if(dec_common_invalid_crc)
            begin
              if(ch1_done)
                state <= DONE;
              else
                state <= FETCH_CH1_COMMON;
            end
            else
            begin
              state <= SUM_CH0_NUSER;
            end
          end
        end
        /***********************************************************************
        * SUM_CH0_NUSER: compute the number of user per channel 
        ***********************************************************************/
        SUM_CH0_NUSER:
        begin
          /* compute total user for ch0 */
          if(!field_run)
          begin
            ch0_nuser          <= ch0_center?8'd1:8'd0;
            ch_ptr             <= 1'b0;
            rualloc_ptr        <= 3'd0;
            ch0_rualloc0_nuser <= 7'd0;
            ch0_rualloc1_nuser <= 7'd0; 
            ch0_rualloc2_nuser <= 7'd0; 
            ch0_rualloc3_nuser <= 7'd0; 
            field_run          <= 1'b1;
          end
          else
          begin
            ch0_nuser <= n_ch0_nuser;
            rualloc_ptr <= n_rualloc_ptr[1:0];
            case(rualloc_ptr)
              2'd0:    ch0_rualloc0_nuser <= dec_rualloc_nuser;
              2'd1:    ch0_rualloc1_nuser <= dec_rualloc_nuser;
              2'd2:    ch0_rualloc2_nuser <= dec_rualloc_nuser;
              default: ch0_rualloc3_nuser <= dec_rualloc_nuser;
            endcase
            if(n_rualloc_ptr==ch0_nrualloc)
            begin
              field_run       <= 1'b0;
              if(!ch1_done)
                state <= FETCH_CH1_COMMON;
              else
                state <= FETCH_CH0_UBLOCK;
            end
          end
        end
        /***********************************************************************
        * FETCH_CH1_COMMON: fetch and extract channel content common field 
        ***********************************************************************/
        FETCH_CH1_COMMON:
        begin
          if(!field_run)
          begin
            count              <= 3'd0;
            field_captured     <= 1'b0;
            bd_field_length    <= dec_common_field_length;
            bd_ch1_field_start <= 1'b1;
            field_run          <= 1'b1;
            ch_ptr             <= 1'b1;
          end
          else if(field_captured)
          begin
            field_run      <= 1'b0;
            field_captured <= 1'b0;
            ch1_nrualloc   <= dec_common_nrualloc;
            ch1_rualloc0   <= dec_common_rualloc0;
            ch1_rualloc1   <= dec_common_rualloc1;
            ch1_rualloc2   <= dec_common_rualloc2;
            ch1_rualloc3   <= dec_common_rualloc3;
            ch1_center     <= dec_common_center;
            ch1_done       <= dec_common_invalid_crc;
            if(dec_common_invalid_crc)
            begin
              if(ch0_done)
                state <= DONE;
              else
                state <= FETCH_CH0_UBLOCK;
            end
            else
            begin
              state <= SUM_CH1_NUSER;
            end
          end
        end
        /***********************************************************************
        * SUM_CH1_NUSER: compute the number of user per channel 
        ***********************************************************************/
        SUM_CH1_NUSER:
        begin
          /* compute total user for ch1 */
          if(!field_run)
          begin
            ch1_nuser          <= ch1_center?8'd1:8'd0;
            ch_ptr             <= 1'b1;
            rualloc_ptr        <= 3'd0;
            ch1_rualloc0_nuser <= 7'd0;
            ch1_rualloc1_nuser <= 7'd0; 
            ch1_rualloc2_nuser <= 7'd0; 
            ch1_rualloc3_nuser <= 7'd0; 
            field_run          <= 1'b1;
          end
          else
          begin
            ch1_nuser   <= n_ch1_nuser;
            rualloc_ptr <= n_rualloc_ptr[1:0];
            case(rualloc_ptr)
              2'd0:    ch1_rualloc0_nuser <= dec_rualloc_nuser;
              2'd1:    ch1_rualloc1_nuser <= dec_rualloc_nuser;
              2'd2:    ch1_rualloc2_nuser <= dec_rualloc_nuser;
              default: ch1_rualloc3_nuser <= dec_rualloc_nuser;
            endcase
            if(n_rualloc_ptr==ch1_nrualloc)
            begin
              field_run       <= 1'b0;
              if(!ch0_done)
                state <= FETCH_CH0_UBLOCK;
              else
                state <= FETCH_CH1_UBLOCK;
            end
          end
        end
        
        /***********************************************************************
        * FETCH_CH0_UBLOCK:
        ***********************************************************************/
        FETCH_CH0_UBLOCK:
        begin
          if(!field_run)
          begin
            ch_ptr <= 1'b0;
            count  <= 3'd0;
            if(ch0_user_ptr==ch0_nuser)
            begin
              /* ch0 completely parsed */
              ch0_done <= 1'b1;
              if(!ch1_done)
                state <= FETCH_CH1_UBLOCK;
              else
                state <= DONE;
            end
            else
            begin
              field_run          <= 1'b1;
              bd_ch0_field_start <= 1'b1;
              if(!ch0_ublock_nuser)
                /* next user block has 1 user */
                bd_field_length    <= 6'd31;
              else
                /* next user block has 2 user */
                bd_field_length    <= 6'd52;
            end
          end
          else if(field_captured)
          begin
            field_run      <= 1'b0;
            field_captured <= 1'b0;
            state          <= DECODE_CH0_USER;
          end
        end
       
        /***********************************************************************
        * FETCH_CH1_UBLOCK:
        ***********************************************************************/
        FETCH_CH1_UBLOCK:
        begin
          if(!field_run)
          begin
            ch_ptr <= 1'b1;
            count  <= 3'd0;
            if(ch1_user_ptr==ch1_nuser)
            begin
              /* ch1 completely parsed */
              ch1_done <= 1'b1;
              if(!ch0_done)
                state <= FETCH_CH0_UBLOCK;
              else
                state <= DONE;
            end
            else
            begin
              field_run          <= 1'b1;
              bd_ch1_field_start <= 1'b1;
              if(!ch1_ublock_nuser)
                /* next user block has 1 user */
                bd_field_length    <= 6'd31;
              else
                /* next user block has 2 user */
                bd_field_length    <= 6'd52;
            end
          end
          else if(field_captured)
          begin
            field_run      <= 1'b0;
            field_captured <= 1'b0;
            state          <= DECODE_CH1_USER;
          end
        end
      
        /***********************************************************************
        * DECODE_CH0_USER:
        ***********************************************************************/
        DECODE_CH0_USER:
        begin
          if(ch0_user_ptr[0] || !ch0_ublock_nuser)
          begin
            if(!ch1_done)
              state <= FETCH_CH1_UBLOCK;
            else
              state <= FETCH_CH0_UBLOCK;
          end
          ch0_user_ptr <= n_ch0_user_ptr;
        end 
        
        /***********************************************************************
        * DECODE_CH1_USER:
        ***********************************************************************/
        DECODE_CH1_USER:
        begin
          if(ch1_user_ptr[0] || !ch1_ublock_nuser)
          begin
            if(!ch0_done)
              state <= FETCH_CH0_UBLOCK;
            else
              state <= FETCH_CH1_UBLOCK;
          end
          ch1_user_ptr <= n_ch1_user_ptr;
        end 
         
        /* DONE */
        default:
        begin
          bd_ready             <= 1'b0;
          bd_ch0_field_start   <= 1'b0;
          bd_ch1_field_start   <= 1'b0;
          bd_field_length      <= 6'd0;
          ch0_done             <= 1'b1;
          ch1_done             <= 1'b1;
        end
      endcase
    end
  end
  
  /*****************************************************************************
  * common field decoder
  *****************************************************************************/
  rx_bd_ctrl_hesigb_common_dec u_rx_bd_ctrl_hesigb_common_dec
  (
    .bandwidth(           frame_bandwidth),
    .field(               field[36:0]),
    
    .field_length(        dec_common_field_length),
    .nrualloc(            dec_common_nrualloc),
    .rualloc0(            dec_common_rualloc0),
    .rualloc1(            dec_common_rualloc1),
    .rualloc2(            dec_common_rualloc2),
    .rualloc3(            dec_common_rualloc3),
    .center(              dec_common_center),
    .invalid_crc(         dec_common_invalid_crc)
  );

  /*****************************************************************************
  * rualloc index translation decoder
  *****************************************************************************/
  wire  [ 1:0] dec_trans_rualloc_ptr;
  wire  [ 4:0] dec_trans_rualloc_user_ptr;
  
  rx_bd_ctrl_hesigb_rualloc_trans_dec u_rx_bd_ctrl_hesigb_rualloc_trans_dec
  (
    .compression(         compression), 
    .ch_sel(              ch_ptr),
    
    .ch0_rualloc0_nuser(  ch0_rualloc0_nuser),
    .ch0_rualloc1_nuser(  ch0_rualloc1_nuser),
    .ch0_rualloc2_nuser(  ch0_rualloc2_nuser),
    .ch0_rualloc3_nuser(  ch0_rualloc3_nuser),
    .ch0_user(            ch0_user_ptr),
   
    .ch1_rualloc0_nuser(  ch1_rualloc0_nuser),
    .ch1_rualloc1_nuser(  ch1_rualloc1_nuser),
    .ch1_rualloc2_nuser(  ch1_rualloc2_nuser),
    .ch1_rualloc3_nuser(  ch1_rualloc3_nuser),
    .ch1_user(            ch1_user_ptr),
    
    .rualloc_ptr(         dec_trans_rualloc_ptr),
    .rualloc_user_ptr(    dec_trans_rualloc_user_ptr),
    .center(              center)
  );
  
  /*****************************************************************************
  * rualloc decoder
  *****************************************************************************/
  wire  [ 1:0] mux_rualloc_ptr;
  
  /* 1) During SUM_CHX_USER, rualloc table is addressed rualloc_ptr to count number of user per rualloc byte */
  /* 2) Otherwise, rualloc table is address with chx_user                                                    */
  assign mux_rualloc_ptr      = (state==SUM_CH0_NUSER || state==SUM_CH1_NUSER) ?      rualloc_ptr :      dec_trans_rualloc_ptr;
  
  
  wire [ 7:0]  rualloc0,rualloc1,rualloc2,rualloc3;
  
  assign rualloc0 = (!ch_ptr)?ch0_rualloc0:ch1_rualloc0;
  assign rualloc1 = (!ch_ptr)?ch0_rualloc1:ch1_rualloc1;
  assign rualloc2 = (!ch_ptr)?ch0_rualloc2:ch1_rualloc2;
  assign rualloc3 = (!ch_ptr)?ch0_rualloc3:ch1_rualloc3;
  
  rx_bd_ctrl_hesigb_rualloc_dec u_rx_bd_ctrl_hesigb_rualloc_dec
  (
    /* rualloc decoder */
    .ch_sel(              ch_ptr),
    .rualloc_sel(         mux_rualloc_ptr),
    .rualloc_user(        dec_trans_rualloc_user_ptr),
    .rualloc0(            rualloc0),
    .rualloc1(            rualloc1),
    .rualloc2(            rualloc2),
    .rualloc3(            rualloc3),
    .nuser(               dec_rualloc_nuser),
   
    .ru_segment(          dec_rualloc_ru_segment),
    .ru_nuser(            dec_rualloc_ru_nuser),
    .ru_len(              dec_rualloc_ru_len),
    .ru_index(            dec_rualloc_ru_index),
    .ru_user(             dec_rualloc_ru_user)
  );
  
  assign ru_segment = (!center)?dec_rualloc_ru_segment : ch_ptr;
  assign ru_nuser   = (!center)?dec_rualloc_ru_nuser   : 4'd1;
  assign ru_len     = (!center)?dec_rualloc_ru_len     : 3'd0;
  assign ru_index   = (!center)?dec_rualloc_ru_index   : 6'd19;
  assign ru_user    = (!center)?dec_rualloc_ru_user    : 3'd0;
  
  /*****************************************************************************
  * user block decoder
  *****************************************************************************/
  wire ublock_nuser, ublock_user_ptr;
  
  assign ublock_nuser    = (!ch_ptr) ? ch0_ublock_nuser : ch1_ublock_nuser;
  assign ublock_user_ptr = (!ch_ptr) ?  ch0_user_ptr[0] :  ch1_user_ptr[0];
  
  
  rx_bd_ctrl_hesigb_ublock_dec u_rx_bd_ctrl_hesigb_ublock_dec
  (
    .field(               field[51:0]),
    .ublock_nuser(        ublock_nuser), 
    .ublock_user(         ublock_user_ptr), 
    .ru_nuser(            ru_nuser),
    .ru_user(             ru_user),
   
    .staid(               staid),
    .beamformed(          beamformed),
    .mcs(                 mcs),
    .nbpsc(               nbpsc),
    .cr(                  cr),
    .nsts_prev(           nsts_prev),
    .nsts(                nsts),
    .nsts_tot(            nsts_tot),
    .dcm(                 dcm),
    .fec(                 fec),
    .invalid_crc(         dec_ublock_invalid_crc)
  );

  assign user_valid = (state==DECODE_CH0_USER || state==DECODE_CH1_USER) && !dec_ublock_invalid_crc;

`ifdef RW_SIMU_ON
  reg [32*8-1:0] s_state;
  always @(*)
  begin
    case(state)
      IDLE:               s_state <= "IDLE";
      FETCH_CH0_COMMON:   s_state <= "FETCH_CH0_COMMON";
      SUM_CH0_NUSER:      s_state <= "SUM_CH0_NUSER";
      FETCH_CH0_UBLOCK:   s_state <= "FETCH_CH0_UBLOCK";
      DECODE_CH0_USER:    s_state <= "DECODE_CH0_USER";
      FETCH_CH1_COMMON:   s_state <= "FETCH_CH1_COMMON";
      SUM_CH1_NUSER:      s_state <= "SUM_CH1_NUSER";
      FETCH_CH1_UBLOCK:   s_state <= "FETCH_CH1_UBLOCK";
      DECODE_CH1_USER:    s_state <= "DECODE_CH1_USER";
      DONE:               s_state <= "DONE"; 
      default:            s_state <= "XXXXXX";
    endcase
  end
`endif

endmodule
`default_nettype wire
  
  
  
