/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesigb_rualloc_dec
(
  input  wire        ch_sel,
  
  input  wire [ 1:0] rualloc_sel,
  input  wire [ 4:0] rualloc_user,
  input  wire [ 7:0] rualloc0,
  input  wire [ 7:0] rualloc1,
  input  wire [ 7:0] rualloc2,
  input  wire [ 7:0] rualloc3,
 
  output reg  [ 4:0] nuser,
  output reg         ru_segment,
  output reg  [ 3:0] ru_nuser,
  output reg  [ 2:0] ru_len,
  output reg  [ 5:0] ru_index,
  output reg  [ 2:0] ru_user
);

  localparam RU_26=3'd0,
             RU_52=3'd1,
             RU_106=3'd2,
             RU_242=3'd3,
             RU_484=3'd4,
             RU_996=3'd5;
  
  reg [ 7:0]  rualloc;
  reg [ 4:0]  o26,o52,o106,o242,o484;

  always @(*)
  begin
    /* select the ruallocation code to be decoded */
    case({ch_sel,rualloc_sel})
      /* channel content 0 */
      3'd0:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b0, rualloc0,  5'd0,  5'd0,  5'd0,  5'd0,  5'd0};
      3'd1:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b0, rualloc1, 5'd19,  5'd8,  5'd4,  5'd2,  5'd1};
      3'd2:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b1, rualloc2,  5'd0,  5'd0,  5'd0,  5'd0,  5'd0};
      3'd3:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b1, rualloc3, 5'd19,  5'd8,  5'd4,  5'd2,  5'd1};
      /* channel content 1 */
      3'd4:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b0, rualloc0,  5'd9,  5'd4,  5'd2,  5'd1,  5'd0};
      3'd5:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b0, rualloc1, 5'd28, 5'd12,  5'd6,  5'd3,  5'd0};
      3'd6:    {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b1, rualloc2,  5'd9,  5'd4,  5'd2,  5'd1,  5'd0};
      default: {ru_segment, rualloc, o26, o52 , o106, o242, o484} = {1'b1, rualloc3, 5'd28, 5'd12,  5'd6,  5'd3,  5'd0};
    endcase
  end
  
  reg [2:0] u0_ru_len, u1_ru_len, u2_ru_len, u3_ru_len, u4_ru_len, u5_ru_len, u6_ru_len, u7_ru_len;
  reg [2:0] u8_ru_len, u9_ru_len, u10_ru_len, u11_ru_len, u12_ru_len, u13_ru_len, u14_ru_len, u15_ru_len, u16_ru_len;
  reg [3:0] u0_ru_index, u1_ru_index, u2_ru_index, u3_ru_index, u4_ru_index, u5_ru_index, u6_ru_index, u7_ru_index;
  reg [3:0] u8_ru_index, u9_ru_index, u10_ru_index, u11_ru_index, u12_ru_index, u13_ru_index, u14_ru_index, u15_ru_index, u16_ru_index;
  reg [3:0] u0_ru_nuser, u1_ru_nuser, u2_ru_nuser, u3_ru_nuser, u4_ru_nuser, u5_ru_nuser, u6_ru_nuser, u7_ru_nuser;
  reg [3:0] u8_ru_nuser, u9_ru_nuser, u10_ru_nuser, u11_ru_nuser, u12_ru_nuser, u13_ru_nuser, u14_ru_nuser, u15_ru_nuser, u16_ru_nuser;
  reg [2:0] u0_ru_user, u1_ru_user, u2_ru_user, u3_ru_user, u4_ru_user, u5_ru_user, u6_ru_user, u7_ru_user;
  reg [2:0] u8_ru_user, u9_ru_user, u10_ru_user, u11_ru_user, u12_ru_user, u13_ru_user, u14_ru_user, u15_ru_user, u16_ru_user;
  reg [3:0] ru_index20;
  
  always @(*)
  begin
    case(rualloc_user)
     5'd0:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u0_ru_len,  u0_ru_index,  u0_ru_nuser,  u0_ru_user};
     5'd1:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u1_ru_len,  u1_ru_index,  u1_ru_nuser,  u1_ru_user};
     5'd2:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u2_ru_len,  u2_ru_index,  u2_ru_nuser,  u2_ru_user};
     5'd3:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u3_ru_len,  u3_ru_index,  u3_ru_nuser,  u3_ru_user};
     5'd4:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u4_ru_len,  u4_ru_index,  u4_ru_nuser,  u4_ru_user};
     5'd5:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u5_ru_len,  u5_ru_index,  u5_ru_nuser,  u5_ru_user};
     5'd6:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u6_ru_len,  u6_ru_index,  u6_ru_nuser,  u6_ru_user};
     5'd7:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u7_ru_len,  u7_ru_index,  u7_ru_nuser,  u7_ru_user};
     5'd8:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u8_ru_len,  u8_ru_index,  u8_ru_nuser,  u8_ru_user};
     5'd9:    {ru_len, ru_index20, ru_nuser, ru_user} = {  u9_ru_len,  u9_ru_index,  u9_ru_nuser,  u9_ru_user};
     5'd10:   {ru_len, ru_index20, ru_nuser, ru_user} = { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user};
     5'd11:   {ru_len, ru_index20, ru_nuser, ru_user} = { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user};
     5'd12:   {ru_len, ru_index20, ru_nuser, ru_user} = { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user};
     5'd13:   {ru_len, ru_index20, ru_nuser, ru_user} = { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user};
     5'd14:   {ru_len, ru_index20, ru_nuser, ru_user} = { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user};
     5'd15:   {ru_len, ru_index20, ru_nuser, ru_user} = { u15_ru_len, u15_ru_index, u15_ru_nuser, u15_ru_user};
     5'd16:   {ru_len, ru_index20, ru_nuser, ru_user} = { u16_ru_len, u16_ru_index, u16_ru_nuser, u16_ru_user};
     default: {ru_len, ru_index20, ru_nuser, ru_user} = {       3'd0,         4'd0,         4'd0,           3'd0};
    endcase
    
    case(ru_len)
      3'd0:    ru_index = {2'b0,ru_index20} + {1'b0,  o26}; 
      3'd1:    ru_index = {2'b0,ru_index20} + {1'b0,  o52}; 
      3'd2:    ru_index = {2'b0,ru_index20} + {1'b0, o106}; 
      3'd3:    ru_index = {2'b0,ru_index20} + {1'b0, o242}; 
      3'd4:    ru_index = {2'b0,ru_index20} + {1'b0, o484}; 
      default: ru_index = {2'b0,ru_index20}; 
    endcase
  end

  always @(*)
  begin

    {  u0_ru_len,  u0_ru_index,  u0_ru_nuser,  u0_ru_user} =  14'b0;
    {  u1_ru_len,  u1_ru_index,  u1_ru_nuser,  u1_ru_user} =  14'b0;  
    {  u2_ru_len,  u2_ru_index,  u2_ru_nuser,  u2_ru_user} =  14'b0;  
    {  u3_ru_len,  u3_ru_index,  u3_ru_nuser,  u3_ru_user} =  14'b0;  
    {  u4_ru_len,  u4_ru_index,  u4_ru_nuser,  u4_ru_user} =  14'b0;  
    {  u5_ru_len,  u5_ru_index,  u5_ru_nuser,  u5_ru_user} =  14'b0;  
    {  u6_ru_len,  u6_ru_index,  u6_ru_nuser,  u6_ru_user} =  14'b0;  
    {  u7_ru_len,  u7_ru_index,  u7_ru_nuser,  u7_ru_user} =  14'b0;  
    {  u8_ru_len,  u8_ru_index,  u8_ru_nuser,  u8_ru_user} =  14'b0;  
    {  u9_ru_len,  u9_ru_index,  u9_ru_nuser,  u9_ru_user} =  14'b0;  
    { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  14'b0;  
    { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  14'b0;  
    { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  14'b0; 
    { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  14'b0; 
    { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  14'b0;  
    { u15_ru_len, u15_ru_index, u15_ru_nuser, u15_ru_user} =  14'b0;  
    { u16_ru_len, u16_ru_index, u16_ru_nuser, u16_ru_user} =  14'b0;  
    nuser = 5'd0;

    case(rualloc)
      8'b00000000:  /* 00000000 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b00000001:  /* 00000001 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b00000010:  /* 00000010 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b00000011:  /* 00000011 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00000100:  /* 00000100 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b00000101:  /* 00000101 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00000110:  /* 00000110 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00000111:  /* 00000111 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00001000:  /* 00001000 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b00001001:  /* 00001001 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00001010:  /* 00001010 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00001011:  /* 00001011 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00001100:  /* 00001100 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00001101:  /* 00001101 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00001110:  /* 00001110 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00001111:  /* 00001111 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b00010000:  /* 00010y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd3;
      end
      8'b00010001:  /* 00010y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd4;
      end
      8'b00010010:  /* 00010y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd5;
      end
      8'b00010011:  /* 00010y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd6;
      end
      8'b00010100:  /* 00010y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd7;
      end
      8'b00010101:  /* 00010y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd8;
      end
      8'b00010110:  /* 00010y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd9;
      end
      8'b00010111:  /* 00010y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd10;
      end
      8'b00011000:  /* 00011y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd3;
      end
      8'b00011001:  /* 00011y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b00011010:  /* 00011y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b00011011:  /* 00011y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00011100:  /* 00011y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b00011101:  /* 00011y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b00011110:  /* 00011y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b00011111:  /* 00011y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b00100000:  /* 00100y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b00100001:  /* 00100y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd7;
      end
      8'b00100010:  /* 00100y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd8;
      end
      8'b00100011:  /* 00100y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd9;
      end
      8'b00100100:  /* 00100y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd10;
      end
      8'b00100101:  /* 00100y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd11;
      end
      8'b00100110:  /* 00100y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd12;
      end
      8'b00100111:  /* 00100y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd13;
      end
      8'b00101000:  /* 00101y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b00101001:  /* 00101y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd6;
      end
      8'b00101010:  /* 00101y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd7;
      end
      8'b00101011:  /* 00101y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd8;
      end
      8'b00101100:  /* 00101y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd9;
      end
      8'b00101101:  /* 00101y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd10;
      end
      8'b00101110:  /* 00101y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd11;
      end
      8'b00101111:  /* 00101y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_26, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd12;
      end
      8'b00110000:  /* 00110y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b00110001:  /* 00110y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd6;
      end
      8'b00110010:  /* 00110y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd7;
      end
      8'b00110011:  /* 00110y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd8;
      end
      8'b00110100:  /* 00110y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd9;
      end
      8'b00110101:  /* 00110y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd10;
      end
      8'b00110110:  /* 00110y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd11;
      end
      8'b00110111:  /* 00110y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd3, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd4, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd12;
      end
      8'b00111000:  /* 00111y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b00111001:  /* 00111y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd5;
      end
      8'b00111010:  /* 00111y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd6;
      end
      8'b00111011:  /* 00111y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd7;
      end
      8'b00111100:  /* 00111y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd8;
      end
      8'b00111101:  /* 00111y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd9;
      end
      8'b00111110:  /* 00111y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd10;
      end
      8'b00111111:  /* 00111y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd11;
      end
      8'b01000000:  /* 01000y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b01000001:  /* 01000y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b01000010:  /* 01000y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b01000011:  /* 01000y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b01000100:  /* 01000y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b01000101:  /* 01000y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd11;
      end
      8'b01000110:  /* 01000y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd12;
      end
      8'b01000111:  /* 01000y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd13;
      end
      8'b01001000:  /* 01001y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b01001001:  /* 01001y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b01001010:  /* 01001y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b01001011:  /* 01001y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b01001100:  /* 01001y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b01001101:  /* 01001y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b01001110:  /* 01001y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd11;
      end
      8'b01001111:  /* 01001y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd6, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd7, 4'd1, 3'd0};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd12;
      end
      8'b01010000:  /* 01010y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b01010001:  /* 01010y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b01010010:  /* 01010y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b01010011:  /* 01010y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b01010100:  /* 01010y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b01010101:  /* 01010y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b01010110:  /* 01010y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd11;
      end
      8'b01010111:  /* 01010y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_26, 4'd8, 4'd1, 3'd0};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_26, 4'd9, 4'd1, 3'd0};
        nuser = 5'd12;
      end
      8'b01011000:  /* 01011y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b01011001:  /* 01011y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b01011010:  /* 01011y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b01011011:  /* 01011y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b01011100:  /* 01011y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b01011101:  /* 01011y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b01011110:  /* 01011y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b01011111:  /* 01011y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd11;
      end
      8'b01100000:  /* 0110y1y0z1z0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd2;
      end
      8'b01100001:  /* 0110y1y0z1z0 1 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd3;
      end
      8'b01100010:  /* 0110y1y0z1z0 1 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd4;
      end
      8'b01100011:  /* 0110y1y0z1z0 1 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd5;
      end
      8'b01100100:  /* 0110y1y0z1z0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd3;
      end
      8'b01100101:  /* 0110y1y0z1z0 2 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd4;
      end
      8'b01100110:  /* 0110y1y0z1z0 2 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd5;
      end
      8'b01100111:  /* 0110y1y0z1z0 2 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd6;
      end
      8'b01101000:  /* 0110y1y0z1z0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b01101001:  /* 0110y1y0z1z0 3 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd5;
      end
      8'b01101010:  /* 0110y1y0z1z0 3 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd6;
      end
      8'b01101011:  /* 0110y1y0z1z0 3 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd7;
      end
      8'b01101100:  /* 0110y1y0z1z0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b01101101:  /* 0110y1y0z1z0 4 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd6;
      end
      8'b01101110:  /* 0110y1y0z1z0 4 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd7;
      end
      8'b01101111:  /* 0110y1y0z1z0 4 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd8;
      end
      8'b01110000:  /* 01110000 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_52, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_52, 4'd2, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_52, 4'd3, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_52, 4'd4, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b10000000:  /* 10y2y1y0z2z1z0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd3;
      end
      8'b10000001:  /* 10y2y1y0z2z1z0 1 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd4;
      end
      8'b10000010:  /* 10y2y1y0z2z1z0 1 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd5;
      end
      8'b10000011:  /* 10y2y1y0z2z1z0 1 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd6;
      end
      8'b10000100:  /* 10y2y1y0z2z1z0 1 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd7;
      end
      8'b10000101:  /* 10y2y1y0z2z1z0 1 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd8;
      end
      8'b10000110:  /* 10y2y1y0z2z1z0 1 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd9;
      end
      8'b10000111:  /* 10y2y1y0z2z1z0 1 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd1, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd10;
      end
      8'b10001000:  /* 10y2y1y0z2z1z0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd4;
      end
      8'b10001001:  /* 10y2y1y0z2z1z0 2 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd5;
      end
      8'b10001010:  /* 10y2y1y0z2z1z0 2 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd6;
      end
      8'b10001011:  /* 10y2y1y0z2z1z0 2 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd7;
      end
      8'b10001100:  /* 10y2y1y0z2z1z0 2 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd8;
      end
      8'b10001101:  /* 10y2y1y0z2z1z0 2 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd9;
      end
      8'b10001110:  /* 10y2y1y0z2z1z0 2 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd10;
      end
      8'b10001111:  /* 10y2y1y0z2z1z0 2 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd2, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd11;
      end
      8'b10010000:  /* 10y2y1y0z2z1z0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd5;
      end
      8'b10010001:  /* 10y2y1y0z2z1z0 3 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd6;
      end
      8'b10010010:  /* 10y2y1y0z2z1z0 3 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd7;
      end
      8'b10010011:  /* 10y2y1y0z2z1z0 3 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd8;
      end
      8'b10010100:  /* 10y2y1y0z2z1z0 3 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd9;
      end
      8'b10010101:  /* 10y2y1y0z2z1z0 3 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd10;
      end
      8'b10010110:  /* 10y2y1y0z2z1z0 3 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd11;
      end
      8'b10010111:  /* 10y2y1y0z2z1z0 3 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd3, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd12;
      end
      8'b10011000:  /* 10y2y1y0z2z1z0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd6;
      end
      8'b10011001:  /* 10y2y1y0z2z1z0 4 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd7;
      end
      8'b10011010:  /* 10y2y1y0z2z1z0 4 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd8;
      end
      8'b10011011:  /* 10y2y1y0z2z1z0 4 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd9;
      end
      8'b10011100:  /* 10y2y1y0z2z1z0 4 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd10;
      end
      8'b10011101:  /* 10y2y1y0z2z1z0 4 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd11;
      end
      8'b10011110:  /* 10y2y1y0z2z1z0 4 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd12;
      end
      8'b10011111:  /* 10y2y1y0z2z1z0 4 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd4, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd13;
      end
      8'b10100000:  /* 10y2y1y0z2z1z0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd7;
      end
      8'b10100001:  /* 10y2y1y0z2z1z0 5 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd8;
      end
      8'b10100010:  /* 10y2y1y0z2z1z0 5 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd9;
      end
      8'b10100011:  /* 10y2y1y0z2z1z0 5 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd10;
      end
      8'b10100100:  /* 10y2y1y0z2z1z0 5 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd11;
      end
      8'b10100101:  /* 10y2y1y0z2z1z0 5 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd12;
      end
      8'b10100110:  /* 10y2y1y0z2z1z0 5 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd13;
      end
      8'b10100111:  /* 10y2y1y0z2z1z0 5 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd5, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd14;
      end
      8'b10101000:  /* 10y2y1y0z2z1z0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd8;
      end
      8'b10101001:  /* 10y2y1y0z2z1z0 6 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd9;
      end
      8'b10101010:  /* 10y2y1y0z2z1z0 6 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd10;
      end
      8'b10101011:  /* 10y2y1y0z2z1z0 6 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd11;
      end
      8'b10101100:  /* 10y2y1y0z2z1z0 6 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd12;
      end
      8'b10101101:  /* 10y2y1y0z2z1z0 6 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd13;
      end
      8'b10101110:  /* 10y2y1y0z2z1z0 6 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd14;
      end
      8'b10101111:  /* 10y2y1y0z2z1z0 6 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd6, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd15;
      end
      8'b10110000:  /* 10y2y1y0z2z1z0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd9;
      end
      8'b10110001:  /* 10y2y1y0z2z1z0 7 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd10;
      end
      8'b10110010:  /* 10y2y1y0z2z1z0 7 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd11;
      end
      8'b10110011:  /* 10y2y1y0z2z1z0 7 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd12;
      end
      8'b10110100:  /* 10y2y1y0z2z1z0 7 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd13;
      end
      8'b10110101:  /* 10y2y1y0z2z1z0 7 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd14;
      end
      8'b10110110:  /* 10y2y1y0z2z1z0 7 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd15;
      end
      8'b10110111:  /* 10y2y1y0z2z1z0 7 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd7, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u15_ru_len, u15_ru_index, u15_ru_nuser, u15_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd16;
      end
      8'b10111000:  /* 10y2y1y0z2z1z0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd1, 3'd0};
        nuser = 5'd10;
      end
      8'b10111001:  /* 10y2y1y0z2z1z0 8 2 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd2, 3'd1};
        nuser = 5'd11;
      end
      8'b10111010:  /* 10y2y1y0z2z1z0 8 3 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd3, 3'd2};
        nuser = 5'd12;
      end
      8'b10111011:  /* 10y2y1y0z2z1z0 8 4 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd2};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd4, 3'd3};
        nuser = 5'd13;
      end
      8'b10111100:  /* 10y2y1y0z2z1z0 8 5 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd2};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd3};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd5, 3'd4};
        nuser = 5'd14;
      end
      8'b10111101:  /* 10y2y1y0z2z1z0 8 6 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd2};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd3};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd4};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd6, 3'd5};
        nuser = 5'd15;
      end
      8'b10111110:  /* 10y2y1y0z2z1z0 8 7 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd2};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd3};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd4};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd5};
        { u15_ru_len, u15_ru_index, u15_ru_nuser, u15_ru_user} =  { RU_106, 4'd2, 4'd7, 3'd6};
        nuser = 5'd16;
      end
      8'b10111111:  /* 10y2y1y0z2z1z0 8 8 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_106, 4'd1, 4'd8, 3'd7};
        { u8_ru_len, u8_ru_index, u8_ru_nuser, u8_ru_user} =  { RU_26, 4'd5, 4'd1, 3'd0};
        { u9_ru_len, u9_ru_index, u9_ru_nuser, u9_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd0};
        { u10_ru_len, u10_ru_index, u10_ru_nuser, u10_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd1};
        { u11_ru_len, u11_ru_index, u11_ru_nuser, u11_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd2};
        { u12_ru_len, u12_ru_index, u12_ru_nuser, u12_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd3};
        { u13_ru_len, u13_ru_index, u13_ru_nuser, u13_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd4};
        { u14_ru_len, u14_ru_index, u14_ru_nuser, u14_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd5};
        { u15_ru_len, u15_ru_index, u15_ru_nuser, u15_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd6};
        { u16_ru_len, u16_ru_index, u16_ru_nuser, u16_ru_user} =  { RU_106, 4'd2, 4'd8, 3'd7};
        nuser = 5'd17;
      end
      8'b11000000:  /* 11000y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd1, 3'd0};
        nuser = 5'd1;
      end
      8'b11000001:  /* 11000y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd2, 3'd1};
        nuser = 5'd2;
      end
      8'b11000010:  /* 11000y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd3, 3'd2};
        nuser = 5'd3;
      end
      8'b11000011:  /* 11000y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_242, 4'd1, 4'd4, 3'd3};
        nuser = 5'd4;
      end
      8'b11000100:  /* 11000y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_242, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_242, 4'd1, 4'd5, 3'd4};
        nuser = 5'd5;
      end
      8'b11000101:  /* 11000y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_242, 4'd1, 4'd6, 3'd5};
        nuser = 5'd6;
      end
      8'b11000110:  /* 11000y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_242, 4'd1, 4'd7, 3'd6};
        nuser = 5'd7;
      end
      8'b11000111:  /* 11000y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_242, 4'd1, 4'd8, 3'd7};
        nuser = 5'd8;
      end
      8'b11001000:  /* 11001y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd1, 3'd0};
        nuser = 5'd1;
      end
      8'b11001001:  /* 11001y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd2, 3'd1};
        nuser = 5'd2;
      end
      8'b11001010:  /* 11001y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd3, 3'd2};
        nuser = 5'd3;
      end
      8'b11001011:  /* 11001y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_484, 4'd1, 4'd4, 3'd3};
        nuser = 5'd4;
      end
      8'b11001100:  /* 11001y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_484, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_484, 4'd1, 4'd5, 3'd4};
        nuser = 5'd5;
      end
      8'b11001101:  /* 11001y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_484, 4'd1, 4'd6, 3'd5};
        nuser = 5'd6;
      end
      8'b11001110:  /* 11001y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_484, 4'd1, 4'd7, 3'd6};
        nuser = 5'd7;
      end
      8'b11001111:  /* 11001y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_484, 4'd1, 4'd8, 3'd7};
        nuser = 5'd8;
      end
      8'b11010000:  /* 11010y2y1y0 1 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd1, 3'd0};
        nuser = 5'd1;
      end
      8'b11010001:  /* 11010y2y1y0 2 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd2, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd2, 3'd1};
        nuser = 5'd2;
      end
      8'b11010010:  /* 11010y2y1y0 3 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd3, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd3, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd3, 3'd2};
        nuser = 5'd3;
      end
      8'b11010011:  /* 11010y2y1y0 4 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd4, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd4, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd4, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_996, 4'd1, 4'd4, 3'd3};
        nuser = 5'd4;
      end
      8'b11010100:  /* 11010y2y1y0 5 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd5, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd5, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd5, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_996, 4'd1, 4'd5, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_996, 4'd1, 4'd5, 3'd4};
        nuser = 5'd5;
      end
      8'b11010101:  /* 11010y2y1y0 6 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_996, 4'd1, 4'd6, 3'd5};
        nuser = 5'd6;
      end
      8'b11010110:  /* 11010y2y1y0 7 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_996, 4'd1, 4'd7, 3'd6};
        nuser = 5'd7;
      end
      8'b11010111:  /* 11010y2y1y0 8 1 */
      begin
        { u0_ru_len, u0_ru_index, u0_ru_nuser, u0_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd0};
        { u1_ru_len, u1_ru_index, u1_ru_nuser, u1_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd1};
        { u2_ru_len, u2_ru_index, u2_ru_nuser, u2_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd2};
        { u3_ru_len, u3_ru_index, u3_ru_nuser, u3_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd3};
        { u4_ru_len, u4_ru_index, u4_ru_nuser, u4_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd4};
        { u5_ru_len, u5_ru_index, u5_ru_nuser, u5_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd5};
        { u6_ru_len, u6_ru_index, u6_ru_nuser, u6_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd6};
        { u7_ru_len, u7_ru_index, u7_ru_nuser, u7_ru_user} =  { RU_996, 4'd1, 4'd8, 3'd7};
        nuser = 5'd8;
      end
      
      default: ;
           
    endcase
  end

endmodule
`default_nettype wire
