/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesigb_rualloc_trans_dec
(
  input wire         compression,
  input wire         ch_sel,
  input wire  [ 4:0] ch0_rualloc0_nuser,
  input wire  [ 4:0] ch0_rualloc1_nuser,
  input wire  [ 4:0] ch0_rualloc2_nuser,
  input wire  [ 4:0] ch0_rualloc3_nuser,
  input wire  [ 7:0] ch0_user,
  input wire  [ 4:0] ch1_rualloc0_nuser,
  input wire  [ 4:0] ch1_rualloc1_nuser,
  input wire  [ 4:0] ch1_rualloc2_nuser,
  input wire  [ 4:0] ch1_rualloc3_nuser,
  input wire  [ 7:0] ch1_user,
    
  output reg  [ 1:0] rualloc_ptr,
  output reg  [ 4:0] rualloc_user_ptr,
  output reg         center
);

  wire [ 4:0]   rualloc0_nuser, rualloc1_nuser, rualloc2_nuser, rualloc3_nuser;
  wire [ 7:0]   user;
  
  assign rualloc0_nuser = (!ch_sel)?ch0_rualloc0_nuser:ch1_rualloc0_nuser;
  assign rualloc1_nuser = (!ch_sel)?ch0_rualloc1_nuser:ch1_rualloc1_nuser;
  assign rualloc2_nuser = (!ch_sel)?ch0_rualloc2_nuser:ch1_rualloc2_nuser;
  assign rualloc3_nuser = (!ch_sel)?ch0_rualloc3_nuser:ch1_rualloc3_nuser;
  assign user           = (!ch_sel)?          ch0_user:          ch1_user;

  
  wire [ 8:0]   sub0, sub1, sub2, sub3;
  assign sub0           = {1'b0,user} - {4'b0, rualloc0_nuser};
  assign sub1           =       sub0  - {4'b0, rualloc1_nuser};
  assign sub2           =       sub1  - {4'b0, rualloc2_nuser};
  assign sub3           =       sub2  - {4'b0, rualloc3_nuser};
  
  always @(*)
  begin
    if(!compression)
    begin
      if(sub0[8])
      begin
        rualloc_ptr      = 2'd0;
        rualloc_user_ptr = user[4:0];
        center           = 1'b0;
      end
      else if(sub1[8] )
      begin
        rualloc_ptr      = 2'd1;
        rualloc_user_ptr = sub0[4:0];
        center           = 1'b0;
      end
      else if(sub2[8])
      begin
        rualloc_ptr      = 2'd2;
        rualloc_user_ptr = sub1[4:0];
        center           = 1'b0;
      end
      else if(sub3[8])
      begin
        rualloc_ptr      = 2'd3;
        rualloc_user_ptr = sub2[4:0];
        center           = 1'b0;
      end
      else
      begin
        rualloc_ptr      = 2'd0;
        rualloc_user_ptr = 5'd0;
        center           = 1'b1;
      end
    end
    else
    begin
      rualloc_ptr = 2'd0;
      center      = 1'b0;
      if(!ch_sel)
        rualloc_user_ptr = {1'b0,ch0_user[3:0]};
      else
        rualloc_user_ptr = {1'b0,ch1_user[3:0]+ch0_rualloc0_nuser[3:0]};
    end
  end
  
endmodule
`default_nettype wire
