`default_nettype none
module rx_bd_ctrl_hesigb_staid_match
(
  /* system */
  input wire         rst_n,
  input wire         clk,
   
  input wire         enable,
  
  /* config registers */
  input wire  [10:0] mdmcfg_he_staid0,
  input wire  [10:0] mdmcfg_he_staid1,
  input wire  [10:0] mdmcfg_he_staid2,
  input wire  [10:0] mdmcfg_he_staid3,
 
    /* hesigb parser */
  input wire         user_valid,
  input wire  [10:0] staid,                
  input wire         rusegment,            
  input wire  [ 2:0] rulen,                
  input wire  [ 5:0] ruindex,              
  input wire  [ 3:0] runuser,              
  input wire  [ 2:0] ruuser,               
  input wire         beamformed,           
  input wire  [ 3:0] mcs,                  
  input wire  [ 2:0] nbpsc,                
  input wire  [ 1:0] cr,                   
  input wire         dcm,                  
  input wire         fec,                  
  input wire  [ 2:0] nsts,                 
  input wire  [ 2:0] nsts_prev,            
  input wire  [ 2:0] nsts_tot,             
    
    /* matched staid */
  output reg         matched_user_valid,   
  output reg  [10:0] matched_staid,        
  output reg         matched_rusegment,    
  output reg  [ 2:0] matched_rulen,        
  output reg  [ 5:0] matched_ruindex,      
  output reg  [ 3:0] matched_runuser,      
  output reg  [ 2:0] matched_ruuser,       
  output reg         matched_beamformed,   
  output reg  [ 3:0] matched_mcs,          
  output reg  [ 2:0] matched_nbpsc,        
  output reg  [ 1:0] matched_cr,           
  output reg         matched_dcm,          
  output reg         matched_fec,          
  output reg  [ 2:0] matched_nsts,         
  output reg  [ 2:0] matched_nsts_prev,    
  output reg  [ 2:0] matched_nsts_tot    
);

  reg  staid0_captured,staid1_captured,staid2_captured;
  wire staid0_match,staid1_match,staid2_match,staid3_match;
  
  assign staid0_match = staid==mdmcfg_he_staid0;
  assign staid1_match = staid==mdmcfg_he_staid1;
  assign staid2_match = staid==mdmcfg_he_staid2;
  assign staid3_match = staid==mdmcfg_he_staid3;

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      staid0_captured    <= 1'b0;   
      staid1_captured    <= 1'b0;   
      staid2_captured    <= 1'b0;   
      matched_user_valid <= 1'b0;
      matched_staid      <= 11'd0;
      matched_rusegment  <= 1'b0;                                    
      matched_rulen      <= 3'b0;                                        
      matched_ruindex    <= 6'd0;                                      
      matched_runuser    <= 4'd0;                                      
      matched_ruuser     <= 3'd0;                                       
      matched_beamformed <= 1'b0;                                   
      matched_mcs        <= 4'b0;
      matched_nbpsc      <= 3'b0;                                        
      matched_cr         <= 2'b0;                                        
      matched_dcm        <= 1'b0;                                        
      matched_fec        <= 1'b0;                                          
      matched_nsts       <= 3'b0;                                         
      matched_nsts_prev  <= 3'b0;                                      
      matched_nsts_tot   <= 3'b0;                                         
    end
    else if(!enable)
    begin
      staid0_captured    <= 1'b0;   
      staid1_captured    <= 1'b0;   
      staid2_captured    <= 1'b0;   
      matched_user_valid <= 1'b0;
      matched_staid      <= 11'd0;
      matched_rusegment  <= 1'b0;                                    
      matched_rulen      <= 3'b0;                                        
      matched_ruindex    <= 6'd0;                                      
      matched_runuser    <= 4'd0;                                      
      matched_ruuser     <= 3'd0;                                       
      matched_beamformed <= 1'b0;                                   
      matched_mcs        <= 4'b0;
      matched_nbpsc      <= 3'b0;                                        
      matched_cr         <= 2'b0;                                        
      matched_dcm        <= 1'b0;                                        
      matched_fec        <= 1'b0;                                          
      matched_nsts       <= 3'b0;                                         
      matched_nsts_prev  <= 3'b0;                                      
      matched_nsts_tot   <= 3'b0;                                         
    end
    else
    begin
      if(user_valid)
      begin                                                                               
        if(staid0_match ||                                                                
           staid1_match && !staid0_captured ||                                            
           staid2_match && !staid0_captured && !staid1_captured ||                        
           staid3_match && !staid0_captured && !staid1_captured && !staid2_captured)      
        begin                                                                             
         
          if(staid0_match) staid0_captured <= 1'b1;                                       
          if(staid1_match) staid1_captured <= 1'b1;                                       
          if(staid2_match) staid2_captured <= 1'b1;                                       
                                                                                          
          matched_user_valid <= 1'b1;
          matched_staid      <= staid;
          matched_rusegment  <= rusegment;                                    
          matched_rulen      <= rulen;                                        
          matched_ruindex    <= ruindex;                                      
          matched_runuser    <= runuser;                                      
          matched_ruuser     <= ruuser;                                       
          matched_beamformed <= beamformed;                                   
          matched_mcs        <= mcs;
          matched_nbpsc      <= nbpsc;                                        
          matched_cr         <= cr;                                        
          matched_dcm        <= dcm;                                        
          matched_fec        <= fec;                                          
          matched_nsts       <= nsts;                                         
          matched_nsts_prev  <= nsts_prev;                                    
          matched_nsts_tot   <= nsts_tot;                                     
        end                                                                               
      end
    end
  end

endmodule
`default_nettype none
