/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_hesigb_ublock_dec
(
  input  wire [51:0]  field,
  input  wire         ublock_nuser,
  input  wire         ublock_user, 
  input  wire [ 3:0]  ru_nuser,    
  input  wire [ 2:0]  ru_user,     
  
  output reg  [10:0]  staid,
  output reg          beamformed,
  output reg  [ 3:0]  mcs,
  output reg  [ 2:0]  nbpsc,
  output reg  [ 1:0]  cr,
  output reg  [ 2:0]  nsts_prev, /* starting sts position of user   */
  output reg  [ 2:0]  nsts,      /* number of sts allocated to user */
  output reg  [ 2:0]  nsts_tot,  /* number of sts allocated to ru   */
  output reg          dcm,
  output reg          fec,
  output reg          invalid_crc
);

  /*****************************************************************************
  * user field 
  *****************************************************************************/
  reg [3:0] nsts_spatial_config;
  
  always @(*)
  begin:b_user_decoder
    integer   i;
    reg [7:0] v;
   
    if(!ublock_user)
    begin
      /* first user in the user block */
      staid = field[10:0];
      mcs   = field[18:15];
      fec   = field[20];
      if(ru_nuser==4'd1)
      begin
        /* non-mumimo allocation */
        nsts_spatial_config = {1'b0,field[13:11]};
        beamformed          = field[14];
        dcm                 = field[19];
      end
      else
      begin
        /* mumimo allocation */
        nsts_spatial_config  = field[14:11];
        beamformed           = 1'b1;
        dcm                  = 1'b0;
      end
    end
    else
    begin
      /* second user in the user block */
      staid = field[31:21];
      mcs   = field[39:36];
      fec   = field[41];
      if(ru_nuser==4'd1)
      begin
        /* non-mumimo allocation */
        nsts_spatial_config = {1'b0,field[34:32]};
        beamformed          = field[35];
        dcm                 = field[40];
      end
      else
      begin
        /* mumimo allocation */
        nsts_spatial_config  = field[35:32];
        beamformed           = 1'b1;
        dcm                  = 1'b0;
      end
    end
    
    v = 8'hff;
    if(!ublock_nuser)
    begin
      for(i=0;i<21;i=i+1) v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
      invalid_crc   = ~{v[4],v[5],v[6],v[7]}!= field[24:21];
    end
    else
    begin
      for(i=0;i<42;i=i+1) v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
      invalid_crc   = ~{v[4],v[5],v[6],v[7]}!= field[45:42];
    end
  end

  /*****************************************************************************
  * spatial configuration
  *****************************************************************************/
  localparam   [2:0]  NSTS_1 = 3'd0,
                      NSTS_2 = 3'd1,
                      NSTS_3 = 3'd2,
                      NSTS_4 = 3'd3,
                      NSTS_5 = 3'd4,
                      NSTS_6 = 3'd5,
                      NSTS_7 = 3'd6,
                      NSTS_8 = 3'd7;
                      
  reg [2:0] t,c7,c6,c5,c4,c3,c2,c1,c0;
  
  wire [ 2:0] sum1,sum2,sum3,sum4,sum5,sum6;
  assign sum1 =   c0 + c1;
  assign sum2 = sum1 + c2;
  assign sum3 = sum2 + c3;
  assign sum4 = sum3 + c4;
  assign sum5 = sum4 + c5;
  assign sum6 = sum5 + c6;
  
  wire [ 2:0] c0f,c1f,c2f,c3f,c4f,c5f,c6f,c7f;
  assign c0f  = c0 - 3'd1;
  assign c1f  = c1 - 3'd1;
  assign c2f  = c2 - 3'd1;
  assign c3f  = c3 - 3'd1;
  assign c4f  = c4 - 3'd1;
  assign c5f  = c5 - 3'd1;
  assign c6f  = c6 - 3'd1;
  assign c7f  = c7 - 3'd1;
  
  always @(*)
  begin
    if(ru_nuser==4'd1)
    begin
      nsts_prev = 3'd0;
      nsts_tot  = nsts_spatial_config[2:0];
      nsts      = nsts_spatial_config[2:0];
    end
    else
    begin
      nsts_tot = t;
      case(ru_user)
        3'd0:    {nsts,nsts_prev} = {c0f, 3'd0};
        3'd1:    {nsts,nsts_prev} = {c1f,   c0};
        3'd2:    {nsts,nsts_prev} = {c2f, sum1};
        3'd3:    {nsts,nsts_prev} = {c3f, sum2};
        3'd4:    {nsts,nsts_prev} = {c4f, sum3};
        3'd5:    {nsts,nsts_prev} = {c5f, sum4};
        3'd6:    {nsts,nsts_prev} = {c6f, sum5};
        default: {nsts,nsts_prev} = {c7f, sum6};
      endcase
    end
  end
 
  always @(*)
  begin
    case({ru_nuser,nsts_spatial_config})
      /* NUSER=2                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd2,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_2,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd1, 3'd1};
      { 4'd2,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_3,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd1, 3'd2};
      { 4'd2,  4'd2}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_4,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd1, 3'd3};
      { 4'd2,  4'd3}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd1, 3'd4};
      { 4'd2,  4'd4}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_4,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd2, 3'd2};
      { 4'd2,  4'd5}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd2, 3'd3};
      { 4'd2,  4'd6}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd2, 3'd4};
      { 4'd2,  4'd7}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd3, 3'd3};
      { 4'd2,  4'd8}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd3, 3'd4};
      { 4'd2,  4'd9}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0, 3'd4, 3'd4};

      /* NUSER=3                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd3,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_3,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd1, 3'd1};
      { 4'd3,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_4,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd1, 3'd2};
      { 4'd3,  4'd2}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd1, 3'd3};
      { 4'd3,  4'd3}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd1, 3'd4};
      { 4'd3,  4'd4}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd2, 3'd2};
      { 4'd3,  4'd5}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd2, 3'd3};
      { 4'd3,  4'd6}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd2, 3'd4};
      { 4'd3,  4'd7}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd3, 3'd3};
      { 4'd3,  4'd8}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1, 3'd3, 3'd4};
      { 4'd3,  4'd9}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd2, 3'd2, 3'd2};
      { 4'd3, 4'd10}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd2, 3'd2, 3'd3};
      { 4'd3, 4'd11}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd2, 3'd2, 3'd4};
      
      { 4'd3, 4'd12}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd0,   3'd2, 3'd3, 3'd3};
     
      /* NUSER=4                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd4,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_4,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd1, 3'd1};
      { 4'd4,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd1, 3'd2};
      { 4'd4,  4'd2}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd1, 3'd3};
      { 4'd4,  4'd3}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd1, 3'd4};
      { 4'd4,  4'd4}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd2, 3'd2};
      { 4'd4,  4'd5}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd2, 3'd3};
      { 4'd4,  4'd6}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd2, 3'd4};
      { 4'd4,  4'd7}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1, 3'd3, 3'd3};
      { 4'd4,  4'd8}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd2, 3'd2, 3'd2};
      { 4'd4,  4'd9}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd1,   3'd2, 3'd2, 3'd3};
      { 4'd4, 4'd10}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd0,   3'd2,   3'd2, 3'd2, 3'd2};
      
      /* NUSER=5                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd5,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_5,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd1, 3'd1};
      { 4'd5,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd1, 3'd2};
      { 4'd5,  4'd2}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd1, 3'd3};
      { 4'd5,  4'd3}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd1, 3'd4};
      { 4'd5,  4'd4}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd2, 3'd2};
      { 4'd5,  4'd5}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1, 3'd2, 3'd3};
      { 4'd5,  4'd6}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd0,   3'd1,   3'd1,   3'd2, 3'd2, 3'd2};
      
      /* NUSER=6                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd6,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_6,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd1};
      { 4'd6,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd2};
      { 4'd6,  4'd2}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd3};
      { 4'd6,  4'd3}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1, 3'd2, 3'd2};
      
      /* NUSER=7                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      { 4'd7,  4'd0}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_7,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd1};
      { 4'd7,  4'd1}: {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd0,   3'd1,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd2};
      
      /* NUSER=8                                      TOT   [8]     [7]     [6]     [5]     [4]     [3]   [2]     [1]  */ 
      default:        {t,c7,c6,c5,c4,c3,c2,c1,c0} = { NSTS_8,   3'd1,   3'd1,   3'd1,   3'd1,   3'd1,   3'd1, 3'd1, 3'd1};
    
    endcase
  end
  
  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;  

  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
              
  always @(*)
  begin
    case(mcs)
      4'd0:   {nbpsc, cr} = {NBPSC_1,  CR_12};
      4'd1:   {nbpsc, cr} = {NBPSC_2,  CR_12};
      4'd2:   {nbpsc, cr} = {NBPSC_2,  CR_34};
      4'd3:   {nbpsc, cr} = {NBPSC_4,  CR_12};
      4'd4:   {nbpsc, cr} = {NBPSC_4,  CR_34};
      4'd5:   {nbpsc, cr} = {NBPSC_6,  CR_23};
      4'd6:   {nbpsc, cr} = {NBPSC_6,  CR_34};
      4'd7:   {nbpsc, cr} = {NBPSC_6,  CR_56};
      4'd8:   {nbpsc, cr} = {NBPSC_8,  CR_34};
      4'd9:   {nbpsc, cr} = {NBPSC_8,  CR_56};
      4'd10:  {nbpsc, cr} = {NBPSC_10, CR_34};
      default:{nbpsc, cr} = {NBPSC_10, CR_56};
    endcase
  end

endmodule
`default_nettype wire
