/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_htsig_parser
(
  /* system */
  input  wire         rst_n,
  input  wire         clk,
  
  /* control */
  input  wire         enable,
  output reg          captured,
  
  /* byte stream */
  output reg          bd_ready,
  input  wire [ 7:0]  bd_data,
  input  wire         bd_last,
  input  wire         bd_valid,
  
  /* output parameters */
  output wire [  6:0] mcs,
  output wire [  2:0] bandwidth,
  output wire [ 15:0] length,
  output wire         smoothing,
  output wire         sounding,
  output wire         aggregation,
  output wire         stbc,
  output wire         fec,
  output wire  [ 1:0] gi_type,
  output wire  [ 1:0] ness,
  output wire         mcs32,
  output wire         ndp,
  output reg   [ 2:0] nss,
  output wire  [ 2:0] nsts,
  output reg   [ 1:0] nsd,
  output reg   [ 1:0] cr,
  output reg   [ 2:0] nbpsc,
  
  output wire         invalid_reserved26,
  output wire         invalid_mcs,
  output wire         invalid_length,
  output wire         invalid_ndp_stbc,
  output wire         invalid_ndp_nss,
  output wire         invalid_nsts_ness,
  output wire         invalid_nsts_nss,
  output wire         invalid_mcs32_bw,
  output wire         invalid_mcs32_stbc,
  output wire         invalid_crc,
  output wire         invalid_gf_sgi_1ss
);
 
  /*****************************************************************************
  * DECLARATION
  *****************************************************************************/
  localparam  NSD_48=2'd0,
              NSD_52=2'd1,
              NSD_108=2'd2,
              NSD_234=2'd3;  

  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;  
 
  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
 
  localparam  NSS_1=3'd0,
              NSS_2=3'd1,
              NSS_3=3'd2,
              NSS_4=3'd3; 
 
  localparam  NSTS_1=3'd0,
              NSTS_2=3'd1,
              NSTS_3=3'd2,
              NSTS_4=3'd3; 

  /*****************************************************************************
  * CAPTURE
  *****************************************************************************/
  reg [47:0] field;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready        <= 1'b0;
      captured        <= 1'b0;
      field           <= 48'b0;
    end
    else if(!enable)
    begin
      bd_ready        <= 1'b0;
      captured        <= 1'b0;
      field           <= 48'b0;
    end
    else
    begin
      if(!captured)          
      begin
        bd_ready <= 1'b1;
        if(bd_valid)
        begin                             
          field <= {bd_data,field[47:8]}; 
          if(bd_last)
            captured <= 1'b1;
        end
      end
      else
      begin
        bd_ready <= 1'b0;
      end
    end
  end
 
  /*****************************************************************************
  * DECODER
  *****************************************************************************/
  assign mcs         = field[6:0];
  assign bandwidth   = {2'b0,field[7]};
  assign length      = field[23:8];
  assign smoothing   = field[24];
  assign sounding    = ~field[25];
  assign aggregation = field[27];
  assign stbc        = field[29:28]!=2'd0;
  assign fec         = field[30];
  assign gi_type     = field[31]?2'd0:2'd1;
  assign ness        = field[33:32];
  
  assign mcs32       = mcs==7'd32;
  assign ndp         = length==16'd0;

  always @(*)
  begin
    if(mcs>7'd52)       
      nss=NSS_4;
    else if(mcs>7'd38)  
      nss=NSS_3;
    else if(mcs>7'd32)  
      nss=NSS_2;
    else if(mcs32)      
      nss=NSS_1;
    else                   
      nss=mcs[5:3];
  end
 
  assign nsts = nss + {1'b0,field[29:28]};

  /*****************************************************************************
  * MCS
  *****************************************************************************/
  always @(*)
  begin
    case({bandwidth[0],mcs})
      /* HT EQM 20 */
      {1'b0, 7'd0}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_1};
      {1'b0, 7'd1}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_2};
      {1'b0, 7'd2}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_2};
      {1'b0, 7'd3}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_4};
      {1'b0, 7'd4}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_4};
      {1'b0, 7'd5}:{nsd, cr, nbpsc} = { NSD_52, CR_23, NBPSC_6};
      {1'b0, 7'd6}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_6};
      {1'b0, 7'd7}:{nsd, cr, nbpsc} = { NSD_52, CR_56, NBPSC_6};
      {1'b0, 7'd8}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_1};
      {1'b0, 7'd9}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_2};
      {1'b0,7'd10}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_2};
      {1'b0,7'd11}:{nsd, cr, nbpsc} = { NSD_52, CR_12, NBPSC_4};
      {1'b0,7'd12}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_4};
      {1'b0,7'd13}:{nsd, cr, nbpsc} = { NSD_52, CR_23, NBPSC_6};
      {1'b0,7'd14}:{nsd, cr, nbpsc} = { NSD_52, CR_34, NBPSC_6};
      {1'b0,7'd15}:{nsd, cr, nbpsc} = { NSD_52, CR_56, NBPSC_6};
      /* HT EQM 40 */
      {1'b1, 7'd0}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_1};
      {1'b1, 7'd1}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_2};
      {1'b1, 7'd2}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_2};
      {1'b1, 7'd3}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_4};
      {1'b1, 7'd4}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_4};
      {1'b1, 7'd5}:{nsd, cr, nbpsc} = {NSD_108, CR_23, NBPSC_6};
      {1'b1, 7'd6}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_6};
      {1'b1, 7'd7}:{nsd, cr, nbpsc} = {NSD_108, CR_56, NBPSC_6};
      {1'b1, 7'd8}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_1};
      {1'b1, 7'd9}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_2};
      {1'b1,7'd10}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_2};
      {1'b1,7'd11}:{nsd, cr, nbpsc} = {NSD_108, CR_12, NBPSC_4};
      {1'b1,7'd12}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_4};
      {1'b1,7'd13}:{nsd, cr, nbpsc} = {NSD_108, CR_23, NBPSC_6};
      {1'b1,7'd14}:{nsd, cr, nbpsc} = {NSD_108, CR_34, NBPSC_6};
      {1'b1,7'd15}:{nsd, cr, nbpsc} = {NSD_108, CR_56, NBPSC_6};
      /* HTDUP 40*/
      {1'b1,7'd32}:{nsd, cr, nbpsc} = { NSD_48, CR_12, NBPSC_1};
      /* unsupported */
      default:     {nsd, cr, nbpsc} = { NSD_48, CR_12, NBPSC_1};
    endcase
  end

  /*****************************************************************************
  * CRC
  *****************************************************************************/
  reg [ 7:0] crc;
  always @(*)
  begin:b_crc
    integer   i;
    reg [7:0] v;
    /* field[ */
    v=8'hff;
    for(i=0;i<34;i=i+1) 
      v = {v[6:2],v[1]^v[7]^field[i],v[0]^v[7]^field[i],v[7]^field[i]};
    crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
  end  

  wire [ 3:0] decimal_nsts;
  wire [ 3:0] decimal_nss;
  wire [ 3:0] decimal_nsts_plus_ness;
  wire [ 3:0] decimal_nss_mult_two;
  
  assign decimal_nsts           = {1'b0, nsts} + 4'd1;
  assign decimal_nss            = {1'b0,  nss} + 4'd1;
  assign decimal_nsts_plus_ness = decimal_nsts + {2'b0, ness};
  assign decimal_nss_mult_two   = {decimal_nss[2:0], 1'b0};

  assign invalid_reserved26 = ~field[26];                                 /* reserved bit #26 is not 1 */   
  assign invalid_mcs        = mcs>7'd76;                                  /* illegal mcs code          */   
  assign invalid_length     = length<16'd14;                              /* not NDP and length<14     */  
  assign invalid_ndp_stbc   = ndp & stbc!=2'd0;                           /* NDP and stbc              */     
  assign invalid_ndp_nss    = ndp & nss==NSS_1;                           /* NDP and nss=1SS           */     
  assign invalid_nsts_ness  = decimal_nsts_plus_ness> 4'd4;               /* nsts+ness>4               */     
  assign invalid_nsts_nss   = decimal_nsts > decimal_nss_mult_two;        /* nsts>2*nss                */      
  assign invalid_mcs32_bw   = mcs32 & bandwidth!=3'd1;                    /* mcs32 and cbw!=40         */      
  assign invalid_mcs32_stbc = mcs32 & stbc!=2'd0;                         /* mcs32 and stbc            */   
  assign invalid_crc        = (field[41:34]!=crc);                        /* invalid crc               */
  assign invalid_gf_sgi_1ss = nss==NSS_1 & gi_type==2'd0 & ness==2'd0 & stbc==2'd0; /* HTGF 1SS SGI where field[2 is followed by DATA (11n 20.3.11.11.6)*/             
  
endmodule
`default_nettype wire
