/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_lsig_parser
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,
  
  input  wire        lsig_enable,
  output reg         lsig_captured,
  input  wire        herlsig_enable,
  output reg         herlsig_captured,
  
  /* byte stream */
  output wire        bd_ready,
  input  wire [ 7:0] bd_data,
  input  wire        bd_last,
  input  wire        bd_valid,
  
  /* lsig parameters */
  output wire [ 3:0] rate,
  output wire [11:0] length,
  output reg  [ 2:0] nbpsc,
  output reg  [ 1:0] cr,
  output wire        length_lt_12,
  output wire        length_lt_14,
  output reg         invalid_rate,
  output wire        invalid_reserved4,
  output wire        invalid_parity,
  
  /* herlsig */
  output wire        herlsig_eq_lsig
);
  
  /*****************************************************************************
  * DECLARATION
  *****************************************************************************/
  localparam  LEG_6=4'hb,     LEG_24=4'h9,
              LEG_9=4'hf,     LEG_36=4'hd,
              LEG_12=4'ha,    LEG_48=4'h8,
              LEG_18=4'he,    LEG_54=4'hc;
  
  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;  
 
  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;
  
  /*****************************************************************************
  * CAPTURE
  *****************************************************************************/
  reg [23:0]  lsig;
  reg         bd_ready_lsig;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready_lsig <= 1'b0;
      lsig_captured <= 1'b0;
      lsig          <= 24'b0;
    end
    else if(!lsig_enable)
    begin
      bd_ready_lsig <= 1'b0;
      lsig_captured <= 1'b0;
      lsig          <= 24'b0;
    end
    else
    begin
      if(!lsig_captured)
      begin                                            
        bd_ready_lsig <= 1'b1;
        if(bd_valid)
        begin                                        
          lsig <= {bd_data,lsig[23:8]};              
          if(bd_last)                                  
            lsig_captured <= 1'b1;
        end                   
      end 
      else
      begin
        bd_ready_lsig <= 1'b0;
      end                                             
    end
  end

  reg [23:0]  herlsig;
  reg         bd_ready_herlsig;

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready_herlsig <= 1'b0;
      herlsig_captured <= 1'b0;
      herlsig          <= 24'b0;
    end
    else if(!herlsig_enable)
    begin
      bd_ready_herlsig <= 1'b0;
      herlsig_captured <= 1'b0;
      herlsig          <= 24'b0;
    end
    else
    begin
      if(!herlsig_captured)                                        
      begin 
        bd_ready_herlsig <= 1'b1;
        if(bd_valid)
        begin                                           
          herlsig <= {bd_data,herlsig[23:8]};              
          if(bd_last)                                  
            herlsig_captured <= 1'b1;
        end
      end
      else
      begin
        bd_ready_herlsig <= 1'b0;
      end                   
    end
  end
  
  assign bd_ready        = bd_ready_lsig | bd_ready_herlsig;
  assign herlsig_eq_lsig = herlsig_captured && (lsig==herlsig);

  
  /*****************************************************************************
  * DECODER
  *****************************************************************************/
  assign rate   = lsig[ 3:0];
  assign length = lsig[16:5];
  
  always @(*)
  begin
    case(rate)
      /* nonht rate */
      LEG_6:  {invalid_rate,cr,nbpsc}={1'b0,CR_12, NBPSC_1};
      LEG_9:  {invalid_rate,cr,nbpsc}={1'b0,CR_34, NBPSC_1};
      LEG_12: {invalid_rate,cr,nbpsc}={1'b0,CR_12, NBPSC_2};
      LEG_18: {invalid_rate,cr,nbpsc}={1'b0,CR_34, NBPSC_2};
      LEG_24: {invalid_rate,cr,nbpsc}={1'b0,CR_12, NBPSC_4};
      LEG_36: {invalid_rate,cr,nbpsc}={1'b0,CR_34, NBPSC_4};
      LEG_48: {invalid_rate,cr,nbpsc}={1'b0,CR_23, NBPSC_6};
      LEG_54: {invalid_rate,cr,nbpsc}={1'b0,CR_34, NBPSC_6};
      /* invalid rate */
      default:{invalid_rate,cr,nbpsc}={1'b1,CR_12, NBPSC_1};
    endcase
  end
                                                              
  assign invalid_reserved4 = lsig[4];                   /* reserved bit #4 is not 0 */ 
  assign invalid_parity    = !(^lsig[16:0]==lsig[17]);  /* bad parity               */
  assign length_lt_12      = length<12'd12;               /* leglength<12  see note1  */
  assign length_lt_14      = length<12'd14;               /* leglength<14  */
   
  /* note1: HTMM NDP or HTMM 1SS with a single  1 data symbol gives nonht_length==12  */
endmodule
`default_nettype wire
