/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_rxvector
(
  /* system */
  input  wire           rst_n,
  input  wire           clk,
  
  /* symbol */
  input  wire           enable,
  input  wire           data_confirmed,

  /* config registers */
  input  wire [ 1:0]    mdmcfg_conf_bw,
  input  wire           mdmcfg_qam256_en,
  input  wire           mdmcfg_qam1024_en,
  input  wire           mdmcfg_htmm_en,
  input  wire           mdmcfg_htgf_en,
  input  wire           mdmcfg_vht_en,
  input  wire           mdmcfg_he_en,
  input  wire           mdmcfg_ldpc_en,
  input  wire           mdmcfg_stbc_en,
  input  wire           mdmcfg_dcm_en,
  input  wire [ 2:0]    mdmcfg_nss_max,
  input  wire [15:0]    mdmcfg_bcc_lgi_ndbps_max,
  input  wire [15:0]    mdmcfg_bcc_sgi_ndbps_max,
  input  wire [15:0]    mdmcfg_ldpc_lgi_ndbps_max,
  input  wire [15:0]    mdmcfg_ldpc_sgi_ndbps_max,
  input  wire           mdmcfg_vht_mumimo_en,
  input  wire           mdmcfg_he_mumimo_en,
  input  wire [ 2:0]    mdmcfg_ndp_nsts_max,
  input  wire [35:0]    mdmcfg_frame_violation_mask,
  input  wire [31:0]    mdmcfg_he_frame_violation_mask,
  
  /* mfsm */
  output reg            mfsm_rxv_update,
  output reg            mfsm_frame_unsupported,
  output reg            mfsm_frame_violation,
  output reg            mfsm_phy_error,
  
  /* ucpu */
  input  wire           ucpu_lsig_done,
  input  wire           ucpu_htsig_done,
  input  wire           ucpu_vhtsig_done,
  input  wire           ucpu_hesig_done,
  input  wire [15:0]    ucpu_nsym,
  input  wire [15:0]    ucpu_ncbps,
  input  wire [15:0]    ucpu_ndbps,
  input  wire [23:0]    ucpu_psdulen,
  input  wire           ucpu_inconsistent,
  input  wire [ 2:0]    ucpu_tpe,
  input  wire [ 1:0]    ucpu_l_length_mod3,
  input  wire [ 8:0]    ucpu_nma,
  
  /* lsig parser */
  input  wire           lsig_captured,
  input  wire [ 3:0]    lsig_rate,              
  input  wire [11:0]    lsig_length,            
  input  wire [ 2:0]    lsig_nbpsc,            
  input  wire [ 1:0]    lsig_cr,               
  input  wire           lsig_length_lt_12,      
  input  wire           lsig_length_lt_14,      
  input  wire           lsig_invalid_rate,     
  input  wire           lsig_invalid_reserved4, 
  input  wire           lsig_invalid_parity,     
  
  /* herlsig parser */
  input  wire           herlsig_captured,
  input  wire           herlsig_eq_lsig,
  
  /* htsig parser */
  input  wire           htsig_captured,
  input  wire  [ 6:0]   htsig_mcs,
  input  wire  [ 2:0]   htsig_bandwidth,
  input  wire  [15:0]   htsig_length,
  input  wire           htsig_smoothing,
  input  wire           htsig_sounding,
  input  wire           htsig_aggregation,
  input  wire           htsig_stbc,
  input  wire           htsig_fec,
  input  wire  [ 1:0]   htsig_gi_type,
  input  wire  [ 1:0]   htsig_ness,
  input  wire           htsig_mcs32,
  input  wire           htsig_ndp,
  input  wire  [ 2:0]   htsig_nss,
  input  wire  [ 2:0]   htsig_nsts,
  input  wire  [ 1:0]   htsig_nsd,
  input  wire  [ 1:0]   htsig_cr,
  input  wire  [ 2:0]   htsig_nbpsc,
  
  input wire            htsig_invalid_reserved26,
  input wire            htsig_invalid_mcs,
  input wire            htsig_invalid_length,
  input wire            htsig_invalid_ndp_stbc,
  input wire            htsig_invalid_ndp_nss,
  input wire            htsig_invalid_nsts_ness,
  input wire            htsig_invalid_nsts_nss,
  input wire            htsig_invalid_mcs32_bw,
  input wire            htsig_invalid_mcs32_stbc,
  input wire            htsig_invalid_crc,
  input wire            htsig_invalid_gf_sgi_1ss,
  
  /* vhtsig parser */
  input  wire           vhtsiga_captured,
  input  wire           vhtsigb_captured,
  
  input  wire [  2:0]   vhtsig_bandwidth,
  input  wire           vhtsig_stbc,
  input  wire [  5:0]   vhtsig_gid,
  input  wire           vhtsig_mumimo,
  input  wire           vhtsig_dozenotallowed,
  input  wire [  1:0]   vhtsig_gi_type,
  input  wire           vhtsig_sgidisamb,
  input  wire           vhtsig_extra,
  input  wire [  2:0]   vhtsig_nss,
  input  wire           vhtsig_fec,
  input  wire [  8:0]   vhtsig_paid,
  input  wire [  2:0]   vhtsig_nsts,
  input  wire [  2:0]   vhtsig_nsts_tot,
  input  wire [  3:0]   vhtsig_mcs,
  input  wire           vhtsig_beamformed,
  input  wire           vhtsig_mu_user_valid,
  input  wire           vhtsig_mu_first_user,
  input  wire [  1:0]   vhtsig_mu_posid,
  input  wire [  2:0]   vhtsig_mu_nsts_prev,
  input  wire [  1:0]   vhtsig_nsd,
  input  wire [  1:0]   vhtsig_cr,
  input  wire [  2:0]   vhtsig_nbpsc,
  input  wire [  7:0]   vhtsig_sigb_crc,
  input  wire           vhtsig_invalid_siga_reserved2,
  input  wire           vhtsig_invalid_siga_reserved23,
  input  wire           vhtsig_invalid_siga_reserved31,
  input  wire           vhtsig_invalid_siga_reserved32,
  input  wire           vhtsig_invalid_siga_reserved33,
  input  wire           vhtsig_invalid_siga_crc,
  input  wire           vhtsig_invalid_sgi,
  input  wire           vhtsig_invalid_stbc_odd,
  input  wire           vhtsig_invalid_mcs,
  input  wire           vhtsig_invalid_su_fec_extra,
  input  wire           vhtsig_invalid_mu_stbc,
  input  wire           vhtsig_invalid_mu_nsts_fec,
  
  /* hesiga parser */
  input  wire           hesiga_captured,
  input  wire [ 3:0]    hesiga_format,           
  input  wire           hesiga_beamchange,       
  input  wire           hesiga_uplink, 
  input  wire [ 5:0]    hesiga_bss_color,        
  input  wire [ 3:0]    hesiga_spatial_reuse1,   
  input  wire [ 3:0]    hesiga_spatial_reuse2,   
  input  wire [ 3:0]    hesiga_spatial_reuse3,   
  input  wire [ 3:0]    hesiga_spatial_reuse4,   
  input  wire [ 2:0]    hesiga_bandwidth,        
  input  wire [ 1:0]    hesiga_gi_type,          
  input  wire [ 1:0]    hesiga_ltf_type,         
  input  wire [ 2:0]    hesiga_nheltf,           
  input  wire [ 6:0]    hesiga_txop,             
  input  wire           hesiga_extra,            
  input  wire           hesiga_stbc,             
  input  wire [ 1:0]    hesiga_a,                
  input  wire           hesiga_pedisamb,         
  input  wire           hesiga_doppler,          
  input  wire           hesiga_midamble,          
  input  wire [ 2:0]    hesiga_sigb_mcs,         
  input  wire           hesiga_sigb_dcm, 
  input  wire [ 2:0]    hesiga_sigb_nbpsc,
  input  wire [ 1:0]    hesiga_sigb_cr,
  input  wire [ 7:0]    hesiga_sigb_ndbps,
  input  wire [ 7:0]    hesiga_sigb_nsym, 
  input  wire [ 2:0]    hesiga_sigb_compression_nuser, 
  input  wire           hesiga_sigb_compression, 
  input  wire           hesiga_invalid_crc,
  
  /* hesiga/hesigb parser */
  input  wire           hesig_user_valid,
  input  wire [ 3:0]    hesig_mcs,
  input  wire           hesig_rusegment,
  input  wire [ 5:0]    hesig_ruindex,
  input  wire [ 3:0]    hesig_runuser,
  input  wire [ 2:0]    hesig_ruuser,
  input  wire [ 2:0]    hesig_nsts_prev,
  input  wire [ 2:0]    hesig_nsts_tot,
  input  wire [ 2:0]    hesig_nsts,
  input  wire           hesig_beamformed,
  input  wire [ 2:0]    hesig_nbpsc, 
  input  wire [ 1:0]    hesig_cr, 
  input  wire           hesig_dcm,
  input  wire [ 2:0]    hesig_rulen,
  input  wire           hesig_fec,
  
  /* data parser */
  input  wire           service_captured,
  input  wire [15:0]    service,           
  
  /* AGC/CCA */
  output reg            cca_lsig_valid,
  output reg            cca_htsig_vhtsiga_valid,

  /* frame parameters */
  /* part 1 */
  output reg            framep1_update,
  output reg  [ 3:0]    framep1_format,
  output reg  [ 1:0]    framep1_nsd,
  output reg  [ 1:0]    framep1_cr,
  output reg  [ 2:0]    framep1_nbpsc,
  output reg  [ 2:0]    framep1_nss,
  output reg  [ 2:0]    framep1_nsts,
  output reg  [ 1:0]    framep1_ness,
  output reg            framep1_stbc,
  output reg            framep1_fec,
  output reg            framep1_smoothing,
  output reg            framep1_htndp,
  output reg            framep1_mumimo,
  output reg            framep1_beamformed,
  output reg  [ 2:0]    framep1_vhtmu_nsts_tot,
  output reg  [ 2:0]    framep1_vhtmu_nsts_prev,
  output reg  [ 1:0]    framep1_vhtmu_userpos,
  output reg            framep1_dcm,
  output reg  [ 2:0]    framep1_rulen,
  output reg  [ 1:0]    framep1_gi_type,
  output reg  [ 6:0]    framep1_mcs,
  output reg  [ 3:0]    framep1_legrate,
  output reg  [ 2:0]    framep1_bandwidth,
  output reg            framep1_vhtndp,
  output reg [ 2:0]     framep1_hesigb_mcs, 
  output reg            framep1_hesigb_dcm, 
  output reg [ 2:0]     framep1_hesigb_nbpsc,
  output reg [ 1:0]     framep1_hesigb_cr,
  output reg [ 7:0]     framep1_hesigb_ndbps,
  output reg [ 2:0]     framep1_nheltf,
  output reg [ 1:0]     framep1_heltftype,
  output reg            framep1_doppler,
  output reg            framep1_midamble,
  
  /* part 2 */
  output reg            framep2_update,
  output reg  [ 2:0]    framep2_mu_nbpsc,
  output reg            framep2_hemu_beamformed,
  output reg            framep2_hemu_rusegment,
  output reg  [ 2:0]    framep2_hemu_rulen,
  output reg  [ 5:0]    framep2_hemu_ruindex,
  output reg  [ 3:0]    framep2_hemu_runuser,
  output reg  [ 2:0]    framep2_hemu_ruuser,
  output reg            framep2_hemu_dcm,
  output reg  [ 2:0]    framep2_hemu_nsts,
  output reg  [ 2:0]    framep2_hemu_nsts_tot,
  output reg  [ 2:0]    framep2_hemu_nsts_prev,
  output reg            framep2_hemu_fec,
  /* part 3 */
  output reg            framep3_update,
  output reg            framep3_he_confirmed,
  /* part 4 */
  output reg            framep4_update,
  output reg            framep4_lsig6m,
  /* part 6 */
  output reg            framep6_update,
  output reg            framep6_l_length_mod3_eq_1,
  /* part 7 */
  output reg            framep7_update,
  output reg [ 7:0]     framep7_hesigb_nsym, 
  /* part 8 */
  output reg            framep8_update,
  output reg  [15:0]    framep8_ncbps,
  output reg  [15:0]    framep8_nsym,
  output reg  [ 2:0]    framep8_tpe,
  output reg  [ 8:0]    framep8_nma,

  /* MAC/PHY interface */
  /* rxvector */
  output reg            rxv1_update,
  output reg  [ 3:0]    rxv1_format,
  output reg  [ 2:0]    rxv1_ch_bandwidth,
  output reg            rxv2_update,
  output reg  [11:0]    rxv2_l_length,
  output reg  [ 3:0]    rxv2_l_rate,
  output reg  [ 7:0]    rxv2_rssi,
  output reg            rxv2_dyn_bandwidth_in_non_ht,
  output reg  [ 1:0]    rxv2_ch_bandwidth_in_non_ht,
  output reg            rxv2_sounding,
  output reg            rxv2_smoothing,
  output reg  [ 1:0]    rxv2_gi_type,
  output reg            rxv2_aggregation,
  output reg            rxv2_stbc,
  output reg  [ 1:0]    rxv2_num_ext_ss,
  output reg            rxv2_l_sig_valid,
  output reg            rxv2_beamformed,
  output reg            rxv2_doze_not_allowed,
  output reg            rxv2_first_user,
  output reg  [ 8:0]    rxv2_partial_aid,
  output reg  [ 5:0]    rxv2_group_id,
  output reg  [ 6:0]    rxv2_mcs,
  output reg  [ 2:0]    rxv2_nss,
  output reg            rxv2_fec_coding,
  output reg  [19:0]    rxv2_length,
  output reg            rxv2_uplink_flag,
  output reg            rxv2_beam_change,
  output reg            rxv2_dcm,
  output reg  [ 2:0]    rxv2_rulen,
  output reg  [ 1:0]    rxv2_he_ltf_type,
  output reg            rxv2_doppler,
  output reg  [ 5:0]    rxv2_bss_color,
  output reg  [ 6:0]    rxv2_txop_duration,
  output reg  [ 3:0]    rxv2_pe_duration,
  output reg  [ 3:0]    rxv2_spatial_reuse,
  output reg            rxv2_sig_b_compression_mode,
  output reg            rxv2_dcm_sig_b,
  output reg  [ 2:0]    rxv2_mcs_sig_b,
  output reg  [ 7:0]    rxv2_n_user,
  output reg  [10:0]    rxv2_staid
);
  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  localparam  LEG_6=4'hb,
              LEG_9=4'hf,
              LEG_12=4'ha,
              LEG_18=4'he,
              LEG_24=4'h9,
              LEG_36=4'hd,
              LEG_48=4'h8,
              LEG_54=4'hc;

  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;

  localparam  RU_26=3'd0, 
              RU_52=3'd1, 
              RU_106=3'd2, 
              RU_242=3'd3, 
              RU_484=3'd4, 
              RU_996=3'd5, 
              RU_2X996=3'd6;

  localparam  NSTS_1=3'd0,
              NSTS_2=3'd1,
              NSTS_3=3'd2,
              NSTS_4=3'd3,
              NSTS_5=3'd4,
              NSTS_6=3'd5,
              NSTS_7=3'd6, 
              NSTS_8=3'd7; 

  localparam  BD_IDLE=5'd0,
              BD_LSIG=5'd1,
              BD_LDATA0_VHTSIGA1=5'd2,
              BD_LDATA=5'd3,
              BD_HTSIG1=5'd4,
              BD_HTSIG2=5'd5,
              BD_HTDATA=5'd6,
              BD_VHTSIGA2=5'd7,
              BD_VHTSIGB=5'd8,
              BD_VHTDATA=5'd9,
              BD_HERLSIG=5'd10,
              BD_HESIGA1=5'd11,
              BD_HESIGA2=5'd12,
              BD_HEERSUSIGA2=5'd13,
              BD_HEERSUSIGA3=5'd14,
              BD_HEERSUSIGA4=5'd15,
              BD_HESIGB=5'd16,
              BD_HEDATA=5'd17;

  localparam  NON_HT=4'd0,    
              NON_HT_DUP=4'd1,
              HT_MM=4'd2,     
              HT_GF=4'd3,
              VHT=4'd4,
              HE_SU=4'd5,     
              HE_MU=4'd6,       
              HE_ER_SU=4'd7,    
              HE_TB=4'd8;

  localparam  GI_400=2'd0,
              GI_800=2'd1,
              GI_1600=2'd2,
              GI_3200=2'd3;            

  localparam  HELTF_1X=2'd0,
              HELTF_2X=2'd1,
              HELTF_4X=2'd2;            
  
  /* frame violation and unsupported */
  wire        nonht_frame_violation;
  wire        ht_frame_violation;
  wire        ht_frame_unsupported;
  wire        vht_siga_frame_violation;
  wire        vht_ucpu_frame_violation;
  wire        vht_sigbcrc_frame_violation;
  wire        vht_siga_frame_unsupported;
  wire        vht_ucpu_frame_unsupported;
  wire        hesu_siga_frame_violation;
  wire        hesu_ucpu_frame_violation;
  wire        hesu_siga_frame_unsupported;
  wire        hesu_ucpu_frame_unsupported;
  wire        hemu_siga_frame_violation;
  wire        hemu_ucpu_frame_violation;
  wire        hemu_siga_frame_unsupported;
  wire        hemu_ucpu_frame_unsupported;
  wire        hetb_siga_frame_violation;
  wire        hetb_siga_frame_unsupported;
 
  wire [31:0] frame_violation_rule;
  
  /* small frame detection */
  reg         nonht_smallframe_valid;
  reg         ht_smallframe_valid;
  
  /*****************************************************************************
  * RXVECTOR and frame parameters
  *****************************************************************************/
  wire   vht_ndp;
  assign vht_ndp = ((lsig_length==12'd15) & (vhtsig_nsts==3'd1)                  ) |
                   ((lsig_length==12'd21) & (vhtsig_nsts==3'd2 || vhtsig_nsts==3'd3)) |
                   ((lsig_length==12'd27) & (vhtsig_nsts==3'd4 || vhtsig_nsts==3'd5)) |
                   ((lsig_length==12'd33) & (vhtsig_nsts==3'd6 || vhtsig_nsts==3'd7));

  wire   he_ndp;
  assign he_ndp = (ucpu_nsym==16'd0);
 
  /* rxvector decoding */
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      mfsm_rxv_update              <= 1'b0;
      mfsm_frame_violation         <= 1'b0;
      mfsm_frame_unsupported       <= 1'b0;
      mfsm_phy_error               <= 1'b0;

      rxv1_update                  <= 1'b0;
      rxv1_format                  <= 4'd0;
      rxv1_ch_bandwidth            <= 3'b0;
      rxv2_update                  <= 1'b0;
      rxv2_l_length                <= 12'b0;
      rxv2_l_rate                  <= 4'b0;
      rxv2_rssi                    <= 8'b0;
      rxv2_dyn_bandwidth_in_non_ht <= 1'b0;
      rxv2_ch_bandwidth_in_non_ht  <= 2'b0;
      rxv2_sounding                <= 1'b0;
      rxv2_smoothing               <= 1'b0;
      rxv2_gi_type                 <= 2'b0;
      rxv2_aggregation             <= 1'b0;
      rxv2_stbc                    <= 1'b0;
      rxv2_num_ext_ss              <= 2'b0;
      rxv2_l_sig_valid             <= 1'b0;
      rxv2_beamformed              <= 1'b0;
      rxv2_doze_not_allowed        <= 1'b0;
      rxv2_first_user              <= 1'b0;
      rxv2_partial_aid             <= 9'b0;
      rxv2_group_id                <= 6'b0;
      rxv2_mcs                     <= 7'b0;
      rxv2_nss                     <= 3'b0;
      rxv2_fec_coding              <= 1'b0;
      rxv2_length                  <= 20'b0;
      rxv2_uplink_flag             <= 1'b0;
      rxv2_beam_change             <= 1'b0;
      rxv2_dcm                     <= 1'b0;
      rxv2_rulen                   <= 3'b0;
      rxv2_he_ltf_type             <= 2'b0;
      rxv2_doppler                 <= 1'b0;
      rxv2_bss_color               <= 6'b0;
      rxv2_txop_duration           <= 7'b0;
      rxv2_pe_duration             <= 4'b0;
      rxv2_spatial_reuse           <= 4'b0;
      rxv2_sig_b_compression_mode  <= 1'b0;
      rxv2_dcm_sig_b               <= 1'b0;
      rxv2_mcs_sig_b               <= 3'b0;
      rxv2_n_user                  <= 8'b0;
      rxv2_staid                   <= 11'b0;
      
      framep1_update               <= 1'b0;
      framep1_format               <= 4'd0;
      framep1_nsd                  <= 2'b0;
      framep1_cr                   <= 2'b0;
      framep1_nbpsc                <= 3'b0;
      framep1_nss                  <= 3'b0;
      framep1_nsts                 <= 3'b0;
      framep1_ness                 <= 2'b0;
      framep1_stbc                 <= 1'b0;
      framep1_fec                  <= 1'b0;
      framep1_smoothing            <= 1'b0;
      framep1_htndp                <= 1'b0;
      framep1_mumimo               <= 1'b0;
      framep1_beamformed           <= 1'b0;
      framep1_vhtmu_nsts_prev      <= 3'b0;
      framep1_vhtmu_nsts_tot       <= 3'b0;
      framep1_vhtmu_userpos        <= 3'b0;
      framep1_dcm                  <= 1'b0;
      framep1_rulen                <= 3'b0;
      framep1_gi_type              <= 2'b0;
      framep1_mcs                  <= 7'b0;
      framep1_legrate              <= 4'b0;
      framep1_bandwidth            <= 3'b0;
      framep1_vhtndp               <= 1'b0;
      framep1_hesigb_mcs           <= 3'b0;  
      framep1_hesigb_dcm           <= 1'b0;  
      framep1_hesigb_nbpsc         <= 3'b0;  
      framep1_hesigb_cr            <= 2'b0;  
      framep1_hesigb_ndbps         <= 8'd0;  
      framep1_nheltf               <= 3'd0;
      framep1_heltftype            <= 2'd0;
      framep1_doppler              <= 1'b0;
      framep1_midamble             <= 1'b0; 
     
      framep2_update               <= 1'b0;
      framep2_mu_nbpsc             <= 3'b0;
      framep2_hemu_beamformed      <= 1'b0;
      framep2_hemu_rusegment       <= 1'b0;
      framep2_hemu_rulen           <= 3'b0;
      framep2_hemu_ruindex         <= 6'b0;
      framep2_hemu_runuser         <= 4'b0;
      framep2_hemu_ruuser          <= 3'b0; 
      framep2_hemu_dcm             <= 1'b0;
      framep2_hemu_nsts            <= 3'b0;   
      framep2_hemu_nsts_tot        <= 3'b0;   
      framep2_hemu_nsts_prev       <= 3'b0;   
      framep2_hemu_fec             <= 1'b0;   

      framep3_update               <= 1'b0;
      framep3_he_confirmed         <= 1'b0;

      framep4_update               <= 1'b0;
      framep4_lsig6m               <= 1'b0;

      framep6_update               <= 1'b0;
      framep6_l_length_mod3_eq_1   <= 1'b0;
     
      framep7_update               <= 1'd0;  
      framep7_hesigb_nsym          <= 8'd0;  
    
      framep8_update               <= 1'b0;
      framep8_ncbps                <= 16'b0;
      framep8_nsym                 <= 16'b0;
      framep8_tpe                  <= 3'd0;
      framep8_nma                  <= 9'd0;
    
      cca_lsig_valid               <= 1'b0;
      cca_htsig_vhtsiga_valid      <= 1'b0;
    end
    else if(!enable)
    begin
      mfsm_rxv_update              <= 1'b0;
      mfsm_frame_violation         <= 1'b0;
      mfsm_frame_unsupported       <= 1'b0;
      mfsm_phy_error               <= 1'b0;

      rxv1_update                  <= 1'b0;
      rxv1_format                  <= 4'd0;
      rxv1_ch_bandwidth            <= 3'b0;
      rxv2_update                  <= 1'b0;
      rxv2_l_length                <= 12'b0;
      rxv2_l_rate                  <= 4'b0;
      rxv2_rssi                    <= 8'b0;
      rxv2_dyn_bandwidth_in_non_ht <= 1'b0;
      rxv2_ch_bandwidth_in_non_ht  <= 2'b0;
      rxv2_sounding                <= 1'b0;
      rxv2_smoothing               <= 1'b0;
      rxv2_gi_type                 <= 2'b0;
      rxv2_aggregation             <= 1'b0;
      rxv2_stbc                    <= 1'b0;
      rxv2_num_ext_ss              <= 2'b0;
      rxv2_l_sig_valid             <= 1'b0;
      rxv2_beamformed              <= 1'b0;
      rxv2_doze_not_allowed        <= 1'b0;
      rxv2_first_user              <= 1'b0;
      rxv2_partial_aid             <= 9'b0;
      rxv2_group_id                <= 6'b0;
      rxv2_mcs                     <= 7'b0;
      rxv2_nss                     <= 3'b0;
      rxv2_fec_coding              <= 1'b0;
      rxv2_length                  <= 20'b0;
      rxv2_uplink_flag             <= 1'b0;
      rxv2_beam_change             <= 1'b0;
      rxv2_dcm                     <= 1'b0;
      rxv2_rulen                   <= 3'b0;
      rxv2_he_ltf_type             <= 2'b0;
      rxv2_doppler                 <= 1'b0;
      rxv2_bss_color               <= 6'b0;
      rxv2_txop_duration           <= 7'b0;
      rxv2_pe_duration             <= 4'b0;
      rxv2_spatial_reuse           <= 4'b0;
      rxv2_sig_b_compression_mode  <= 1'b0;
      rxv2_dcm_sig_b               <= 1'b0;
      rxv2_mcs_sig_b               <= 3'b0;
      rxv2_n_user                  <= 8'b0;
      rxv2_staid                   <= 11'b0;

      framep1_update               <= 1'b0;
      framep1_format               <= 4'd0;
      framep1_nsd                  <= 2'b0;
      framep1_cr                   <= 2'b0;
      framep1_nbpsc                <= 3'b0;
      framep1_nss                  <= 3'b0;
      framep1_nsts                 <= 3'b0;
      framep1_ness                 <= 2'b0;
      framep1_stbc                 <= 1'b0;
      framep1_fec                  <= 1'b0;
      framep1_smoothing            <= 1'b0;
      framep1_htndp                <= 1'b0;
      framep1_mumimo               <= 1'b0;
      framep1_beamformed           <= 1'b0;
      framep1_vhtmu_nsts_prev      <= 3'b0;
      framep1_vhtmu_nsts_tot       <= 3'b0;
      framep1_vhtmu_userpos        <= 3'b0;
      framep1_dcm                  <= 1'b0;
      framep1_rulen                <= 3'b0;
      framep1_gi_type              <= 2'b0;
      framep1_mcs                  <= 7'b0;
      framep1_legrate              <= 4'b0;
      framep1_bandwidth            <= 3'b0;
      framep1_vhtndp               <= 1'b0;
      framep1_hesigb_mcs           <= 3'b0;  
      framep1_hesigb_dcm           <= 1'b0;  
      framep1_hesigb_nbpsc         <= 3'b0;  
      framep1_hesigb_cr            <= 2'b0;  
      framep1_hesigb_ndbps         <= 8'd0;  
      framep1_nheltf               <= 3'd0;
      framep1_heltftype            <= 2'd0;
      framep1_doppler              <= 1'b0;
      framep1_midamble             <= 1'b0; 
      
      framep2_update               <= 1'b0;
      framep2_mu_nbpsc             <= 3'b0;
      framep2_hemu_beamformed      <= 1'b0;
      framep2_hemu_rusegment       <= 1'b0;
      framep2_hemu_rulen           <= 3'b0;
      framep2_hemu_ruindex         <= 6'b0;
      framep2_hemu_runuser         <= 4'b0;
      framep2_hemu_ruuser          <= 3'b0; 
      framep2_hemu_dcm             <= 1'b0;
      framep2_hemu_nsts            <= 3'b0;   
      framep2_hemu_nsts_tot        <= 3'b0;   
      framep2_hemu_nsts_prev       <= 3'b0;   
      framep2_hemu_fec             <= 1'b0;   
 
      framep3_update               <= 1'b0;
      framep3_he_confirmed         <= 1'b0;

      framep4_update               <= 1'b0;
      framep4_lsig6m               <= 1'b0;
     
      framep6_update               <= 1'b0;
      framep6_l_length_mod3_eq_1   <= 1'b0;

      framep7_update               <= 1'd0;  
      framep7_hesigb_nsym          <= 8'd0;  
    
      framep8_update               <= 1'b0;
      framep8_ncbps                <= 16'b0;
      framep8_nsym                 <= 16'b0;
      framep8_tpe                  <= 3'd0;
      framep8_nma                  <= 9'd0;
     
      cca_lsig_valid               <= 1'b0;
      cca_htsig_vhtsiga_valid      <= 1'b0;
    end
    else
    begin 

      /* he confirmation*/
      if(ucpu_lsig_done)
      begin
        if(ucpu_l_length_mod3==2'd0)
        begin
          /* confirmed that is not a HE frame */
          framep3_update       <= 1'b1;
          framep3_he_confirmed <= 1'b0;
        end
        else
        begin
          if(herlsig_captured)
          begin
            framep3_update       <= 1'b1;
            framep3_he_confirmed <= herlsig_eq_lsig;
          end
        end
      end

      /*************************************************************************
      * NON-HT 
      *************************************************************************/ 
      if(lsig_captured)
      begin
        if(ucpu_lsig_done)
        begin
          framep6_update             <= 1'b1;
          framep6_l_length_mod3_eq_1 <= ucpu_l_length_mod3==2'd1;
        end
        
        if(lsig_rate!=LEG_6)                                                           
        begin                                                                           
          /* NONHT confirmed */
          
          /* framep1 */
          framep1_update    <= 1'b1;
          framep1_format    <= NON_HT;                                                      
          framep1_nsd       <= NSD_48;                                                    
          framep1_nbpsc     <= lsig_nbpsc; 
          framep1_cr        <= lsig_cr;
          framep1_bandwidth <= 3'd0;
          framep1_mcs       <= 7'b0;
          framep1_legrate   <= lsig_rate;
          
          /* framep2 */
          if(nonht_smallframe_valid)
          begin
            /* known small frame */
            framep2_update  <= 1'b1;                                                      
            framep8_update  <= 1'b1;                                                      
            framep8_nsym    <= 16'd1;                                         
          end
          else if(ucpu_lsig_done)
          begin
            /* wait nsym from ucpu */
            framep2_update  <= 1'b1;                                                      
            framep8_update  <= 1'b1;                                                      
            framep8_nsym    <= ucpu_nsym;                                         
          end
        
          /* framep4 */
          framep4_update    <= 1'b1;
          framep4_lsig6m    <= 1'b0;
          
          /* rxvp1 */
          rxv1_update       <= 1'b1;
          rxv1_format       <= NON_HT;
          rxv1_ch_bandwidth <= 3'd0; /* 20M */
          
          /* rxvp2 */
          if(data_confirmed && service_captured)
          begin
            rxv2_update                  <= 1'b1;
            rxv2_l_rate                  <= lsig_rate;                                      
            rxv2_l_length                <= lsig_length;                                    
            rxv2_l_sig_valid             <= 1'b1; 
            rxv2_ch_bandwidth_in_non_ht  <= service[6:5];
            rxv2_dyn_bandwidth_in_non_ht <= service[4];         
          end
          
          /* MFSM */
          if(lsig_length_lt_14 || nonht_frame_violation)
          begin
            /* lsig inconsistent */
            mfsm_frame_violation <= 1'b1;
          end
          else
          begin
            /* lock agccca  */
            mfsm_rxv_update <= 1'b1;
            cca_lsig_valid  <= 1'b1;
          end
        end
        else
        begin
          /* framep4 */
          framep4_update    <= 1'b1;
          framep4_lsig6m    <= 1'b1;
          
          /* lock agccca  */
          cca_lsig_valid    <= ~nonht_frame_violation;
          
          if(data_confirmed && !htsig_captured && !vhtsiga_captured && !hesiga_captured)
          begin
            /* NONHT 6M confirmed */
            /* framep1 */
           
            framep1_update    <= 1'b1;
            framep1_format    <= NON_HT;                                                    
            framep1_nsd       <= NSD_48;                                                  
            framep1_nbpsc     <= lsig_nbpsc; 
            framep1_cr        <= lsig_cr;
            framep1_bandwidth <= 3'd0;
            framep1_mcs       <= 7'b0;
            framep1_legrate   <= lsig_rate;
          
            /* framep2 */
            if(nonht_smallframe_valid)
            begin
              /* known small frame */
              framep2_update  <= 1'b1;                                                    
              framep8_update  <= 1'b1;                                                    
              framep8_nsym    <= 16'd1;                                         
            end
            else if(ucpu_lsig_done)
            begin
              /* wait nsym from ucpu */
              framep2_update  <= 1'b1;                                                    
              framep8_update  <= 1'b1;                                                    
              framep8_nsym    <= ucpu_nsym;                                        
            end
          
            /* framep3 */
            framep3_update    <= 1'b1;
        
            /* MFSM */
            if(lsig_length_lt_14 || nonht_frame_violation)
            begin
              /* lsig inconsistent */
              mfsm_frame_violation <= 1'b1;
            end
            else
            begin
              mfsm_rxv_update <= 1'b1;
            end
          
            /* rxvp1 */
            rxv1_update       <= 1'b1;
            rxv1_format       <= NON_HT;
            rxv1_ch_bandwidth <= 3'd0; /* 20M */
          
            /* rxvp2 */
            if(service_captured)
            begin
              rxv2_update                  <= 1'b1;
              rxv2_l_rate                  <= lsig_rate;                                    
              rxv2_l_length                <= lsig_length;                                  
              rxv2_l_sig_valid             <= 1'b1; 
              rxv2_ch_bandwidth_in_non_ht  <= service[6:5];
              rxv2_dyn_bandwidth_in_non_ht <= service[4];         
            end
          end
        end
      end          
     
      /*************************************************************************
      * HTGF/HTMM
      *************************************************************************/
      if(htsig_captured)
      begin
        /* framep1 */
        framep1_update    <= 1'b1;
        framep1_format    <= lsig_captured?HT_MM:HT_GF;                                                      
        framep1_nsd       <= htsig_nsd;         
        framep1_nsts      <= htsig_nsts;         
        framep1_cr        <= htsig_cr;
        framep1_nbpsc     <= htsig_nbpsc;     
        framep1_nss       <= htsig_nss;         
        framep1_ness      <= htsig_ness;        
        framep1_stbc      <= htsig_stbc!=2'b0;
        framep1_fec       <= htsig_fec;
        framep1_smoothing <= htsig_smoothing;  
        framep1_htndp     <= htsig_length==16'd0;  
        framep1_mcs       <= htsig_mcs[6:0];
        framep1_legrate   <= lsig_rate;
        framep1_bandwidth <= htsig_bandwidth;
        framep1_gi_type   <= htsig_gi_type;
      
        /* framep2 */
        if(ht_smallframe_valid)
        begin
          /* known small frame */
          framep2_update <= 1'b1;                            
          framep8_update <= 1'b1;                            
          framep8_ncbps  <= 16'd0; /* not used in bcc */                           
          framep8_nsym   <= 16'd1;         
        end
        else if(ucpu_htsig_done)                                     
        begin                                                
          framep2_update <= 1'b1;                            
          framep8_update <= 1'b1;                            
          framep8_ncbps  <= ucpu_ncbps;                           
          framep8_nsym   <= (htsig_length==16'd0)?16'd0:ucpu_nsym;         
        end                                                  
       
        /* rxvp1 */
        rxv1_update    <= 1'b1;               
        rxv2_update    <= 1'b1;               
        if(lsig_captured)
        begin
          rxv1_format       <= HT_MM;  
          rxv2_l_rate       <= lsig_rate;         
          rxv2_l_length     <= lsig_length;       
          rxv2_l_sig_valid  <= ~nonht_frame_violation;
        end
        else
        begin
          rxv1_format       <= HT_GF;                        
        end          
        
        rxv1_ch_bandwidth <= htsig_bandwidth;                
        rxv2_update       <= 1'b1;
        rxv2_length       <= {4'b0,htsig_length};         
        rxv2_gi_type      <= htsig_gi_type;               
        rxv2_stbc         <= htsig_stbc;                  
        rxv2_smoothing    <= htsig_smoothing;             
        rxv2_mcs          <= htsig_mcs;                   
        rxv2_sounding     <= htsig_sounding;              
        rxv2_num_ext_ss   <= htsig_ness;                  
        rxv2_fec_coding   <= htsig_fec;
        rxv2_aggregation  <= htsig_aggregation;               
        
        if(ht_frame_violation)
        begin
          /* htsig is corrupted */
          mfsm_frame_violation    <= 1'b1;
        end
        else
        begin
          /* htsig is corrrect */
          cca_htsig_vhtsiga_valid <= 1'b1;
          mfsm_rxv_update         <= 1'b1;
          
          if(ucpu_htsig_done)
          begin
            /* need to wait ucpu for ndbps_max check */
            mfsm_frame_unsupported  <= ht_frame_unsupported;
          end
        end
      end
  
      /*************************************************************************
      * VHT
      *************************************************************************/
      if(vhtsiga_captured)
      begin
        framep1_update          <= 1'b1;
        framep1_format          <= VHT;
        framep1_bandwidth       <= vhtsig_bandwidth;
        framep1_nsd             <= vhtsig_nsd;
        framep1_cr              <= vhtsig_cr;
        framep1_nbpsc           <= vhtsig_nbpsc;
        framep1_nss             <= vhtsig_nss;
        framep1_stbc            <= vhtsig_stbc;
        framep1_fec             <= vhtsig_fec;
        framep1_smoothing       <= ~vhtsig_beamformed;
        framep1_mumimo          <= vhtsig_mumimo;
        framep1_nsts            <= vhtsig_nsts;
        framep1_vhtmu_nsts_tot  <= vhtsig_nsts_tot;
        framep1_vhtmu_nsts_prev <= vhtsig_mu_nsts_prev;
        framep1_vhtmu_userpos   <= vhtsig_mu_posid;
        framep1_mcs             <= {3'b0,vhtsig_mcs}; // In case of Mu-MIMO, MCS is available only after VHTSIGB decoding
        framep1_legrate         <= lsig_rate;
        framep1_gi_type         <= vhtsig_gi_type;
       
        if(!vhtsig_mumimo)
        begin
          /* SU */
          framep1_vhtndp <= vht_ndp;
        end
        else
        begin
          framep1_mumimo <= 1'b1;
        end
       
        /* framep2 */
        if(vhtsig_mumimo)
        begin
          if(vhtsigb_captured)
          begin
            framep2_update    <= 1'b1;
            framep2_mu_nbpsc  <= vhtsig_nbpsc;
          end
        end
        else
        begin
          framep2_update <= 1'b1;
        end
        
        /* framep8 */
        if(vht_ndp)
        begin
          framep8_update    <= 1'b1;
          framep8_nsym      <= 16'd0;
          framep8_ncbps     <= 16'd0;
        end
        else if(ucpu_vhtsig_done)
        begin
          framep8_update    <= 1'b1;
          framep8_nsym      <= ucpu_nsym;
          framep8_ncbps     <= ucpu_ncbps;
        end
        
        /* rxvp1 */
        rxv1_update       <= 1'b1;
        rxv1_format       <= VHT;
        rxv1_ch_bandwidth <= vhtsig_bandwidth;
       
        /* rxvp2 */
        if(vht_ndp || vht_siga_frame_unsupported || ucpu_vhtsig_done) 
        begin
          /* note1: in case of unsupported from siga, rxv2_mcs may not be accurate    (mu frame)     */
          /* note2: in case of unsupported from siga, rxv2_length may not be accurate (ucpu latency) */
          rxv2_update           <= 1'b1;
          rxv2_l_rate           <= lsig_rate;
          rxv2_l_length         <= lsig_length;
          rxv2_length           <= ucpu_psdulen[19:0]; /* bit [25:20] unsupported */
          rxv2_gi_type          <= vhtsig_gi_type;
          rxv2_stbc             <= vhtsig_stbc;
          rxv2_mcs              <= {3'b0,vhtsig_mcs};
          rxv2_nss              <= vhtsig_nss;
          rxv2_l_sig_valid      <= 1'b1;
          rxv2_fec_coding       <= vhtsig_fec;
          rxv2_partial_aid      <= vhtsig_paid;
          rxv2_group_id         <= vhtsig_gid;
          rxv2_first_user       <= vhtsig_mu_first_user;
          rxv2_doze_not_allowed <= vhtsig_dozenotallowed;                 
          rxv2_aggregation      <= 1'b1;
          rxv2_beamformed       <= vhtsig_beamformed;
        end

        /* mfsm/cca */
        if(vht_siga_frame_violation)
        begin
          /* vhtsiga is corrupted */
          mfsm_frame_violation <= 1'b1;
        end
        else
        begin
          /* vhtsiga at first glance is correct */
          cca_htsig_vhtsiga_valid <= 1'b1;
          
          if(vht_ndp || vht_siga_frame_unsupported)
          begin
            mfsm_rxv_update         <= 1'b1;
            mfsm_frame_unsupported  <= vht_siga_frame_unsupported;
          end
          else if(ucpu_vhtsig_done)
          begin
            if(vht_ucpu_frame_violation || vht_sigbcrc_frame_violation)
            begin
              mfsm_frame_violation <= 1'b1;
            end
            else
            begin
              mfsm_rxv_update         <= 1'b1;
              mfsm_frame_unsupported  <= vht_ucpu_frame_unsupported;
            end
          end
        end
      end

      /*************************************************************************
      * HE
      *************************************************************************/
      if(hesiga_captured)
      begin
        /* RXV and FRAME PARAM */
        rxv1_update        <= 1'b1;
        rxv1_format        <= hesiga_format;
        rxv1_ch_bandwidth  <= hesiga_bandwidth;
        
        framep1_update     <= 1'b1;
        framep1_format     <= hesiga_format;
        framep1_cr         <= hesig_cr;
        framep1_nbpsc      <= hesig_nbpsc;
        framep1_nss        <= hesiga_stbc?{1'b0,hesig_nsts[2:1]}:hesig_nsts;
        framep1_nsts       <= hesig_nsts;
        framep1_stbc       <= hesiga_stbc;
        framep1_fec        <= hesig_fec;
        framep1_beamformed <= hesig_beamformed;
        framep1_legrate    <= lsig_rate;
        case(hesiga_bandwidth)
          3'd0:    framep1_rulen <= RU_242;
          3'd1:    framep1_rulen <= RU_484;
          3'd2:    framep1_rulen <= RU_996;
          default: framep1_rulen <= RU_2X996;
        endcase
        
        framep1_gi_type      <= hesiga_gi_type;
        framep1_mcs          <= {3'b0,hesig_mcs};
        framep1_bandwidth    <= hesiga_bandwidth;
        framep1_dcm          <= hesig_dcm; 
        framep1_hesigb_mcs   <= hesiga_sigb_mcs; 
        framep1_hesigb_dcm   <= hesiga_sigb_dcm; 
        framep1_hesigb_nbpsc <= hesiga_sigb_nbpsc; 
        framep1_hesigb_cr    <= hesiga_sigb_cr; 
        framep1_hesigb_ndbps <= hesiga_sigb_ndbps; 
        framep1_nheltf       <= hesiga_nheltf;
        framep1_heltftype    <= hesiga_ltf_type;
        framep1_doppler      <= hesiga_doppler;
        framep1_midamble     <= hesiga_midamble;
        
        framep7_update       <= 1'b1;
        framep7_hesigb_nsym  <= hesiga_sigb_nsym; 

        if(ucpu_hesig_done)
        begin
          if(hesiga_format==HE_MU)
          begin
            /*HE_MU */
            framep2_mu_nbpsc        <= hesig_nbpsc;
            framep2_hemu_fec        <= hesig_fec;
            framep2_hemu_rusegment  <= hesig_rusegment;
            framep2_hemu_rulen      <= hesig_rulen;
            framep2_hemu_ruindex    <= hesig_ruindex;
            framep2_hemu_runuser    <= hesig_runuser;
            framep2_hemu_ruuser     <= hesig_ruuser;
            framep2_hemu_dcm        <= hesig_dcm;
            framep2_hemu_beamformed <= hesig_beamformed;
            framep2_hemu_nsts       <= hesig_nsts;
            framep2_hemu_nsts_prev  <= hesig_nsts_prev;
            framep2_hemu_nsts_tot   <= hesig_nsts_tot;
          end
          
          framep2_update              <= 1'b1;
          framep8_update              <= 1'b1;
          framep8_ncbps               <= ucpu_ncbps;
          framep8_nsym                <= ucpu_nsym;
          framep8_tpe                 <= ucpu_tpe;
          framep8_nma                 <= ucpu_nma;
            
          rxv2_update                 <= 1'b1;
          rxv2_l_length               <= lsig_length;
          rxv2_l_rate                 <= lsig_rate;
          rxv2_gi_type                <= hesiga_gi_type;
          rxv2_aggregation            <= 1'b1;
          rxv2_stbc                   <= hesiga_stbc;
          rxv2_l_sig_valid            <= 1'b1;
          rxv2_beamformed             <= hesig_beamformed;
          rxv2_mcs                    <= {3'b0,hesig_mcs};
          rxv2_nss                    <= hesiga_stbc?{1'b0,hesig_nsts[2:1]}:hesig_nsts;
          rxv2_fec_coding             <= hesig_fec;
          rxv2_length                 <= ucpu_psdulen[19:0];
          rxv2_uplink_flag            <= hesiga_uplink;
          rxv2_beam_change            <= hesiga_beamchange;
          rxv2_dcm                    <= hesig_dcm;
          rxv2_rulen                  <= hesig_rulen;
          rxv2_he_ltf_type            <= hesiga_ltf_type;
          rxv2_doppler                <= hesiga_doppler;
          rxv2_bss_color              <= hesiga_bss_color;
          rxv2_txop_duration          <= hesiga_txop;
          rxv2_pe_duration            <= {1'b0,ucpu_tpe};
          rxv2_spatial_reuse          <= hesiga_spatial_reuse1;                  
          rxv2_sig_b_compression_mode <= hesiga_sigb_compression;
          rxv2_dcm_sig_b              <= hesiga_sigb_dcm;
          rxv2_mcs_sig_b              <= hesiga_sigb_mcs;
        end
      
        /* MFSM */
        case(hesiga_format)
          HE_SU,HE_ER_SU:
          begin
            if(hesu_siga_frame_violation)
            begin
              /* siga corrupted */
              mfsm_frame_violation <= 1'b1;
            end
            else
            begin
              /* siga at first glance ok */
              cca_htsig_vhtsiga_valid <= 1'b1;
              
              if(hesu_siga_frame_unsupported)
              begin
                mfsm_rxv_update         <= 1'b1;
                mfsm_frame_unsupported  <= 1'b1;
              end
              else if(ucpu_hesig_done)
              begin
                if(hesu_ucpu_frame_violation)
                  mfsm_frame_violation <= 1'b1;
                else
                begin
                  mfsm_rxv_update         <= 1'b1;
                  mfsm_frame_unsupported <= hesu_ucpu_frame_unsupported;
                end
              end
            end
          end
          HE_MU:
          begin
            if(hemu_siga_frame_violation)
            begin
              /* siga corrupted */
              mfsm_frame_violation <= 1'b1;
            end
            else
            begin
              /* siga at first glance ok */
              cca_htsig_vhtsiga_valid <= 1'b1;
              
              if(hemu_siga_frame_unsupported)
              begin
                mfsm_rxv_update         <= 1'b1;
                mfsm_frame_unsupported  <= 1'b1;
              end 
              else if(ucpu_hesig_done)
              begin
                if(hemu_ucpu_frame_violation)
                  mfsm_frame_violation   <= 1'b1;
                else
                begin
                  mfsm_rxv_update        <= 1'b1;
                  mfsm_frame_unsupported <= hemu_ucpu_frame_unsupported;
                end
              end
            end
          end
          default: /* HE_TB */
          begin
            if(hetb_siga_frame_violation)
            begin
              /* siga corrupted */
              mfsm_frame_violation <= 1'b1;
            end
            else
            begin
              /* siga at first glance ok */
              cca_htsig_vhtsiga_valid <= 1'b1;
              mfsm_rxv_update         <= 1'b1;
              mfsm_frame_unsupported  <= hetb_siga_frame_unsupported;
            end
          end
        endcase
      end
    end
  end
  
  /******************************************************************************
  * NONHT FRAME VIOLATION
  ******************************************************************************/
  assign frame_violation_rule[0] = lsig_invalid_rate;       /* bad rate encoding        */
  assign frame_violation_rule[1] = lsig_invalid_parity;     /* bad parity               */
  assign frame_violation_rule[2] = lsig_invalid_reserved4;  /* reserved bit #4 is not 0 */
  assign frame_violation_rule[3] = lsig_length_lt_12;       /* leglength<12             */
  
  assign nonht_frame_violation   = |(frame_violation_rule[3:0] & mdmcfg_frame_violation_mask[3:0]);
  
  /******************************************************************************
  * HT FRAME VIOLATION
  ******************************************************************************/
  assign frame_violation_rule[4]  = htsig_invalid_reserved26;                 
  assign frame_violation_rule[5]  = htsig_invalid_mcs;
  assign frame_violation_rule[6]  = htsig_invalid_length;              
  assign frame_violation_rule[7]  = htsig_invalid_ndp_stbc; 
  assign frame_violation_rule[8]  = htsig_invalid_ndp_nss;       
  assign frame_violation_rule[9]  = htsig_invalid_nsts_ness;       
  assign frame_violation_rule[10] = htsig_invalid_nsts_nss;    
  assign frame_violation_rule[11] = htsig_invalid_mcs32_bw;    
  assign frame_violation_rule[12] = htsig_invalid_mcs32_stbc;
  assign frame_violation_rule[13] = htsig_invalid_crc;                           
  assign frame_violation_rule[14] = htsig_invalid_gf_sgi_1ss & ~lsig_captured;

  assign ht_frame_violation = |(frame_violation_rule[14:4] & mdmcfg_frame_violation_mask[14:4]);
    
  /******************************************************************************
  * HT FRAME UNSUPPORTED
  ******************************************************************************/
  assign ht_frame_unsupported =
    ~mdmcfg_htmm_en & lsig_captured     |                                       /* unsupported htmm                  */
    ~mdmcfg_htgf_en & ~lsig_captured    |                                       /* unsupported htgf                  */
    ~mdmcfg_stbc_en & htsig_stbc        |                                       /* unsupported stbc                  */
     mdmcfg_stbc_en & htsig_nsts>NSTS_2 |                                       /* unsupported nsts                  */
    (htsig_nss>mdmcfg_nss_max)            |                                     /* unsupported nss                   */
    (htsig_bandwidth[1:0]>mdmcfg_conf_bw) |                                     /* unsupported frame bw              */
    ~htsig_fec & htsig_gi_type!=2'd0 & (ucpu_ndbps>mdmcfg_bcc_lgi_ndbps_max) |  /* unsupported bcc lgi ndbps         */
    ~htsig_fec & htsig_gi_type==2'd0 & (ucpu_ndbps>mdmcfg_bcc_sgi_ndbps_max) |  /* unsupported bcc sgi ndbps         */
    ~mdmcfg_ldpc_en & htsig_fec |                                               /* unsupported ldpc                  */
     mdmcfg_ldpc_en & htsig_fec & htsig_gi_type!=2'd0 & (ucpu_ndbps>mdmcfg_ldpc_lgi_ndbps_max) |    /* unsupported ldpc lgi ndbps        */
     mdmcfg_ldpc_en & htsig_fec & htsig_gi_type==2'd0 & (ucpu_ndbps>mdmcfg_ldpc_sgi_ndbps_max) |    /* unsupported ldpc sgi ndbps        */
    htsig_mcs > 7'd32 |                                                         /* unsupported ht unequal modulation */
    htsig_ness!=2'd0;                                                           /* unsupported ht extension ss       */

  /******************************************************************************
  * VHT FRAME VIOLATION
  ******************************************************************************/
  /* common vhtsiga su or vhtsigb mu related */
  assign frame_violation_rule[16] = ~vhtsig_mumimo & vhtsig_invalid_mcs                   | /* illegal mcs code          */
                                     vhtsig_mumimo & vhtsigb_captured & vhtsig_invalid_mcs;
  /* vhtsiga related */
  assign frame_violation_rule[17] = vhtsig_invalid_siga_reserved2;                 /* reserved bit #2 is not 1  */
  assign frame_violation_rule[18] = vhtsig_invalid_siga_reserved23;                /* reserved bit #23 is not 1 */
  assign frame_violation_rule[19] = vhtsig_invalid_siga_reserved33;                /* reserved bit #33 is not 1 */
  assign frame_violation_rule[20] = vhtsig_invalid_siga_crc;                       /* crc not matching          */
  assign frame_violation_rule[22] = vhtsig_invalid_sgi;                            /* illegal combination of sgi/sgidisamb */
  assign frame_violation_rule[23] = vhtsig_invalid_su_fec_extra;                   /* illegal combination of fec/ldpc_extra in SUMIMO */
  assign frame_violation_rule[24] = vhtsig_invalid_stbc_odd;                       /* stbc and odd nsts         */
  assign frame_violation_rule[26] = vht_ndp & (vhtsig_nsts_tot==NSTS_1);           /* illegal NDP with 1SS */  
  assign frame_violation_rule[28] = vhtsig_invalid_siga_reserved31;                /* reserved bit #31 is not 1 in mu-mimo */
  assign frame_violation_rule[29] = vhtsig_invalid_siga_reserved32;                /* reserved bit #32 is not 1 in mu-mimo */
  assign frame_violation_rule[30] = vhtsig_invalid_mu_stbc;                        /* illegal combination of stbc/mumimo */
  assign frame_violation_rule[31] = vhtsig_invalid_mu_nsts_fec;                    /* illegal combination of nsts/fec/mumimo */

  // VHT frame violation excluding MCS and VHT length check which is known later in VHTSIGB with Mu-MIMO
  assign vht_siga_frame_violation = (|(frame_violation_rule[31:28] & mdmcfg_frame_violation_mask[31:28])) |
                                    (frame_violation_rule[26]      & mdmcfg_frame_violation_mask[26])     |                        
                                    (|(frame_violation_rule[24:22] & mdmcfg_frame_violation_mask[24:22])) |
                                    (|(frame_violation_rule[20:17] & mdmcfg_frame_violation_mask[20:17])) |
                                    (frame_violation_rule[16]      & mdmcfg_frame_violation_mask[32]);

  /* ucpu or vhtsigb related */                                   
  assign frame_violation_rule[15] = vhtsig_stbc & ucpu_nsym[0];            /* lsig/vhtsiga inconsitent, found an odd nsym (lsig) with stbc (vhtsiga) */
  assign frame_violation_rule[21] = ~vht_ndp & ucpu_psdulen[23:0]<24'd14 ; /* not NDP and length<14     */ 
  assign frame_violation_rule[25] = 1'b0;                                  /* unused, non-integral ncbps merged with invalid mcs            */
  assign frame_violation_rule[27] = ucpu_inconsistent;                     /* resolution of nsym gives inconsistency (ie sgi+sgidisamb+ndp) */
 
  /* VHT frame violation with MCS and VHT length check */
  assign vht_ucpu_frame_violation = (frame_violation_rule[15] & mdmcfg_frame_violation_mask[15]) |
                                    (frame_violation_rule[16] & mdmcfg_frame_violation_mask[32]) |
                                    (frame_violation_rule[21] & mdmcfg_frame_violation_mask[33]) |
                                    (frame_violation_rule[25] & mdmcfg_frame_violation_mask[34]) |
                                    (frame_violation_rule[27] & mdmcfg_frame_violation_mask[27]);

  /* VHT frame violation with VHT-SIG-B CRC */
  assign vht_sigbcrc_frame_violation = (vhtsig_sigb_crc!=service[15:8]) & service_captured & mdmcfg_frame_violation_mask[35];
  
  /******************************************************************************
  * VHT FRAME UNSUPPORTED
  ******************************************************************************/
  /* vhtsiga related */
  assign vht_siga_frame_unsupported =
    (vhtsig_bandwidth[1:0]>mdmcfg_conf_bw) |                                      /* unsupported frame bandwidth                         */
    ~vht_ndp & (vhtsig_nss>mdmcfg_nss_max) |                                      /* unsupported nss                                     */
     vht_ndp & (vhtsig_nsts_tot>mdmcfg_ndp_nsts_max) |                            /* unsupported nsts for NDP                            */
    ~mdmcfg_vht_mumimo_en & vhtsig_mumimo |                                       /* unsupported mu-mimo                                 */
     mdmcfg_vht_mumimo_en & vhtsig_mumimo & ~vhtsig_mu_user_valid |               /* unsupported mu-mimo for nsts_user=0 or not in group */
     mdmcfg_vht_mumimo_en & vhtsig_mumimo & vht_ndp |                             /* unsupported mu-mimo NDP                             */
    ~mdmcfg_vht_en |                                                              /* unsupported vht                                     */
    ~mdmcfg_stbc_en & vhtsig_stbc |                                               /* unsupported stbc                                    */
     mdmcfg_stbc_en & vhtsig_stbc & vhtsig_nsts!=NSTS_2 |                         /* unsupported stbc                                    */
    ~mdmcfg_qam256_en & ~vhtsig_mumimo & vhtsig_mcs>4'd7 |                        /* unsupported qam256 for su                           */
    ~mdmcfg_ldpc_en & vhtsig_fec;                                                 /* unsupported ldpc                                    */
  
  /* ucpu or vhtsigb related */
  assign vht_ucpu_frame_unsupported =
    ~mdmcfg_qam256_en &  vhtsig_mumimo & vhtsigb_captured & vhtsig_mcs>4'd7 |                       /* unsupported qam256 for mu         */
    ~vhtsig_fec & vhtsig_gi_type!=2'd0 & (ucpu_ndbps>mdmcfg_bcc_lgi_ndbps_max) |                    /* unsupported bcc lgi ndbps         */
    ~vhtsig_fec & vhtsig_gi_type==2'd0 & (ucpu_ndbps>mdmcfg_bcc_sgi_ndbps_max) |                    /* unsupported bcc sgi ndbps         */
     mdmcfg_ldpc_en & vhtsig_fec & vhtsig_gi_type!=2'd0 & (ucpu_ndbps>mdmcfg_ldpc_lgi_ndbps_max) |  /* unsupported ldpc lgi ndbps        */
     mdmcfg_ldpc_en & vhtsig_fec & vhtsig_gi_type==2'd0 & (ucpu_ndbps>mdmcfg_ldpc_sgi_ndbps_max);   /* unsupported ldpc sgi ndbps        */

  /******************************************************************************
  * HESU FRAME VIOLATION
  ******************************************************************************/
  /* siga related */
  assign hesu_siga_frame_violation = mdmcfg_he_frame_violation_mask[0] & hesiga_invalid_crc |                                   /* invalid hesig crc            */
                                     mdmcfg_he_frame_violation_mask[1] & hesiga_ltf_type==HELTF_1X & hesiga_gi_type==GI_1600 |  /* invalid gi vs ltf            */
                                     mdmcfg_he_frame_violation_mask[1] & hesiga_ltf_type==HELTF_4X & hesiga_gi_type==GI_1600 |  /* invalid gi vs ltf            */
                                     mdmcfg_he_frame_violation_mask[1] & hesiga_ltf_type==HELTF_1X & hesiga_gi_type==GI_3200 |  /* invalid gi vs ltf            */
                                     mdmcfg_he_frame_violation_mask[1] & hesiga_ltf_type==HELTF_2X & hesiga_gi_type==GI_3200 |  /* invalid gi vs ltf            */
                                     mdmcfg_he_frame_violation_mask[2] & hesig_mcs>4'd11 |                                      /* invalid mcs                  */
                                     mdmcfg_he_frame_violation_mask[3] & ~hesig_fec & hesig_mcs>4'd9 |                          /* invalid bcc mcs              */
                                     mdmcfg_he_frame_violation_mask[4] & ~hesig_fec & hesig_nsts>NSTS_4 |                       /* invalid bcc vs nts>4         */
                                     mdmcfg_he_frame_violation_mask[5] & hesig_dcm & (hesig_mcs>4'd4 | hesig_mcs==4'd2) |       /* invalid dcm vs mcs           */
                                     mdmcfg_he_frame_violation_mask[6] & ~hesig_fec & hesig_rulen>RU_242;                       /* invalid bcc vs rulen         */
                                    
  /* ucpu related */
  assign hesu_ucpu_frame_violation = mdmcfg_he_frame_violation_mask[7] & he_ndp & (hesig_nsts==NSTS_1) |                        /* illegal ndp with 1           */  
                                     mdmcfg_he_frame_violation_mask[8] & ucpu_inconsistent;                                     /* resolution of nsym gives inconsistency */

  /******************************************************************************
  * HESU FRAME UNSUPPORTED
  *****************************************************************************/
  /* siga related */
  assign hesu_siga_frame_unsupported = ~mdmcfg_he_en |                                                               /* unsupported he               */
                                       ~mdmcfg_stbc_en & hesiga_stbc |                                               /* unsupported stbc             */
                                       mdmcfg_stbc_en & hesiga_stbc & hesig_nsts!=NSTS_2 |                           /* unsupported stbc vs nsts     */
                                       ~mdmcfg_ldpc_en & hesig_fec |                                                 /* unsupported stbc vs nsts     */
                                       hesiga_bandwidth>{1'b0,mdmcfg_conf_bw} |                                      /* unsupported frame bandwidth  */
                                       hesig_mcs>4'd7 & ~mdmcfg_qam256_en |                                          /* unsupported qam256           */
                                       hesig_mcs>4'd9 & ~mdmcfg_qam1024_en |                                         /* unsupported qam1024          */
                                       ~mdmcfg_dcm_en & hesig_dcm  |                                                 /* unsupported dcm              */
                                       hesiga_format==HE_ER_SU;                                                      /* unsupported HE_ER_SU         */

  /* ucpu related */
  assign hesu_ucpu_frame_unsupported = ~he_ndp & ((hesiga_stbc?{1'b0,hesig_nsts[2:1]}:hesig_nsts) >mdmcfg_nss_max) | /* unsupported nss              */
                                       he_ndp  & (hesig_nsts>mdmcfg_ndp_nsts_max);                                   /* unsupported nsts for NDP     */

  /******************************************************************************
  * HEMU FRAME VIOLATION
  ******************************************************************************/
  /* siga related */
  assign hemu_siga_frame_violation   = mdmcfg_he_frame_violation_mask[16] & hesiga_invalid_crc |                                   /* invalid hesig crc            */
                                       mdmcfg_he_frame_violation_mask[17] & hesiga_ltf_type==HELTF_1X & hesiga_gi_type==GI_800  |  /* invalid gi vs ltf            */
                                       mdmcfg_he_frame_violation_mask[17] & hesiga_ltf_type==HELTF_1X & hesiga_gi_type==GI_1600 |  /* invalid gi vs ltf            */
                                       mdmcfg_he_frame_violation_mask[17] & hesiga_ltf_type==HELTF_4X & hesiga_gi_type==GI_1600 |  /* invalid gi vs ltf            */
                                       mdmcfg_he_frame_violation_mask[17] & hesiga_ltf_type==HELTF_1X & hesiga_gi_type==GI_3200 |  /* invalid gi vs ltf            */
                                       mdmcfg_he_frame_violation_mask[17] & hesiga_ltf_type==HELTF_2X & hesiga_gi_type==GI_3200 |  /* invalid gi vs ltf            */
                                       mdmcfg_he_frame_violation_mask[18] & hesiga_sigb_mcs>4'd5 |                                 /* invalid sigb mcs             */
                                       mdmcfg_he_frame_violation_mask[19] & hesiga_sigb_dcm & hesiga_sigb_mcs==4'd2 |              /* invalid sigb mcs vs dcm      */
                                       mdmcfg_he_frame_violation_mask[20] & hesiga_sigb_dcm & hesiga_sigb_mcs==4'd5;               /* invalid sigb mcs vs dcm      */

  /* sigb/ucpu related */
  assign hemu_ucpu_frame_violation   = mdmcfg_he_frame_violation_mask[21] & he_ndp |                                               /* illegal mu ndp               */  
                                       mdmcfg_he_frame_violation_mask[22] & ucpu_inconsistent |                                    /* resolution of nsym gives inconsistency */
                                       mdmcfg_he_frame_violation_mask[23] & hesig_rulen<RU_106 & hesig_runuser>4'd1 |              /* invalid mumimo vs rulen      */
                                       mdmcfg_he_frame_violation_mask[24] & hesig_mcs>4'd11 |                                      /* invalid mcs                  */
                                       mdmcfg_he_frame_violation_mask[25] & ~hesig_fec & hesig_mcs>4'd9 |                          /* invalid bcc mcs              */
                                       mdmcfg_he_frame_violation_mask[26] & ~hesig_fec & hesig_nsts>NSTS_4 |                       /* invalid bcc vs nts>4         */
                                       mdmcfg_he_frame_violation_mask[27] & hesig_dcm & (hesig_mcs>4'd4 | hesig_mcs==4'd2) |       /* invalid dcm vs mcs           */
                                       mdmcfg_he_frame_violation_mask[28] & ~hesig_fec & hesig_rulen>RU_242;                       /* invalid bcc vs rulen         */

  /******************************************************************************
  * HEMU FRAME UNSUPPORTED
  ******************************************************************************/
  /* siga related */
  assign hemu_siga_frame_unsupported = ~mdmcfg_he_en |                                                           /* unsupported he               */
                                       ~mdmcfg_stbc_en & hesiga_stbc |                                           /* unsupported stbc             */
                                        hesiga_bandwidth>3'd2;                                                   /* unsupported HEMU160          */

  /* sigb/ucpu related */
  assign hemu_ucpu_frame_unsupported =  hesiga_stbc & hesig_nsts!=NSTS_2 |                                       /* unsupported stbc vs nsts     */
                                       ~mdmcfg_ldpc_en & hesig_fec |                                             /* unsupported stbc vs nsts     */
                                        hesig_mcs>4'd7 & ~mdmcfg_qam256_en |                                     /* unsupported qam256           */
                                        hesig_mcs>4'd9 & ~mdmcfg_qam1024_en |                                    /* unsupported qam1024          */
                                       ~mdmcfg_dcm_en & hesig_dcm |                                              /* unsupported dcm              */
                                       ~hesig_user_valid |                                                       /* no matching staid            */
                                        mdmcfg_conf_bw==2'd0 & hesiga_bandwidth!=3'd0 & hesig_rulen>RU_106 |     /* unsupported RU for 20 only non-ap sta */
                                       ~mdmcfg_he_mumimo_en & hesig_runuser>4'd1;                                /* unsupported mumimo           */
                                   
  /******************************************************************************
  * HETB FRAME VIOLATION
  ******************************************************************************/
  assign hetb_siga_frame_violation = hesiga_invalid_crc;                                   /* invalid crc */
  
  /******************************************************************************
  * HETB FRAME UNSUPPORTED
  ******************************************************************************/
  assign hetb_siga_frame_unsupported = 1'b1;                                               /* unsupported as non-ap sta   */
  

  /*****************************************************************************
  * small frame early detection
  *
  * for frame with a single data symbol preceded by LSIG or HTGFSIG2, 
  * the bd_rxctrl_proc might display nsym too late for the TD (rxendfortiming generation).
  * we anticipate here this particular case. 
  *
  * It only occurs for :
  *
  *  NONHT   36M  ndbps=144;length=15;nsym=1 
  *  NONHT   48M  ndbps=192;length=21;nsym=1 
  *  NONHT   54M  ndbps=216;length=24;nsym=1 
  *
  *  HTGF20 MCS4  ndbps=156;length=16;nsym=1 
  *  HTGF20 MCS5  ndbps=208;length=23;nsym=1 
  *  HTGF20 MCS6  ndbps=234;length=26;nsym=1 
  *  HTGF20 MCS7  ndbps=260;length=29;nsym=1 
  *  HTGF40 MCS2  ndbps=162;length=17;nsym=1 
  *  HTGF40 MCS3  ndbps=216;length=24;nsym=1 
  *  HTGF40 MCS4  ndbps=324;length=37;nsym=1 
  *  HTGF40 MCS5  ndbps=432;length=51;nsym=1 
  *  HTGF40 MCS6  ndbps=486;length=58;nsym=1 
  *  HTGF40 MCS7  ndbps=540;length=64;nsym=1 
  * 
  *****************************************************************************/
  always @(*)
  begin
    /* NONHT */
    nonht_smallframe_valid = 1'b0;
    if(lsig_length[11:5]==7'b0)
    begin
      if((lsig_length[4:0]<=5'd15 && lsig_rate==LEG_36) || 
         (lsig_length[4:0]<=5'd21 && lsig_rate==LEG_48) ||   
         (lsig_length[4:0]<=5'd24 && lsig_rate==LEG_54)) 
        nonht_smallframe_valid = 1'b1;
    end
  end
    
  always @(*)
  begin
    /* HTGF 1STS */
    ht_smallframe_valid = 1'b0;
    if(htsig_length[15:7]==9'd0 && htsig_length[6:0]!=7'd0 && htsig_nsts==NSTS_1 && !htsig_fec && !lsig_captured)
    begin
      /* CBW20 */
      if(htsig_bandwidth==3'd0)
      begin
        if((htsig_length[6:0]<=7'd16 && htsig_mcs==7'd4) ||
           (htsig_length[6:0]<=7'd23 && htsig_mcs==7'd5) ||
           (htsig_length[6:0]<=7'd26 && htsig_mcs==7'd6) ||
           (htsig_length[6:0]<=7'd29 && htsig_mcs==7'd7))
          ht_smallframe_valid = 1'b1; 
      end
      /* CBW40 */
      if(htsig_bandwidth==3'd1)
      begin
        if((htsig_length[6:0]<=7'd17 && htsig_mcs==7'd2) || 
           (htsig_length[6:0]<=7'd24 && htsig_mcs==7'd3) ||
           (htsig_length[6:0]<=7'd37 && htsig_mcs==7'd4) ||
           (htsig_length[6:0]<=7'd51 && htsig_mcs==7'd5) ||
           (htsig_length[6:0]<=7'd58 && htsig_mcs==7'd6) ||
           (htsig_length[6:0]<=7'd64 && htsig_mcs==7'd7))
          ht_smallframe_valid = 1'b1;
      end
    end
  end

endmodule
`default_nettype wire
