/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_ctrl_vhtsig_parser
(
    /* system */
    input  wire         rst_n,
    input  wire         clk,
    
    input  wire [ 63:0] mdmcfg_membershipstat,
    input  wire [127:0] mdmcfg_userposid,
   
    input  wire         vhtsiga_enable,
    output reg          vhtsiga_captured,
    input  wire         vhtsigb_enable,
    output reg          vhtsigb_captured,
    
    /* byte stream */
    output wire         bd_ready,
    input  wire [ 7:0]  bd_data,
    input  wire         bd_last,
    input  wire         bd_valid,
    
    output wire [  2:0] bandwidth,
    output wire         stbc,
    output wire [  5:0] gid,
    output wire         dozenotallowed,
    output wire [  1:0] gi_type,
    output wire         sgidisamb,
    output wire         extra,
    output wire [  2:0] nss,
    output wire         fec,
    output wire [  8:0] paid,
    output wire [  2:0] nsts,
    output wire [  2:0] nsts_tot,
    output wire [  3:0] mcs,
    output wire         beamformed,
    
    output wire         mumimo,
    output wire         mu_user_valid,
    output wire         mu_first_user,
    output reg  [ 1:0]  mu_posid,
    output reg  [23:0]  mu_sigb_length,
    output reg  [ 2:0]  mu_pre_user_nsts,
    
    output reg  [ 1:0]  nsd,
    output reg  [ 1:0]  cr,
    output reg  [ 2:0]  nbpsc,
    
    output reg  [ 7:0]  sigb_crc,
    
    output wire         invalid_siga_reserved2,
    output wire         invalid_siga_reserved23,
    output wire         invalid_siga_reserved31,
    output wire         invalid_siga_reserved32,
    output wire         invalid_siga_reserved33,
    output wire         invalid_siga_crc,
    output wire         invalid_sgi,
    output wire         invalid_stbc_odd,
    output wire         invalid_mcs,
    output wire         invalid_su_fec_extra,
    output wire         invalid_mu_stbc,
    output wire         invalid_mu_nsts_fec
);

  /*****************************************************************************
  * DECLARATIONS
  *****************************************************************************/
  localparam  CR_12=2'd0,
              CR_23=2'd1,
              CR_34=2'd2,
              CR_56=2'd3;  

  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;

  localparam  NSS_1=3'd0,
              NSS_2=3'd1,
              NSS_3=3'd2,
              NSS_4=3'd3,
              NSS_5=3'd4,
              NSS_6=3'd5,
              NSS_7=3'd6, 
              NSS_8=3'd7; 
 
  localparam  NSTS_1=3'd0,
              NSTS_2=3'd1,
              NSTS_3=3'd2,
              NSTS_4=3'd3,
              NSTS_5=3'd4,
              NSTS_6=3'd5,
              NSTS_7=3'd6, 
              NSTS_8=3'd7; 
 
  localparam  NSD_48=2'd0,
              NSD_52=2'd1,
              NSD_108=2'd2,
              NSD_234=2'd3;  

  /*****************************************************************************
  * CAPTURE VHTSIGA
  *****************************************************************************/
  reg  [ 47:0] vhtsiga;
  reg  [119:0] vhtsigb;
  
  reg          bd_ready_vhtsiga;
  reg          bd_ready_vhtsigb;
 
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready_vhtsiga <= 1'b0;
      vhtsiga_captured <= 1'b0;
      vhtsiga          <= 48'b0;
    end
    else if(!vhtsiga_enable)
    begin
      bd_ready_vhtsiga <= 1'b0;
      vhtsiga_captured <= 1'b0;
      vhtsiga          <= 48'b0;
    end
    else
    begin
      /* capture */                     
      if(!vhtsiga_captured)          
      begin   
        bd_ready_vhtsiga <= 1'b1;
        if(bd_valid)
        begin                          
          vhtsiga <= {bd_data,vhtsiga[47:8]}; 
          if(bd_last)
            vhtsiga_captured <= 1'b1; 
        end                
      end
      else
      begin
        bd_ready_vhtsiga <= 1'b0;
      end
    end
  end
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      bd_ready_vhtsigb <= 1'b0;
      vhtsigb_captured <= 1'b0;
      vhtsigb          <= 120'b0;
    end
    else if(!vhtsigb_enable)
    begin
      bd_ready_vhtsigb <= 1'b0;
      vhtsigb_captured <= 1'b0;
      vhtsigb          <= 120'b0;
    end
    else
    begin
      /* capture */                     
      if(!vhtsigb_captured)          
      begin                             
        bd_ready_vhtsigb <= 1'b1;
        if(bd_valid)
        begin
          case(bandwidth)
            3'd0:    vhtsigb <= {88'b0,bd_data,vhtsigb[ 31:8]};
            3'd1:    vhtsigb <= {64'b0,bd_data,vhtsigb[ 55:8]};
            default: vhtsigb <= {bd_data,vhtsigb[119:8]};
          endcase
          if(bd_last)
            vhtsigb_captured <= 1'b1; 
        end                
      end
      else
      begin
        bd_ready_vhtsigb <= 1'b0;
      end
    end
  end

  assign bd_ready = bd_ready_vhtsiga | bd_ready_vhtsigb;

  /*****************************************************************************
  * DECODING
  *****************************************************************************/
  wire        mumimo_valid;
  wire [ 2:0] su_nsts;
  wire [ 8:0] su_paid;
  wire        su_fec;
  wire [ 3:0] su_mcs;
  wire        su_beamformed;
  wire [ 1:0] mu_user;
  reg         mu_fec;
  reg  [ 2:0] mu_nsts;
  wire [ 2:0] mu_nsts0;
  wire [ 2:0] mu_nsts1;
  wire [ 2:0] mu_nsts2;
  wire [ 2:0] mu_nsts3;
  wire [ 2:0] mu_nsts_tot;
  wire        mu_fec0;
  wire        mu_fec1;
  wire        mu_fec2;
  wire        mu_fec3;
  reg  [ 3:0] mu_mcs;
  reg  [ 7:0] siga_crc;
  
  /* common fields */
  assign bandwidth      = {1'b0,vhtsiga[1:0]};
  assign stbc           = vhtsiga[3];
  assign gid            = vhtsiga[9:4];
  assign mumimo         = ~(gid==6'd0 | gid==6'd63);
  assign dozenotallowed = vhtsiga[22];  
  assign gi_type        = vhtsiga[24]?2'd0:2'd1;
  assign sgidisamb      = vhtsiga[25]; 
  assign extra          = vhtsiga[27]; 
  assign nss            = (!stbc)?nsts:{1'b0,nsts[2:1]};

  /* su specific */
  assign su_nsts        = vhtsiga[12:10];
  assign su_paid        = vhtsiga[21:13];
  assign su_fec         = vhtsiga[26];
  assign su_mcs         = vhtsiga[31:28];
  assign su_beamformed  = vhtsiga[32]; 

  /* mu specific */
  assign mu_user_valid  = mdmcfg_membershipstat[gid] & (mu_nsts != 2'b0);
  assign mu_user        = {mdmcfg_userposid[{gid,1'b0}+7'd1],mdmcfg_userposid[{gid,1'b0}]};
  assign mu_first_user  = ((mu_user==2'd0)                                            |
                          ((mu_user==2'd1) & (mu_nsts0 == 3'b0))                      |
                          ((mu_user==2'd2) & (mu_nsts0 == 3'b0) & (mu_nsts1 == 3'b0)) |
                          ((mu_user==2'd3) & (mu_nsts0 == 3'b0) & (mu_nsts1 == 3'b0) & (mu_nsts2 == 3'b0)));
  
  assign mu_nsts0       = vhtsiga[12:10];
  assign mu_nsts1       = vhtsiga[15:13];
  assign mu_nsts2       = vhtsiga[18:16];
  assign mu_nsts3       = vhtsiga[21:19];
  assign mu_nsts_tot    = mu_nsts0 + mu_nsts1 + mu_nsts2 + mu_nsts3;

  assign mu_fec0        = vhtsiga[26];
  assign mu_fec1        = vhtsiga[28];
  assign mu_fec2        = vhtsiga[29];
  assign mu_fec3        = vhtsiga[30];
  
  always @(*)
  begin
    case(bandwidth)
      3'd0:    mu_mcs = vhtsigb[19:16];
      3'd1:    mu_mcs = vhtsigb[20:17];
      default: mu_mcs = vhtsigb[22:19];
    endcase
  end
  
  /* payload length */
  always @(*)
  begin
    case(bandwidth)
      3'd0:    mu_sigb_length = {6'b0,vhtsigb[15:0],2'b0};
      3'd1:    mu_sigb_length = {5'b0,vhtsigb[16:0],2'b0};
      default: mu_sigb_length = {3'b0,vhtsigb[18:0],2'b0};
    endcase
  end  

  always @(*)
  begin
    case(mu_user)
      2'd0:
      begin
        mu_fec           = mu_fec0;
        mu_nsts          = mu_nsts0;
        mu_pre_user_nsts = 3'd0;
        mu_posid         = 2'b0;
      end
      2'd1:
      begin
        mu_fec           = mu_fec1;
        mu_nsts          = mu_nsts1;
        mu_pre_user_nsts = mu_nsts0;
        if(mu_nsts0 == 3'b0)
          mu_posid = 2'b0;
        else
          mu_posid = mu_nsts0[1:0];
      end
      
      2'd2:
      begin  
        mu_fec           = mu_fec2;
        mu_nsts          = mu_nsts2;
        mu_pre_user_nsts = mu_nsts0 + mu_nsts1;
        if(mu_nsts0 == 3'b0)
          if(mu_nsts1 == 3'b0)
            mu_posid = 2'b0;
          else
            mu_posid = mu_nsts1[1:0];
        else
          if(mu_nsts1 == 3'b0)
            mu_posid = mu_nsts0[1:0];
          else
            mu_posid = mu_nsts0[1:0] + mu_nsts1[1:0];
      end
      
      default:
      begin
        mu_fec           = mu_fec3;
        mu_nsts          = mu_nsts3;
        mu_pre_user_nsts = mu_nsts_tot - mu_nsts;
        if(mu_nsts0 == 3'b0)
          if(mu_nsts1 == 3'b0)
            if(mu_nsts2 == 3'b0)
              mu_posid = 2'b0;
            else
              mu_posid = mu_nsts2[1:0];
          else
            if(mu_nsts2 == 3'b0)
              mu_posid = mu_nsts1[1:0];
            else
              mu_posid = mu_nsts1[1:0] + mu_nsts2[1:0];
        else
          if(mu_nsts1 == 3'b0)
            if(mu_nsts2 == 3'b0)
              mu_posid = mu_nsts0[1:0];
            else
              mu_posid = mu_nsts0[1:0] + mu_nsts2[1:0];
          else
            if(mu_nsts2 == 3'b0)
              mu_posid = mu_nsts0[1:0] + mu_nsts1[1:0];
            else
              mu_posid = mu_nsts0[1:0] + mu_nsts1[1:0] + mu_nsts2[1:0];
    
      end
    endcase
  end

  assign mumimo_valid            = mumimo & !invalid_siga_crc;
  assign paid                    = (mumimo_valid) ? 9'b0                 : su_paid;
  assign nsts                    = (mumimo_valid) ? (mu_nsts     - 3'd1) : su_nsts;
  assign nsts_tot                = (mumimo_valid) ? (mu_nsts_tot - 3'd1) : su_nsts;
  assign fec                     = (mumimo_valid) ? mu_fec               : su_fec;
  assign mcs                     = (mumimo_valid) ? mu_mcs               : su_mcs;
  assign beamformed              = (mumimo_valid) ? 1'b1                 : su_beamformed;
  
  always @(*)
    case(bandwidth)
      /* supported rate */
      3'd0:  nsd = NSD_52;
      3'd1:  nsd = NSD_108;
      3'd2:  nsd = NSD_234;
      /* unsupported rate */
      default: nsd = NSD_52;
    endcase
  
  always @(*)
    case(mcs)
      /* valid mcs */
      4'd0:   {cr,nbpsc} = {CR_12, NBPSC_1};
      4'd1:   {cr,nbpsc} = {CR_12, NBPSC_2};
      4'd2:   {cr,nbpsc} = {CR_34, NBPSC_2};
      4'd3:   {cr,nbpsc} = {CR_12, NBPSC_4};
      4'd4:   {cr,nbpsc} = {CR_34, NBPSC_4};
      4'd5:   {cr,nbpsc} = {CR_23, NBPSC_6};
      4'd6:   {cr,nbpsc} = {CR_34, NBPSC_6};
      4'd7:   {cr,nbpsc} = {CR_56, NBPSC_6};
      4'd8:   {cr,nbpsc} = {CR_34, NBPSC_8};
      4'd9:   {cr,nbpsc} = {CR_56, NBPSC_8};
      /* invalid mcs */
      default:{cr,nbpsc} = {CR_12, NBPSC_1};
    endcase    
  
  /* violation */
  assign invalid_siga_reserved2     = ~vhtsiga[2];                  /* reserved bit #2  is not 1            */            
  assign invalid_siga_reserved23    = ~vhtsiga[23];                 /* reserved bit #23 is not 1            */            
  assign invalid_siga_reserved31    = ~vhtsiga[31] & mumimo_valid;  /* reserved bit #31 is not 1 in MU      */            
  assign invalid_siga_reserved32    = ~vhtsiga[32] & mumimo_valid;  /* reserved bit #32 is not 1 in MU      */            
  assign invalid_siga_reserved33    = ~vhtsiga[33];                 /* reserved bit #33 is not 1            */            
  assign invalid_siga_crc           = vhtsiga[41:34]!=siga_crc;     /* bad siga crc                         */            
  assign invalid_sgi                = gi_type!=2'd0 & sgidisamb;    /* illegal combination of sgi/sgidisamb */            
  assign invalid_stbc_odd           = stbc & ~nsts[0];              /* stbc and odd nsts                    */
  assign invalid_su_fec_extra       = ~fec & extra & ~mumimo_valid; /* illegal combination of fec/ldpc_extra in SUMIMO */ 
  assign invalid_mu_stbc            = stbc & mumimo_valid;

  assign invalid_mu_nsts_fec        = mumimo_valid & 
                                      ((mu_nsts0==3'b0 & ~mu_fec0) | /* illegal combination of nsts/fec/mumimo */
                                       (mu_nsts1==3'b0 & ~mu_fec1) |
                                       (mu_nsts2==3'b0 & ~mu_fec2) |
                                       (mu_nsts3==3'b0 & ~mu_fec3));
  
  assign invalid_mcs                = mcs>4'd9                                 | /* illegal mcs code   */            
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_1 | /* non-integral NCBPS */
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_2 | 
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_4 | 
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_5 | 
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_7 | 
                                      mcs==4'd9 & bandwidth==3'd0 & nss==NSS_8 | 
                                      mcs==4'd6 & bandwidth==3'd2 & nss==NSS_3 | 
                                      mcs==4'd9 & bandwidth==3'd2 & nss==NSS_6 | 
                                      mcs==4'd6 & bandwidth==3'd2 & nss==NSS_7 |  
                                      mcs==4'd9 & bandwidth==3'd3 & nss==NSS_3; 

  /*****************************************************************************
  * CRC
  *****************************************************************************/
  always @(*)
  begin:b_crc
    integer   i;
    reg [7:0] v;
    v=8'hff;
    for(i=0;i<34;i=i+1) 
      v = {v[6:2],v[1]^v[7]^vhtsiga[i],v[0]^v[7]^vhtsiga[i],v[7]^vhtsiga[i]};
    siga_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};

    /* vhtsigb */
    v=8'hff;
    case(bandwidth)
      3'd0:  for(i=0;i<20;i=i+1) 
                 v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
      3'd1:  for(i=0;i<21;i=i+1) 
                 v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
      default: for(i=0;i<23;i=i+1) 
                 v = {v[6:2],v[1]^v[7]^vhtsigb[i],v[0]^v[7]^vhtsigb[i],v[7]^vhtsigb[i]};
    endcase
    sigb_crc = ~{v[0],v[1],v[2],v[3],v[4],v[5],v[6],v[7]};
  end



endmodule
`default_nettype wire
