  /***************************************************************************
  * 
  ***************************************************************************/
  {J,               CC_HT,           L_HT};
  {J,              CC_VHT,          L_VHT};
  {J,               CC_HE,           L_HE};
  
  /***************************************************************************
  * NONHT
  ***************************************************************************/
L_NONHT:
  {I,      W_NULL,  CLRXY,     R_L_LENGTH};               
  {I,      W_NULL,    ADD,            R_3}; 
  {I,      W_NULL,    DIV,         R_NULL}; 
  {I,W_LLENGTHMOD3, CLRXY,        R_NBPSC}; // l_length_mod3 = l_length%3         
  {I,      W_NULL,    ADD,          R_NSD}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,     W_NCBPS,    NOP,          R_CRN}; // ncbps = 48*nbpsc
  {I,      W_NULL,    MUL,          R_CRD};
  {I,      W_NULL,    DIV,         R_NULL};
  {I,     W_NDBPS,  CLRXY,   R_L_LENGTHX8}; // ndbps = ncbps*cr_n/cr_d
  {I,      W_NULL,    ADD,           R_22};
  {I,      W_NULL,    ADD,        R_NDBPS};
  {I,      W_NULL,    DIV,            R_1};
  {J,           CC_X_ZERO,      L_NONHT_0};
  {I,      W_NULL,    ADD,         R_NULL};
L_NONHT_0:
  {I,      W_NSYM,  CLRXY,     R_L_LENGTH}; // nsym = ceil( (16+8*l_length+6) / ndbps ) 
  {I,      W_NULL,    ADD,            R_3}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
  {I,      W_NULL,    DIV,            R_1}; 
  {J,           CC_X_ZERO,      L_NONHT_1}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
L_NONHT_1:  
  {I,      W_NULL,    NOP,            R_5}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
  {I,    W_RXTIME,    NOP,         R_NULL}; // rxtime= 4*(ceil( (l_length+3)/3) + 5)
  {I,      W_DONE,   TERM,         R_NULL}; 

  /***************************************************************************
  * HT
  ***************************************************************************/
L_HT:  
  {I,      W_NULL,  CLRXY,        R_NBPSC};  
  {I,      W_NULL,    ADD,          R_NSD};
  {I,      W_NULL,    MUL,          R_NSS};
  {I,      W_NULL,    MUL,         R_NULL};
  {I,     W_NCBPS,    NOP,          R_CRN}; // ncbps = nbpsc*nsd*nss
  {I,      W_NULL,    MUL,          R_CRD}; 
  {I,      W_NULL,    DIV,         R_NULL}; 
  {I,     W_NDBPS,  CLRXY,  R_HT_LENGTHX8}; // ndbps = ncbps*crn/crd
  {I,      W_NULL,    ADD,          R_SPT};
  {I,      W_NULL,    ADD,      R_MXNDBPS}; 
  {I,      W_NPLD,    DIV,            R_1}; // npld = htlength*8+16+tail
  {J,           CC_X_ZERO,         L_HT_1}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
L_HT_1:
  {I,  W_NSYMINIT,    NOP,         R_NULL}; // nsym = ceil(  npld/(mstbc*ndbps) )
  {J,              CC_BCC,          L_END}; 
  {I,      W_NULL,    NOP,      R_MXNCBPS}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,   W_NAVBITS,    NOP,         R_NULL}; // navbits = npld*mstbc*mcbps
  {J,     CC_TRUE,                  L_NCW}; 
 
  /***************************************************************************
  * SUBPROG2: VHT NDBPS,NCBPS,NSYM
  ***************************************************************************/  
L_VHT:  
  {I,      W_NULL,  CLRXY,        R_NBPSC};
  {I,      W_NULL,    ADD,          R_NSD};
  {I,      W_NULL,    MUL,          R_NSS}; 
  {I,      W_NULL,    MUL,         R_NULL};
  {I,     W_NCBPS,    NOP,          R_CRN}; // ncbps = nbpsc*nsd*nss
  {I,      W_NULL,    MUL,          R_CRD};
  {I,      W_NULL,    DIV,         R_NULL};
  {I,     W_NDBPS,  CLRXY,       R_RXTIME}; // ndbps = ncbps*crn/crd
  {I,      W_NULL,    ADD, R_36P4XNVHTLTF};     
  {I,      W_NULL,    SUB,         R_NULL};     
  {I, W_INCONS_LT,    NOP,         R_NULL};       
  {I,        W_R0,    NOP,         R_NULL}; // r0 =  rxtime - (36+4*nvhtltf)             
  {I,      W_NULL,    NOP,         R_R0X4};    
  {I,      W_NULL,    ADD,         R_TSYM}; // y = 5*r0     
  {I,      W_NULL,    DIV,       R_SGIDIS}; // y = 5*(rxtime - (36+4*nvhtltf)) / (5*tsym)   
  {I,      W_NULL,    SUB,         R_NULL};
  {I, W_INCONS_LT,    NOP,         R_NULL};
  {I,      W_NSYM,    NOP,         R_NULL}; // nsym = floor( ( rxtime - (36+4*nvhtltf) ) / tsym ) - sgidisamb
  {J,               CC_NE,        L_VHT_1};       

  {I,      W_NULL,  CLRXY,         R_NULL}; // NDP
  {I,      W_NSYM,    NOP,         R_NULL}; 
  {I,  W_NSYMINIT,    NOP,         R_NULL}; 
  {J,             CC_TRUE,          L_END}; 
  
L_VHT_1:  
  {I,      W_NULL,    NOP,     R_EXTRAFIX}; // nsym = floor( ( rxtime - (36+4*nvhtltf) ) / tsym ) - sgidisamb
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I, W_INCONS_LT,    NOP,        R_NDBPS};
  {I,  W_NSYMINIT,    MUL,          R_SPT}; // nsyminit = nsym - extrafix(0,1,2) 
  {I,      W_NPLD,    SUB,         R_NULL}; // npld     = nsyminit*ndbps
  {I,   W_PSDULEN,    NOP ,        R_NULL}; // psdulen = floor( (nsyminit*ndbps-(16+6*nes))/8 )
  {J,      CC_BCC,                  L_END}; 
  {I,      W_NULL,  CLRXY,     R_NSYMINIT}; 
  {I,      W_NULL,    ADD,        R_NCBPS}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,   W_NAVBITS,    NOP,         R_NULL}; // navbits = nsyminit*ncbps
  {J,     CC_TRUE,                  L_NCW}; 

  /***************************************************************************
  * SUBPROG3: HE NDBPS,NCBPS,NSYM
  ***************************************************************************/
L_HE:  
  {I,      W_NULL,  CLRXY,        R_NBPSC}; // nes=1
  {I,      W_NULL,    ADD,          R_NSS}; 
  {I,      W_NULL,    MUL,          R_NSD}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,     W_NCBPS,    NOP,          R_CRN}; // ncbps=nbpsc*nss*nsd
  {I,      W_NULL,    MUL,          R_CRD}; 
  {I,      W_NULL,    DIV,         R_NULL}; 
  {I,     W_NDBPS,  CLRXY,        R_NBPSC}; // ndbps=floor(ncbps*crn/crd)
  {I,      W_NULL,    ADD,          R_NSS};
  {I,      W_NULL,    MUL,     R_NSDSHORT}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,W_NCBPSSHORT,    NOP,          R_CRN}; // ncbps_short=nbpsc*nss*nsd_short
  {I,      W_NULL,    MUL,          R_CRD};
  {I,      W_NULL,    DIV,         R_NULL}; 
  {I,W_NDBPSSHORT,    NOP,         R_NULL}; // ndbps_short=floor(ncbps_short*crn/crd)
  {I,      W_NULL,  CLRXY,       R_NHELTF}; 
  {I,      W_NULL,    ADD,       R_THELTF}; 
  {I,      W_NULL,    MUL,          R_480}; 
  {I,        W_R3,    ADD,         R_NULL}; // r3 = nheltf*theltf
  {I,        W_R1,  CLRXY,   R_HESIGBNSYM}; // r1 = nheltf*theltf + 16  (x30) 
  {I,      W_NULL,    ADD,          R_120}; 
  {I,      W_NULL,    MUL,           R_R1}; 
  {I,      W_NULL,    ADD,         R_NULL}; // y  = hesigb_nsym*4us
  {I,        W_R1,  CLRXY,           R_10}; // r1 = t_he_preamble + hesigb_nsym*4us;
  {I,      W_NULL,    ADD,         R_NULL}; 
  {I,        W_R0,  CLRXY,     R_L_LENGTH}; // r0 = 10
  {I,      W_NULL,    ADD,     R_HEMPLUS3}; 
  {I,      W_NULL,    ADD,         R_R0X4};
  {I,      W_NULL,    MUL,           R_R1}; // y  = (l_length+m+3)*40
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I,        W_R1,    NOP,         R_NULL}; // r1 = (l_length+m+3)*40 - t_he_preamble*30
  {I,      W_NULL,  CLRXY,           R_R3};
  {I,      W_NULL,    ADD,     R_MMAXTSYM};
  {I,      W_NULL,    ADD,         R_NULL};
  {I,        W_R0,  CLRXY,           R_R1}; // r0  = t_ma = mma*t_sym + nheltf*theltf
  {I,      W_NULL,    ADD, R_PEDISP2XTSYM};
  {I,      W_NULL,    SUB,           R_R0}; // y = (l_length+m+3)*40 - t_he_preamble*30 - (bpedis+2)*tsym*30
  {J,         CC_NMA_TEST,        L_HE_X1}; 
  {I,      W_NULL,  CLRXY,         R_NULL}; 
  {I,       W_NMA,    MUL,         R_NULL}; // nma = 0 if( !doppler || y<0)
  {J,             CC_TRUE,        L_HE_X2};
L_HE_X1:  
  {I,      W_NULL,    DIV,         R_NULL};
  {I,       W_NMA,    MUL,         R_NULL}; // nma = floor( [ (l_length+m+3)*40 - t_he_preamble*30 - (bpedis+2)*tsym*30 ] / t_ma)
L_HE_X2:  
  {I,      W_NULL,  CLRXY,           R_R3}; 
  {I,      W_NULL,    ADD,          R_NMA}; 
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,        W_R3,    NOP,         R_NULL}; 
  {I,      W_NULL,  CLRXY,           R_R1}; // r3 = nma*nheltf*theltf
  {I,      W_NULL,    ADD,           R_R3}; 
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I,        W_R1,    NOP,         R_TSYM}; // r1 = (l_length+m+3)*40 - t_he_preamble*30 - nma*nheltf*theltf 
  {I, W_INCONS_LT,    DIV,            R_1}; 
  {J,     CC_NOT_PEDISAMB,         L_HE_2}; 
  {I,      W_NULL,    SUB,         R_NULL};
  {I, W_INCONS_LT,    NOP,         R_NULL}; // y = floor[ ( (l_length+m+3)*40 - t_he_preamble*30 ) / t_sym*30 ] - bpedis



L_HE_2:  
  {J,       CC_NE,                 L_HE_3}; 
  {I,      W_NULL,  CLRXY,            R_1}; // NDP
  {I,      W_NSYM,    ADD,         R_NULL}; // nsym = 0
  {I,       W_TPE,    NOP,         R_NULL}; // tpe  = 1 (4us)
  {I,      W_DONE,   TERM,         R_NULL}; // DONE


L_HE_3:
  {I,      W_NSYM,    NOP,         R_TSYM}; // nsym = floor[ ( (l_length+m+3)*40 - t_he_preamble*30 ) / t_sym*30 ] - bpedis
  {I,      W_NULL,    MUL,         R_NULL}; 
  {I,        W_R0,    NOP,         R_NULL}; // r0   = nsym*t_sym*30
  {I,      W_NULL,  CLRXY,           R_R1}; 
  {I,      W_NULL,    ADD,           R_R0}; 
  {I,      W_NULL,    SUB,          R_120}; 
  {I, W_INCONS_LT,    NOP,         R_NULL}; // y    = (l_length+m+3)*40 - t_he_preamble*30 - nma*nheltf*theltf - nsym*t_sym*30
  {I,      W_NULL,    DIV,         R_NULL}; 
  {I,       W_TPE,    NOP,         R_NULL}; // tpe  = floor[ ( (l_length+m+3)*40 - t_he_preamble*30  - nma*nheltf*theltf - nsym*t_sym*30 ) / 120 ]
/* NSYMINIT */
  {I,      W_NULL,  CLRXY,         R_NSYM}; 
  {I,      W_NULL,    ADD,        R_MSTBC}; 
  {J, CC_NOT_A_EQ1_EXTRA,          L_HE_4};
  {I,      W_NULL,    SUB,         R_NULL}; 
L_HE_4: 
  {I,  W_NSYMINIT,    NOP,        R_NDBPS}; // nsyminit = nsym-mstbc if(extra && fec && a==1)
/* NPLD, PSDULEN */
  {I,      W_NULL,    MUL,      R_MXNDBPS}; // y    = nsym * ndbps 
  {J,CC_AINIT_EQ4,                 L_HE_5};
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I,      W_NULL,    NOP, R_MXNDBPSSHORT}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
  {J,CC_AINIT_EQ1,                 L_HE_5};
  {I,      W_NULL,    ADD,         R_NULL}; 
  {J,CC_AINIT_EQ2,                 L_HE_5};
  {I,      W_NULL,    ADD,         R_NULL}; 
L_HE_5:
  {I,      W_NPLD,    NOP,          R_SPT}; // if(a==4) npld = nsyminit*ndbps  else npld = (nsyminit-mstbc)*ndbps+mstbc*ainit*ndbps_short
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I,   W_PSDULEN,    NOP,         R_NULL}; // psdulen = floor( (fieldlen-16-tail)/8); note: round done at writeback
  {J,      CC_BCC,                  L_END}; 
 
/* NAVBITS */
  {I,      W_NULL,  CLRXY,     R_NSYMINIT}; 
  {I,      W_NULL,    ADD,        R_NCBPS}; 
  {I,      W_NULL,    MUL,      R_MXNCBPS};
  {J,CC_AINIT_EQ4,                 L_HE_6};
  {I,      W_NULL,    SUB,         R_NULL}; 
  {I,      W_NULL,    NOP, R_MXNCBPSSHORT}; 
  {I,      W_NULL,    ADD,         R_NULL}; 
  {J,CC_AINIT_EQ1,                 L_HE_6};
  {I,      W_NULL,    ADD,         R_NULL}; 
  {J,CC_AINIT_EQ2,                 L_HE_6};
  {I,      W_NULL,    ADD,         R_NULL}; 
L_HE_6:
  {I,   W_NAVBITS,    NOP,         R_NULL}; //if(a==4) navbits = nsyminit*ncbps  else navbits = (nsyminit-mstbc)*ncbps+mstbc*ainit*ncbps_short
  {I, W_INCONS_LT,    NOP,         R_NULL}; 
  
  /***************************************************************************
  * HT/VHT/HE LDPC COMMON
  ****************************************************************************
  * ncw, lldpc, nshrt, npunc(1st pass) ,extrau(final) and nsymu(final)
  * note: navbits and npunc are **not** updated by extra, this is done into
  *       another sub-progr.
  ***************************************************************************/
  /* NCW, LLDPC */
L_NCW:
  {I,      W_NULL,    NOP,          R_648}; 
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-648  
  {J,               CC_LE,          NCW_0}; // JMP NCW0 IF NAVBITS<=648
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-1296    
  {J,               CC_LE,          NCW_1}; // JMP NCW1 IF NAVBITS<=1296
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-1944     
  {J,               CC_LE,          NCW_2}; // JMP NCW2 IF NAVBITS<=1944
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-2592      
  {J,               CC_LE,          NCW_3}; // JMP NCW3 IF NAVBITS<=2592
  /* IF 2592 < NAVBITS */
NCW_4:
  {I, W_LLDPC1944,  CLRXY,         R_NPLD}; // LLDPC=1944 ;   X=Y=0
  {I,      W_NULL,    ADD,      R_1944XCR}; // Y=NPLD;        B=1944*CR
  {I,      W_NULL,    DIV,            R_1}; // Y=NPLD/1944/R; B=1
  {J,           CC_X_ZERO,         NCW_41}; // JMP  IF X==0
  {I,      W_NULL,    ADD,         R_NULL}; // Y=NPLD/1944/R+1 
NCW_41:  
  {I,       W_NCW,    NOP,         R_NULL}; // NCW=Y;
  {J,             CC_TRUE,         L_NSHR}; // JMP L_NSHR
  /* IF 1944 < NAVBITS <= 2592 */
NCW_3:  
  {I,      W_NCW2,  CLRXY,      R_NAVBITS}; // NCW=2; X=Y=0 ; B=NAVBITS
  {I, W_LLDPC1944,    ADD,         R_NPLD}; // LLDPC=1944; Y=NAVBITS;  B=NPLD
  {I,      W_NULL,    SUB,   R_2916DIVCRD}; // Y=NAVBITS-NPLD;         B=2916*(1-CR)
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-NPLD-2616*(1-CR)
  {J,               CC_GE,         L_NSHR}; // JMP L_NSHR IF NAVBITS >= (NPLD+2616*(1-CR))     
  {I, W_LLDPC1296,    NOP,         R_NULL}; // LLDPC=1296  
  {J,             CC_TRUE,         L_NSHR}; // JMP L_NSHR
  /* IF 1296 < NAVBITS <= 1944 */
NCW_2:  
  {I,      W_NCW1,    NOP,         R_NULL}; // NCW=1 ;
  {I, W_LLDPC1944,    NOP,         R_NULL}; // LLDPC=2 [1944] ;
  {J,             CC_TRUE,         L_NSHR}; // JMP L_NSHR
  /* IF 648  < NAVBITS <= 1296 */
NCW_1:
  {I,      W_NCW1,  CLRXY,      R_NAVBITS}; // NCW=1 ; X=Y=0 ; B=NAVBITS
  {I, W_LLDPC1944,    ADD,         R_NPLD}; // LLDPC=1944; Y=NAVBITS; B=NPLD 
  {I,      W_NULL,    SUB,   R_1464DIVCRD}; // Y=NAVBITS-NPLD;        B=1464*(1-CR)
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-NPLD-1464*(1-R)    
  {J,               CC_GE,         L_NSHR}; // JMP L_NSHR IF NAVBITS >= (NPLD+1464*(1-CR)) 
  {I, W_LLDPC1296,    NOP,         R_NULL}; // LLDPC=1296   
  {J,             CC_TRUE,         L_NSHR}; // JMP L_NSHR
  /* IF NAVBITS <= 648  */
NCW_0:
  {I,      W_NCW1,  CLRXY,      R_NAVBITS}; // NCW=1 ; X=Y=0 ;          B=NAVBITS
  {I, W_LLDPC1296,    ADD,         R_NPLD}; // LLDPC=1296; Y=NAVBITS;   B=NPLD
  {I,      W_NULL,    SUB,    R_912DIVCRD}; // Y=NAVBITS-NPLD;          B=912*(1-CR)
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-NPLD-912*(1-CR)
  {J,               CC_GE,         L_NSHR}; // JMP L_NSHR   
  {I,  W_LLDPC648,    NOP,         R_NULL}; // LLDPC=648  
  /* NSHRT */
L_NSHR:  
  {I,      W_NULL,  CLRXY,          R_NCW}; // X=Y=0;      B=NCW
  {I,      W_NULL,    ADD,        R_LLDPC}; // Y=NCW;      B=LLDPC
  {I,      W_NULL,    MUL,         R_NULL}; // Y=NCW*LLDPC
  /*    R0=NCW*LLDPC                        [ used several times afterwards ] */
  {I,        W_R0,    NOP,          R_CRD}; // R0=Y; B=CRD
  /*    R1=NCW*LLDPC*(1-CR)=NCW*LLDPC/CRD   [ used several times afterwards ] */
  {I,      W_NULL,    DIV,         R_NULL}; // Y=NCW*LLDPC/CRD
  {I,        W_R1,    NOP,          R_CRN}; // R1=Y; B=CRN
  /* NSHRT=MAX(0,NCW*LLDPC*CR-NPLD) */
  {I,      W_NULL,    MUL,         R_NULL}; // Y=NCW*LLDPC/CRD
  {I,      W_NULL,    NOP,         R_NPLD}; // Y=NCW*LLDPC/CRD*CRN;  B=NPLD
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NCW*LLDPC/CRD*CRN-NPLD
  {J,               CC_GE,         NSHR_0}; // JMP LA_9 NCW*LLDPC/CRD*CRN-NPLD >= 0
  {I,      W_NULL,  CLRXY,         R_NULL}; // X=Y=0
NSHR_0:
  {I,     W_NSHRT,    NOP,         R_NULL}; // NSHRT=Y
  /* NPUNC=MAX(0,NCW*LLDPC-NAVBITS-NSHRT) */
  {I,      W_NULL,  CLRXY,           R_R0}; // B=NCW*LLDPC;
  {I,      W_NULL,    ADD,      R_NAVBITS}; // Y=NCW*LLDPC;  B=NAVBITS
  {I,      W_NULL,    SUB,        R_NSHRT}; // Y=NCW*LLDPC-NAVBITS;  B=NSHRT
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NCW*LLDPC-NAVBITS-NSHRT
  {J,               CC_GE,         NSHR_1}; // JMP LA_10 NCW*LLDPC-NAVBITS-NSHRT >= 0
  {I,      W_NULL,  CLRXY,         R_NULL}; // X=Y=0;
  /* R3=10*NPUNC                            [ used several times afterwards ] */
NSHR_1:
  {I,     W_NPUNC,    NOP,           R_10}; // NPUNC=Y;  B=10 ;
  
  /***************************************************************************
  * HT extra bit generation: 
  *  for HT,  determine the extra bit
  *  for VHT, the bit is already provided by VHTSIGA                  
  *  for HE,  the bit is already provided by VHTSIGA                  
  ***************************************************************************/  
  {J,               CC_HT,  L_HT_DETEXTRA}; // JMP L_HT_DETEXTRA IF HT
  {J,    CC_VHTSIGA_EXTRA,  L_HT_ADDEXTRA}; // JMP L_HT_ADDEXTRA IF CC_VHTSIGA_EXTRA
  {J,     CC_HESIGA_EXTRA,  L_HE_ADDEXTRA}; // JMP L_HE_ADDEXTRA IF CC_HESIGA_EXTRA
  {J,             CC_TRUE,          UPD_1}; // JMP UPD_1 

  /* IF NPUNC > 0.3*NCW*LLDPC*(1-CR) THEN ADD EXTRAU */
L_HT_DETEXTRA:
  {I,      W_NULL,    MUL,         R_NULL}; // Y=NPUNC*10;
  {I,        W_R3,  CLRXY,           R_R1}; // R3=10*NPUNC ; X=Y=0; B=NCW*LLDPC*(1-CR) 
  {I,      W_NULL,    ADD,         R_NULL}; // Y=NCW*LLDPC*(1-CR)
  {I,      W_NULL,    ADD,         R_NULL}; // Y=2*NCW*LLDPC*(1-CR)
  {I,      W_NULL,    ADD,           R_R3}; // Y=2*NCW*LLDPC*(1-CR); B=10*NPUNC
  {I,      W_NULL,    SUB,         R_NULL}; // Y=3*NCW*LLDPC*(1-CR)-10*NPUNC
  {J,               CC_LT,  L_HT_ADDEXTRA}; // JMP ADDEXT IF 10*NPUNC > 3*NCW*LLDPC*(1-CR)
  /* IF !(NPUNC > 0.1*NCW*LLDPC(1-CR)) THEN NO EXTRAU  IS REWRITTEN AS */
  /* IF NPUNC <= 0.1*NCW*LLDPC(1-CR) THEN NO EXTRAU   */
  {I,      W_NULL,  CLRXY,           R_R1}; // X=Y=0;  B=NCW*LLDPC*(1-CR)
  {I,      W_NULL,    ADD,           R_R3}; // Y=NCW*LLDPC*(1-CR); B=10*NPUNC  
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NCW*LLDPC*(1-CR)-10*NPUNC
  {J,               CC_GE,          UPD_1}; // JMP NOEXT [NOEXTRAU]
  {I,      W_NULL,  CLRXY,        R_NSHRT}; // X=Y=0 ; B=NSHRT 
  {I,      W_NULL,    ADD,           R_10}; // Y=NSHRT ; B=10
  {I,      W_NULL,    MUL,         R_NULL}; // Y=NSHRT*10;
  /*   R3 = 10*NSHRT   */
  {I,        W_R3,  CLRXY,        R_NPUNC}; // R3=10*NSHRT ; X=Y=0; B=NPUNC
  {I,      W_NULL,    ADD,       R_12XCRN}; // Y=NPUNC ; B=12*CR/(1-CR)
  {I,      W_NULL,    MUL,           R_R3}; // Y=12*NPUNC*R/(1-R) ; B=10*NSHRT
  {I,      W_NULL,    SUB,         R_NULL}; // Y=12*NPUNC*R/(1-R)-10*NSHRT
  /* IF NSHRT < 1.2*NPUNC*R/(1-R) THEN ADD EXTRAU  */
  {J,               CC_GT,  L_HT_ADDEXTRA}; // JMP L_HT_ADDEXTRA
  {J,             CC_TRUE,          UPD_1}; // JMP UPD_1

  /***************************************************************************
  * UPDATE NAVBITS AND NBPUNC (HE ONLY)
  ***************************************************************************/
L_HE_ADDEXTRA:
  {I,      W_NULL,  CLRXY,      R_NAVBITS}; // X=Y=0;        B=NAVBITS
  {J,CC_AINIT_EQ3, L_HE_ADDEXTRA_AINITEQ3};
  {I,      W_NULL,  ADD,   R_MXNCBPSSHORT};
  {I,      W_NULL,  ADD,           R_NULL};
  {J,           CC_TRUE,  L_NAVBITS_WRITE}; // JMP UPD_1
L_HE_ADDEXTRA_AINITEQ3:
  {I,      W_NULL,  ADD,        R_MXNCBPS};
  {I,      W_NULL,  ADD,   R_MXNCBPSSHORT};
  {I,      W_NULL,  SUB,           R_NULL};
  {I,      W_NULL,  SUB,           R_NULL};
  {I,      W_NULL,  SUB,           R_NULL}; // y=navbits + mstbc*(ncbps-3*ncbps_short)
  {J,           CC_TRUE,  L_NAVBITS_WRITE};
  /***************************************************************************
  * UPDATE NAVBITS AND NBPUNC (HT AND VHT ONLY)
  ***************************************************************************/
L_HT_ADDEXTRA:
  /* EXTRA SYMBLOL, UPDATE NAVBITS AND NPUNC (HT AND VHT ONLY) */
  {I,     W_EXTRA,  CLRXY,      R_NAVBITS}; // X=Y=0;        B=NAVBITS
  {I,      W_NULL,    ADD,      R_MXNCBPS}; // Y=NAVBITS;    B=NCBPS*MSTBC
  {I,      W_NULL,    ADD,         R_NULL}; // Y=NAVBITS+NCBPS*MSTBC

L_NAVBITS_WRITE:
  /* NAVBITS */
  {I,   W_NAVBITS,    NOP,         R_NULL}; // NAVBITS=Y
  {I,      W_NULL,  CLRXY,           R_R0}; // X=Y=0; B=NCW*LLDPC;
  {I,      W_NULL,    ADD,      R_NAVBITS}; // Y=NCW*LLDPC;         B=NAVBITS
  {I,      W_NULL,    SUB,        R_NSHRT}; // Y=NCW*LLDPC-NAVBITS; B=NSHRT
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NCW*LLDPC-NAVBITS-NSHRT
  {J,               CC_GE,          UPD_0}; // JMP SP3_0 IF NCW*LLDPC-NAVBITS-NSHRT >=0 
  {I,      W_NULL,  CLRXY,         R_NULL}; // X=Y=0;
UPD_0:
  {I,     W_NPUNC,    NOP,         R_NULL}; // NPUNC=Y;

  /***************************************************************************
  * NREPQ,NREPR, NPUNCQ,NPUNCR, NSHRTQ,NSHRTR
  ***************************************************************************/
UPD_1:
  /* NREP */
  {I,      W_NULL,  CLRXY,      R_NAVBITS}; // X=Y=0; B=NAVBITS
  {I,      W_NULL,    ADD,           R_R1}; // Y=NAVBITS;                  B=NCW*LLDPC*(1-CR)
  {I,      W_NULL,    SUB,         R_NPLD}; // Y=NAVBITS-NCW*LLDPC*(1-CR); B=NPLD
  {I,      W_NULL,    SUB,         R_NULL}; // Y=NAVBITS-NCW*LLDPC*(1-CR)-NPLD
  {J,               CC_GE,          UPD_2}; // JMP SP4_0 IF NAVBITS-NCW*LLDPC*(1-CR)-NPLD>=0     
  {I,      W_NULL,  CLRXY,         R_NULL}; // X=Y=0
UPD_2:
  {I,      W_NULL,    NOP,          R_NCW}; // B=NCW
  {I,      W_NULL,    DIV,         R_NULL}; // Y=NREP/NCW
  /* NREPQ,  NREPR */
  {I,    W_NREPQR,  CLRXY,        R_NPUNC}; // {NREPQ,NREPR}={X,Y}; X=Y=0; B=NPUNC
  {I,      W_NULL,    ADD,          R_NCW}; // Y=NPUNC; B=NCW
  {I,      W_NULL,    DIV,         R_NULL}; // Y=NPUNC/NCW
  /* NPUNCQ, NPUNCR */
  {I,   W_NPUNCQR,  CLRXY,        R_NSHRT}; // {NPUNCQ,NPUNCR}={X,Y}; X=Y=0; B=NSHRT
  {I,      W_NULL,    ADD,          R_NCW}; // Y=NSHRT; B=NCW
  {I,      W_NULL,    DIV,         R_NULL}; // Y=NSHRT/NCW
  /* NSHRTQ, NSHRTR */
  {I,   W_NSHRTQR,  CLRXY,         R_NULL}; // {NSHRTQ,NSHRTR}={X,Y}; X=Y=0; 
  {J,              CC_VHT,          L_END}; // JUMP TO L_END IF VHT
  {J,               CC_HE,          L_END}; // JUMP TO L_END IF HE
 
  /* UPDATE HT_NSYM */
  {J,          CC_NOEXTRA,          L_END}; // JMP H_END IF NOEXTRA
  {I,     W_NULL,   CLRXY,     R_NSYMINIT}; // Y=0; B=NSYMINIT
  {I,     W_NULL,     ADD,        R_MSTBC}; // Y=NSYMINIT;  B=MSTBC
  {I,     W_NULL,     ADD,         R_NULL}; // Y=MSTBC+NSYMINIT
  /* HT_NSYM */
  {I,     W_NSYM,     NOP,         R_NULL}; // HT_NSYM=MSTBC+NSYMINIT
L_END:
  {I,     W_DONE,    TERM,         R_NULL}; // HT_DONE=1
  /***************************************************************************
  * NULL line because of prefecth
  ***************************************************************************/
  {I,     W_NULL,   TERM,          R_NULL}; //
  {I,     W_NULL,   TERM,          R_NULL}; //
