/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_deinterleaver2
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire        rst_n,
  input  wire        clk,

  /*****************************************************************************
  * symbol/control
  *****************************************************************************/
  input  wire        enable,
  
  input  wire        sigen,
  input  wire [ 2:0] nss,
  input  wire [ 1:0] nsd,
  input  wire [ 2:0] nbpsc,
  input  wire        ruen,
  input  wire [ 2:0] rulen,
  input  wire        dcm,
  input  wire        qbpsk,
  
  input  wire        row_fifo,
  input  wire [ 2:0] row_fifo_wrptr,
  output wire [ 2:0] row_fifo_rdptr,
  
  /*****************************************************************************
  * soft bit interfaces
  *****************************************************************************/
  /* ch0 channel content and other fields */
  input  wire        ch0_start,
  input  wire [ 1:0] ch0_sigsel,
  output reg         ch0_done,
  
  input  wire [ 3:0] ch0_ready,
  output wire [ 4:0] ch0_sb0,  
  output wire [ 4:0] ch0_sb1,  
  output wire [ 4:0] ch0_sb2,  
  output wire [ 4:0] ch0_sb3,
  output wire [ 4:0] ch0_sb4,
  output wire [ 4:0] ch0_sb5,
  output wire [ 4:0] ch0_sb6,
  output wire [ 4:0] ch0_sb7,
  output wire        ch0_last,
  output wire [ 3:0] ch0_valid,
  
  /* ch1 channel content only */
  input  wire        ch1_start,
  input  wire [ 1:0] ch1_sigsel,
  output reg         ch1_done,
 
  input  wire [ 3:0] ch1_ready,
  output wire [ 4:0] ch1_sb0,  
  output wire [ 4:0] ch1_sb1,  
  output wire [ 4:0] ch1_sb2,  
  output wire [ 4:0] ch1_sb3,
  output wire [ 4:0] ch1_sb4,
  output wire [ 4:0] ch1_sb5,
  output wire [ 4:0] ch1_sb6,
  output wire [ 4:0] ch1_sb7,
  output wire        ch1_last,
  output wire [ 3:0] ch1_valid,
  
  /*****************************************************************************
  * sram interface
  *****************************************************************************/
  output wire        ren,
  output wire [ 8:0] raddr,
  input  wire [39:0] rdata
);
  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;
  
  localparam  NBPSC_1=3'd0,
              NBPSC_2=3'd1,
              NBPSC_4=3'd2,
              NBPSC_6=3'd3,
              NBPSC_8=3'd4,
              NBPSC_10=3'd5;

  localparam  NSS_1=3'd0,
              NSS_2=3'd1,
              NSS_3=3'd2,
              NSS_4=3'd3;

  /*****************************************************************************
  * parameters decoding
  *****************************************************************************/
  reg  [ 2:0] s;    /* max(1,0.5*nbpsc) */
  reg  [ 4:0] ncol;
  reg  [ 3:0] nrow;
  reg  [ 3:0] nbpsc_dec;
  wire        odd_ndbps;
  
  always @(*)
  begin
    case(nbpsc)                               
      NBPSC_1: {s,nbpsc_dec} = {3'd1,4'd1};   
      NBPSC_2: {s,nbpsc_dec} = {3'd1,4'd2};   
      NBPSC_4: {s,nbpsc_dec} = {3'd2,4'd4};   
      NBPSC_6: {s,nbpsc_dec} = {3'd3,4'd6};   
      NBPSC_8: {s,nbpsc_dec} = {3'd4,4'd8};   
      default: {s,nbpsc_dec} = {3'd5,4'd10};   
    endcase                                   
    
    if(!ruen)
      case(nsd)
        NSD_48:    {ncol, nrow} = {5'd16, 4'd3};
        NSD_52:
          if(!dcm)
                   {ncol, nrow} = {5'd13, 4'd4};
          else
                   {ncol, nrow} = {5'd13, 4'd2};
       
        NSD_108:   {ncol, nrow} = {5'd18, 4'd6};
        default:   {ncol, nrow} = {5'd26, 4'd9};
      endcase
    else
    begin
      if(!dcm)
        case(rulen)
          RU_26:   {ncol, nrow} = { 5'd8, 4'd3};
          RU_52:   {ncol, nrow} = {5'd16, 4'd3};
          RU_106:  {ncol, nrow} = {5'd17, 4'd6};
          default: {ncol, nrow} = {5'd26, 4'd9};
        endcase 
      else
        case(rulen)
          RU_26:   {ncol, nrow} = { 5'd4, 4'd3};
          RU_52:   {ncol, nrow} = { 5'd8, 4'd3};
          RU_106:  {ncol, nrow} = {5'd17, 4'd3};
          default: {ncol, nrow} = {5'd13, 4'd9};
        endcase 
    end
  end

  /* odd ndbps */
  assign odd_ndbps = nbpsc==NBPSC_1 && nss==NSS_1 && 
                     ruen && dcm && 
                     (rulen==RU_106 || rulen==RU_242);

  /*****************************************************************************
  * S0: address, offset, nsb generation
  *****************************************************************************/
  wire [2:0]  s0_row_fifo_rdptr;
  wire        s0_ch0_valid,        s0_ch1_valid;
  wire [7:0]  s0_ch0_addr,         s0_ch1_addr;
  wire [3:0]  s0_ch0_nsb,          s0_ch1_nsb;
  wire [2:0]  s0_ch0_offset,       s0_ch1_offset;
  wire        s0_ch0_last,         s0_ch1_last;
  reg  [5:0]  s0_ch0_count,        s0_ch1_count; 
  wire [5:0]  n_s0_ch0_count,      n_s0_ch1_count;
  wire [5:0]  n_s0_ch0_count_req,  n_s0_ch1_count_req;
  wire [5:0]  n_s0_ch0_count_decr, n_s0_ch1_count_decr;
  wire        s0_ch0_ready,        s0_ch1_ready;
  wire [ 3:0] s5_ch0_fifo_rdlen,   s5_ch1_fifo_rdlen;
  
  rx_bd_deinterleaver_genaddr2 u_ch0_genaddr
  (
    .rst_n(                 rst_n),
    .clk(                   clk),

    .enable(                enable),
    .start(                 ch0_start),
  
    .odd_ndbps(             odd_ndbps),
    .b_init(                qbpsk),
    .nbpsc_dec(             nbpsc_dec),
    .sigen(                 sigen),
    .nrow(                  nrow),
    .ncol(                  ncol),
    .sel(                   ch0_sigsel),
    .row_fifo(              row_fifo),
    .row_fifo_wrptr(        row_fifo_wrptr),
    .row_fifo_rdptr(        s0_row_fifo_rdptr),
    
    .ready(                 s0_ch0_ready),
    .valid(                 s0_ch0_valid),
    .addr(                  s0_ch0_addr),
    .nsb(                   s0_ch0_nsb),
    .offset(                s0_ch0_offset),
    .last(                  s0_ch0_last)
  );

  assign n_s0_ch0_count_req  = s0_ch0_count + ({2'b0,s0_ch0_nsb} & {6{s0_ch0_valid}}) - {2'b0,s5_ch0_fifo_rdlen};
  assign n_s0_ch0_count_decr = s0_ch0_count - {2'b0,s5_ch0_fifo_rdlen};
  assign n_s0_ch0_count      = s0_ch0_ready?n_s0_ch0_count_req:n_s0_ch0_count_decr;
 
  rx_bd_deinterleaver_genaddr2 u_ch1_genaddr
  (
    .rst_n(                 rst_n),                
    .clk(                   clk),                  

    .enable(                enable),               
    .start(                 ch1_start),            
  
    .odd_ndbps(             1'b0),                 
    .b_init(                1'b0),                 
    .nbpsc_dec(             nbpsc_dec),            
    .sigen(                 1'b1),                 
    .nrow(                  nrow),                 
    .ncol(                  ncol),                 
    .sel(                   ch1_sigsel),           
    .row_fifo(              1'b0),                 
    .row_fifo_wrptr(        3'd0),                 
    .row_fifo_rdptr(        /* do not connect */), 
  
    .ready(                 s0_ch1_ready),         
    .valid(                 s0_ch1_valid),         
    .addr(                  s0_ch1_addr),          
    .nsb(                   s0_ch1_nsb),           
    .offset(                s0_ch1_offset),        
    .last(                  s0_ch1_last)           
  );

  assign n_s0_ch1_count_req  = s0_ch1_count + ({2'b0,s0_ch1_nsb} & {6{s0_ch1_valid}}) - {2'b0,s5_ch1_fifo_rdlen};
  assign n_s0_ch1_count_decr = s0_ch1_count - {2'b0,s5_ch1_fifo_rdlen};
  assign n_s0_ch1_count      = s0_ch1_ready?n_s0_ch1_count_req:n_s0_ch1_count_decr;
  
  assign s0_ch0_ready        = n_s0_ch0_count_req <= 6'd40;
  assign s0_ch1_ready        = n_s0_ch1_count_req <= 6'd40 && !(s0_ch0_ready&& s0_ch0_valid);
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s0_ch0_count <= 6'b0;
      s0_ch1_count <= 6'b0;
    end
    else if(!enable)
    begin
      s0_ch0_count <= 6'b0;
      s0_ch1_count <= 6'b0;
    end
    else
    begin
      if(ch0_start)
        s0_ch0_count <= 6'd0;
      else
        s0_ch0_count <= n_s0_ch0_count;
        
      if(ch1_start)
        s0_ch1_count <= 6'd0;
      else
        s0_ch1_count <= n_s0_ch1_count;
    end
  end

  /*****************************************************************************
  * S1: memory address cycle
  *****************************************************************************/
  reg         s1_en;
  reg  [ 8:0] s1_addr;
  reg  [ 3:0] s1_nsb;
  reg  [ 2:0] s1_offset;
  reg         s1_last;
  reg         s1_channel;
  reg  [ 2:0] s1_row_fifo_rdptr;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s1_en             <= 1'b0;
      s1_addr           <= 9'b0;
      s1_nsb            <= 4'd0;
      s1_offset         <= 3'd0;
      s1_last           <= 1'b0;
      s1_channel        <= 1'b0;
      s1_row_fifo_rdptr <= 3'b0;
    end
    else if(!enable)
    begin
      s1_en             <= 1'b0;
      s1_addr           <= 9'b0;
      s1_nsb            <= 4'd0;
      s1_offset         <= 3'd0;
      s1_last           <= 1'b0;
      s1_channel        <= 1'b0;
      s1_row_fifo_rdptr <= 3'b0;
    end
    else
    begin
      if(s0_ch0_ready)
         s1_row_fifo_rdptr <= s0_row_fifo_rdptr;
      
      if(s0_ch0_ready && s0_ch0_valid)                   
      begin                                              
        s1_en             <= 1'b1;                      
        s1_addr           <= {1'b0,s0_ch0_addr};        
        s1_offset         <= s0_ch0_offset;             
        s1_channel        <= 1'b0;                      
        s1_nsb            <= s0_ch0_nsb;                  
        s1_last           <= s0_ch0_last;
      end                                                
      else if(s0_ch1_ready && s0_ch1_valid)              
      begin                                              
        s1_en      <= 1'b1;                              
        s1_addr    <= {1'b1,s0_ch1_addr};                
        s1_offset  <= s0_ch1_offset;                     
        s1_channel <= 1'b1;                              
        s1_nsb     <= s0_ch1_nsb;                        
        s1_last    <= s0_ch1_last;                       
      end                                                
      else                                               
      begin                                              
        s1_en      <= 1'b0;                              
        s1_nsb     <= 4'b0;                              
        s1_offset  <= 3'd0;                              
        s1_last    <= 1'b0;                              
        s1_channel <= 1'b0;                              
      end
    end
  end
 
  assign ren   = s1_en;
  assign raddr = s1_addr;
 
  /*****************************************************************************
  * S2: memory access cycle
  *****************************************************************************/
  reg        s2_en;
  reg [ 3:0] s2_nsb;
  reg [ 2:0] s2_offset;
  reg        s2_last;
  reg        s2_channel;
  reg [ 2:0] s2_row_fifo_rdptr;

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s2_en             <= 1'b0;
      s2_nsb            <= 4'd0;
      s2_offset         <= 3'd0;
      s2_last           <= 1'b0;
      s2_channel        <= 1'b0;
      s2_row_fifo_rdptr <= 3'b0;                     
    end
    else if(!enable)
    begin
      s2_en             <= 1'b0;
      s2_nsb            <= 4'd0;
      s2_offset         <= 3'd0;
      s2_last           <= 1'b0;
      s2_channel        <= 1'b0;
      s2_row_fifo_rdptr <= 3'b0;                      
    end
    else
    begin
      s2_en             <= s1_en;      
      s2_nsb            <= s1_nsb;     
      s2_offset         <= s1_offset;  
      s2_last           <= s1_last;    
      s2_channel        <= s1_channel; 
      s2_row_fifo_rdptr <= s1_row_fifo_rdptr;                     
    end
  end
  
  /*****************************************************************************
  * S3: memux re-registering
  *****************************************************************************/
  reg        s3_ch0_en;
  reg        s3_ch1_en;
  reg [ 3:0] s3_nsb;
  reg [ 2:0] s3_offset;
  reg        s3_last;
  reg [ 2:0] s3_row_fifo_rdptr;

  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s3_ch0_en         <= 1'b0;
      s3_ch1_en         <= 1'b0;
      s3_nsb            <= 4'd0;
      s3_offset         <= 3'd0;
      s3_last           <= 1'b0;
      s3_row_fifo_rdptr <= 3'd0;                     
    end
    else if(!enable)
    begin
      s3_ch0_en         <= 1'b0;
      s3_ch1_en         <= 1'b0;
      s3_nsb            <= 4'd0;
      s3_offset         <= 3'd0;
      s3_last           <= 1'b0;
      s3_row_fifo_rdptr <= 3'd0;                
    end
    else
    begin
      s3_ch0_en         <= s2_en & !s2_channel;
      s3_ch1_en         <= s2_en &  s2_channel;
      s3_nsb            <= s2_nsb;
      s3_offset         <= s2_offset;
      s3_last           <= s2_last;
      s3_row_fifo_rdptr <= s2_row_fifo_rdptr;                     
    end
  end
 
  /*****************************************************************************
  * S4: data capture
  *****************************************************************************/
  reg        s4_ch0_en;
  reg        s4_ch1_en;
  reg [ 2:0] s4_offset;
  reg [39:0] s4_data;
  reg [ 3:0] s4_nsb;
  reg        s4_last;
  reg [ 2:0] s4_row_fifo_rdptr;
  
  wire   [ 2:0] n_s4_row_fifo_rdptr_flush;
  assign n_s4_row_fifo_rdptr_flush = s4_row_fifo_rdptr + 3'd1;
  
  wire   s4_row_fifo_empty;
  assign s4_row_fifo_empty = s4_row_fifo_rdptr==row_fifo_wrptr;
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s4_ch0_en         <= 1'b0;
      s4_ch1_en         <= 1'b0;
      s4_data           <= 40'b0;
      s4_nsb            <= 4'd0;
      s4_offset         <= 3'd0;
      s4_last           <= 1'b0;
      s4_row_fifo_rdptr <= 3'd0;
    end
    else if(!enable)
    begin
      s4_ch0_en         <= 1'b0;
      s4_ch1_en         <= 1'b0;
      s4_data           <= 40'b0;
      s4_nsb            <= 4'd0;
      s4_offset         <= 3'd0;
      s4_last           <= 1'b0;
    end
    else
    begin
      s4_ch0_en  <= s3_ch0_en;
      s4_ch1_en  <= s3_ch1_en;
      s4_data    <= rdata;
      s4_nsb     <= s3_nsb;
      s4_offset  <= s3_offset;
      s4_last    <= s3_last;
      if(row_fifo)
      begin  
        s4_row_fifo_rdptr <= s3_row_fifo_rdptr; 
      end
      else
      begin
        s4_row_fifo_rdptr <= 3'd0;                   
      end
    end
  end
  
  assign row_fifo_rdptr = s4_row_fifo_rdptr;
  
  wire  [ 3:0]  s4_ch0_nsb,s4_ch1_nsb;
  assign s4_ch0_nsb  = s4_nsb  & {4{s4_ch0_en}};
  assign s4_ch1_nsb  = s4_nsb  & {4{s4_ch1_en}};
  
  wire          s4_ch0_last,s4_ch1_last;
  assign s4_ch0_last = s4_last & s4_ch0_en;
  assign s4_ch1_last = s4_last & s4_ch1_en;
  
  /*  remove offset and mask unwanted sb */
  wire  [39:0]  s4_in_sh1,s4_in_sh2,s4_in_sh3;
  assign s4_in_sh1   = s4_offset[0]?{ 5'b0,   s4_data[39:5]}:s4_data;
  assign s4_in_sh2   = s4_offset[1]?{10'b0, s4_in_sh1[39:10]}:s4_in_sh1;
  assign s4_in_sh3   = s4_offset[2]?{20'b0, s4_in_sh2[39:20]}:s4_in_sh2;
  
  wire  [39:0]  s4_ch0_im_sh1,s4_ch0_im_sh2,s4_ch0_im_sh3,s4_ch0_im_sh4;
  assign s4_ch0_im_sh1   = s4_ch0_nsb[0]?{35'b0,           {5{1'b1}}}:{40{1'b0}};
  assign s4_ch0_im_sh2   = s4_ch0_nsb[1]?{s4_ch0_im_sh1[29:0],{10{1'b1}}}:s4_ch0_im_sh1;
  assign s4_ch0_im_sh3   = s4_ch0_nsb[2]?{s4_ch0_im_sh2[19:0],{20{1'b1}}}:s4_ch0_im_sh2;
  assign s4_ch0_im_sh4   = s4_ch0_nsb[3]?{                {40{1'b1}}}:s4_ch0_im_sh3;

  wire  [39:0]  s4_ch1_im_sh1,s4_ch1_im_sh2,s4_ch1_im_sh3,s4_ch1_im_sh4;
  assign s4_ch1_im_sh1   = s4_ch1_nsb[0]?{35'b0,           {5{1'b1}}}:{40{1'b0}};
  assign s4_ch1_im_sh2   = s4_ch1_nsb[1]?{s4_ch1_im_sh1[29:0],{10{1'b1}}}:s4_ch1_im_sh1;
  assign s4_ch1_im_sh3   = s4_ch1_nsb[2]?{s4_ch1_im_sh2[19:0],{20{1'b1}}}:s4_ch1_im_sh2;
  assign s4_ch1_im_sh4   = s4_ch1_nsb[3]?{                {40{1'b1}}}:s4_ch1_im_sh3;
  
  wire  [39:0]  s4_ch0_in_data,s4_ch1_in_data;
  assign s4_ch0_in_data  = s4_in_sh3 & s4_ch0_im_sh4;
  assign s4_ch1_in_data  = s4_in_sh3 & s4_ch1_im_sh4;

  wire [ 4:0] s4_ch0_sb7,s4_ch0_sb6,s4_ch0_sb5,s4_ch0_sb4,s4_ch0_sb3,s4_ch0_sb2,s4_ch0_sb1,s4_ch0_sb0;
  assign {s4_ch0_sb7,s4_ch0_sb6,s4_ch0_sb5,s4_ch0_sb4,s4_ch0_sb3,s4_ch0_sb2,s4_ch0_sb1,s4_ch0_sb0} = s4_ch0_in_data;
  
  wire [ 4:0] s4_ch1_sb7,s4_ch1_sb6,s4_ch1_sb5,s4_ch1_sb4,s4_ch1_sb3,s4_ch1_sb2,s4_ch1_sb1,s4_ch1_sb0;
  assign {s4_ch1_sb7,s4_ch1_sb6,s4_ch1_sb5,s4_ch1_sb4,s4_ch1_sb3,s4_ch1_sb2,s4_ch1_sb1,s4_ch1_sb0} = s4_ch1_in_data;

  /*****************************************************************************
  * S5: output fifos
  *****************************************************************************/
  /* ch0 */
  reg  [199:0] s5_ch0_fifo;
  wire [199:0] n_s5_ch0_fifo;
  reg  [  5:0] s5_ch0_fifo_count;
  wire [  5:0] n_s5_ch0_fifo_count;
  reg          s5_ch0_fifo_last;
  wire         n_s5_ch0_fifo_last;
  
  wire [ 3:0]  s5_ch0_fifo_wrlen;
  wire [ 5:0]  s5_ch0_fifo_in_shsel;
  
  wire [199:0] s5_ch0_fifo_in_sh1,s5_ch0_fifo_in_sh2,s5_ch0_fifo_in_sh3,s5_ch0_fifo_in_sh4,s5_ch0_fifo_in_sh5,s5_ch0_fifo_in_sh6;
  wire [199:0] s5_ch0_fifo_out_sh1,s5_ch0_fifo_out_sh2,s5_ch0_fifo_out_sh3,s5_ch0_fifo_out_sh4;
  
  assign  s5_ch0_fifo_wrlen    = s4_ch0_nsb;
  assign  s5_ch0_fifo_rdlen    = (ch0_valid>ch0_ready)?ch0_ready:ch0_valid;
  
  assign  s5_ch0_fifo_in_shsel = s5_ch0_fifo_count - {2'b0,s5_ch0_fifo_rdlen};
  
  assign  s5_ch0_fifo_in_sh1  = s5_ch0_fifo_in_shsel[0]?{ 155'b0,   s4_ch0_in_data,  5'b0}:{160'b0,s4_ch0_in_data};
  assign  s5_ch0_fifo_in_sh2  = s5_ch0_fifo_in_shsel[1]?{s5_ch0_fifo_in_sh1[189:0], 10'b0}:{s5_ch0_fifo_in_sh1};
  assign  s5_ch0_fifo_in_sh3  = s5_ch0_fifo_in_shsel[2]?{s5_ch0_fifo_in_sh2[179:0], 20'b0}:{s5_ch0_fifo_in_sh2};
  assign  s5_ch0_fifo_in_sh4  = s5_ch0_fifo_in_shsel[3]?{s5_ch0_fifo_in_sh3[159:0], 40'b0}:{s5_ch0_fifo_in_sh3};
  assign  s5_ch0_fifo_in_sh5  = s5_ch0_fifo_in_shsel[4]?{s5_ch0_fifo_in_sh4[119:0], 80'b0}:{s5_ch0_fifo_in_sh4};
  assign  s5_ch0_fifo_in_sh6  = s5_ch0_fifo_in_shsel[5]?{s5_ch0_fifo_in_sh5[ 39:0],160'b0}:{s5_ch0_fifo_in_sh5};
  
  assign  s5_ch0_fifo_out_sh1 = s5_ch0_fifo_rdlen[0]?{ 5'b0,         s5_ch0_fifo[199: 5]}:{s5_ch0_fifo};
  assign  s5_ch0_fifo_out_sh2 = s5_ch0_fifo_rdlen[1]?{10'b0,s5_ch0_fifo_out_sh1[199:10]}:{s5_ch0_fifo_out_sh1};
  assign  s5_ch0_fifo_out_sh3 = s5_ch0_fifo_rdlen[2]?{20'b0,s5_ch0_fifo_out_sh2[199:20]}:{s5_ch0_fifo_out_sh2};
  assign  s5_ch0_fifo_out_sh4 = s5_ch0_fifo_rdlen[3]?{40'b0,s5_ch0_fifo_out_sh3[199:40]}:{s5_ch0_fifo_out_sh3};
  
  assign  n_s5_ch0_fifo       = s5_ch0_fifo_in_sh6 | s5_ch0_fifo_out_sh4;
  assign  n_s5_ch0_fifo_count = s5_ch0_fifo_count  + {2'b0,s5_ch0_fifo_wrlen} - {2'b0,s5_ch0_fifo_rdlen};
  assign  n_s5_ch0_fifo_last  = s5_ch0_fifo_last | (s4_ch0_en & s4_ch0_last);
  
  reg     ch0_state;
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      ch0_state         <= 1'b0;
      ch0_done          <= 1'b0;
      s5_ch0_fifo       <= 200'd0;
      s5_ch0_fifo_count <= 6'd0;
      s5_ch0_fifo_last  <= 1'b0;
    end
    else if(!enable)
    begin
      ch0_state         <= 1'b0;
      ch0_done          <= 1'b0;
      s5_ch0_fifo       <= 200'd0;
      s5_ch0_fifo_count <= 6'd0;
      s5_ch0_fifo_last  <= 1'b0;
    end
    else
    begin
      ch0_done          <= 1'b0;
      s5_ch0_fifo       <= n_s5_ch0_fifo;
      s5_ch0_fifo_count <= n_s5_ch0_fifo_count;
      s5_ch0_fifo_last  <= n_s5_ch0_fifo_last;
     
      if(!ch0_state)
      begin
        if(ch0_start)
        begin
          ch0_state <= 1'b1;
        end
      end
      else
      begin
        if(s5_ch0_fifo_rdlen!=4'd0 && ch0_last)
        begin
          s5_ch0_fifo       <= 200'd0;
          s5_ch0_fifo_count <= 6'd0;
          s5_ch0_fifo_last  <= 1'b0;
          ch0_state         <= 1'b0;
          ch0_done          <= 1'b1;
        end
      end
    end
  end
  
  assign {ch0_sb7,ch0_sb6,ch0_sb5,ch0_sb4,ch0_sb3,ch0_sb2,ch0_sb1,ch0_sb0} = s5_ch0_fifo[39:0];
  assign ch0_last   = s5_ch0_fifo_last & {2'b0,s5_ch0_fifo_rdlen}==s5_ch0_fifo_count & s5_ch0_fifo_rdlen!=4'd0;
  assign ch0_valid  = (s5_ch0_fifo_count>=8'd8)?4'd8:s5_ch0_fifo_count[3:0];
 
  /* ch1 */
  reg  [199:0] s5_ch1_fifo;
  wire [199:0] n_s5_ch1_fifo;
  reg  [  5:0] s5_ch1_fifo_count;
  wire [  5:0] n_s5_ch1_fifo_count;
  reg          s5_ch1_fifo_last;
  wire         n_s5_ch1_fifo_last;
  
  wire [ 3:0]  s5_ch1_fifo_wrlen;
  wire [ 5:0]  s5_ch1_fifo_in_shsel;
  
  wire [199:0] s5_ch1_fifo_in_sh1,s5_ch1_fifo_in_sh2,s5_ch1_fifo_in_sh3,s5_ch1_fifo_in_sh4,s5_ch1_fifo_in_sh5,s5_ch1_fifo_in_sh6;
  wire [199:0] s5_ch1_fifo_out_sh1,s5_ch1_fifo_out_sh2,s5_ch1_fifo_out_sh3,s5_ch1_fifo_out_sh4;
  
  assign  s5_ch1_fifo_wrlen    = s4_ch1_nsb;
  assign  s5_ch1_fifo_rdlen    = (ch1_valid>ch1_ready)?ch1_ready:ch1_valid;
  
  assign  s5_ch1_fifo_in_shsel = s5_ch1_fifo_count - {2'b0,s5_ch1_fifo_rdlen};
  
  assign  s5_ch1_fifo_in_sh1  = s5_ch1_fifo_in_shsel[0]?{ 155'b0,   s4_ch1_in_data,  5'b0}:{160'b0,s4_ch1_in_data};
  assign  s5_ch1_fifo_in_sh2  = s5_ch1_fifo_in_shsel[1]?{s5_ch1_fifo_in_sh1[189:0], 10'b0}:{s5_ch1_fifo_in_sh1};
  assign  s5_ch1_fifo_in_sh3  = s5_ch1_fifo_in_shsel[2]?{s5_ch1_fifo_in_sh2[179:0], 20'b0}:{s5_ch1_fifo_in_sh2};
  assign  s5_ch1_fifo_in_sh4  = s5_ch1_fifo_in_shsel[3]?{s5_ch1_fifo_in_sh3[159:0], 40'b0}:{s5_ch1_fifo_in_sh3};
  assign  s5_ch1_fifo_in_sh5  = s5_ch1_fifo_in_shsel[4]?{s5_ch1_fifo_in_sh4[119:0], 80'b0}:{s5_ch1_fifo_in_sh4};
  assign  s5_ch1_fifo_in_sh6  = s5_ch1_fifo_in_shsel[5]?{s5_ch1_fifo_in_sh5[ 39:0],160'b0}:{s5_ch1_fifo_in_sh5};
  
  assign  s5_ch1_fifo_out_sh1 = s5_ch1_fifo_rdlen[0]?{ 5'b0,         s5_ch1_fifo[199: 5]}:{s5_ch1_fifo};
  assign  s5_ch1_fifo_out_sh2 = s5_ch1_fifo_rdlen[1]?{10'b0,s5_ch1_fifo_out_sh1[199:10]}:{s5_ch1_fifo_out_sh1};
  assign  s5_ch1_fifo_out_sh3 = s5_ch1_fifo_rdlen[2]?{20'b0,s5_ch1_fifo_out_sh2[199:20]}:{s5_ch1_fifo_out_sh2};
  assign  s5_ch1_fifo_out_sh4 = s5_ch1_fifo_rdlen[3]?{40'b0,s5_ch1_fifo_out_sh3[199:40]}:{s5_ch1_fifo_out_sh3};
  
  assign  n_s5_ch1_fifo       = s5_ch1_fifo_in_sh6 | s5_ch1_fifo_out_sh4;
  assign  n_s5_ch1_fifo_count = s5_ch1_fifo_count  + {2'b0,s5_ch1_fifo_wrlen} - {2'b0,s5_ch1_fifo_rdlen};
  assign  n_s5_ch1_fifo_last  = s5_ch1_fifo_last | (s4_ch1_en & s4_ch1_last);
  
  reg     ch1_state;
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      ch1_state         <= 1'b0;
      ch1_done          <= 1'b0;
      s5_ch1_fifo       <= 200'd0;
      s5_ch1_fifo_count <= 6'd0;
      s5_ch1_fifo_last  <= 1'b0;
    end
    else if(!enable)
    begin
      ch1_state         <= 1'b0;
      ch1_done          <= 1'b0;
      s5_ch1_fifo       <= 200'd0;
      s5_ch1_fifo_count <= 6'd0;
      s5_ch1_fifo_last  <= 1'b0;
    end
    else
    begin
      ch1_done          <= 1'b0;
      s5_ch1_fifo       <= n_s5_ch1_fifo;
      s5_ch1_fifo_count <= n_s5_ch1_fifo_count;
      s5_ch1_fifo_last  <= n_s5_ch1_fifo_last;
     
      if(!ch1_state)
      begin
        if(ch1_start)
        begin
          ch1_state <= 1'b1;
        end
      end
      else
      begin
        if(s5_ch1_fifo_rdlen!=4'd0 && ch1_last)
        begin
          s5_ch1_fifo       <= 200'd0;
          s5_ch1_fifo_count <= 6'd0;
          s5_ch1_fifo_last  <= 1'b0;
          ch1_state         <= 1'b0;
          ch1_done          <= 1'b1;
        end
      end
    end
  end
 
  assign {ch1_sb7,ch1_sb6,ch1_sb5,ch1_sb4,ch1_sb3,ch1_sb2,ch1_sb1,ch1_sb0} = s5_ch1_fifo[39:0];
  assign ch1_last   = s5_ch1_fifo_last & {2'b0,s5_ch1_fifo_rdlen}==s5_ch1_fifo_count & s5_ch1_fifo_rdlen!=4'd0;
  assign ch1_valid  = (s5_ch1_fifo_count>=8'd8)?4'd8:s5_ch1_fifo_count[3:0];
 
endmodule
`default_nettype wire
