`default_nettype none
module rx_bd_deinterleaver_genaddr_ldpc
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire        rst_n,
  input  wire        clk,

  input  wire        enable,
  input  wire        start,
  input  wire        ruen,
  input  wire [ 2:0] rulen,
  input  wire [ 1:0] nsd,
  
  input  wire        ready,
  output wire        valid,
  output wire        last,
  output wire [8:0]  addr
);

  /* constants */
  localparam  NSD_48=2'd0, 
              NSD_52=2'd1, 
              NSD_108=2'd2, 
              NSD_234=2'd3;

  localparam  RU_26=3'd0,
              RU_52=3'd1,
              RU_106=3'd2,
              RU_242=3'd3,
              RU_484=3'd4,
              RU_996=3'd5;
  
  /*****************************************************************************
  * S0: address, offset, nsb generation
  *****************************************************************************/
  reg [8:0]  s0_addr, s0_addr_last;
  reg        s0_valid, s0_last;

  always @(*)
  begin
    if (ruen) begin
      case(rulen)
        RU_26:   s0_addr_last = 9'd22;  // RU26 : 26-2pilots-2
        RU_52:   s0_addr_last = 9'd46;  // RU52 : 52-4pilots-2
        RU_106:  s0_addr_last = 9'd100; // RU106: 106-4pilots-2
        RU_242:  s0_addr_last = 9'd232; // RU242: 242-8pilots-2
        default: s0_addr_last = 9'd466; // RU484: 484-16pilots-2
      endcase    
    end else begin
      case (nsd)
        NSD_48  : s0_addr_last = 9'd46;
        NSD_52  : s0_addr_last = 9'd50;  
        NSD_108 : s0_addr_last = 9'd106;
        default : s0_addr_last = 9'd232;
      endcase
    end
  end

  /* fsm */
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      s0_valid           <= 1'b0;
      s0_last            <= 1'b0;
      s0_addr            <= 9'd0;
    end
    else if(!enable)
    begin
      s0_valid           <= 1'b0;
      s0_last            <= 1'b0;
      s0_addr            <= 9'd0;
    end
    else
    begin
      if(!s0_valid)
      begin
        if(start) begin
          s0_valid <= 1'b1;
          s0_last  <= 1'b0;
          s0_addr  <= 9'd0;
        end
      end
      else
      begin
        if(ready)
        begin
          s0_addr <= s0_addr + 9'd1;
          if (s0_addr==s0_addr_last)
            s0_last <= 1'b1;
          if (s0_last)
            s0_valid <= 1'b0;
        end
      end
    end
  end

  assign valid  = s0_valid;
  assign addr   = s0_addr;  
  assign last   = s0_last;

endmodule
`default_nettype wire
