/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_depunct
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,

  /* symbol parameters */
  input  wire  [1:0] cr,
  
  /* control */
  input  wire        enable,

  /* punctured bit stream */
  output wire  [3:0] esi_ready,
  input  wire  [4:0] esi_sb0,
  input  wire  [4:0] esi_sb1,
  input  wire  [4:0] esi_sb2,
  input  wire  [4:0] esi_sb3,
  input  wire  [4:0] esi_sb4,
  input  wire  [4:0] esi_sb5,
  input  wire  [4:0] esi_sb6,
  input  wire  [4:0] esi_sb7,
  input  wire  [3:0] esi_valid,
  
  /* depunctured bit stream */
  input  wire  [3:0] eso_ready,
  output wire  [4:0] eso_sb0,
  output wire  [4:0] eso_sb1,
  output wire  [4:0] eso_sb2,
  output wire  [4:0] eso_sb3,
  output wire  [4:0] eso_sb4,
  output wire  [4:0] eso_sb5,
  output wire  [4:0] eso_sb6,
  output wire  [4:0] eso_sb7,
  output wire  [3:0] eso_valid
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* design constants */
  localparam CR_12=2'd0,
             CR_23=2'd1,
             CR_34=2'd2,
             CR_56=2'd3;  

  wire   [ 4: 0]  fifo_free;
  wire   [ 3: 0]  fifo_avail;
  wire   [55: 0]  fifo_avail_mask_sh1,fifo_avail_mask_sh2,fifo_avail_mask_sh3,fifo_avail_mask_sh4;
  wire   [55: 0]  odm;
  wire   [ 3: 0]  fifo_wrlen;
  wire   [39: 0]  fifo_in;
  wire   [ 3: 0]  fifo_in_shsel;
  wire   [79: 0]  fifo_in_sh1,fifo_in_sh2,fifo_in_sh3,fifo_in_sh4;
  wire   [ 3: 0]  fifo_rdlen;
  wire   [79: 0]  fifo_out_sh1,fifo_out_sh2,fifo_out_sh3,fifo_out_sh4;
  wire   [ 4: 0]  n_fifo_count;
  reg    [ 4: 0]  fifo_count;
  wire   [79: 0]  n_fifo;
  reg    [79: 0]  fifo;
  wire   [ 4: 0]  ptr_plus_wrlen;
  reg    [ 3: 0]  n_ptr;
  reg    [ 3: 0]  ptr;     
  
  /*****************************************************************************
  * depuncturing pattern
  *****************************************************************************/
  /* 
    [  6] available
    [  5] valid from input
    [4:0] SB valuse
  */
  reg  [6:0] d0,d1,d2,d3,d4,d5,d6,d7;
  reg  [6:0] o0,o1,o2,o3,o4,o5,o6,o7;
  reg  [6:0] n0,n1,n2,n3,n4,n5,n6,na;
  
  
  always @(*)
  begin
  
    /* data */
    d0[ 4: 0] = esi_sb0; d0[6]     = 1'b1;  
    d1[ 4: 0] = esi_sb1; d1[6]     = 1'b1;  
    d2[ 4: 0] = esi_sb2; d2[6]     = 1'b1;  
    d3[ 4: 0] = esi_sb3; d3[6]     = 1'b1;  
    d4[ 4: 0] = esi_sb4; d4[6]     = 1'b1;  
    d5[ 4: 0] = esi_sb5; d5[6]     = 1'b1;  
    d6[ 4: 0] = esi_sb6; d6[6]     = 1'b1;  
    d7[ 4: 0] = esi_sb7; d7[6]     = 1'b1;
   
    /* valid out */
    case(esi_valid)
      4'd0:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00000000;
      4'd1:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00000001;
      4'd2:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00000011;
      4'd3:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00000111;
      4'd4:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00001111;
      4'd5:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00011111;
      4'd6:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b00111111;
      4'd7:    {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b01111111;
      default: {d7[5],d6[5],d5[5],d4[5],d3[5],d2[5],d1[5],d0[5]} = 8'b11111111;
    endcase
   
    /* neutral with validity of the preceding sb */
    n0  = {1'b0,d0[5],5'b0}; 
    n1  = {1'b0,d1[5],5'b0}; 
    n2  = {1'b0,d2[5],5'b0}; 
    n3  = {1'b0,d3[5],5'b0}; 
    n4  = {1'b0,d4[5],5'b0}; 
    n5  = {1'b0,d5[5],5'b0}; 
    n6  = {1'b0,d6[5],5'b0}; 
    na  = {1'b0, 1'b1,5'b0};
      
    case(cr)
      CR_12:       
      begin 
        { o7, o6, o5, o4, o3, o2, o1, o0} = {   d7,   d6,   d5,   d4,   d3,   d2,   d1,   d0};
        n_ptr = 4'd0;
      end
      CR_34:
      begin
        case(ptr)
          4'd0:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   d3,   n2,   n2,   d2,   d1,   d0};
          4'd1:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   d3,   d2,   n1,   n1,   d1,   d0};
          4'd2:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n4,   d4,   d3,   d2,   d1,   n0,   n0,   d0};
          4'd3:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n3,   n3,   d3,   d2,   d1,   d0,   na,   na};
          4'd4:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d4,   n3,   n3,   d3,   d2,   d1,   d0,   na};
          default: { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   n3,   n3,   d3,   d2,   d1,   d0};
        endcase
      
        case(ptr_plus_wrlen)
          5'd0,5'd6,5'd12:  n_ptr = 4'd0;
          5'd1,5'd7,5'd13:  n_ptr = 4'd1;
          5'd2,5'd8:        n_ptr = 4'd2;
          5'd3,5'd9:        n_ptr = 4'd3;
          5'd4,5'd10:       n_ptr = 4'd4;
          default:          n_ptr = 4'd5;
        endcase
      end
      CR_23:
      begin
        case(ptr)
          4'd0:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n5,   d5,   d4,   d3,   n2,   d2,   d1,   d0};
          4'd1:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   n4,   d4,   d3,   d2,   n1,   d1,   d0};
          4'd2:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   n3,   d3,   d2,   d1,   n0,   d0};
          default: { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   d3,   n2,   d2,   d1,   d0,   na};
        endcase
        
        case(ptr_plus_wrlen)
          5'd0,5'd4,5'd8:        n_ptr = 4'd0;
          5'd1,5'd5,5'd9:        n_ptr = 4'd1;
          5'd2,5'd6,5'd10:       n_ptr = 4'd2;
          default:               n_ptr = 4'd3;
        endcase
      end
      default: /* CR_56 */
      begin
        case(ptr)
          4'd0:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n4,   d4,   d3,   n2,   n2,   d2,   d1,   d0};
          4'd1:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n3,   n3,   d3,   d2,   n1,   n1,   d1,   d0};
          4'd2:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d3,   n2,   n2,   d2,   d1,   n0,   n0,   d0};
          4'd3:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d3,   d2,   n1,   n1,   d1,   d0,   na,   na};
          4'd4:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d4,   d3,   d2,   n1,   n1,   d1,   d0,   na};
          4'd5:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   d3,   d2,   n1,   n1,   d1,   d0};
          4'd6:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n4,   d4,   d3,   d2,   d1,   n0,   n0,   d0};
          4'd7:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   n3,   n3,   d3,   d2,   d1,   d0,   na,   na};
          4'd8:    { o7, o6, o5, o4, o3, o2, o1, o0} = {   d4,   n3,   n3,   d3,   d2,   d1,   d0,   na};
          default: { o7, o6, o5, o4, o3, o2, o1, o0} = {   d5,   d4,   n3,   n3,   d3,   d2,   d1,   d0};
        endcase
        
        case(ptr_plus_wrlen)
          5'd0,5'd10:  n_ptr = 4'd0;
          5'd1,5'd11:  n_ptr = 4'd1;
          5'd2,5'd12:  n_ptr = 4'd2;
          5'd3,5'd13:  n_ptr = 4'd3;
          5'd4,5'd14:  n_ptr = 4'd4;
          5'd5,5'd15:  n_ptr = 4'd5;
          5'd6,5'd16:  n_ptr = 4'd6;
          5'd7,5'd17:  n_ptr = 4'd7;
          5'd8:        n_ptr = 4'd8;
          default:     n_ptr = 4'd9;
        endcase
      end
    endcase
  end
  
  /*****************************************************************************
  * fifo 16 sb
  *****************************************************************************/
  /* fifo free entries */
  assign fifo_free           = 5'd16 - fifo_count;
  assign fifo_avail          = (fifo_free>5'd8)?4'd8:fifo_free[3:0];
  
  /* mask input according fifo entries availability */
  assign fifo_avail_mask_sh1 =  fifo_avail[0]?{49'b0                    ,{ 7{1'b1}}}:56'b0;
  assign fifo_avail_mask_sh2 =  fifo_avail[1]?{fifo_avail_mask_sh1[41:0],{14{1'b1}}}:fifo_avail_mask_sh1;
  assign fifo_avail_mask_sh3 =  fifo_avail[2]?{fifo_avail_mask_sh2[27:0],{28{1'b1}}}:fifo_avail_mask_sh2;
  assign fifo_avail_mask_sh4 =  fifo_avail[3]?{                          {56{1'b1}}}:fifo_avail_mask_sh3;
  
  assign odm                 = { o7, o6, o5, o4, o3, o2, o1, o0} & fifo_avail_mask_sh4;

   /* number of input sb than can be consummed from input  */
  assign esi_ready           = {3'b0,odm[55]}+{3'b0,odm[48]}+{3'b0,odm[41]}+{3'b0,odm[34]}+
                               {3'b0,odm[27]}+{3'b0,odm[20]}+{3'b0,odm[13]}+{3'b0,odm[ 6]};
  
  /* number of sb+neutral that can be pushed into the fifo */
  assign fifo_wrlen          = {3'b0,odm[54]}+{3'b0,odm[47]}+{3'b0,odm[40]}+{3'b0,odm[33]}+
                               {3'b0,odm[26]}+{3'b0,odm[19]}+{3'b0,odm[12]}+{3'b0,odm[ 5]};
  
  assign fifo_in             = {odm[53:49],odm[46:42],odm[39:35],odm[32:28],
                                odm[25:21],odm[18:14],odm[11: 7],odm[ 4: 0]};

  assign fifo_in_shsel       =  fifo_count[3:0] - fifo_rdlen;
  assign fifo_in_sh1         =  fifo_in_shsel[0]?{35'b0,       fifo_in, 5'b0}:{40'b0, fifo_in}; 
  assign fifo_in_sh2         =  fifo_in_shsel[1]?{   fifo_in_sh1[69:0],10'b0}:fifo_in_sh1; 
  assign fifo_in_sh3         =  fifo_in_shsel[2]?{   fifo_in_sh2[59:0],20'b0}:fifo_in_sh2; 
  assign fifo_in_sh4         =  fifo_in_shsel[3]?{   fifo_in_sh3[39:0],40'b0}:fifo_in_sh3; 

  assign fifo_rdlen          = (eso_ready>eso_valid)?eso_valid:eso_ready;
  assign fifo_out_sh1        = fifo_rdlen[0]?{ 5'b0,         fifo[79: 5]}:fifo;
  assign fifo_out_sh2        = fifo_rdlen[1]?{10'b0, fifo_out_sh1[79:10]}:fifo_out_sh1;
  assign fifo_out_sh3        = fifo_rdlen[2]?{20'b0, fifo_out_sh2[79:20]}:fifo_out_sh2;
  assign fifo_out_sh4        = fifo_rdlen[3]?{40'b0, fifo_out_sh3[79:40]}:fifo_out_sh3;

  /* fifo next state */
  assign n_fifo_count        = fifo_count + {1'b0,fifo_wrlen} - {1'b0,fifo_rdlen};
  assign n_fifo              = fifo_in_sh4 | fifo_out_sh4;

  /* depuncturing pointer next_state */
  assign ptr_plus_wrlen      = {1'b0,ptr} + {1'b0,fifo_wrlen}; 
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fifo       <= 80'b0;
      fifo_count <= 5'd0;
      ptr        <= 4'd0;
    end
    else if(!enable)
    begin
      fifo       <= 80'b0;
      fifo_count <= 5'd0;
      ptr        <= 4'd0;
    end
    else
    begin
      fifo       <= n_fifo;
      fifo_count <= n_fifo_count;
      ptr        <= n_ptr;
    end
  end

  /*****************************************************************************
  *
  *****************************************************************************/
  assign eso_valid    = (fifo_count>5'd8)?4'd8:fifo_count[3:0];
 
  assign {eso_sb7,eso_sb6,eso_sb5,eso_sb4,eso_sb3,eso_sb2,eso_sb1,eso_sb0} = fifo[39:0];

  wire [4:0] fifo_15,fifo_14,fifo_13,fifo_12,fifo_11,fifo_10,fifo_9,fifo_8;
  assign {fifo_15,fifo_14,fifo_13,fifo_12,fifo_11,fifo_10,fifo_9,fifo_8} = fifo[79:40];


endmodule
`default_nettype wire
