/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_field
(
  /* system */
  input  wire        rst_n,
  input  wire        clk,
  
  /* control */
  input  wire        enable,

  /* field parameters */
  input  wire        start,
  input  wire        nes,
  input  wire [23:0] length,      // see note (1) (2)
  input  wire        stfix,
  output reg         busy,
  
  /* input depunctured stream */
  output wire  [3:0] esi_ready,
  input  wire  [4:0] esi_sb0,
  input  wire  [4:0] esi_sb1,
  input  wire  [4:0] esi_sb2,
  input  wire  [4:0] esi_sb3,
  input  wire  [4:0] esi_sb4,
  input  wire  [4:0] esi_sb5,
  input  wire  [4:0] esi_sb6,
  input  wire  [4:0] esi_sb7,
  input  wire  [3:0] esi_valid,
  
  /* field stream */
  input  wire  [3:0] eso_ready,
  output wire  [4:0] eso_sb0,
  output wire  [4:0] eso_sb1,
  output wire  [4:0] eso_sb2,
  output wire  [4:0] eso_sb3,
  output wire  [4:0] eso_sb4,
  output wire  [4:0] eso_sb5,
  output wire  [4:0] eso_sb6,
  output wire  [4:0] eso_sb7,
  output wire  [1:0] eso_last,
  output wire  [3:0] eso_valid
);  
  /*****************************************************************************
  * note 1) o 'length' parameter is the field length in bits before bit parsing. 
  *         o 'add_service_tail' indicates that 'length' does not include service
  *            and tail lengths.
  *
  * note 2) the module can be started before that the length parameter is known.
  *         in this case, module is started with length=0 add_service_tail=0, 
  *         and then updated before the last sb enters the module.
  *****************************************************************************/
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg          boundary_fix;
  reg          boundary_fix_done;
  wire [ 4:0]  fifo_free;
  wire [ 3:0]  fifo_avail;
  wire [ 3:0]  fifo_wrlen;
  wire [ 3:0]  fifo_rdlen;
  
  wire [39:0]  esi;   
  wire [39:0]  fifo_mask_sh1,fifo_mask_sh2,fifo_mask_sh3,fifo_mask_sh4;   
  
  wire [47:0]  fifo_in;
  wire [ 4:0]  fifo_in_shsel;
  wire [95:0]  fifo_in_sh1,fifo_in_sh2,fifo_in_sh3,fifo_in_sh4,fifo_in_sh5;
  wire [95:0]  fifo_out_sh3,fifo_out_sh4;
  
  wire [ 95:0] n_fifo;
  reg  [ 95:0] fifo;
  wire [  4:0] n_fifo_count;
  reg  [  4:0] fifo_count;
  
  wire [ 24:0] n_count;
  reg  [ 24:0] count;
  wire [ 24:0] remaining;

  wire [ 23:0] length_fix;
  wire [ 24:0] length2;
  wire         length2_valid;
  
  /* fifo free entries */
  assign fifo_free           = 5'd16 - fifo_count;
  assign fifo_avail          = ((fifo_free>5'd8)?4'd8:fifo_free[3:0]) & {4{busy}};

  /* 'length'+'add_service_tail' is the field length before bit parsing,  */
  /* 'length2' is then the sb quantity that needs to enter the viterbi    */
   
  assign length_fix          = length + {19'b0,stfix,4'b0} ;                      /* add service if not included    */
 
  assign length2             = { (!nes)?{length_fix,1'b0}:{1'b0,length_fix} } +   /* divide per 2 if NES==2         */
                               {                    21'b0, {2{stfix}}, 2'b0 };    /* add 6 bit (12 vtb input) tail if not included */
  
  assign remaining           = length2 - count;
  
  assign length2_valid       = length2!=25'd0;
  
  assign esi_ready           = (remaining<={21'b0,fifo_avail} && length2_valid)?remaining[3:0]:fifo_avail;

  assign fifo_wrlen          = (esi_ready>esi_valid)?esi_valid:esi_ready; 
  assign fifo_rdlen          = (eso_ready>eso_valid)?eso_valid:eso_ready;
 
  /* detect postion of field last sb */
  reg [7:0] last;
  always @(*)
  begin
    last = 8'b0;
    if(length2_valid && remaining[24:4]==21'b0 && remaining[3:0]==fifo_wrlen)
    begin
      case(fifo_wrlen)
        4'd1:    last = 8'b00000001;
        4'd2:    last = 8'b00000010;
        4'd3:    last = 8'b00000100;
        4'd4:    last = 8'b00001000;
        4'd5:    last = 8'b00010000;
        4'd6:    last = 8'b00100000;
        4'd7:    last = 8'b01000000;
        4'd8:    last = 8'b10000000;
        default: last = 8'b00000000;
      endcase
    end
  end
  
  /* input mask */
  assign fifo_mask_sh1       = fifo_wrlen[0]?{               35'b0,{ 5{1'b1}}}:40'b0; 
  assign fifo_mask_sh2       = fifo_wrlen[1]?{ fifo_mask_sh1[29:0],{10{1'b1}}}:fifo_mask_sh1; 
  assign fifo_mask_sh3       = fifo_wrlen[2]?{ fifo_mask_sh2[19:0],{20{1'b1}}}:fifo_mask_sh2; 
  assign fifo_mask_sh4       = fifo_wrlen[3]?{                     {40{1'b1}}}:fifo_mask_sh3; 
 
  /* a fifo 6 bit fifo entry is {lastx,sbx} */ 
  assign esi                 = {esi_sb7,esi_sb6,esi_sb5,esi_sb4,esi_sb3,esi_sb2,esi_sb1,esi_sb0} & fifo_mask_sh4;
  
  assign fifo_in             = {last[7],esi[39:35],last[6],esi[34:30],last[5],esi[29:25],last[4],esi[24:20],
                                last[3],esi[19:15],last[2],esi[14:10],last[1],esi[ 9: 5],last[0],esi[ 4: 0]};
  
  /* push 0 to 8 sb at once */
  assign fifo_in_shsel       =  fifo_count - {1'b0,fifo_rdlen};
  assign fifo_in_sh1         =  fifo_in_shsel[0]?{42'b0,       fifo_in, 6'b0}:{48'b0,fifo_in}; 
  assign fifo_in_sh2         =  fifo_in_shsel[1]?{   fifo_in_sh1[83:0],12'b0}:fifo_in_sh1; 
  assign fifo_in_sh3         =  fifo_in_shsel[2]?{   fifo_in_sh2[71:0],24'b0}:fifo_in_sh2; 
  assign fifo_in_sh4         =  fifo_in_shsel[3]?{   fifo_in_sh3[47:0],48'b0}:fifo_in_sh3; 
  assign fifo_in_sh5         =  fifo_in_shsel[4]?                       96'b0:fifo_in_sh4; 

  /* pull 0,4 or 8 sb at once */
  assign fifo_out_sh3        = fifo_rdlen[2]?{24'b0,         fifo[95:24]}:fifo;
  assign fifo_out_sh4        = fifo_rdlen[3]?{48'b0, fifo_out_sh3[95:48]}:fifo_out_sh3;

  /* fifo next state */
  assign n_fifo_count        = fifo_count + {1'b0,fifo_wrlen} - {1'b0,fifo_rdlen} + {3'b0,boundary_fix,1'b0};
  assign n_fifo              = fifo_in_sh5 | fifo_out_sh4;
  
  assign n_count             = count + {21'b0,fifo_wrlen};
  
  always @(posedge clk, negedge rst_n)
  begin
    if(!rst_n)
    begin
      fifo              <= 96'b0;
      fifo_count        <= 5'd0;
      busy              <= 1'b0;
      count             <= 25'd0;
      boundary_fix      <= 1'b0;
      boundary_fix_done <= 1'b0;
    end
    else if(!enable)
    begin
      fifo              <= 96'b0;
      fifo_count        <= 5'd0;
      busy              <= 1'b0;
      count             <= 25'd0;
      boundary_fix      <= 1'b0;
      boundary_fix_done <= 1'b0;
    end
    else
    begin
      fifo         <= n_fifo;
      fifo_count   <= n_fifo_count;
      count        <= n_count;
      boundary_fix <= 1'b0;
      if(!busy)
      begin
        if(start)
        begin
          boundary_fix_done <= 1'b0;
          count             <= 25'd0;
          busy              <= 1'b1;
        end
      end
      else
      begin
        if(remaining==25'd0 && length2_valid)
        begin
          if(!boundary_fix_done && length2[1])
          begin
            boundary_fix_done <= 1'b1;
            boundary_fix      <= 1'b1;
          end
        
          if(fifo_count==5'd0)
            busy <= 1'b0;
        end
        
      end
    end
  end

  /*****************************************************************************
  * output slot
  *****************************************************************************/
  wire       last_7,last_6,last_5,last_4,last_3,last_2,last_1,last_0;
  
  wire [1:0] eso_mask;
  
  assign {eso_mask,eso_valid} = (fifo_count>=5'd8)?{2'b11,4'd8}:
                                (fifo_count>=5'd4)?{2'b01,4'd4}:
                                                   {2'b00,4'd0};
 
  assign {last_0 , eso_sb0} = fifo[ 5: 0] & {6{eso_mask[0]}}; 
  assign {last_1 , eso_sb1} = fifo[11: 6] & {6{eso_mask[0]}}; 
  assign {last_2 , eso_sb2} = fifo[17:12] & {6{eso_mask[0]}}; 
  assign {last_3 , eso_sb3} = fifo[23:18] & {6{eso_mask[0]}}; 
  assign {last_4 , eso_sb4} = fifo[29:24] & {6{eso_mask[1]}}; 
  assign {last_5 , eso_sb5} = fifo[35:30] & {6{eso_mask[1]}}; 
  assign {last_6 , eso_sb6} = fifo[41:36] & {6{eso_mask[1]}}; 
  assign {last_7 , eso_sb7} = fifo[47:42] & {6{eso_mask[1]}}; 

  assign eso_last[0] = (last_3|last_2|last_1|last_0) & eso_mask[0];
  assign eso_last[1] = (last_7|last_6|last_5|last_4) & eso_mask[1];

  /*****************************************************************************
  *
  *****************************************************************************/
`ifdef RW_SIMU_ON
  always @(posedge clk)
  begin:b_assert
    if(eso_valid[1:0]==2'b01 || eso_valid[1:0]==2'b10 || eso_valid[1:0]==2'b11 )
    begin
      $write("error:%m: illegal value for eso_valid !\n");
      $write("simulation FAILURE\n");
      $stop();
    end

    if(eso_ready[1:0]==2'b01 || eso_ready[1:0]==2'b10 || eso_ready[1:0]==2'b11 )
    begin
      $write("error:%m: illegal value for eso_ready !\n");
      $write("simulation FAILURE\n");
      $stop();
    end

    if(busy && length2!='d0 && count > length2 )
    begin
      $write("error:%m: length parameter has been updated too late !\n");
      $write("simulation FAILURE\n");
      $stop();
    end
  
  end
`endif

endmodule
`default_nettype wire
