`default_nettype none
module rx_bd_ldpc
(
  /*****************************************************************************
  * regular domain
  *****************************************************************************/
  /* system */
  input  wire             ldpc_rst_n,
  input  wire             ldpc_clk,
  input  wire             ldpc_dec_clk,

  output wire             ldpc_dec_clken,

  /* config registers */
  input  wire [  5:0]     mdmcfg_ldpcdec_llrunity,
  
  /* parameters */
  input  wire             param_update,
  input  wire  [ 3:0]     param_format,
  input  wire  [ 2:0]     param_bandwidth,
  input  wire  [ 6:0]     param_mcs,
  input  wire  [ 1:0]     param_cr,
  input  wire  [ 2:0]     param_nbpsc,
  input  wire  [ 2:0]     param_nss,
  input  wire             param_stbc,
  input  wire  [ 2:0]     param_rulen,
  input  wire  [15:0]     param_nsym,
  input  wire  [15:0]     param_ncbps,
  input  wire  [11:0]     param_ncw,
  input  wire  [ 1:0]     param_lldpc,
  input  wire  [11:0]     param_nshrtq,
  input  wire  [11:0]     param_nshrtr,
  input  wire  [11:0]     param_npuncq,
  input  wire  [11:0]     param_npuncr,
  input  wire  [13:0]     param_nrepq,
  input  wire  [11:0]     param_nrepr,
  
  /* input soft-bit stream */
  output wire  [ 3:0]     in_ready,
  input  wire  [ 4:0]     in_sb0,
  input  wire  [ 4:0]     in_sb1,
  input  wire  [ 4:0]     in_sb2,
  input  wire  [ 4:0]     in_sb3,
  input  wire  [ 4:0]     in_sb4,
  input  wire  [ 4:0]     in_sb5,
  input  wire  [ 4:0]     in_sb6,
  input  wire  [ 4:0]     in_sb7,
  input  wire  [ 4:0]     in_sb8,
  input  wire  [ 4:0]     in_sb9,
  input  wire  [ 3:0]     in_valid,

  /* output byte stream */
  input  wire             out_ready,
  output wire  [ 7:0]     out_data,
  output wire             out_last,
  output wire             out_valid,
  
  /* Config data interface */
  output wire [`RW_LDPCCFGRAM_AWIDTH-1:0] ldec0_cfg_addr,
  output wire                             ldec0_cfg_addr_update,
  input  wire [28:0]                      ldec0_cfg_data,
  input  wire                             ldec0_cfg_data_update,
  
  /*  LDPC0 Memories */
  // Cr _s
  output wire [6:0]       ldpcrx0_cr_waddr,   
  output wire [6:0]       ldpcrx0_cr_raddr,   
  output wire [485:0]     ldpcrx0_cr_wdata,   
  output wire             ldpcrx0_cr_ren,     
  output wire             ldpcrx0_cr_wen,     
  input  wire [485:0]     ldpcrx0_cr_rdata,   
  // Vr _s
  output wire [4:0]       ldpcrx0_vr_waddr,   
  output wire [4:0]       ldpcrx0_vr_raddr,   
  output wire [647:0]     ldpcrx0_vr_wdata,   
  output wire             ldpcrx0_vr_ren,     
  output wire             ldpcrx0_vr_wen,     
  input  wire [647:0]     ldpcrx0_vr_rdata,   
  // VM _s
  output wire [4:0]       ldpcrx0_vmx_waddr,  
  output wire [4:0]       ldpcrx0_vmx_raddr,  
  output wire [647:0]     ldpcrx0_vmx_wdata,  
  output wire             ldpcrx0_vmx_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmx_wen,    
  input  wire [647:0]     ldpcrx0_vmx_rdata,  

  output wire [4:0]       ldpcrx0_vmy_waddr,  
  output wire [4:0]       ldpcrx0_vmy_raddr,  
  output wire [647:0]     ldpcrx0_vmy_wdata,  
  output wire             ldpcrx0_vmy_ren,    
  output wire [`RW_NX_DERIV_LDPC_VMWE_WIDTH-1:0] ldpcrx0_vmy_wen,
  input  wire [647:0]     ldpcrx0_vmy_rdata,  
  // HD _s
  output wire [4:0]       ldpcrx0_hd_waddr,   
  output wire [80:0]      ldpcrx0_hd_wdata,   

  output wire [4:0]       ldpcrx0_hdx_raddr,  
  input  wire [80:0]      ldpcrx0_hdx_rdata,  
  output wire             ldpcrx0_hdx_ren,    
  output wire             ldpcrx0_hdx_wen,    
  
  output wire [4:0]       ldpcrx0_hdy_raddr,  
  output wire             ldpcrx0_hdy_wen,  
  output wire             ldpcrx0_hdy_ren,    
  input  wire [80:0]      ldpcrx0_hdy_rdata,

  /* debug ports */
  output wire  [15:0]     dbg0,
  output wire  [15:0]     dbg1,
  output wire  [15:0]     dbg2,
  output wire  [15:0]     dbg3,
  output wire  [15:0]     dbg4,
  output wire  [15:0]     dbg5,
  output wire  [15:0]     dbg6,
  output wire  [15:0]     dbg7,
  output wire  [15:0]     dbg8,
  output wire  [15:0]     dbg9,
  output wire  [15:0]     dbg10
);

  /*****************************************************************************
  * LDPC - no VHT, no STBC, 20 or 40 MHz HE register sizes
  *****************************************************************************/
  localparam NBPSC_1  = 3'd0,
             NBPSC_2  = 3'd1,
             NBPSC_4  = 3'd2,
             NBPSC_6  = 3'd3,
             NBPSC_8  = 3'd4,
             NBPSC_10 = 3'd5;


  wire [31:0] dbgCfg, dbgCtrl;
  wire [15:0] dbgIter, dbgIp;
`ifdef RW_NX_DERIV_CHBW20ONLY
  wire [ 8:0] blkErrs;
`endif // RW_NX_DERIV_CHBW20ONLY
`ifdef RW_NX_DERIV_CHBW4020ONLY
  wire [ 9:0] blkErrs;
`endif // RW_NX_DERIV_CHBW4020ONLY
`ifdef RW_NX_DERIV_CHBW804020ONLY
  wire [10:0] blkErrs;
`endif // RW_NX_DERIV_CHBW804020ONLY

 
  wire [21:0] logic0;
  wire        ldec0_enable;
  wire [ 1:0] ldec0_nsym;
  wire        ldec0_in_ready;
  wire        ldec0_in_valid;
  wire [ 3:0] ldec0_in_len;
  wire [49:0] ldec0_in_data;
  wire [ 3:0] ldec0_op_bit_en;
  wire        ldec0_decodeComplete;
  wire        ldec0_packetOpComplete;
  wire        ldec0_decodeStatus;
  wire        ldec0_packetComplete;
  wire        ldec0_packetStatus;
  wire        ldec0_ip_loaded;
  wire        ldec0_op_done;

  assign logic0 = 22'd0;
  
  /* fix soft-bit encoding */
  reg [3:0] dec_nbpsc;
  always @(*)
  begin
    case(param_nbpsc)
      NBPSC_1: dec_nbpsc = 4'd1;
      NBPSC_2: dec_nbpsc = 4'd2;
      NBPSC_4: dec_nbpsc = 4'd4;
      NBPSC_6: dec_nbpsc = 4'd6;
      NBPSC_8: dec_nbpsc = 4'd8;
      default: dec_nbpsc = 4'd10;
    endcase
  end
  
  assign ldec0_enable     = param_update;
  
  wire [4:0]  in_fix_sb9,in_fix_sb8,in_fix_sb7,in_fix_sb6,in_fix_sb5;
  wire [4:0]  in_fix_sb4,in_fix_sb3,in_fix_sb2,in_fix_sb1,in_fix_sb0;
  
  assign in_fix_sb9 = ~in_sb9+5'd1;
  assign in_fix_sb8 = ~in_sb8+5'd1;
  assign in_fix_sb7 = ~in_sb7+5'd1;
  assign in_fix_sb6 = ~in_sb6+5'd1;
  assign in_fix_sb5 = ~in_sb5+5'd1;
  assign in_fix_sb4 = ~in_sb4+5'd1;
  assign in_fix_sb3 = ~in_sb3+5'd1;
  assign in_fix_sb2 = ~in_sb2+5'd1;
  assign in_fix_sb1 = ~in_sb1+5'd1;
  assign in_fix_sb0 = ~in_sb0+5'd1;

  assign ldec0_in_data    = {in_fix_sb9,in_fix_sb8,in_fix_sb7,in_fix_sb6,in_fix_sb5,
                             in_fix_sb4,in_fix_sb3,in_fix_sb2,in_fix_sb1,in_fix_sb0};
  
  assign ldec0_in_len   = dec_nbpsc;
  assign in_ready       = (ldec0_in_ready && in_valid>=dec_nbpsc)?dec_nbpsc:4'd0;
  assign ldec0_in_valid = in_ready!=4'd0 && in_valid!=4'd0;   
  
  
  assign out_last       = ldec0_packetOpComplete;
  
  // LDPC controls
  assign ldec0_nsym  = (param_nsym>15'd3) ? 2'd3 : param_nsym[1:0];
  
  wire frame_is_he;
  assign frame_is_he = param_format>=4'd5;
  
  wire frame_is_ac;
  assign frame_is_ac = param_format==4'd4;

  wire [16:0] stbc_ncbps;
  assign stbc_ncbps  = param_stbc ? {param_ncbps,1'b0}:{1'b0,param_ncbps};

  ldpcDecCoreWrap 
  #(
    .NUM_USERS               (1)
  ) 
  u_ldpcDecCoreWrap0 
  (
    .nReset                  (ldpc_rst_n),
    //-----------------------------------------
    // Clocking
    //-----------------------------------------
    .FreeClk                 (ldpc_clk),
    .DecClk                  (ldpc_dec_clk),
    .DecClkEn                (ldpc_dec_clken),
    //-----------------------------------------
    // User control (not used)
    //-----------------------------------------
    .inUser                  (logic0[4:0]),
    .opUser                  (),
    //-----------------------------------------
    // Data flow
    //-----------------------------------------
    // Encoded stream
    .inDataWord              (ldec0_in_data),
    .inStrobe                (ldec0_in_valid),
    .ipWidth                 (ldec0_in_len),
    .rdyToRcvOut             (ldec0_in_ready),

    // packet split between decoders control
    .ipSkipBlock             (logic0[0]),
    .ipLoaded                (ldec0_ip_loaded),
    .numIpBits               (/* not connected */),
    .numIpBitsValid          (/* not connected */),
    .opDoneOut               (ldec0_op_done),
    
    // Downstream hardware
    .opDataWordOut           (out_data),
    .opStrobeOut             (out_valid),
    .clrToSend               (out_ready),
    .opByteEnOut             (),
    .opBitEnOut              (ldec0_op_bit_en),                           
    .decodeCompleteOut       (ldec0_decodeComplete),
    .decodeStatusOut         (ldec0_decodeStatus),
    .packetCompleteOut       (ldec0_packetComplete),
    .packetOpCompleteOut     (ldec0_packetOpComplete),
    .packetStatusOut         (ldec0_packetStatus),
    //-----------------------------------------
    // Controls
    //-----------------------------------------
    .enable                  (ldec0_enable),
    .enableIp                (ldec0_enable), 
    .rEnum                   (param_cr),                  // Coding rate: 0-1-2-3  means 1/2-2/3-3/4-5/6
`ifdef RW_NX_DERIV_CHBW20ONLY
    .bitsPerSymbol           (stbc_ncbps[12:0]),     // mSTBC*nCbps
    .RegNcw                  (param_ncw[8:0]),       // Number of LDPC code blocks in the packet
    .shrtMod                 (param_nshrtr[8:0]),
    .puncMod                 (param_npuncr[8:0]),
    .nRepFloor               (param_nrepq[12:0]),
    .repMod                  (param_nrepr[8:0]),
`endif // RW_NX_DERIV_CHBW20ONLY
`ifdef RW_NX_DERIV_CHBW4020ONLY
    .bitsPerSymbol           (stbc_ncbps[13:0]),     // mSTBC*nCbps
    .RegNcw                  (param_ncw[9:0]),       // Number of LDPC code blocks in the packet
    .shrtMod                 (param_nshrtr[9:0]),
    .puncMod                 (param_npuncr[9:0]),
    .nRepFloor               (param_nrepq[13:0]),
    .repMod                  (param_nrepr[9:0]),
`endif // RW_NX_DERIV_CHBW4020ONLY
`ifdef RW_NX_DERIV_CHBW804020ONLY
    .bitsPerSymbol           (stbc_ncbps[14:0]),     // mSTBC*nCbps
    .RegNcw                  (param_ncw[10:0]),       // Number of LDPC code blocks in the packet
    .shrtMod                 (param_nshrtr[10:0]),
    .puncMod                 (param_npuncr[10:0]),
    .nRepFloor               ({1'b0,param_nrepq[13:0]}), // $todo : must be enlarged to 15-bit   TBD !!!!!!!
    .repMod                  (param_nrepr[10:0]),
`endif // RW_NX_DERIV_CHBW804020ONLY
    .zEnum                   (param_lldpc),          // LDPC code size: 0-1-2 means 648-1296-1944
    .nShrtFloor              (param_nshrtq[10:0]),
    .nPuncFloor              (param_npuncq[9:0]),
    
    .nssLess1                (param_nss[1:0]),
    .stbc                    (param_stbc),     
    .qamEnum                 (param_nbpsc),            // Modulation: 0-1-2-3-4 means BPSK-QPSK-16QAM-64QAM-256QAM. 
    .ac                      (frame_is_ac),            // 0-1 means 11n-11ac      
    .he                      (frame_is_he),
    .bw                      (param_bandwidth[1:0]), // 0-1-2-3 means 20-40-80-160 MHz
    .mcs                     (param_mcs),
    .nSym                    (ldec0_nsym),             // Number of OFDM symbols in the packet, clipped to 3      
    .RuType                  (param_rulen),

    .llrUnity                (mdmcfg_ldpcdec_llrunity),
    //-----------------------------------------
    // Registers
    //-----------------------------------------
    .iterationAbort          (logic0[0]),              // Rely on iteration calculations and reset from MAC
    .enLostTime              (logic0[0]),
    .beatTimeLine            (logic0[0]),
    .packetBytesLs           (logic0[15:0]),
`ifdef RW_NX_DERIV_CHBW20ONLY
    .packetBytesMs           (logic0[0]),
    .frameEndByteMs          (logic0[1:0]),
`endif // RW_NX_DERIV_CHBW20ONLY
`ifdef RW_NX_DERIV_CHBW4020ONLY
    .packetBytesMs           (logic0[1:0]),
    .frameEndByteMs          (logic0[2:0]),
`endif // RW_NX_DERIV_CHBW4020ONLY
`ifdef RW_NX_DERIV_CHBW804020ONLY
    .packetBytesMs           (logic0[2:0]),
    .frameEndByteMs          (logic0[3:0]),
`endif // RW_NX_DERIV_CHBW804020ONLY
    .frameEndByteLs          (logic0[15:0]),           // No frame abort inside an aggregated packet
    //-----------------------------------------
    // Config Data interface
    //-----------------------------------------
    .CfgAddr                 (ldec0_cfg_addr),
    .CfgAddrUpdate           (ldec0_cfg_addr_update),
    .CfgData                 (ldec0_cfg_data),
    .CfgDataUpdate           (ldec0_cfg_data_update),

    //-----------------------------------------
    // I/O busses to RAMS 
    //-----------------------------------------
    .crRamAddrA              (ldpcrx0_cr_waddr),
    .crRamAddrB              (ldpcrx0_cr_raddr),
    .crRamWrData             (ldpcrx0_cr_wdata),
    .crRamEn                 (ldpcrx0_cr_ren),
    .crRamWr                 (ldpcrx0_cr_wen),
    .crRamRdData             (ldpcrx0_cr_rdata),

    .vrRamAddrA              (ldpcrx0_vr_waddr),
    .vrRamAddrB              (ldpcrx0_vr_raddr),
    .vrRamWrData             (ldpcrx0_vr_wdata),
    .vrRamEn                 (ldpcrx0_vr_ren),
    .vrRamWr                 (ldpcrx0_vr_wen),
    .vrRamRdData             (ldpcrx0_vr_rdata),

    .vmRamEnAX               (ldpcrx0_vmx_ren),
    .vmRamAddrAX             (ldpcrx0_vmx_raddr),
    .vmRamRdDataX            (ldpcrx0_vmx_rdata),
    .vmRamAddrBX             (ldpcrx0_vmx_waddr),
    .vmRamWrDataX            (ldpcrx0_vmx_wdata),
    .vmRamWriteX             (ldpcrx0_vmx_wen),

    .vmRamEnAY               (ldpcrx0_vmy_ren),
    .vmRamAddrAY             (ldpcrx0_vmy_raddr),
    .vmRamRdDataY            (ldpcrx0_vmy_rdata),
    .vmRamAddrBY             (ldpcrx0_vmy_waddr),
    .vmRamWrDataY            (ldpcrx0_vmy_wdata),
    .vmRamWriteY             (ldpcrx0_vmy_wen),

    .hdRamAddrB              (ldpcrx0_hd_waddr),
    .hdRamWrData             (ldpcrx0_hd_wdata),

    .hdRamEnAX               (ldpcrx0_hdx_ren),
    .hdRamAddrAX             (ldpcrx0_hdx_raddr),
    .hdRamRdDataX            (ldpcrx0_hdx_rdata),
    .hdRamWriteX             (ldpcrx0_hdx_wen),

    .hdRamEnAY               (ldpcrx0_hdy_ren),
    .hdRamAddrAY             (ldpcrx0_hdy_raddr),
    .hdRamRdDataY            (ldpcrx0_hdy_rdata),
    .hdRamWriteY             (ldpcrx0_hdy_wen),
    //----------------------------
    //  Debug Port
    //----------------------------
    .dbgIter                 (dbgIter),
    .dbgIp                   (dbgIp),
    .dbgCfg                  (dbgCfg),
    .dbgCtrl                 (dbgCtrl),
    .blkErrs                 (blkErrs),
    .prevIterations          (),
    .prevParityErrs          (),
    .prevDecodeStatus        (),
    .curIteration            ()

  );

  /*****************************************************************************
  * assert
  *****************************************************************************/
`ifdef RW_SIMU_ON
  always @(posedge ldpc_clk, negedge ldpc_rst_n)
  begin:b_check_out_flow_control
    reg v_out_valid_1t;
    reg v_out_ready_1t;
    if(!ldpc_rst_n)
    begin
      v_out_valid_1t <= 1'b0;
      v_out_ready_1t <= 1'b0;
    end
    else
    begin
      v_out_valid_1t <= out_valid;
      v_out_ready_1t <= out_ready;
      if(v_out_valid_1t && !v_out_ready_1t && !out_valid)
      begin
        $write("error:%m: flow control violation , see case #10260 !\n");
        $stop();
      end
    end
  end
`endif

  /*****************************************************************************
  * Debug ports 
  *****************************************************************************/
  // LDPC control and data flow diag
  assign dbg0  = {ldec0_enable, in_valid, in_ready, 
                  out_valid, out_ready, out_last,
                  ldec0_packetComplete,3'b0};
                  
  // LDPC config diag
  assign dbg1[15:12]                     = {2'd0, param_cr};
  assign dbg1[11]                        = ldec0_cfg_addr_update;
  assign dbg1[10:`RW_LDPCCFGRAM_AWIDTH]  = {{11-`RW_LDPCCFGRAM_AWIDTH}{1'b0}};
  assign dbg1[`RW_LDPCCFGRAM_AWIDTH-1:0] = ldec0_cfg_addr; // max [8:0]
  // LDPC internal state diag
  assign dbg2  = dbgCfg[31:16];
  assign dbg3  = dbgCtrl[15:0];
  assign dbg4  = dbgCfg[15:0];
  
  assign dbg5  = {ldec0_enable,ldec0_packetOpComplete,ldec0_packetComplete,ldec0_packetStatus,
                  ldec0_decodeComplete,ldec0_decodeStatus,in_valid,in_ready,2'b0};
  assign dbg6  = dbgIter;
  assign dbg7  = {dbgCtrl[0], ldec0_op_done, dbgIp[13:0]};
  assign dbg8  = {dbgCtrl[0], ldec0_decodeStatus,
`ifdef RW_NX_DERIV_CHBW20ONLY
                          1'b0,
`endif // RW_NX_DERIV_CHBW20ONLY
                          4'b0, blkErrs};
  assign dbg9  = {2'b0, ldec0_nsym, param_ncw[11:0]};
  assign dbg10 = {4'd0, param_lldpc, param_npuncr[9:0]};

endmodule
`default_nettype wire
