`default_nettype wire
module rx_bd_ldpcout_resync
(
  /*****************************************************************************
  * ldpc domain
  *****************************************************************************/
  /* system */
  input wire              ldpc_clk,
  input wire              ldpc_rst_n,

  /* global enable */
  input wire              ldpc_global_enable,

  /* input stream */
  output wire             ldpc_ready,
  input  wire  [ 7:0]     ldpc_data,
  input  wire             ldpc_last,
  input  wire             ldpc_valid,

  /*****************************************************************************
  * regular domain
  *****************************************************************************/
  /* system */
  input wire              clk,
  input wire              rst_n,

  /* global enable */
  input wire              global_enable,

  /* input stream */
  input  wire             ready,
  output wire  [ 7:0]     data,
  output wire             last,
  output wire             valid
 
);

  async_fifo2
  #(
    .g_width(      32'd9),
    .g_log_depth(  32'd2)
  )
  u_async_fifo2
  (
    /* write domain  */
    .w_rst_n(        ldpc_rst_n),
    .w_clk(          ldpc_clk),
    
    .w_enable(       ldpc_global_enable),
    .w_ready(        ldpc_ready),
    .w_data(         {ldpc_last,ldpc_data}),
    .w_valid(        ldpc_valid),

    /* read domain  */
    .r_rst_n(        rst_n),
    .r_clk(          clk),
    
    .r_enable(       global_enable),
    .r_ready(        ready),
    .r_data(         {last,data}),
    .r_valid(        valid)
  );
endmodule
`default_nettype wire
