/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       : 
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
module Viterbi #(parameter    REGLENGTHG    = 120, // Length of trace back registes (2*TB)as 2  bits
                 parameter    DATAINWIDTHG  = 5
                )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire                                   ViterbiClk,
            input   wire                                   nHrdRst,
            input   wire                                   InitViterbi,
            input   wire                                   DataInValid,
            input   wire                                   FlushEop,
            input   wire   [7:0]                           CntrVtrbRd, // Indicates the index for  parallel reads
            input   wire   [(DATAINWIDTHG - 1) :0]         InputSoftMetrics0,
            input   wire   [(DATAINWIDTHG - 1) :0]         InputSoftMetrics1,
            input   wire   [(DATAINWIDTHG - 1) :0]         InputSoftMetrics2,
            input   wire   [(DATAINWIDTHG - 1) :0]         InputSoftMetrics3,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg   [1:0]        ViterbiOutput
            );


//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
  // Length of trace back register (2*TB)as 2  decoded bits enters every
  // stage of trellis.
  localparam    PATHLENGTHG   = 8; // Register size to store path metric  values

//-- constants
  localparam    CONSTRLENG    = 7; // Constraint length
  localparam    NUMOFSTATES   = 2**(CONSTRLENG-1); // No. of states, 64

// reset value of Path metric for other than 0 state
  localparam    RSTPATHMTRVAL =  8'b01100100;
  localparam    INVERSE       =  6'b011110; // Value 32-2
                                            //= 30 (2**(DATAINWIDTHG)) -2;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires, Registers & Var Declarations
//////////////////////////////////////////////////////////////////////////////
  // This is used for giving viterbi decoded data parallely from register0
  reg     [DATAINWIDTHG :0]    BranchMetricInt1[3:0];
  reg     [DATAINWIDTHG :0]    BranchMetricInt2[3:0];

  reg     [DATAINWIDTHG +1:0]  BranchMetric[15:0];

  reg     [PATHLENGTHG -1 :0]  PathMetrics[NUMOFSTATES -1:0];//Path metrics
  reg     [1:0]                PathSelectBitsReg[NUMOFSTATES -1:0];
  // Register to delay the DataInValid for proper registering of PathMetrics
  // Register exchange and valid data generation
  reg     [6:0]                DataInValidDly;

  // Registers for all states to store decoded bits corresponding to surviving
  //paths  each of size trace back length and

  reg   [REGLENGTHG -1 :0]    SurvivingPathsReg[NUMOFSTATES -1 :0];

  //  ----------- Adder stage registers for decoded bit generation
// 2nd adder stage reg
  reg   [2 :0]                Col1AddrStage2Reg [NUMOFSTATES/4 -1 :0];
  reg   [2 :0]                Col2AddrStage2Reg [NUMOFSTATES/4 -1 :0];
// 4th adder stage reg
  reg   [4 :0]                Col1AddrStage4Reg [NUMOFSTATES/16 -1 :0];
  reg   [4 :0]                Col2AddrStage4Reg [NUMOFSTATES/16 -1 :0];
// 6th adder stage reg
  reg   [6 :0]                Col1AddrStage6Reg [NUMOFSTATES/64 -1 :0];
  reg   [6 :0]                Col2AddrStage6Reg [NUMOFSTATES/64 -1 :0];

  //decoder parallel o/p when flush or end of packet  comes
  wire     [1 :0]  VtrbDataPrll;

  //decoder o/p when during normal operation
  //(2bits every time when valid in comes)
  wire                        VtrbDataNrml1; // Decoded data1(msb)
  wire                        VtrbDataNrml2; //Decoded data2

  //The adder stages required to do a majority decision decoding
  //when the Viterbi is not in flush mode
  wire    [1:0]               Col1AddrStage1 [NUMOFSTATES/2 -1 :0];
  wire    [1:0]               Col2AddrStage1 [NUMOFSTATES/2 -1 :0];
  wire    [2:0]               Col1AddrStage2 [NUMOFSTATES/4 -1 :0];
  wire    [2:0]               Col2AddrStage2 [NUMOFSTATES/4 -1 :0];
  wire    [3:0]               Col1AddrStage3 [NUMOFSTATES/8 -1 :0];
  wire    [3:0]               Col2AddrStage3 [NUMOFSTATES/8 -1 :0];
  wire    [4:0]               Col1AddrStage4 [NUMOFSTATES/16 -1 :0];
  wire    [4:0]               Col2AddrStage4 [NUMOFSTATES/16 -1 :0];
  wire    [5:0]               Col1AddrStage5 [NUMOFSTATES/32 -1 :0];
  wire    [5:0]               Col2AddrStage5 [NUMOFSTATES/32 -1 :0];
  wire    [6:0]               Col1AddrStage6 [NUMOFSTATES/64 -1 :0];
  wire    [6:0]               Col2AddrStage6 [NUMOFSTATES/64 -1 :0];

  // The following 4 tables store the encoded bits for various dibits
  wire    [3:0]               EncodedBits0 [NUMOFSTATES-1:0];
  wire    [3:0]               EncodedBits1 [NUMOFSTATES-1:0];
  wire    [3:0]               EncodedBits2 [NUMOFSTATES-1:0];
  wire    [3:0]               EncodedBits3 [NUMOFSTATES-1:0];

  //Variables to store the 256 Branch metrics
  wire    [DATAINWIDTHG+ 1:0] Bm0 [NUMOFSTATES-1:0];
  wire    [DATAINWIDTHG+ 1:0] Bm1 [NUMOFSTATES-1:0];
  wire    [DATAINWIDTHG+ 1:0] Bm2 [NUMOFSTATES-1:0];
  wire    [DATAINWIDTHG+ 1:0] Bm3 [NUMOFSTATES-1:0];

  //----- Incoming paths for index state 0  mod 4
  //(0, 4, 8, 12, 16.....60) :16states
  // Each state has 4 paths coming in from states i, i+16, i+32, &
  //i+48 where i is from 0-15.
  //* The following variables are in the format PathExtXY and PathXY where
  // X indicates the destination state index modulo
  // Y indicates the Source Node index as explained in the following
  // Y = 0 if Source node index lies between 0 and 15
  // Y = 1 if Source node index lies between 16 and 31
  // Y = 2 if Source node index lies between 32 and 47
  // Y = 3 if Source node index lies between 48 and 63

  wire     [PATHLENGTHG :0] PathExt00[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt01[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt02[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt03[NUMOFSTATES/4 -1:0];

  wire     [PATHLENGTHG -1 :0] Path00[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path01[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path02[NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path03[NUMOFSTATES/4 -1:0];

  //----- Incoming paths for index state 1 mod 4
  //(1, 5, 9, 13, 17.....61) :16states
  wire     [PATHLENGTHG :0] PathExt10 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt11 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt12 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt13 [NUMOFSTATES/4 -1:0];

  wire     [PATHLENGTHG -1 :0] Path10 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path11 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path12 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path13 [NUMOFSTATES/4 -1:0];

  //----- Incoming paths for index state 2 mod 4
  //(2, 6, 10, 14, 18.....62) :16states
  wire     [PATHLENGTHG :0] PathExt20 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt21 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt22 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt23 [NUMOFSTATES/4 -1:0];

  wire     [PATHLENGTHG -1 :0] Path20 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path21 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path22 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path23 [NUMOFSTATES/4 -1:0];

  //----- Incoming paths for index state 3 mod 4
  //(3, 7, 11, 15, 19.....63) :16states
  wire     [PATHLENGTHG :0] PathExt30 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt31 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt32 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG :0] PathExt33 [NUMOFSTATES/4 -1:0];

  wire     [PATHLENGTHG -1 :0] Path30 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path31 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path32 [NUMOFSTATES/4 -1:0];
  wire     [PATHLENGTHG -1 :0] Path33 [NUMOFSTATES/4 -1:0];
 //------------------------------------------------------------------------
 //--------------- Normalization logic

  wire     [NUMOFSTATES/2 -1:0] NormAndStage1;// 1st stage of and gates
  wire     [NUMOFSTATES/4 -1:0] NormAndStage2;// 2nd stage of and gates
  wire     [NUMOFSTATES/8 -1:0] NormAndStage3;// 3rd stage of and gates
  wire     [NUMOFSTATES/16 -1:0] NormAndStage4;// 4th stage of and gates
  wire     [NUMOFSTATES/32 -1:0] NormAndStage5;// 5th stage of and gates
  wire     [NUMOFSTATES/64 -1:0] NormAndStage6;// 6th stage of and gates

 //--------------- Min path metrics for all states  --------

  wire     [PATHLENGTHG -1 :0] MinPathMetrics[NUMOFSTATES -1:0];  // Minimum path

  // Normalized minimum path after cheking all MSB's of Path metric
  wire     [PATHLENGTHG -1 :0] NormMinPathMetrics[NUMOFSTATES -1:0];

 //--- These two bits for 64 states represent the selected path out of 4
 // incoming paths 

  wire     [1:0]               PathSelectBits[NUMOFSTATES -1:0];

  //--Comparison results for 4 input paths of states 4i (0 Mod 4)  0, 4, 8..60
  wire    [NUMOFSTATES/4 -1:0] SignPath00MinPath01;
  wire    [NUMOFSTATES/4 -1:0] SignPath00MinPath02;
  wire    [NUMOFSTATES/4 -1:0] SignPath00MinPath03;
  wire    [NUMOFSTATES/4 -1:0] SignPath01MinPath02;
  wire    [NUMOFSTATES/4 -1:0] SignPath01MinPath03;
  wire    [NUMOFSTATES/4 -1:0] SignPath02MinPath03;

  //--Comparison results for 4 input paths of states 4i+1(1 Mod 4)1,5,..61
  wire    [NUMOFSTATES/4 -1:0] SignPath10MinPath11;
  wire    [NUMOFSTATES/4 -1:0] SignPath10MinPath12;
  wire    [NUMOFSTATES/4 -1:0] SignPath10MinPath13;
  wire    [NUMOFSTATES/4 -1:0] SignPath11MinPath12;
  wire    [NUMOFSTATES/4 -1:0] SignPath11MinPath13;
  wire    [NUMOFSTATES/4 -1:0] SignPath12MinPath13;

  //--Comparison results for 4 input paths of states 4i+2(2 Mod 4)2,6,..62
  wire    [NUMOFSTATES/4 -1:0] SignPath20MinPath21;
  wire    [NUMOFSTATES/4 -1:0] SignPath20MinPath22;
  wire    [NUMOFSTATES/4 -1:0] SignPath20MinPath23;
  wire    [NUMOFSTATES/4 -1:0] SignPath21MinPath22;
  wire    [NUMOFSTATES/4 -1:0] SignPath21MinPath23;
  wire    [NUMOFSTATES/4 -1:0] SignPath22MinPath23;

  //--Comparison results for 4 input paths of states 4i+3 (3 Mod 4)3,7..63
  wire    [NUMOFSTATES/4 -1:0] SignPath30MinPath31;
  wire    [NUMOFSTATES/4 -1:0] SignPath30MinPath32;
  wire    [NUMOFSTATES/4 -1:0] SignPath30MinPath33;
  wire    [NUMOFSTATES/4 -1:0] SignPath31MinPath32;
  wire    [NUMOFSTATES/4 -1:0] SignPath31MinPath33;
  wire    [NUMOFSTATES/4 -1:0] SignPath32MinPath33;
 //-----------------For Survivor Path register updation----

  wire   [REGLENGTHG -1 :0]     SurvivingPathsAux [NUMOFSTATES -1 :0];

//--------- Generate variables  Declaration ----------------
  genvar   GenVar1 ;
  integer  Var1, Var2, Var3, Var4, Var5, Var6, Var7;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Delay valid signal to take care of registering and
// pipelining for Pathmetrics, Survivor Register updation
// and valid data out generation

always @(posedge ViterbiClk or negedge nHrdRst)
begin: pPathSelectRegBitSeq
  if(!nHrdRst)                                                                         
  begin                                                                                
   DataInValidDly      <=  {7{1'b0}};                                                  
   for(Var1=0; Var1<NUMOFSTATES; Var1= Var1+1)                                         
     PathSelectBitsReg[Var1]   <=  {2'b0}; // Register path select bits                
  end                                                                                  
  else                                                                                 
  begin                                                                                
    DataInValidDly[0]   <= DataInValid;                                                
    DataInValidDly[1]   <= DataInValidDly[0];                                          
    DataInValidDly[2]   <= DataInValidDly[1];                                          
    DataInValidDly[3]   <= DataInValidDly[2];                                          
    DataInValidDly[4]   <= DataInValidDly[3];                                          
    DataInValidDly[5]   <= DataInValidDly[4];                                          
    DataInValidDly[6]   <= DataInValidDly[5];                                          

    if(DataInValidDly[1])                                             
    begin                                                                              
      for(Var1=0; Var1<NUMOFSTATES; Var1= Var1+1)                                      
       PathSelectBitsReg[Var1]   <= PathSelectBits[Var1]; // Register path select bits 
    end                                                                                
    else                                                                               
    begin                                                                              
      for(Var1=0; Var1<NUMOFSTATES; Var1= Var1+1)                                      
       PathSelectBitsReg[Var1]   <= PathSelectBitsReg[Var1];                           
    end                                                                                
  end // else: !if(nHrdRst == 1'b0)                                                    
end // always:pPathSelectRegBitSeq

//-------------------------------------------------------------------
//-------***    Branch metric computation ***------------------------
//-------------------------------------------------------------------

// To run Viterbi at 180 Mhz this unit requires pipelining
// at each adder output stage and at the final adder o/p stage.

//---------------------------------------------

always @(posedge ViterbiClk or negedge nHrdRst)

begin :pBMUSeq
 if(!nHrdRst) begin
   for(Var2=0; Var2<4; Var2= Var2+1) begin
     BranchMetricInt1[Var2] <= {(DATAINWIDTHG+1){1'b0}};
     BranchMetricInt2[Var2] <= {(DATAINWIDTHG+1){1'b0}};
   end // for loop
   for(Var2=0; Var2<16; Var2= Var2+1) begin
     BranchMetric[Var2]     <= {(DATAINWIDTHG+2){1'b0}};
   end  // for loop
 end
 else begin
   if(DataInValid) 
   begin
     // Pipelined 1st adder stage for BM computation
     // For softinput0 and 1
     BranchMetricInt1[0] <=  {1'b0,InputSoftMetrics0} +
                                        {1'b0,InputSoftMetrics1};
     BranchMetricInt1[1] <=  {1'b0,InputSoftMetrics0} +
                                        (INVERSE - {1'b0, InputSoftMetrics1});
     BranchMetricInt1[2] <=  (INVERSE - {1'b0,InputSoftMetrics0}) +
                                        {1'b0,InputSoftMetrics1};
     BranchMetricInt1[3] <=  (INVERSE - {1'b0,InputSoftMetrics0}) +
                                        (INVERSE -{1'b0, InputSoftMetrics1});
     // For softinput2 and 3

     BranchMetricInt2[0] <=  {1'b0,InputSoftMetrics2}
                                          + {1'b0,InputSoftMetrics3} ;
     BranchMetricInt2[1] <=  {1'b0,InputSoftMetrics2}
                                          + (INVERSE - {1'b0,InputSoftMetrics3});
     BranchMetricInt2[2] <=  (INVERSE - {1'b0,InputSoftMetrics2})
                                          + {1'b0,InputSoftMetrics3};
     BranchMetricInt2[3] <=  (INVERSE - {1'b0,InputSoftMetrics2})
                                          + (INVERSE - {1'b0,InputSoftMetrics3});
   end // DataInValid

   // 16 Branch Metrics values (Registered) after adding pipelined 1st stage adder o/p
   if(DataInValidDly[0]) 
   begin
     BranchMetric[0]  <=  {1'b0,BranchMetricInt1[0]} + {1'b0,BranchMetricInt2[0]}  ;
     BranchMetric[1]  <=  {1'b0,BranchMetricInt1[0]} + {1'b0,BranchMetricInt2[1]}  ;
     BranchMetric[2]  <=  {1'b0,BranchMetricInt1[0]} + {1'b0,BranchMetricInt2[2]}  ;
     BranchMetric[3]  <=  {1'b0,BranchMetricInt1[0]} + {1'b0,BranchMetricInt2[3]}  ;
     BranchMetric[4]  <=  {1'b0,BranchMetricInt1[1]} + {1'b0,BranchMetricInt2[0]}  ;
     BranchMetric[5]  <=  {1'b0,BranchMetricInt1[1]} + {1'b0,BranchMetricInt2[1]}  ;
     BranchMetric[6]  <=  {1'b0,BranchMetricInt1[1]} + {1'b0,BranchMetricInt2[2]}  ;
     BranchMetric[7]  <=  {1'b0,BranchMetricInt1[1]} + {1'b0,BranchMetricInt2[3]}  ;
     BranchMetric[8]  <=  {1'b0,BranchMetricInt1[2]} + {1'b0,BranchMetricInt2[0]}  ;
     BranchMetric[9]  <=  {1'b0,BranchMetricInt1[2]} + {1'b0,BranchMetricInt2[1]}  ;
     BranchMetric[10] <=  {1'b0,BranchMetricInt1[2]} + {1'b0,BranchMetricInt2[2]}  ;
     BranchMetric[11] <=  {1'b0,BranchMetricInt1[2]} + {1'b0,BranchMetricInt2[3]}  ;
     BranchMetric[12] <=  {1'b0,BranchMetricInt1[3]} + {1'b0,BranchMetricInt2[0]}  ;
     BranchMetric[13] <=  {1'b0,BranchMetricInt1[3]} + {1'b0,BranchMetricInt2[1]}  ;
     BranchMetric[14] <=  {1'b0,BranchMetricInt1[3]} + {1'b0,BranchMetricInt2[2]}  ;
     BranchMetric[15] <=  {1'b0,BranchMetricInt1[3]} + {1'b0,BranchMetricInt2[3]}  ;
   end
 end 
end  


//-------------------------------------------------------------------
//-------         ***    ACS  computation ***------------------------
//-------------------------------------------------------------------

// Bm0,1,2,3 contains the branch metric values for the 4 paths coming
// out from each of the NUMOFSTATES (64) states

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES; GenVar1= GenVar1 + 1) begin:pBMCom
 // Branch metrics of 1st path coming out from all 64 atates
 assign  Bm0[GenVar1]    = BranchMetric[EncodedBits0[GenVar1]];
 // Branch metrics of 2nd path coming out from all 64 states
 assign  Bm1[GenVar1]    = BranchMetric[EncodedBits1[GenVar1]];
 // Branch metrics of 3rd path coming out from all 64 states
 assign  Bm2[GenVar1]    = BranchMetric[EncodedBits2[GenVar1]];
 // Branch metrics of 4th path coming out from all 64 states
 assign  Bm3[GenVar1]    = BranchMetric[EncodedBits3[GenVar1]];
end
endgenerate

// ---------------Path Metric calculation ----------------------
// Notation : The path metrics are named as PathXY where
// X indicates the Destination node index modulo 4
// Y indicates the Source Node index as explained in the following
// Y = 0 if Source node index lies between 0 and 15
// Y = 1 if Source node index lies between 16 and 31
// Y = 2 if Source node index lies between 32 and 47
// Y = 3 if Source node index lies between 48 and 63

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pPathMetricCom

 //--------- Incoming paths for states 0 mod 4 (0,4, 8,12--60)----

 // First incoming path from states i (0,1..15)
 assign PathExt00[GenVar1] = {1'b0, PathMetrics[GenVar1]} + {{{(PATHLENGTHG-DATAINWIDTHG-1)}{1'b0}}, Bm0[GenVar1]};
 // Second incoming path from states i+16 (16,17..31)
 assign PathExt01[GenVar1] = {1'b0, PathMetrics[GenVar1+NUMOFSTATES/4]} 
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-1)}{1'b0}}, Bm0[GenVar1+ NUMOFSTATES/4]};
 // Third incoming path from states i+32 (32,33,..47)
 assign PathExt02[GenVar1] = {1'b0, PathMetrics[GenVar1+NUMOFSTATES/2]}
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-1)}{1'b0}}, Bm0[GenVar1+ NUMOFSTATES/2]};
 // Fourth incoming path from states i+48(48,49..63)
 assign PathExt03[GenVar1] = {1'b0, PathMetrics[GenVar1+3*NUMOFSTATES/4]}
                                             + {{{(PATHLENGTHG-DATAINWIDTHG-1)}{1'b0}}, Bm0[GenVar1+ 3*NUMOFSTATES/4]};

 //---Path Metric values for Path0 (with overflow protection by saturation)

 // First incoming path from states i (0,1..15)
 assign Path00[GenVar1] =  (PathExt00[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt00[GenVar1][PATHLENGTHG -1 :0]};

 // Second incoming path from states i+16 (16,17..31)
 assign Path01[GenVar1] =  (PathExt01[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt01[GenVar1][PATHLENGTHG -1 :0]};

 // Third incoming path from states i+32 (32,33,..47) 
 assign Path02[GenVar1] =  (PathExt02[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt02[GenVar1][PATHLENGTHG -1 :0]};

 // Fourth incoming path from states i+48(48,49..63)
 assign Path03[GenVar1] =  (PathExt03[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt03[GenVar1][PATHLENGTHG -1 :0]};



 //--------- Incoming  paths for states 1 mod 4 (1,5,9...61)----
 // First incoming path from states i (0,1..15)
 assign PathExt10[GenVar1] =  PathMetrics[GenVar1] + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm1[GenVar1]};
 // Second incoming path from states i+16 (16,17..31)
 assign PathExt11[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm1[GenVar1+ NUMOFSTATES/4]};
 // Third incoming path from states i+32 (32,33,..47)
 assign PathExt12[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/2]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm1[GenVar1+ NUMOFSTATES/2]};
 // Fourth incoming path from states i+48(48,49..63)
 assign PathExt13[GenVar1] =  PathMetrics[GenVar1+3*NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm1[GenVar1+ 3*NUMOFSTATES/4]};


//---Path Metric values for Path1 (with overflow protection by saturation)
// First incoming path from states i (0,1..15)
 assign Path10[GenVar1] =  (PathExt10[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt10[GenVar1][PATHLENGTHG -1 :0]};

 // Second incoming path from states i+16 (16,17..31)
 assign Path11[GenVar1] =  (PathExt11[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt11[GenVar1][PATHLENGTHG -1 :0]};

 // Third incoming path from states i+32 (32,33,..47)
 assign Path12[GenVar1] =  (PathExt12[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt12[GenVar1][PATHLENGTHG -1 :0]};

 // Fourth incoming path from states i+48(48,49..63)
 assign Path13[GenVar1] =  (PathExt13[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt13[GenVar1][PATHLENGTHG -1 :0]};


 //--------- Incoming  paths for states 2 mod 4 (2,6,10...62)----

 // First incoming path from states i (0,1..15)
 assign PathExt20[GenVar1] =  PathMetrics[GenVar1] + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm2[GenVar1]};
 // Second incoming path from states i+16 (16,17..31)
 assign PathExt21[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm2[GenVar1+ NUMOFSTATES/4]};
 // Third incoming path from states i+32 (32,33,..47)
 assign PathExt22[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/2]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm2[GenVar1+ NUMOFSTATES/2]};
 // Fourth incoming path from states i+48(48,49..63)
 assign PathExt23[GenVar1] =  PathMetrics[GenVar1+3*NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm2[GenVar1+ 3*NUMOFSTATES/4]};

//---Path Metric values for Path1 (with overflow protection by saturation)
// First incoming path from states i (0,1..15)
 assign Path20[GenVar1] =  (PathExt20[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt20[GenVar1][PATHLENGTHG -1 :0]};

 // Second incoming path from states i+16 (16,17..31)
 assign Path21[GenVar1] =  (PathExt21[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt21[GenVar1][PATHLENGTHG -1 :0]};

 // Third incoming path from states i+32 (32,33,..47)
 assign Path22[GenVar1] =  (PathExt22[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt22[GenVar1][PATHLENGTHG -1 :0]};

 // Fourth incoming path from states i+48(48,49..63)
 assign Path23[GenVar1] =  (PathExt23[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt23[GenVar1][PATHLENGTHG -1 :0]};


 //--------- Incoming  paths for states 3 mod 4 (3,7,11..63)----

 // First incoming path from states i (0,1..15)
 assign PathExt30[GenVar1] =  PathMetrics[GenVar1] + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm3[GenVar1]};
 // Second incoming path from states i+16 (16,17..31)
 assign PathExt31[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm3[GenVar1+ NUMOFSTATES/4]};
 // Third incoming path from states i+32 (32,33,..47)
 assign PathExt32[GenVar1] =  PathMetrics[GenVar1+NUMOFSTATES/2]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm3[GenVar1+ NUMOFSTATES/2]};
 // Fourth incoming path from states i+48(48,49..63)
 assign PathExt33[GenVar1] =  PathMetrics[GenVar1+3*NUMOFSTATES/4]
                                            + {{{(PATHLENGTHG-DATAINWIDTHG-2)}{1'b0}}, Bm3[GenVar1+ 3*NUMOFSTATES/4]};

//---Path Metric values for Path1 (with overflow protection by saturation)
// First incoming path from states i (0,1..15)
 assign Path30[GenVar1] =  (PathExt30[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt30[GenVar1][PATHLENGTHG -1 :0]};

 // Second incoming path from states i+16 (16,17..31)
 assign Path31[GenVar1] =  (PathExt31[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt31[GenVar1][PATHLENGTHG -1 :0]};

 // Third incoming path from states i+32 (32,33,..47) 
 assign Path32[GenVar1] =  (PathExt32[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt32[GenVar1][PATHLENGTHG -1 :0]};

 // Fourth incoming path from states i+48(48,49..63)
 assign Path33[GenVar1] =  (PathExt33[GenVar1][PATHLENGTHG] == 1'b1) ?
                                 {(PATHLENGTHG){1'b1}}
                               : {PathExt33[GenVar1][PATHLENGTHG -1 :0]};

end
endgenerate
//----------------- path metrics calulation complete-----------------


//--------------- Path Selection ( Finding Minimum Path)---------------


 //-- Compare logic for 4 input paths comping to each of the 64 states
generate 
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pPathSelCom

 //-- Comparison results for 4 paths for each of the 16 states corresponding
//-- to 4i (0 Mod 4) ie. states 0, 4, 8, 12...60
 assign  SignPath00MinPath01[GenVar1] =(Path00[GenVar1] <= Path01[GenVar1]);
 assign  SignPath00MinPath02[GenVar1] =(Path00[GenVar1] <= Path02[GenVar1]);
 assign  SignPath00MinPath03[GenVar1] =(Path00[GenVar1] <= Path03[GenVar1]);
 assign  SignPath01MinPath02[GenVar1] =(Path01[GenVar1] <= Path02[GenVar1]);
 assign  SignPath01MinPath03[GenVar1] =(Path01[GenVar1] <= Path03[GenVar1]);
 assign  SignPath02MinPath03[GenVar1] =(Path02[GenVar1] <= Path03[GenVar1]);

//-- Comparison results for 4 paths for each of the 16 states corresponding
//-- to 4i+1 (1 Mod 4) ie. states 1, 5, 9.....61
 assign  SignPath10MinPath11[GenVar1] =(Path10[GenVar1] <= Path11[GenVar1]);
 assign  SignPath10MinPath12[GenVar1] =(Path10[GenVar1] <= Path12[GenVar1]);
 assign  SignPath10MinPath13[GenVar1] =(Path10[GenVar1] <= Path13[GenVar1]);
 assign  SignPath11MinPath12[GenVar1] =(Path11[GenVar1] <= Path12[GenVar1]);
 assign  SignPath11MinPath13[GenVar1] =(Path11[GenVar1] <= Path13[GenVar1]);
 assign  SignPath12MinPath13[GenVar1] =(Path12[GenVar1] <= Path13[GenVar1]);

 //-- Comparison results for 4 paths for each of the 16 states corresponding
//-- to 4i+2 (2 Mod 4) ie. states 2, 6, 10...62
 assign  SignPath20MinPath21[GenVar1] =(Path20[GenVar1] <= Path21[GenVar1]);
 assign  SignPath20MinPath22[GenVar1] =(Path20[GenVar1] <= Path22[GenVar1]);
 assign  SignPath20MinPath23[GenVar1] =(Path20[GenVar1] <= Path23[GenVar1]);
 assign  SignPath21MinPath22[GenVar1] =(Path21[GenVar1] <= Path22[GenVar1]);
 assign  SignPath21MinPath23[GenVar1] =(Path21[GenVar1] <= Path23[GenVar1]);
 assign  SignPath22MinPath23[GenVar1] =(Path22[GenVar1] <= Path23[GenVar1]);

 //-- Comparison results for 4 paths for each of the 16 states corresponding
//-- to 4i+3 (3 Mod 4) ie. states 3,7,11...63
 assign  SignPath30MinPath31[GenVar1] =(Path30[GenVar1] <= Path31[GenVar1]);
 assign  SignPath30MinPath32[GenVar1] =(Path30[GenVar1] <= Path32[GenVar1]);
 assign  SignPath30MinPath33[GenVar1] =(Path30[GenVar1] <= Path33[GenVar1]);
 assign  SignPath31MinPath32[GenVar1] =(Path31[GenVar1] <= Path32[GenVar1]);
 assign  SignPath31MinPath33[GenVar1] =(Path31[GenVar1] <= Path33[GenVar1]);
 assign  SignPath32MinPath33[GenVar1] =(Path32[GenVar1] <= Path33[GenVar1]);
end
endgenerate

//------------------------------------------------------------------
//-- Selection of minimum path based on comparison results----

//-- PathSelectBits represents the selected path out of 4 incoming paths
// to each of the 64 states
// If PathSelectBits[n]= 00, Choose path coming from State i
// If PathSelectBits[n]= 01, Choose path coming from State i+16
// If PathSelectBits[n]= 10, Choose path coming from State i+32
// If PathSelectBits[n]= 11, Choose path coming from State i+48
//where n is the destination state.


generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pMinPathSelCom

  // Path selection bits for state 4i
 assign  PathSelectBits[4*GenVar1] = ((SignPath00MinPath01[GenVar1]) &&
            (SignPath00MinPath02[GenVar1]) && (SignPath00MinPath03[GenVar1])) ?
          (2'b00) : ((!SignPath00MinPath01[GenVar1])&&
             (SignPath01MinPath02[GenVar1])&&( SignPath01MinPath03[GenVar1])) ?
          (2'b01) : ((!SignPath00MinPath02[GenVar1])&&
             (!SignPath01MinPath02[GenVar1])&&(SignPath02MinPath03[GenVar1])) ?
          (2'b10) : ((!SignPath00MinPath03[GenVar1])&&
            (!SignPath01MinPath03[GenVar1])&&(!SignPath02MinPath03[GenVar1])) ?
          (2'b11): (2'b00) ;

  // Path selection bits for state 4i+1
 assign  PathSelectBits[4*GenVar1 +1] = ((SignPath10MinPath11[GenVar1])&&
            (SignPath10MinPath12[GenVar1]) && (SignPath10MinPath13[GenVar1])) ?
          2'b00 : ((!SignPath10MinPath11[GenVar1])&&
             (SignPath11MinPath12[GenVar1])&&( SignPath11MinPath13[GenVar1])) ?
          2'b01 : ((!SignPath10MinPath12[GenVar1])&&
             (!SignPath11MinPath12[GenVar1])&&(SignPath12MinPath13[GenVar1])) ?
          2'b10 : ((!SignPath10MinPath13[GenVar1])&&
            (!SignPath11MinPath13[GenVar1])&&(!SignPath12MinPath13[GenVar1])) ?
          2'b11:2'b00 ;


  // Path selection bits for state 4i+2
 assign  PathSelectBits[4*GenVar1 +2] = ((SignPath20MinPath21[GenVar1])&&
            (SignPath20MinPath22[GenVar1]) && (SignPath20MinPath23[GenVar1])) ?
          2'b00 : ((!SignPath20MinPath21[GenVar1])&&
             (SignPath21MinPath22[GenVar1])&&( SignPath21MinPath23[GenVar1])) ?
          2'b01 : ((!SignPath20MinPath22[GenVar1])&&
             (!SignPath21MinPath22[GenVar1])&&(SignPath22MinPath23[GenVar1])) ?
          2'b10 : ((!SignPath20MinPath23[GenVar1])&&
            (!SignPath21MinPath23[GenVar1])&&(!SignPath22MinPath23[GenVar1])) ?
          2'b11:2'b00 ;


  // Path selection bits for state 4i+3
 assign  PathSelectBits[4*GenVar1 +3] = ((SignPath30MinPath31[GenVar1])&&
            (SignPath30MinPath32[GenVar1]) && (SignPath30MinPath33[GenVar1])) ?
          2'b00 : ((!SignPath30MinPath31[GenVar1])&&
             (SignPath31MinPath32[GenVar1])&&( SignPath31MinPath33[GenVar1])) ?
          2'b01 : ((!SignPath30MinPath32[GenVar1])&&
             (!SignPath31MinPath32[GenVar1])&&(SignPath32MinPath33[GenVar1])) ?
          2'b10 : ((!SignPath30MinPath33[GenVar1])&&
            (!SignPath31MinPath33[GenVar1])&&(!SignPath32MinPath33[GenVar1])) ?
          2'b11:2'b00 ;


 //--------------------- Selection of Minimum path ----------------------
 assign MinPathMetrics[4*GenVar1] =
                           (PathSelectBits[4*GenVar1] == 2'b00) ? Path00[GenVar1]:
                           (PathSelectBits[4*GenVar1] == 2'b01) ? Path01[GenVar1]:
                           (PathSelectBits[4*GenVar1] == 2'b10) ? Path02[GenVar1]:
                                                                  Path03[GenVar1];

 assign MinPathMetrics[4*GenVar1 +1]= 
                           (PathSelectBits[4*GenVar1+1] == 2'b00) ? Path10[GenVar1]:
                           (PathSelectBits[4*GenVar1+1] == 2'b01) ? Path11[GenVar1]:
                           (PathSelectBits[4*GenVar1+1] == 2'b10) ? Path12[GenVar1]:
                                                                     Path13[GenVar1];

 assign MinPathMetrics[4*GenVar1+2]=
                            (PathSelectBits[4*GenVar1+2] == 2'b00) ? Path20[GenVar1]:
                            (PathSelectBits[4*GenVar1+2] == 2'b01) ? Path21[GenVar1]:
                            (PathSelectBits[4*GenVar1+2] == 2'b10) ? Path22[GenVar1]:
                                                                     Path23[GenVar1];

 assign MinPathMetrics[4*GenVar1+3] =
                            (PathSelectBits[4*GenVar1+3] == 2'b00) ? Path30[GenVar1]:
                            (PathSelectBits[4*GenVar1+3] == 2'b01) ? Path31[GenVar1]:
                            (PathSelectBits[4*GenVar1+3] == 2'b10) ? Path32[GenVar1]:
                                                                     Path33[GenVar1];

end
endgenerate
//------------------------Min path selection done -----------------

//----------------------------------------------------------------
//----------------------*** End of ACS Unit   ***---------------------
//----------------------------------------------------------------


//---------------------------------------------------------------------
//-Feed back the new normalized path metric value to PathMetric register--
//----------------------------------------------------------------------

// Replacing old pathMetric Value with the calculated ones

always @( posedge ViterbiClk or negedge nHrdRst)
begin :pPathMetricSeq
  if(!nHrdRst) 
  begin
     PathMetrics[0] <= {(PATHLENGTHG){1'b0}}; // With reset set state0 as min path metric
     for(Var3 =1; Var3<NUMOFSTATES; Var3=Var3 + 1)
       PathMetrics[Var3] <= RSTPATHMTRVAL; // for other path metric values
  end
  else 
  begin
    if(InitViterbi == 1'b1) 
    begin // Reset PathMetrics if this signal comes           

     // Need to check with init do we have to use 0 in state 0 and rest 100 PM       
     // value as in case of reset ????                                               
     PathMetrics[0] <= {(PATHLENGTHG){1'b0}};                                        
     for(Var3 =1; Var3<NUMOFSTATES; Var3=Var3 + 1)                                 
       PathMetrics[Var3] <= RSTPATHMTRVAL;                                         
    end                                                                              
    else 
    begin                                                                       
      if(DataInValidDly[1] == 1'b1) begin  //For 2 level of registering at BMU       
      // Registering minimum normalized  path metric value, it should be updated     
      // based on delayed InputValid                                                 
         for(Var3=0; Var3<NUMOFSTATES; Var3= Var3+1)                                 
           PathMetrics[Var3] <= NormMinPathMetrics[Var3];                            
      end                                                                            
    end //else : !if(InitViterbi)                                                    
  end // else: !if(nHrdRst)
end //always:pPathMetricSeq


//-------------------------------------------------------------------------
// -------------------***** Normalization unit *****-------------
//-------------------------------------------------------------------------
// Checking the MSBs of PathMetrics Registers for all states and if all
// 1's then reset it (divide by2), performed in two cycles to avoid too
// long logical path(assuming that no overflow will happen at next cycle
// otherwise PathMetricReg value will wrap
// Total 6 stages of 2 input and gates will be required
//------------------------------------------------------------------

//------------------------------------------------------------------
//----- 1st stage of AND gates where input is MSB of 64 PathMetrics values

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/2; GenVar1= GenVar1 + 1) begin:pNormStg1Com
 assign NormAndStage1[GenVar1] =  PathMetrics[2*GenVar1][PATHLENGTHG-1] &
                                  PathMetrics[2*GenVar1+1][PATHLENGTHG-1];
end
endgenerate

// If no pipelining in Normalization unit
/*
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/2; GenVar1= GenVar1 + 1) begin:pNormStg1Com 
 assign NormAndStage1[GenVar1] =  MinPathMetrics[2*GenVar1][PATHLENGTHG-1] &&
                                    MinPathMetrics[2*GenVar1+1][PATHLENGTHG-1];
end
endgenerate
*/
//----- 2nd stage of AND gates where i/p is AND stage 1 o/p
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pNormStg2Com
 assign NormAndStage2[GenVar1] =  NormAndStage1[2*GenVar1] &
                                  NormAndStage1[2*GenVar1+1];
end
endgenerate
//----- 3rd stage of AND gates
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/8; GenVar1= GenVar1 + 1) begin:pNormStg3Com
 assign NormAndStage3[GenVar1] =  NormAndStage2[2*GenVar1] &
                                  NormAndStage2[2*GenVar1+1];
end
endgenerate


// ----- 4th stage of AND gates 

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/16; GenVar1= GenVar1 + 1) begin:pNormStg4Com
 assign NormAndStage4[GenVar1] =  NormAndStage3[2*GenVar1] &
                                  NormAndStage3[2*GenVar1+1];
end
endgenerate


//---------- 5th Stage of And gates(2, 2 input AND gates)

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/32; GenVar1= GenVar1 + 1) begin:pNormStg5Com
 assign NormAndStage5[GenVar1] =  NormAndStage4[2*GenVar1] &
                                  NormAndStage4[2*GenVar1+1];
end
endgenerate

//---------- 6th Stage of And gates(1, 2 input AND gates)

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/64; GenVar1= GenVar1 + 1) begin:pNormStg6Com
 assign NormAndStage6[GenVar1] =  NormAndStage5[2*GenVar1] &
                                  NormAndStage5[2*GenVar1+1];
end
endgenerate
//--------------------------------------------------------------------------

//--------------- Normalization of Min Path metric based on AND logic o/p

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES; GenVar1= GenVar1 + 1) begin:pNormPathMetCom
 assign NormMinPathMetrics[GenVar1] = (NormAndStage6[0] == 1'b1)
                                ? {1'b0,MinPathMetrics[GenVar1][PATHLENGTHG -2 :0]}
                                : MinPathMetrics[GenVar1] ;
end
endgenerate

//-------------------------------------------------------------------------
//--------------**** Normalization logic ends here ****-----------------
//-------------------------------------------------------------------------


//-------------------------------------------------------------------------
//-------*** Survivor Path Memory Unit (Register Exchange Method) ***------
//------------------------------------------------------------------------

// Decision Bits at the output of ACS unit tells which of the 4 paths
// are selected and these four paths are coming to all states  from states
// i, 1+16, i+32, i+48 so at the current state register values are updated
// based on the register contents of one of these states.
// The decoded bit values are added to the the register contents(after
// and decoded bit will depend on current state for states 4i it is 00
// for 4i+1 :01, 4i+2 : 10, 4i+3: 11

generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pSPMUCom
 // Register exchange for states 4i (0 Mod 4) ; decoded bits are 00
 assign SurvivingPathsAux[4*GenVar1] =
               (PathSelectBitsReg[4*GenVar1] == 2'b00) ?
                  { SurvivingPathsReg[GenVar1][REGLENGTHG -3 :0], 2'b00}
             : (PathSelectBitsReg[4*GenVar1] == 2'b01) ?
                  { SurvivingPathsReg[GenVar1 +16][REGLENGTHG -3 :0], 2'b00}
             : (PathSelectBitsReg[4*GenVar1] == 2'b10) ?
                  { SurvivingPathsReg[GenVar1+32][REGLENGTHG -3 :0], 2'b00}
             :    { SurvivingPathsReg[GenVar1+48][REGLENGTHG -3 :0], 2'b00};

 // Register exchange for states 4i+1 (1 Mod 4) , decoded bits are 01
 assign SurvivingPathsAux[4*GenVar1+1] =
               (PathSelectBitsReg[4*GenVar1+1] == 2'b00) ?
                  { SurvivingPathsReg[GenVar1][REGLENGTHG -3 :0], 2'b01}
             : (PathSelectBitsReg[4*GenVar1+1] == 2'b01) ?
                  { SurvivingPathsReg[GenVar1 +16][REGLENGTHG -3 :0], 2'b01}
             : (PathSelectBitsReg[4*GenVar1+1] == 2'b10) ?
                  { SurvivingPathsReg[GenVar1+32][REGLENGTHG -3 :0], 2'b01}
             :    { SurvivingPathsReg[GenVar1+48][REGLENGTHG -3 :0], 2'b01};

 // Register exchange for states 4i+2 (2 Mod 4) , decoded bits are 10
 assign SurvivingPathsAux[4*GenVar1+2] =
               (PathSelectBitsReg[4*GenVar1+2] == 2'b00) ?
                  { SurvivingPathsReg[GenVar1][REGLENGTHG -3 :0], 2'b10}
             : (PathSelectBitsReg[4*GenVar1+2] == 2'b01) ?
                  { SurvivingPathsReg[GenVar1 +16][REGLENGTHG -3 :0], 2'b10}
             : (PathSelectBitsReg[4*GenVar1+2] == 2'b10) ?
                  { SurvivingPathsReg[GenVar1+32][REGLENGTHG -3 :0], 2'b10}
             :    { SurvivingPathsReg[GenVar1+48][REGLENGTHG -3 :0], 2'b10};

 // Register exchange for states 4i+3 (3 Mod 4) , decoded bits are 11
 assign SurvivingPathsAux[4*GenVar1+3] =
               (PathSelectBitsReg[4*GenVar1+3] == 2'b00) ?
                  { SurvivingPathsReg[GenVar1][REGLENGTHG -3 :0], 2'b11}
             : (PathSelectBitsReg[4*GenVar1+3] == 2'b01) ?
                  { SurvivingPathsReg[GenVar1 +16][REGLENGTHG -3 :0], 2'b11}
             : (PathSelectBitsReg[4*GenVar1+3] == 2'b10) ?
                  { SurvivingPathsReg[GenVar1+32][REGLENGTHG -3 :0], 2'b11}
             :    { SurvivingPathsReg[GenVar1+48][REGLENGTHG -3 :0], 2'b11};
end
endgenerate

//-------------Registering the decoded bits based on  survivor paths ----------

always @( posedge ViterbiClk or negedge nHrdRst)
begin :pSPMUSeq
  if(!nHrdRst)                                                        
  begin                                                               
    for(Var4=0; Var4<NUMOFSTATES; Var4= Var4+1)                       
      SurvivingPathsReg[Var4]   <=  {(REGLENGTHG){1'b0}};             
  end                                                                 
  else                                                                
  begin                                                               
    if(InitViterbi)                                                   
    begin // reset the registers (when flush, EOP come)               
      for(Var4=0; Var4<NUMOFSTATES; Var4= Var4+1)                     
         SurvivingPathsReg[Var4]   <=  {(REGLENGTHG){1'b0}};          
    end                                                               
    else                                                              
    begin                                                             
      if(DataInValidDly[2] == 1'b1)                                   
      begin  //For 2 level of pipelining at BMU                       
         for(Var4=0; Var4<NUMOFSTATES; Var4= Var4+1)                  
           SurvivingPathsReg[Var4]   <=  SurvivingPathsAux[Var4];     
      end                                                             
    end                                                               
  end //else : !if(nHrdRst)                                           
end   // always : pSPMUSeq

//-----------------------------------------------------------------------
//----------------***  SPMU  ends (Register Exchange Method) ***------
//------------------------------------------------------------------------

//-----------------------------------------------------------------------
//   ----------------***       decoded bits output  logic  ***------
//------------------------------------------------------------------------

//-------  6 adder stages with 3 levels of  pipelining -----
// This adder unit adds the last two columns of Registers (SPMU) and based on
// this decison is taken abt the decoded bits
//-- For 1st adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/2; GenVar1= GenVar1 + 1) begin:pOutAddrStg1Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage1[GenVar1] = {1'b0,SurvivingPathsReg[2*GenVar1][REGLENGTHG-1]} +
                           {1'b0,SurvivingPathsReg[2*GenVar1+1][REGLENGTHG-1]};
 // for second last  column of SPMU
 assign Col2AddrStage1[GenVar1] = {1'b0,SurvivingPathsReg[2*GenVar1][REGLENGTHG-2]} +
                           {1'b0,SurvivingPathsReg[2*GenVar1+1][REGLENGTHG-2]};
end
endgenerate


//-- For 2nd adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/4; GenVar1= GenVar1 + 1) begin:pOutAddrStg2Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage2[GenVar1] = {1'b0,Col1AddrStage1[2*GenVar1]} +
                           {1'b0,Col1AddrStage1[2*GenVar1+1]};
 // for second last  column of SPMU
 assign Col2AddrStage2[GenVar1] = {1'b0,Col2AddrStage1[2*GenVar1]} +
                           {1'b0,Col2AddrStage1[2*GenVar1+1]};
end
endgenerate

//---------- Registering 2nd adder stage o/p (pipelining)
always @(posedge ViterbiClk or negedge nHrdRst)
begin: pOutadderStg2Seq
  if(!nHrdRst)                                                 
  begin                                                        
    for(Var5=0; Var5<NUMOFSTATES/4; Var5= Var5+1)              
    begin                                                      
      Col1AddrStage2Reg[Var5]  <= 3'b0;                        
      Col2AddrStage2Reg[Var5]  <= 3'b0;                        
    end                                                        
  end                                                          
  else                                                         
  begin                                                        
    if(DataInValidDly[3])                                      
    begin                                                      
      for(Var5=0; Var5<NUMOFSTATES/4; Var5= Var5+1) begin      
        Col1AddrStage2Reg[Var5]  <= Col1AddrStage2[Var5];      
        Col2AddrStage2Reg[Var5]  <= Col2AddrStage2[Var5];      
      end                                                      
    end                                                        
  end //else: !if(nHrdRst)                                     
end //always


//-- For 3rd adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/8; GenVar1= GenVar1 + 1) begin:pOutAddrStg3Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage3[GenVar1] = {1'b0,Col1AddrStage2Reg[2*GenVar1]} +
                           {1'b0,Col1AddrStage2Reg[2*GenVar1+1]};
 // for second last  column of SPMU
 assign Col2AddrStage3[GenVar1] = {1'b0,Col2AddrStage2Reg[2*GenVar1]} +
                           {1'b0,Col2AddrStage2Reg[2*GenVar1+1]};
end
endgenerate


//-- For 4th  adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/16; GenVar1= GenVar1 + 1) begin:pOutAddrStg4Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage4[GenVar1] = {1'b0,Col1AddrStage3[2*GenVar1]} +
                           {1'b0,Col1AddrStage3[2*GenVar1+1]};
 // for second last  column of SPMU
 assign Col2AddrStage4[GenVar1] = {1'b0,Col2AddrStage3[2*GenVar1]} +
                           {1'b0,Col2AddrStage3[2*GenVar1+1]};
end
endgenerate

//---------- Registering 4th  adder stage o/p (pipelining)
always @(posedge ViterbiClk or negedge nHrdRst)
begin: pOutadderStg4Seq
  if(!nHrdRst) 
  begin
    for(Var6=0; Var6<NUMOFSTATES/16; Var6= Var6+1) 
    begin
      Col1AddrStage4Reg[Var6]  <= 5'b0;
      Col2AddrStage4Reg[Var6]  <= 5'b0;
    end
  end
  else 
  begin
    if(DataInValidDly[4]) begin
      for(Var6=0; Var6<NUMOFSTATES/16; Var6= Var6+1) begin
        Col1AddrStage4Reg[Var6] <= Col1AddrStage4[Var6];
        Col2AddrStage4Reg[Var6] <= Col2AddrStage4[Var6];
      end
    end
  end //else: !if(nHrdRst)
end //always

//-- For 5th adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/32; GenVar1= GenVar1 + 1) begin:pOutAddrStg5Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage5[GenVar1] = {1'b0,Col1AddrStage4Reg[2*GenVar1]} +
                           {1'b0,Col1AddrStage4Reg[2*GenVar1+1]};
 // for second last  column of SPMU
 assign Col2AddrStage5[GenVar1] = {1'b0,Col2AddrStage4Reg[2*GenVar1]} +
                           {1'b0,Col2AddrStage4Reg[2*GenVar1+1]};
end
endgenerate

//-- For 6th adder stage
generate
for(GenVar1=0; GenVar1 <NUMOFSTATES/64; GenVar1= GenVar1 + 1) begin:pOutAddrStg6Com
// for last column of SPMU [corresponding to decoded MSB]
 assign Col1AddrStage6[GenVar1] = {1'b0,Col1AddrStage5[2*GenVar1]} +
                           {1'b0,Col1AddrStage5[2*GenVar1+1]};
 // for second last  column of SPMU
 assign Col2AddrStage6[GenVar1] = {1'b0,Col2AddrStage5[2*GenVar1]} +
                           {1'b0,Col2AddrStage5[2*GenVar1+1]};
end
endgenerate

//---------- Registering 6th  adder stage o/p (pipelining)
always @(posedge ViterbiClk or negedge nHrdRst)
begin: pOutadderStg6Seq
  if(!nHrdRst)                                                
  begin                                                       
    for(Var7=0; Var7<NUMOFSTATES/64; Var7= Var7+1) 
    begin      
      Col1AddrStage6Reg[Var7]  <= 7'b0;                       
      Col2AddrStage6Reg[Var7]  <= 7'b0;                       
    end                                                       
  end                                                         
  else 
  begin                                                  
    if(DataInValidDly[5])                                     
    begin                                                     
      for(Var7=0; Var7<NUMOFSTATES/64; Var7= Var7+1) begin    
        Col1AddrStage6Reg[Var7]  <= Col1AddrStage6[Var7];     
        Col2AddrStage6Reg[Var7]  <= Col2AddrStage6[Var7];     
      end                                                     
    end                                                       
  end //else: !if(nHrdRst)                                    
end //always

//----------End adderlogic for decode o/p bit generation------
//-------------------------------------------------------------------

//-----------------------------------------------------------------------
//   ----------------***       decoded bits output    ***------
//------------------------------------------------------------------------

//------------- Parallel Viterbi Data Out Mux ----------------
//  MUX for parallel read considering TB length of 120 and 2 bit parallel read
// Viterbi parallel o/p from Trace backRegister0 which corresponds to state 0
// as with tail bits trellis converges to state0.

  assign VtrbDataPrll = SurvivingPathsReg[0][CntrVtrbRd*2-1 -: 2];


//--- Normal viterbi read when TB length is full

 // If last column of all states contain more than 32 bits set to 1 then
 // the decoder o/p is 1

 assign  VtrbDataNrml1 = (Col1AddrStage6Reg[0][6:5] ==2'b0) ? 1'b0 : 1'b1;

 // If second last column of all states contain more than 32 bits set to 1 then
 // the decoder o/p is 1

 assign  VtrbDataNrml2 = (Col2AddrStage6Reg[0][6:5] ==2'b0) ? 1'b0 : 1'b1;

//------   Viterbi data out----------------

always @(posedge ViterbiClk or negedge nHrdRst)
begin: pDecodedDataSeq
  if(!nHrdRst)                                                                       
  begin                                                                              
    ViterbiOutput  <=  2'd0;                                                      
  end                                                                                
  else 
  begin                                                                         
    if(FlushEop == 1'b1) begin// Flush has come and start giving data parallely      
      ViterbiOutput <= VtrbDataPrll;                                                 
    end                                                                              
    else                                                                             
    begin                                                                            
      // Give 2 valid decoded bits for every valid data in signal                    
      if(DataInValidDly[6] == 1'b1)                                                  
      begin // to take care of delay in (BMU, Adder)                                 
        ViterbiOutput  <= {VtrbDataNrml1,VtrbDataNrml2};                             
      end                                                                            
    end                                                                              
  end //else: !if(nHrdRst)                                                           
end  //always


//-------------------------------------------------------------------
//-------***    Index LUTs for BM computation ***--------------------
//-------------------------------------------------------------------

// 4 LUTs, each having 64 entries and the elements of these LUTs represent
// four coded bits coming out from state i.

//---------- LUT0: Encoded bits coming from first path for all 64 states
assign EncodedBits0[0] =  4'b0000;
assign EncodedBits0[1] =  4'b0111;
assign EncodedBits0[2] =  4'b1111;
assign EncodedBits0[3] =  4'b1000;
assign EncodedBits0[4] =  4'b1100;
assign EncodedBits0[5] =  4'b1011;
assign EncodedBits0[6] =  4'b0011;
assign EncodedBits0[7] =  4'b0100;
assign EncodedBits0[8] =  4'b0010;
assign EncodedBits0[9] =  4'b0101;
assign EncodedBits0[10] = 4'b1101;
assign EncodedBits0[11] = 4'b1010;
assign EncodedBits0[12] = 4'b1110;
assign EncodedBits0[13] = 4'b1001;
assign EncodedBits0[14] = 4'b0001;
assign EncodedBits0[15] = 4'b0110;
assign EncodedBits0[16] = 4'b1011;
assign EncodedBits0[17] = 4'b1100;
assign EncodedBits0[18] = 4'b0100;
assign EncodedBits0[19] = 4'b0011;
assign EncodedBits0[20] = 4'b0111;
assign EncodedBits0[21] = 4'b0000;
assign EncodedBits0[22] = 4'b1000;
assign EncodedBits0[23] = 4'b1111;
assign EncodedBits0[24] = 4'b1001;
assign EncodedBits0[25] = 4'b1110;
assign EncodedBits0[26] = 4'b0110;
assign EncodedBits0[27] = 4'b0001;
assign EncodedBits0[28] = 4'b0101;
assign EncodedBits0[29] = 4'b0010;
assign EncodedBits0[30] = 4'b1010;
assign EncodedBits0[31] = 4'b1101;
assign EncodedBits0[32] = 4'b1100;
assign EncodedBits0[33] = 4'b1011;
assign EncodedBits0[34] = 4'b0011;
assign EncodedBits0[35] = 4'b0100;
assign EncodedBits0[36] = 4'b0000;
assign EncodedBits0[37] = 4'b0111;
assign EncodedBits0[38] = 4'b1111;
assign EncodedBits0[39] = 4'b1000;
assign EncodedBits0[40] = 4'b1110;
assign EncodedBits0[41] = 4'b1001;
assign EncodedBits0[42] = 4'b0001;
assign EncodedBits0[43] = 4'b0110;
assign EncodedBits0[44] = 4'b0010;
assign EncodedBits0[45] = 4'b0101;
assign EncodedBits0[46] = 4'b1101;
assign EncodedBits0[47] = 4'b1010;
assign EncodedBits0[48] = 4'b0111;
assign EncodedBits0[49] = 4'b0000;
assign EncodedBits0[50] = 4'b1000;
assign EncodedBits0[51] = 4'b1111;
assign EncodedBits0[52] = 4'b1011;
assign EncodedBits0[53] = 4'b1100;
assign EncodedBits0[54] = 4'b0100;
assign EncodedBits0[55] = 4'b0011;
assign EncodedBits0[56] = 4'b0101;
assign EncodedBits0[57] = 4'b0010;
assign EncodedBits0[58] = 4'b1010;
assign EncodedBits0[59] = 4'b1101;
assign EncodedBits0[60] = 4'b1001;
assign EncodedBits0[61] = 4'b1110;
assign EncodedBits0[62] = 4'b0110;
assign EncodedBits0[63] = 4'b0001;

//---------------------------------------
//---------- LUT1: Encoded bits coming from second path for all 64 states

assign EncodedBits1[0]    =  4'b0011;
assign EncodedBits1[1]    =  4'b0100;
assign EncodedBits1[2]    =  4'b1100;
assign EncodedBits1[3]    =  4'b1011;
assign EncodedBits1[4]    =  4'b1111;
assign EncodedBits1[5]    =  4'b1000;
assign EncodedBits1[6]    =  4'b0000;
assign EncodedBits1[7]    =  4'b0111;
assign EncodedBits1[8]    =  4'b0001;
assign EncodedBits1[9]    =  4'b0110;
assign EncodedBits1[10]    = 4'b1110;
assign EncodedBits1[11]    = 4'b1001;
assign EncodedBits1[12]    = 4'b1101;
assign EncodedBits1[13]    = 4'b1010;
assign EncodedBits1[14]    = 4'b0010;
assign EncodedBits1[15]    = 4'b0101;
assign EncodedBits1[16]    = 4'b1000;
assign EncodedBits1[17]    = 4'b1111;
assign EncodedBits1[18]    = 4'b0111;
assign EncodedBits1[19]    = 4'b0000;
assign EncodedBits1[20]    = 4'b0100;
assign EncodedBits1[21]    = 4'b0011;
assign EncodedBits1[22]    = 4'b1011;
assign EncodedBits1[23]    = 4'b1100;
assign EncodedBits1[24]    = 4'b1010;
assign EncodedBits1[25]    = 4'b1101;
assign EncodedBits1[26]    = 4'b0101;
assign EncodedBits1[27]    = 4'b0010;
assign EncodedBits1[28]    = 4'b0110;
assign EncodedBits1[29]    = 4'b0001;
assign EncodedBits1[30]    = 4'b1001;
assign EncodedBits1[31]    = 4'b1110;
assign EncodedBits1[32]    = 4'b1111;
assign EncodedBits1[33]    = 4'b1000;
assign EncodedBits1[34]    = 4'b0000;
assign EncodedBits1[35]    = 4'b0111;
assign EncodedBits1[36]    = 4'b0011;
assign EncodedBits1[37]    = 4'b0100;
assign EncodedBits1[38]    = 4'b1100;
assign EncodedBits1[39]    = 4'b1011;
assign EncodedBits1[40]    = 4'b1101;
assign EncodedBits1[41]    = 4'b1010;
assign EncodedBits1[42]    = 4'b0010;
assign EncodedBits1[43]    = 4'b0101;
assign EncodedBits1[44]    = 4'b0001;
assign EncodedBits1[45]    = 4'b0110;
assign EncodedBits1[46]    = 4'b1110;
assign EncodedBits1[47]    = 4'b1001;
assign EncodedBits1[48]    = 4'b0100;
assign EncodedBits1[49]    = 4'b0011;
assign EncodedBits1[50]    = 4'b1011;
assign EncodedBits1[51]    = 4'b1100;
assign EncodedBits1[52]    = 4'b1000;
assign EncodedBits1[53]    = 4'b1111;
assign EncodedBits1[54]    = 4'b0111;
assign EncodedBits1[55]    = 4'b0000;
assign EncodedBits1[56]    = 4'b0110;
assign EncodedBits1[57]    = 4'b0001;
assign EncodedBits1[58]    = 4'b1001;
assign EncodedBits1[59]    = 4'b1110;
assign EncodedBits1[60]    = 4'b1010;
assign EncodedBits1[61]    = 4'b1101;
assign EncodedBits1[62]    = 4'b0101;
assign EncodedBits1[63]    = 4'b0010;
//-----------------------------------------------
//---------- LUT2: Encoded bits coming from third  path for all 64 states

assign EncodedBits2[0]    =  4'b1101;
assign EncodedBits2[1]    =  4'b1010;
assign EncodedBits2[2]    =  4'b0010;
assign EncodedBits2[3]    =  4'b0101;
assign EncodedBits2[4]    =  4'b0001;
assign EncodedBits2[5]    =  4'b0110;
assign EncodedBits2[6]    =  4'b1110;
assign EncodedBits2[7]    =  4'b1001;
assign EncodedBits2[8]    =  4'b1111;
assign EncodedBits2[9]    =  4'b1000;
assign EncodedBits2[10]    = 4'b0000;
assign EncodedBits2[11]    = 4'b0111;
assign EncodedBits2[12]    = 4'b0011;
assign EncodedBits2[13]    = 4'b0100;
assign EncodedBits2[14]    = 4'b1100;
assign EncodedBits2[15]    = 4'b1011;
assign EncodedBits2[16]    = 4'b0110;
assign EncodedBits2[17]    = 4'b0001;
assign EncodedBits2[18]    = 4'b1001;
assign EncodedBits2[19]    = 4'b1110;
assign EncodedBits2[20]    = 4'b1010;
assign EncodedBits2[21]    = 4'b1101;
assign EncodedBits2[22]    = 4'b0101;
assign EncodedBits2[23]    = 4'b0010;
assign EncodedBits2[24]    = 4'b0100;
assign EncodedBits2[25]    = 4'b0011;
assign EncodedBits2[26]    = 4'b1011;
assign EncodedBits2[27]    = 4'b1100;
assign EncodedBits2[28]    = 4'b1000;
assign EncodedBits2[29]    = 4'b1111;
assign EncodedBits2[30]    = 4'b0111;
assign EncodedBits2[31]    = 4'b0000;
assign EncodedBits2[32]    = 4'b0001;
assign EncodedBits2[33]    = 4'b0110;
assign EncodedBits2[34]    = 4'b1110;
assign EncodedBits2[35]    = 4'b1001;
assign EncodedBits2[36]    = 4'b1101;
assign EncodedBits2[37]    = 4'b1010;
assign EncodedBits2[38]    = 4'b0010;
assign EncodedBits2[39]    = 4'b0101;
assign EncodedBits2[40]    = 4'b0011;
assign EncodedBits2[41]    = 4'b0100;
assign EncodedBits2[42]    = 4'b1100;
assign EncodedBits2[43]    = 4'b1011;
assign EncodedBits2[44]    = 4'b1111;
assign EncodedBits2[45]    = 4'b1000;
assign EncodedBits2[46]    = 4'b0000;
assign EncodedBits2[47]    = 4'b0111;
assign EncodedBits2[48]    = 4'b1010;
assign EncodedBits2[49]    = 4'b1101;
assign EncodedBits2[50]    = 4'b0101;
assign EncodedBits2[51]    = 4'b0010;
assign EncodedBits2[52]    = 4'b0110;
assign EncodedBits2[53]    = 4'b0001;
assign EncodedBits2[54]    = 4'b1001;
assign EncodedBits2[55]    = 4'b1110;
assign EncodedBits2[56]    = 4'b1000;
assign EncodedBits2[57]    = 4'b1111;
assign EncodedBits2[58]    = 4'b0111;
assign EncodedBits2[59]    = 4'b0000;
assign EncodedBits2[60]    = 4'b0100;
assign EncodedBits2[61]    = 4'b0011;
assign EncodedBits2[62]    = 4'b1011;
assign EncodedBits2[63]    = 4'b1100;
//---------------------------------------------------
//---------- LUT3: Encoded bits coming from fourth path for all 64 states

assign EncodedBits3[0]    =  4'b1110;
assign EncodedBits3[1]    =  4'b1001;
assign EncodedBits3[2]    =  4'b0001;
assign EncodedBits3[3]    =  4'b0110;
assign EncodedBits3[4]    =  4'b0010;
assign EncodedBits3[5]    =  4'b0101;
assign EncodedBits3[6]    =  4'b1101;
assign EncodedBits3[7]    =  4'b1010;
assign EncodedBits3[8]    =  4'b1100;
assign EncodedBits3[9]    =  4'b1011;
assign EncodedBits3[10]    = 4'b0011;
assign EncodedBits3[11]    = 4'b0100;
assign EncodedBits3[12]    = 4'b0000;
assign EncodedBits3[13]    = 4'b0111;
assign EncodedBits3[14]    = 4'b1111;
assign EncodedBits3[15]    = 4'b1000;
assign EncodedBits3[16]    = 4'b0101;
assign EncodedBits3[17]    = 4'b0010;
assign EncodedBits3[18]    = 4'b1010;
assign EncodedBits3[19]    = 4'b1101;
assign EncodedBits3[20]    = 4'b1001;
assign EncodedBits3[21]    = 4'b1110;
assign EncodedBits3[22]    = 4'b0110;
assign EncodedBits3[23]    = 4'b0001;
assign EncodedBits3[24]    = 4'b0111;
assign EncodedBits3[25]    = 4'b0000;
assign EncodedBits3[26]    = 4'b1000;
assign EncodedBits3[27]    = 4'b1111;
assign EncodedBits3[28]    = 4'b1011;
assign EncodedBits3[29]    = 4'b1100;
assign EncodedBits3[30]    = 4'b0100;
assign EncodedBits3[31]    = 4'b0011;
assign EncodedBits3[32]    = 4'b0010;
assign EncodedBits3[33]    = 4'b0101;
assign EncodedBits3[34]    = 4'b1101;
assign EncodedBits3[35]    = 4'b1010;
assign EncodedBits3[36]    = 4'b1110;
assign EncodedBits3[37]    = 4'b1001;
assign EncodedBits3[38]    = 4'b0001;
assign EncodedBits3[39]    = 4'b0110;
assign EncodedBits3[40]    = 4'b0000;
assign EncodedBits3[41]    = 4'b0111;
assign EncodedBits3[42]    = 4'b1111;
assign EncodedBits3[43]    = 4'b1000;
assign EncodedBits3[44]    = 4'b1100;
assign EncodedBits3[45]    = 4'b1011;
assign EncodedBits3[46]    = 4'b0011;
assign EncodedBits3[47]    = 4'b0100;
assign EncodedBits3[48]    = 4'b1001;
assign EncodedBits3[49]    = 4'b1110;
assign EncodedBits3[50]    = 4'b0110;
assign EncodedBits3[51]    = 4'b0001;
assign EncodedBits3[52]    = 4'b0101;
assign EncodedBits3[53]    = 4'b0010;
assign EncodedBits3[54]    = 4'b1010;
assign EncodedBits3[55]    = 4'b1101;
assign EncodedBits3[56]    = 4'b1011;
assign EncodedBits3[57]    = 4'b1100;
assign EncodedBits3[58]    = 4'b0100;
assign EncodedBits3[59]    = 4'b0011;
assign EncodedBits3[60]    = 4'b0111;
assign EncodedBits3[61]    = 4'b0000;
assign EncodedBits3[62]    = 4'b1000;
assign EncodedBits3[63]    = 4'b1111;
//--------------- END LUT 3-----------------


endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
