/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module viterbi_clkgate_ctrl
(
  /*****************************************************************************
  * system 
  *****************************************************************************/
  input  wire   rst_n,
  input  wire   clk,
  
  /*****************************************************************************
  * parameter 
  *****************************************************************************/
  input  wire   nes,
  
  /*****************************************************************************
  * field control
  *****************************************************************************/
  input  wire   start,
  input  wire   valid,
  input  wire   flush,
  
  /*******************************************************************************
  * output flow control / clock enable
  *******************************************************************************/
  output reg    vtb0_clken,      
  output reg    vtb1_clken,      
      
  output wire   vtb_start,
  input  wire   vtb_flush_done        
);
  reg [15:0] sr_valid;
  reg [ 5:0] sr_start;
  reg        flushing;
    
  assign vtb_start = sr_start[5];
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      sr_valid    <= 16'b0;
      sr_start    <=  6'b0;
      vtb0_clken  <=  1'b0;
      vtb1_clken  <=  1'b0;
      flushing    <=  1'b0;
    end
    else 
    begin
      /* keep history */
      sr_valid <= {sr_valid[14:0],valid};
      sr_start <= {sr_start[ 4:0],start};
      if(start || flush)
      begin
        vtb0_clken  <=  1'b1;
        vtb1_clken  <=  nes;
        sr_valid    <=  16'b0; // cancel any valid history
        flushing    <=  flush;
      end 
      else if(!flushing)
      begin
        /* no more activity for a while, viterbi empty then clock off */
        if(sr_valid==16'b1000_0000_0000_0000)
        begin
          vtb0_clken  <=  1'b0;
          vtb1_clken  <=  1'b0;
        end
      end
      else if(vtb_flush_done)
      begin
        vtb0_clken  <=  1'b0;
        vtb1_clken  <=  1'b0;
        flushing    <=  1'b0;
      end
    end  
          
endmodule
`default_nettype wire
