`default_nettype none
module rx_bd_vtb_clkctrl
(
  /* system */
  input  wire clk,
  input  wire rst_n,
  
  input  wire global_enable,
  
  /* vtbin if */
  input  wire vtbin_valid,
  input  wire vtbin_last,
  output reg  vtbin_ready,
  
  /* vtbctrl if */
  output reg  vtbctrl_start,
  output reg  vtbctrl_flush,
  output wire vtbctrl_ready_valid,
  input  wire vtbctrl_flushdone,
  
  /* clock enable */
  output wire vtb_core_clken
  
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg  [ 7:0] vtb_clken_sr;
  reg  [15:0] vtbin_valid_sr;
  
  reg         flushing;
  reg         vtb_start_state;
  
  assign vtb_core_clken      = vtb_clken_sr[0];
  assign vtbctrl_ready_valid = vtbin_ready & vtbin_valid;
  
  always @(posedge clk,negedge rst_n)
  begin
    if(!rst_n)
    begin
      vtb_clken_sr    <= 8'b0;
      vtbin_valid_sr  <= 16'b0;
      
      flushing        <= 1'b0;
      vtbin_ready     <= 1'b0;
     
      vtb_start_state <= 1'b0;
      vtbctrl_start   <= 1'b0;
      vtbctrl_flush   <= 1'b0;
    end
    else if(!global_enable)
    begin
      vtb_clken_sr    <= 8'b0;
      vtbin_valid_sr  <= 16'b0;
      
      flushing        <= 1'b0;
      vtbin_ready     <= 1'b0;
     
      vtb_start_state <= 1'b0;
      vtbctrl_start   <= 1'b0;
      vtbctrl_flush   <= 1'b0;
    end
    else
    begin
      /* rtz */
      vtbctrl_start <= 1'b0;
      vtbctrl_flush <= 1'b0;
      
      /* history */
      vtb_clken_sr   <= {vtb_clken_sr[6:0],vtb_clken_sr[0]};
      vtbin_valid_sr <= {vtbin_valid_sr[14:0],vtbin_valid};
      
      /* vtbin_ready */
      if(!flushing)
      begin
        if(!vtbin_ready)
        begin
          if(vtbin_valid)
          begin
            if(vtb_clken_sr==8'b0)
            begin
              vtb_clken_sr  <= 8'b00000001;
            end
            else if(vtb_clken_sr==8'b11111111)
            begin
              if(!vtb_start_state)
              begin
                vtbctrl_start   <= 1'b1;
                vtb_start_state <= 1'b1;
              end
              else
              begin
                vtbin_ready <= 1'b1;
              end
            end
          end
        end
        else
        begin
          if(vtbin_valid)
          begin
            if(vtbin_last)
            begin
              flushing        <= 1'b1;
              vtbctrl_flush   <= 1'b1;
              vtb_start_state <= 1'b0;
            end
          end
          else if(vtbin_valid_sr==16'b0000_0000_0000_0000)
          begin
            vtb_clken_sr  <= 8'b00000000;
            vtbin_ready   <= 1'b0;
          end
        end
      end
      else
      begin
        if(vtbctrl_flushdone)
        begin
          flushing     <= 1'b0;
        end
      end  
    end
  end

endmodule
`default_nettype wire

