/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_vtbin_resync
(
  /*******************************************************************
  * regular domain
  *******************************************************************/
  input  wire        rst_n,
  input  wire        clk,
  
  input  wire        enable,
  
  output wire [3:0]  ready,
  input  wire [4:0]  sb0,
  input  wire [4:0]  sb1,   
  input  wire [4:0]  sb2,   
  input  wire [4:0]  sb3,   
  input  wire [4:0]  sb4,   
  input  wire [4:0]  sb5,   
  input  wire [4:0]  sb6,   
  input  wire [4:0]  sb7,   
  input  wire [1:0]  last,  
  input  wire [3:0]  valid, 

  /*******************************************************************
  * vtb domain
  *******************************************************************/
  input  wire        vtb_rst_n,
  input  wire        vtb_clk,
  
  input  wire        vtb_enable,
  
  input  wire        vtb_ready,
  output wire [4:0]  vtb_sb0,
  output wire [4:0]  vtb_sb1,
  output wire [4:0]  vtb_sb2,
  output wire [4:0]  vtb_sb3,
  output wire        vtb_last,
  output wire        vtb_valid
);
  
  /*****************************************************************************
  * S0 asynchronous fifo
  *****************************************************************************/
  wire        async_fifo_ready;
  wire        async_fifo_valid;
  
  wire        s0_ready;
  wire [41:0] s0_data;
  wire        s0_valid;
  wire [ 1:0] s0_last;
  wire [ 4:0] s0_sb7,s0_sb6,s0_sb5,s0_sb4,s0_sb3,s0_sb2,s0_sb1,s0_sb0;
  
  /* accept only 8 bits chunks */
  assign ready            = 4'd8 & {4{async_fifo_ready && (valid==4'd8 || valid!=4'd0 && last!=2'd0)}} ;
  assign async_fifo_valid = ready!=2'd0 && valid!=4'd0;
  
  async_fifo2
  #(
    .g_width(      32'd42),
    .g_log_depth(  32'd2)
  )
  u_async_fifo2
  (
    /* control (async) */
    
    /* write domain (regular clk) */
    .w_rst_n(        rst_n),
    .w_clk(          clk),
    
    .w_enable(       enable),
    .w_ready(        async_fifo_ready),
    .w_data(         {last[1],sb7,sb6,sb5,sb4,last[0],sb3,sb2,sb1,sb0}),
    .w_valid(        async_fifo_valid),

    /* read domain (vtb clk) */
    .r_rst_n(        vtb_rst_n),
    .r_clk(          vtb_clk),
    
    .r_enable(       vtb_enable),
    .r_ready(        s0_ready),
    .r_data(         s0_data),
    .r_valid(        s0_valid)
  );
  
  
  assign {s0_last[1],s0_sb7,s0_sb6,s0_sb5,s0_sb4,s0_last[0],s0_sb3,s0_sb2,s0_sb1,s0_sb0} = s0_data;

  /*****************************************************************************
  * S1 quadruplet output fifo (3 entries of 4SB (21 bits))
  *****************************************************************************/
  wire        s1_fifo_wren;
  wire        s1_fifo_rden;
  wire        s1_fifo_in_shsel;
  
  wire [62:0] s1_fifo_in_sh1;
  wire [62:0] s1_fifo_out_sh1;
  wire [62:0] n_s1_fifo; 
  reg  [62:0] s1_fifo;
  wire [ 1:0] n_s1_fifo_count;
  reg  [ 1:0] s1_fifo_count;
 
  assign s0_ready        = s1_fifo_count<2'd2 ;
  
  assign s1_fifo_wren    = s0_ready & s0_valid; 
  assign s1_fifo_rden    = vtb_valid & vtb_ready;

  assign s1_fifo_in_shsel= s1_fifo_count==2'd1 & !s1_fifo_rden;
  
  assign s1_fifo_in_sh1  = s1_fifo_in_shsel?{s0_data,21'b0}:{21'b0,s0_data};
  assign s1_fifo_out_sh1 = s1_fifo_rden?{21'b0,s1_fifo[62:21]}:s1_fifo;

  assign n_s1_fifo       = s1_fifo_out_sh1 | s1_fifo_in_sh1 & {63{s1_fifo_wren}};
  assign n_s1_fifo_count = s1_fifo_count + {s1_fifo_wren,1'b0} - {1'b0,s1_fifo_rden};
  
  always @(posedge vtb_clk, negedge vtb_rst_n)
  begin
    if(!vtb_rst_n)
    begin
      s1_fifo       <= 63'd0;
      s1_fifo_count <= 2'd0;
    end
    else if(!vtb_enable)
    begin
      s1_fifo       <= 63'd0;
      s1_fifo_count <= 2'd0;
    end
    else
    begin
      if(vtb_ready && vtb_valid && vtb_last)
      begin
        s1_fifo       <= 63'd0;
        s1_fifo_count <= 2'd0;
      end
      else
      begin
        s1_fifo       <= n_s1_fifo;
        s1_fifo_count <= n_s1_fifo_count;
      end
    end
  end
  
  wire  [4:0] s1_2_sb3,s1_2_sb2,s1_2_sb1,s1_2_sb0, 
              s1_1_sb3,s1_1_sb2,s1_1_sb1,s1_1_sb0, 
              s1_0_sb3,s1_0_sb2,s1_0_sb1,s1_0_sb0;
        
  wire        s1_2_last,  s1_1_last,  s1_0_last;  
  
  
  assign {s1_2_last,s1_2_sb3,s1_2_sb2,s1_2_sb1,s1_2_sb0, 
          s1_1_last,s1_1_sb3,s1_1_sb2,s1_1_sb1,s1_1_sb0, 
          s1_0_last,s1_0_sb3,s1_0_sb2,s1_0_sb1,s1_0_sb0} = s1_fifo; 
  
  assign vtb_last                          = s1_fifo[20];
  assign {vtb_sb3,vtb_sb2,vtb_sb1,vtb_sb0} = s1_fifo[19:0];
  assign vtb_valid                         = s1_fifo_count!=2'd0;
  
endmodule
`default_nettype wire
