/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module rx_bd_vtbout_resync
(
  /*******************************************************************
  * vtb domain
  *******************************************************************/
  input  wire        vtb_rst_n,
  input  wire        vtb_clk,
  
  input  wire        vtb_enable,
  
  input  wire        vtb_flush,
  input  wire  [1:0] vtb_data,
  input  wire        vtb_valid, 

  /*******************************************************************
  * bd domain
  *******************************************************************/
  input  wire        rst_n,
  input  wire        clk,
  
  output wire        overflow,
  input  wire        enable,
  
  input  wire        ready,
  output wire [7:0]  data,
  output wire        last,
  output wire        valid
);
 
  /*****************************************************************************
  * S0 byte reconstruction fifo 
  *  o 5 entries of 2 bits 
  *    ->4 for byte reconstruction
  *    ->1 to convert the flush done into a last data attribute 
  *      flush occurs after the last data is pushed
  *****************************************************************************/
  wire        s0_fifo_wren;
  wire        s0_fifo_rden;
  wire [ 2:0] s0_fifo_rdlen;
  wire [ 2:0] s0_fifo_in_shsel;
  
  wire [ 9:0] s0_fifo_in_sh1,s0_fifo_in_sh2,s0_fifo_in_sh3;
  wire [ 9:0] s0_fifo_out_sh1;
  wire [ 9:0] n_s0_fifo; 
  reg  [ 9:0] s0_fifo;
  wire [ 2:0] n_s0_fifo_count;
  reg  [ 2:0] s0_fifo_count;
  wire        n_s0_fifo_last;
  reg         s0_fifo_last;
  wire        s0_ready,s0_last,s0_valid;
  reg         s0_overflow;
  
  assign s0_fifo_wren     = vtb_valid;
  
  assign s0_fifo_rden     = s0_ready & (s0_fifo_count>3'd4 | s0_fifo_count!=3'd0 & s0_fifo_last);
  assign s0_fifo_rdlen    = {(s0_fifo_count>3'd4)?3'd4:s0_fifo_count[2:0]} & {3{s0_fifo_rden}};

  assign s0_fifo_in_shsel = s0_fifo_count - s0_fifo_rdlen;
  
  assign s0_fifo_in_sh1   = s0_fifo_in_shsel[0]?{6'b0,      vtb_data, 2'b0}:{8'b0,vtb_data};
  assign s0_fifo_in_sh2   = s0_fifo_in_shsel[1]?{s0_fifo_in_sh1[5:0], 4'b0}:s0_fifo_in_sh1;
  assign s0_fifo_in_sh3   = s0_fifo_in_shsel[2]?{s0_fifo_in_sh2[1:0], 8'b0}:s0_fifo_in_sh2;
  
  assign s0_fifo_out_sh1  = s0_fifo_rden?{8'b0,s0_fifo[9:8]}:s0_fifo;

  assign n_s0_fifo        = s0_fifo_out_sh1 | s0_fifo_in_sh3 & {10{s0_fifo_wren}};
  assign n_s0_fifo_count  = s0_fifo_count + { 2'b0,s0_fifo_wren} - s0_fifo_rdlen;
  assign n_s0_fifo_last   = s0_fifo_last | vtb_flush;
  
  assign s0_valid         = s0_fifo_rden;
  assign s0_last          = s0_fifo_rden & s0_fifo_count<=3'd4 & s0_fifo_last;

  always @(posedge vtb_clk, negedge vtb_rst_n)
  begin
    if(!vtb_rst_n)
    begin
      s0_fifo       <= 10'd0;
      s0_fifo_count <= 4'd0;
      s0_fifo_last  <= 1'b0;
      s0_overflow   <= 1'b0;
    end
    else if(!vtb_enable)
    begin
      s0_fifo       <= 10'd0;
      s0_fifo_count <= 4'd0;
      s0_fifo_last  <= 1'b0;
      s0_overflow   <= 1'b0;
    end
    else
    begin
      if(s0_ready && s0_valid && s0_last)
      begin
        s0_fifo       <= 10'd0;
        s0_fifo_count <= 4'd0;
        s0_fifo_last  <= 1'b0;
      end
      else
      begin
        s0_fifo       <= n_s0_fifo;
        s0_fifo_count <= n_s0_fifo_count;
        s0_fifo_last  <= n_s0_fifo_last;
        if(vtb_valid && s0_fifo_count==4'd5 && !s0_fifo_rden)
          s0_overflow  <= 1'b1;
      end
    end
  end

  /*****************************************************************************
  * S1 asynchronous fifo
  *****************************************************************************/
  async_fifo2
  #(
    .g_width(      32'd9),
    .g_log_depth(  32'd4)
  )
  u_async_fifo2
  (
    
    /* write domain (vtb clk) */
    .w_rst_n(        vtb_rst_n),
    .w_clk(          vtb_clk),
    
    .w_enable(       vtb_enable),
    .w_ready(        s0_ready),
    .w_data(         {s0_last,s0_fifo[7:0]}),
    .w_valid(        s0_valid),

    /* read domain (regular clk) */
    .r_rst_n(        rst_n),
    .r_clk(          clk),
    
    .r_enable(       enable),
    .r_ready(        ready),
    .r_data(         {last,data}),
    .r_valid(        valid)
  );
 
  ClkSyncSimple u_overflow_resync
  ( 
    .dstclk(          clk),
    .dstresetn(       rst_n),
    .srcdata(         s0_overflow),
    .dstdata(         overflow)
  );
  
endmodule
`default_nettype wire
