////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top level Module of Channel Estimation and Smoothing
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/ChEstSmthTop.v $
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module ChEstSmthTop #(parameter FFTBUFWIDTH   = 13,  // Data width of the FFT memory
                      parameter HBUFDATAWIDTH = 13,  // Data width of one channel coefficient
                      parameter NSTS_PARAM    =  4   // Spatial Streams supported
                     )(

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                       nPhyRst,            // Active Low Reset
            input   wire                       PhyClk,             // Phy Clock

            ///////////////////////////////////////////////
            // Registers
            ///////////////////////////////////////////////
            input   wire [1:0]                 CfgSmoothFilterSet, // Smooth Filter Set

            ///////////////////////////////////////////////
            // Controls from FD FSM
            ///////////////////////////////////////////////
            input   wire [3:0]                 NShiftLTF,         // No. of LTF to shift in case of Mu-MIMO
            input   wire [3:0]                 ReceptionMode,     // Mode of Current Pkt
            input   wire [2:0]                 SymbolType,        // Type of Symbol
            input   wire [2:0]                 RUType,            // Type of RU (0:26, 1:52, 2:106, 3:242, 4:484)
            input   wire [5:0]                 RUIndex,           // RU allocation index (up to 37)
            input   wire                       FirstLTF,          // Indicates First LTF
            input   wire                       LastLTF,           // Indicates Last LTF
            input   wire                       FrameNDP,          // Indicates frame is NDP
`ifdef RW_MUMIMO_RX_EN
            input   wire                       HEMuMIMOEn,        // Indicates frame is HE Mu-MIMO
`endif // RW_MUMIMO_RX_EN
            //
            input   wire [1:0]                 RxNsts,            // No. of Space Time Steams
            //
            input   wire                       EstimEn,           // Enable Ch Est
            input   wire                       SmoothEn,          // Enable smoothing
            input   wire                       SmoothfromHP,      // Start Smoothing Only
            input   wire                       StartSignalP,      // Start of a symbol
            //
            output  wire                       EstimDoneP,        // To Rx FSM
            output  wire                       SmthDoneP,         // To Rx FSM
            output  wire                       DataChannelEnOut,  // Enable G Matrix Comp

            ///////////////////////////////////////////////
            // H Buffer Interface
            ///////////////////////////////////////////////
            // Read Port
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataRe0,     // H Data Real buffer 0
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataIm0,     // H Data Imag buffer 0
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataRe1,     // H Data Real buffer 1
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataIm1,     // H Data Imag buffer 1
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataRe2,     // H Data Real buffer 2
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataIm2,     // H Data Imag buffer 2
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataRe3,     // H Data Real buffer 3
            input   wire [HBUFDATAWIDTH-1:0]   HBufRdDataIm3,     // H Data Imag buffer 3
            input   wire                       HBufRdDataEnIn,    // Qualifies HBufRdData
            output  wire [9:0]                 HBufRdAddr,        // Address for Read Port
            output  wire                       HBufRdEn,          // Qualifies HBufRdAddr

            // Write Port
            output  wire [9:0]                 HBufWrAddr,        // Address for Write Port
            output  wire                       HBufWrAddrEn,      // Qualifies HBufWrAddr
            output  wire [1:0]                 HBufWrEn0,         // Write Enable buffer 0
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataRe0,     // H Write Data Real buffer 0
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataIm0,     // H Write Data Imag buffer 0
            output  wire [1:0]                 HBufWrEn1,         // Write Enable buffer 1
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataRe1,     // H Write Data Real buffer 1
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataIm1,     // H Write Data Imag buffer 1
            output  wire [1:0]                 HBufWrEn2,         // Write Enable buffer 2
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataRe2,     // H Write Data Real buffer 2
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataIm2,     // H Write Data Imag buffer 2
            output  wire [1:0]                 HBufWrEn3,         // Write Enable buffer 3
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataRe3,     // H Write Data Real buffer 3
            output  wire [HBUFDATAWIDTH-1:0]   HBufWrDataIm3,     // H Write Data Imag buffer 3

            ///////////////////////////////////////////////
            // FFT Memory Interface
            ///////////////////////////////////////////////
            input   wire [FFTBUFWIDTH-1:0]     FFTBufRdDataReRx0, // FFT buffer Data Real
            input   wire [FFTBUFWIDTH-1:0]     FFTBufRdDataImRx0, // FFT buffer Data Imag
            //
            output  wire [9:0]                 FFTBufRdAddr,      // Read Address
            output  wire                       FFTBufRdAddrEnOut  // Qualifies FFTBufRdAddr
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [3:0]               BlockEn;
wire               [1:0]               HDataMult;
wire               [1:0]               RoundLSB;
wire                                   PreambleCoeff;
wire               [3:0]               PtCoeff;
wire                                   ReadFromH;
wire                                   DCClear;
wire                                   SelIQPhase;
wire                                   PilotStore;
wire                                   PilotRead;
wire               [3:0]               RotIndex0;
wire               [3:0]               RotIndex1;
wire               [3:0]               RotIndex2;
wire               [3:0]               RotIndex3;
wire               [1:0]               RotQuad0;
wire               [1:0]               RotQuad1;
wire               [1:0]               RotQuad2;
wire               [1:0]               RotQuad3;
wire                                   RotDataEnIn;
wire                                   RotDataEnOut;
wire                                   PilotAvEn;
wire               [9:0]               PilotAvSCIndex;
wire                                   PilotAvDataInValid;
wire               [NSTS_PARAM-1:0]    SmoothEnIn;
wire    signed     [9:0]               SmoothCoeff0;
wire    signed     [9:0]               SmoothCoeff1;
wire    signed     [9:0]               SmoothCoeff2;
wire    signed     [9:0]               SmoothCoeff3;
wire    signed     [9:0]               SmoothCoeff4;
wire    signed     [9:0]               SmoothCoeff5;
wire    signed     [9:0]               SmoothCoeff6;
wire    signed     [9:0]               SmoothCoeff7;
wire    signed     [9:0]               SmoothCoeff8;
wire    signed     [9:0]               SmoothCoeff9;
wire    signed     [9:0]               SmoothCoeff10;
wire    signed     [9:0]               SmoothCoeff11;
wire               [1:0]               SmoothCoeffRS;
wire                                   DivByJ;
wire                                   MultByJ;
wire                                   ShiftIn;
wire                                   SmoothFilterEn;
wire                                   RotCordicEnIn;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Smooth Enable In (Merging Block Enable and Rx FSM Signals)
assign SmoothEnIn[NSTS_PARAM-1:0] = {NSTS_PARAM{SmoothFilterEn}};

// Enable Cordics as long as either DataEnIn or DataEnOut is high
assign RotCordicEnIn = RotDataEnIn | RotDataEnOut;


//Instantiate EstimSmoothRx for the first chain
EstimSmoothRx # (
                 //Parameters
                .FFTBUFWIDTH(FFTBUFWIDTH),
                .HBUFDATAWIDTH(HBUFDATAWIDTH),
                .NSTS(NSTS_PARAM)
                ) U_EstimSmoothRx0 (
                          //Inputs
                          .nPhyRst(nPhyRst),
                          .PhyClk(PhyClk),
                          .RxNsts(RxNsts),
                          .ReceptionMode(ReceptionMode),
                          .SymbolType(SymbolType),
                          .RUType(RUType),
                          .SmoothEnIn(SmoothEnIn),
                          .ShiftIn(ShiftIn),
                          .BlockEn(BlockEn),
                          .DivByJ(DivByJ),
                          .MultByJ(MultByJ),
                          .FirstLTF(FirstLTF),
                          .PilotAvEn(PilotAvEn),
                          .PilotAvSCIndex(PilotAvSCIndex),
                          .PilotAvDataInValid(PilotAvDataInValid),
                          .RotCordicEnIn(RotCordicEnIn),
                          .RotQuad0(RotQuad0),
                          .RotQuad1(RotQuad1),
                          .RotQuad2(RotQuad2),
                          .RotQuad3(RotQuad3),
                          .RotIndex0(RotIndex0),
                          .RotIndex1(RotIndex1),
                          .RotIndex2(RotIndex2),
                          .RotIndex3(RotIndex3),
                          .EstimEn(EstimEn),
                          .HDataMult(HDataMult),
                          .RoundLSB(RoundLSB),
                          .PtCoeff(PtCoeff),
                          .ReadFromH(ReadFromH),
                          .DCClear(DCClear),
                          .SelIQPhase(SelIQPhase),
                          .PilotStore(PilotStore),
                          .PilotRead(PilotRead),
                          .PreambleCoeff(PreambleCoeff),
                          .SmoothCoeff0(SmoothCoeff0),
                          .SmoothCoeff1(SmoothCoeff1),
                          .SmoothCoeff2(SmoothCoeff2),
                          .SmoothCoeff3(SmoothCoeff3),
                          .SmoothCoeff4(SmoothCoeff4),
                          .SmoothCoeff5(SmoothCoeff5),
                          .SmoothCoeff6(SmoothCoeff6),
                          .SmoothCoeff7(SmoothCoeff7),
                          .SmoothCoeff8(SmoothCoeff8),
                          .SmoothCoeff9(SmoothCoeff9),
                          .SmoothCoeff10(SmoothCoeff10),
                          .SmoothCoeff11(SmoothCoeff11),
                          .SmoothCoeffRS(SmoothCoeffRS),
                          .FFTBufReadDataRe(FFTBufRdDataReRx0),
                          .FFTBufReadDataIm(FFTBufRdDataImRx0),
                          .HBufRdDataRe0(HBufRdDataRe0),
                          .HBufRdDataIm0(HBufRdDataIm0),
                          .HBufRdDataRe1(HBufRdDataRe1),
                          .HBufRdDataIm1(HBufRdDataIm1),
                          .HBufRdDataRe2(HBufRdDataRe2),
                          .HBufRdDataIm2(HBufRdDataIm2),
                          .HBufRdDataRe3(HBufRdDataRe3),
                          .HBufRdDataIm3(HBufRdDataIm3),
                          .HBufReadDataEnIn(HBufRdDataEnIn),

                          //Output
                          .HBufWrDataRe0(HBufWrDataRe0),
                          .HBufWrDataIm0(HBufWrDataIm0),
                          .HBufWrDataRe1(HBufWrDataRe1),
                          .HBufWrDataIm1(HBufWrDataIm1),
                          .HBufWrDataRe2(HBufWrDataRe2),
                          .HBufWrDataIm2(HBufWrDataIm2),
                          .HBufWrDataRe3(HBufWrDataRe3),
                          .HBufWrDataIm3(HBufWrDataIm3)
                         );


//Instantiate EstimController
EstimController # (
                    //Parameters
                   .NSTS_PARAM(NSTS_PARAM)
                   ) U_EstimController (
                                //Inputs
                                .nPhyRst(nPhyRst),
                                .PhyClk(PhyClk),
                                .CfgSmoothFilterSet(CfgSmoothFilterSet),
                                .NShiftLTF(NShiftLTF),
                                .RxNsts(RxNsts),
                                .ReceptionMode(ReceptionMode),
                                .SymbolType(SymbolType),
                                .RUType(RUType),
                                .RUIndex(RUIndex),
                                .FirstLTF(FirstLTF),
                                .StartSignalP(StartSignalP),
                                .SmoothEn(SmoothEn),
                                .SmoothfromHP(SmoothfromHP),
                                .LastLTF(LastLTF),
                                .FrameNDP(FrameNDP),
                                .EstimEn(EstimEn),
`ifdef RW_MUMIMO_RX_EN
                                .HEMuMIMOEn(HEMuMIMOEn),
`endif // RW_MUMIMO_RX_EN
                                //Outputs
                                .BlockEn(BlockEn),
                                .FFTBufRdAddr(FFTBufRdAddr),
                                .FFTBufRdAddrEnOut(FFTBufRdAddrEnOut),
                                .HBufWrAddr(HBufWrAddr),
                                .HBufWrEn0(HBufWrEn0),
                                .HBufWrEn1(HBufWrEn1),
                                .HBufWrEn2(HBufWrEn2),
                                .HBufWrEn3(HBufWrEn3),
                                .HBufWrAddrEnOut(HBufWrAddrEn),
                                .HBufRdAddr(HBufRdAddr),
                                .HBufRdAddrEnOut(HBufRdEn),
                                .HDataMult(HDataMult),
                                .RoundLSB(RoundLSB),
                                .PreambleCoeff(PreambleCoeff),
                                .PtCoeff(PtCoeff),
                                .ReadFromH(ReadFromH),
                                .DCClear(DCClear),
                                .SelIQPhase(SelIQPhase),
                                .PilotStore(PilotStore),
                                .PilotRead(PilotRead),
                                .DivByJ(DivByJ),
                                .MultByJ(MultByJ),
                                .RotIndex0(RotIndex0),
                                .RotIndex1(RotIndex1),
                                .RotIndex2(RotIndex2),
                                .RotIndex3(RotIndex3),
                                .RotQuad0(RotQuad0),
                                .RotQuad1(RotQuad1),
                                .RotQuad2(RotQuad2),
                                .RotQuad3(RotQuad3),
                                .RotDataEnIn(RotDataEnIn),
                                .RotDataEnOut(RotDataEnOut),
                                .PilotAvEn(PilotAvEn),
                                .PilotAvSCIndex(PilotAvSCIndex),
                                .PilotAvDataInValid(PilotAvDataInValid),
                                .ShiftIn(ShiftIn),
                                .SmoothFilterEn(SmoothFilterEn),
                                .SmoothCoeff0(SmoothCoeff0),
                                .SmoothCoeff1(SmoothCoeff1),
                                .SmoothCoeff2(SmoothCoeff2),
                                .SmoothCoeff3(SmoothCoeff3),
                                .SmoothCoeff4(SmoothCoeff4),
                                .SmoothCoeff5(SmoothCoeff5),
                                .SmoothCoeff6(SmoothCoeff6),
                                .SmoothCoeff7(SmoothCoeff7),
                                .SmoothCoeff8(SmoothCoeff8),
                                .SmoothCoeff9(SmoothCoeff9),
                                .SmoothCoeff10(SmoothCoeff10),
                                .SmoothCoeff11(SmoothCoeff11),
                                .SmoothCoeffRS(SmoothCoeffRS),
                                .EstimDoneP(EstimDoneP),
                                .SmthDoneP(SmthDoneP),
                                .DataChannelEnOut(DataChannelEnOut)
                                );

endmodule // ChEstSmthTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
