//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 37286 $
// $Date: 2019-01-23 11:08:24 +0100 (Wed, 23 Jan 2019) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Cordic Index & Quadrant Computation Module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/CordicIndQdComp.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module CordicIndQdComp (

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                                   nPhyRst, // Active Low Reset
            input   wire                                   PhyClk,  // PHY Clock

            ///////////////////////////////////////////////
            // Control Signal
            ///////////////////////////////////////////////
            input   wire                                   Enable, // Block Enable
            input   wire                                   Sel,    // LUT selection: 0=non HE, 1=HE

            ///////////////////////////////////////////////
            // LUT Address
            ///////////////////////////////////////////////
            input   wire       [5:0]                       LUTAddr, // For LUT

            ///////////////////////////////////////////////
            // Quadrant values
            ///////////////////////////////////////////////
            output  wire       [3:0]                       Index0, // Index for Cordic 0
            output  reg        [3:0]                       Index1, // Index for Cordic 1
            output  reg        [3:0]                       Index2, // Index for Cordic 2
            output  reg        [3:0]                       Index3, // Index for Cordic 3
            output  wire       [1:0]                       Quad0,  // Quadrant for Cordic 0
            output  reg        [1:0]                       Quad1,  // Quadrant for Cordic 1
            output  reg        [1:0]                       Quad2,  // Quadrant for Cordic 2
            output  reg        [1:0]                       Quad3   // Quadrant for Cordic 3
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [3:0]               Index1Int;
reg                [3:0]               Index2Int;
reg                [3:0]               Index3Int;
reg                [1:0]               Quad1Int;
reg                [1:0]               Quad2Int;
reg                [1:0]               Quad3Int;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Index Mapping LUT
assign Index0 = 4'b0;

always @ (*)
   begin: Index_LUT
      if (Sel) // HE format
      begin
        case (LUTAddr[3:0])

           4'd0: begin
              Index1Int = 4'd0;
              Index2Int = 4'd0;
              Index3Int = 4'd0;
           end

           4'd1: begin
              Index1Int = 4'd14;
              Index2Int = 4'd15;
              Index3Int = 4'd13;
           end

           4'd2: begin
              Index1Int = 4'd12;
              Index2Int = 4'd14;
              Index3Int = 4'd10;
           end

           4'd3: begin
              Index1Int = 4'd10;
              Index2Int = 4'd13;
              Index3Int = 4'd7;
           end

           4'd4: begin
              Index1Int = 4'd8;
              Index2Int = 4'd12;
              Index3Int = 4'd4;
           end

           4'd5: begin
              Index1Int = 4'd6;
              Index2Int = 4'd11;
              Index3Int = 4'd1;
           end

           4'd6: begin
              Index1Int = 4'd4;
              Index2Int = 4'd10;
              Index3Int = 4'd14;
           end

           4'd7: begin
              Index1Int = 4'd2;
              Index2Int = 4'd9;
              Index3Int = 4'd11;
           end

           4'd8: begin
              Index1Int = 4'd0;
              Index2Int = 4'd8;
              Index3Int = 4'd8;
           end

           4'd9: begin
              Index1Int = 4'd14;
              Index2Int = 4'd7;
              Index3Int = 4'd5;
           end

           4'd10: begin
              Index1Int = 4'd12;
              Index2Int = 4'd6;
              Index3Int = 4'd2;
           end

           4'd11: begin
              Index1Int = 4'd10;
              Index2Int = 4'd5;
              Index3Int = 4'd15;
           end

           4'd12: begin
              Index1Int = 4'd8;
              Index2Int = 4'd4;
              Index3Int = 4'd12;
           end

           4'd13: begin
              Index1Int = 4'd6;
              Index2Int = 4'd3;
              Index3Int = 4'd9;
           end

           4'd14: begin
              Index1Int = 4'd4;
              Index2Int = 4'd2;
              Index3Int = 4'd6;
           end

           default: begin
              Index1Int = 4'd2;
              Index2Int = 4'd1;
              Index3Int = 4'd3;
           end

        endcase
      end
      else
        case (LUTAddr[1:0])

           2'd0: begin
              Index1Int = 4'd0;
              Index2Int = 4'd0;
              Index3Int = 4'd0;
           end

           2'd1: begin
              Index1Int = 4'd8;
              Index2Int = 4'd12;
              Index3Int = 4'd4;
           end

           2'd2: begin
              Index1Int = 4'd0;
              Index2Int = 4'd8;
              Index3Int = 4'd8;
           end

           default: begin
              Index1Int = 4'd8;
              Index2Int = 4'd4;
              Index3Int = 4'd12;
           end

        endcase
      begin
      end
   end // Index_LUT

// Quadrant Mapping LUT
assign Quad0 = 2'b00;

always @ (*)
   begin: Quad_LUT
      if (Sel) // HE format
      begin
         case (LUTAddr[5:0])
                                 // 00 = 1; 01 = j; 10 = -1; 11 = -j;
            6'd0: begin
               Quad1Int = 2'b00; //  1
               Quad2Int = 2'b00; //  1
               Quad3Int = 2'b00; //  1
            end

            6'd1: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b11; // -j
            end

            6'd2: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b11; // -j
            end

            6'd3: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b11; // -j
            end

            6'd4: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b11; // -j
            end

            6'd5: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b11; // -j
            end

            6'd6: begin
               Quad1Int = 2'b11; // -j
               Quad2Int = 2'b11; // -j
               Quad3Int = 2'b10; // -1
            end

            6'd7: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b10;  // -1
            end

            6'd8: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b10;  // -1
            end

            6'd9: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b10;  // -1
            end

            6'd10: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b10;  // -1
            end

            6'd11: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd12: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd13: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd14: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd15: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd16: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b11;  // -j
               Quad3Int = 2'b01;  //  j
            end

            6'd17: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b00;  //  1
            end

            6'd18: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b00;  //  1
            end

            6'd19: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b00;  //  1
            end

            6'd20: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b00;  //  1
            end

            6'd21: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b00;  //  1
            end

            6'd22: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b11;  // -j
            end

            6'd23: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b11;  // -j
            end

            6'd24: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b11;  // -j
            end

            6'd25: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b11;  // -j
            end

            6'd26: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b11;  // -j
            end

            6'd27: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd28: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd29: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd30: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd31: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd32: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b10;  // -1
               Quad3Int = 2'b10;  // -1
            end

            6'd33: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b01;  //  j
            end

            6'd34: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b01;  //  j
            end

            6'd35: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b01;  //  j
            end

            6'd36: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b01;  //  j
            end

            6'd37: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b01;  //  j
            end

            6'd38: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b00;  //  1
            end

            6'd39: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b00;  //  1
            end

            6'd40: begin
               Quad1Int = 2'b11;  // -j
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b00;  //  1
            end

            6'd41: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b00;  //  1
            end

            6'd42: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b00;  //  1
            end

            6'd43: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd44: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd45: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd46: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd47: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd48: begin
               Quad1Int = 2'b10;  // -1
               Quad2Int = 2'b01;  //  j
               Quad3Int = 2'b11;  // -j
            end

            6'd49: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b10;  // -1
            end

            6'd50: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b10;  // -1
            end

            6'd51: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b10;  // -1
            end

            6'd52: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b10;  // -1
            end

            6'd53: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b10;  // -1
            end

            6'd54: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b01;  //  j
            end

            6'd55: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b01;  //  j
            end

            6'd56: begin
               Quad1Int = 2'b01;  //  j
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b01;  //  j
            end

            6'd57: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b01;  //  j
            end

            6'd58: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b01;  //  j
            end

            6'd59: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b00;  //  1
            end

            6'd60: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b00;  //  1
            end

            6'd61: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b00;  //  1
            end

            6'd62: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b00;  //  1
            end

            default: begin
               Quad1Int = 2'b00;  //  1
               Quad2Int = 2'b00;  //  1
               Quad3Int = 2'b00;  //  1
            end

         endcase
      end
      else
      begin
         case (LUTAddr[3:0])

            4'd0: begin
               Quad1Int = 2'b00; // 00 = 1; 01 = j; 10 = -1; 11 = -j;
               Quad2Int = 2'b00;
               Quad3Int = 2'b00;
            end

            4'd1: begin
               Quad1Int = 2'b11;
               Quad2Int = 2'b11;
               Quad3Int = 2'b11;
            end

            4'd2: begin
               Quad1Int = 2'b11;
               Quad2Int = 2'b11;
               Quad3Int = 2'b10;
            end

            4'd3: begin
               Quad1Int = 2'b10;
               Quad2Int = 2'b11;
               Quad3Int = 2'b01;
            end

            4'd4: begin
               Quad1Int = 2'b10;
               Quad2Int = 2'b11;
               Quad3Int = 2'b01;
            end

            4'd5: begin
               Quad1Int = 2'b01;
               Quad2Int = 2'b10;
               Quad3Int = 2'b00;
            end

            4'd6: begin
               Quad1Int = 2'b01;
               Quad2Int = 2'b10;
               Quad3Int = 2'b11;
            end

            4'd7: begin
               Quad1Int = 2'b00;
               Quad2Int = 2'b10;
               Quad3Int = 2'b10;
            end

            4'd8: begin
               Quad1Int = 2'b00;
               Quad2Int = 2'b10;
               Quad3Int = 2'b10;
            end

            4'd9: begin
               Quad1Int = 2'b11;
               Quad2Int = 2'b01;
               Quad3Int = 2'b01;
            end

            4'd10: begin
               Quad1Int = 2'b11;
               Quad2Int = 2'b01;
               Quad3Int = 2'b00;
            end

            4'd11: begin
               Quad1Int = 2'b10;
               Quad2Int = 2'b01;
               Quad3Int = 2'b11;
            end

            4'd12: begin
               Quad1Int = 2'b10;
               Quad2Int = 2'b01;
               Quad3Int = 2'b11;
            end

            4'd13: begin
               Quad1Int = 2'b01;
               Quad2Int = 2'b00;
               Quad3Int = 2'b10;
            end

            4'd14: begin
               Quad1Int = 2'b01;
               Quad2Int = 2'b00;
               Quad3Int = 2'b01;
            end

            default: begin
               Quad1Int = 2'b00;
               Quad2Int = 2'b00;
               Quad3Int = 2'b00;
            end

         endcase
      end
   end // Quad_LUT


// Registering Outputs
always @ (posedge PhyClk or negedge nPhyRst)
   begin: Index_Output_Blk
      if(nPhyRst == 1'b0) begin
         Index1 <= 4'b0000;
         Index2 <= 4'b0000;
         Index3 <= 4'b0000;
      end
      else if (Enable == 1'b0) begin
         Index1 <= 4'b0000;
         Index2 <= 4'b0000;
         Index3 <= 4'b0000;
      end
      else begin
         Index1 <= Index1Int;
         Index2 <= Index2Int;
         Index3 <= Index3Int;
      end
   end // Index_Output_Blk

always @ (posedge PhyClk or negedge nPhyRst)
   begin: Quad_Output_Blk
      if(nPhyRst == 1'b0) begin
         Quad1 <= 2'b00;
         Quad2 <= 2'b00;
         Quad3 <= 2'b00;
      end
      else if (Enable == 1'b0) begin
         Quad1 <= 2'b00;
         Quad2 <= 2'b00;
         Quad3 <= 2'b00;
      end
      else begin
         Quad1 <= Quad1Int;
         Quad2 <= Quad2Int;
         Quad3 <= Quad3Int;
      end
   end // Quad_Output_Blk

endmodule // CordicIndQdComp

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
