//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 37172 $
// $Date: 2019-01-16 18:30:47 +0100 (Wed, 16 Jan 2019) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Cordic ROM Module - stores Delta values
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/CordicROM.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module CordicROM #(parameter ITERATION = 13)
                  (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            input   wire [3:0]           Index,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output reg [ITERATION - 1:0] Delta //For Cordic Rotation.
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam DELTA_0   = 'b1000011010001; // 0         ( 0)
localparam DELTA_1   = 'b0011010001001; //           ( 4)
localparam DELTA_2   = 'b0110111101001; // pi/16     ( 8)
localparam DELTA_3   = 'b1111110111001; //           (12)
localparam DELTA_4   = 'b0101100100101; // pi/8      (16)
localparam DELTA_5   = 'b1100011010101; //           (20)
localparam DELTA_6   = 'b0111010001101; // 3pi/16    (24)
localparam DELTA_7   = 'b1110111101101; //           (28)
localparam DELTA_8   = 'b0111110000011; // pi/4      (32)
localparam DELTA_9   = 'b0001000010011; //           (36)
localparam DELTA_10  = 'b1000101110011; // 5pi/16    (40)
localparam DELTA_11  = 'b0011100101011; //           (44)
localparam DELTA_12  = 'b1010011011011; // 3pi/8     (48)
localparam DELTA_13  = 'b0000001000111; //           (52)
localparam DELTA_14  = 'b1001000010111; // 7pi/16    (56)
localparam DELTA_15  = 'b1100101110111; //           (60)

//                       RTL                   |                Matlab     
//                                             | delta256 = [ 
//        (0)       1000011010001  bit-reverse   +1 -1 -1 -1 +1 -1 +1 +1 -1 -1 -1 -1 +1
//                  1100100110001  bit-reverse   +1 -1 -1 -1 +1 +1 -1 -1 +1 -1 -1 +1 +1
//                  0110001110001  bit-reverse   +1 -1 -1 -1 +1 +1 +1 -1 -1 -1 +1 +1 -1
//                  0001111110001  bit-reverse   +1 -1 -1 -1 +1 +1 +1 +1 +1 +1 -1 -1 -1
//        (4)       0011010001001  bit-reverse   +1 -1 -1 +1 -1 -1 -1 +1 -1 +1 +1 -1 -1
//                  1111101001001  bit-reverse   +1 -1 -1 +1 -1 -1 +1 -1 +1 +1 +1 +1 +1
//                  1000100101001  bit-reverse   +1 -1 -1 +1 -1 +1 -1 -1 +1 -1 -1 -1 +1
//                  1100001101001  bit-reverse   +1 -1 -1 +1 -1 +1 +1 -1 -1 -1 -1 +1 +1
//        (8)       0110111101001  bit-reverse   +1 -1 -1 +1 -1 +1 +1 +1 +1 -1 +1 +1 -1
//                  0001010011001  bit-reverse   +1 -1 -1 +1 +1 -1 -1 +1 -1 +1 -1 -1 -1
//                  0101101011001  bit-reverse   +1 -1 -1 +1 +1 -1 +1 -1 +1 +1 -1 +1 -1
//                  1011000111001  bit-reverse   +1 -1 -1 +1 +1 +1 -1 -1 -1 +1 +1 -1 +1
//       (12)       1111110111001  bit-reverse   +1 -1 -1 +1 +1 +1 -1 +1 +1 +1 +1 +1 +1
//                  1000111111001  bit-reverse   +1 -1 -1 +1 +1 +1 +1 +1 +1 -1 -1 -1 +1
//                  1010110000101  bit-reverse   +1 -1 +1 -1 -1 -1 -1 +1 +1 -1 +1 -1 +1
//                  1110011000101  bit-reverse   +1 -1 +1 -1 -1 -1 +1 +1 -1 -1 +1 +1 +1
// pi/8  (16)       0101100100101  bit-reverse   +1 -1 +1 -1 -1 +1 -1 -1 +1 +1 -1 +1 -1
//                  0011001100101  bit-reverse   +1 -1 +1 -1 -1 +1 +1 -1 -1 +1 +1 -1 -1
//                  0111111100101  bit-reverse   +1 -1 +1 -1 -1 +1 +1 +1 +1 +1 +1 +1 -1
//                  1000110010101  bit-reverse   +1 -1 +1 -1 +1 -1 -1 +1 +1 -1 -1 -1 +1
//       (20)       1100011010101  bit-reverse   +1 -1 +1 -1 +1 -1 +1 +1 -1 -1 -1 +1 +1
//                  1010100110101  bit-reverse   +1 -1 +1 -1 +1 +1 -1 -1 +1 -1 +1 -1 +1
//                  0001001110101  bit-reverse   +1 -1 +1 -1 +1 +1 +1 -1 -1 +1 -1 -1 -1
//                  0101111110101  bit-reverse   +1 -1 +1 -1 +1 +1 +1 +1 +1 +1 -1 +1 -1
//       (24)       0111010001101  bit-reverse   +1 -1 +1 +1 -1 -1 -1 +1 -1 +1 +1 +1 -1
//                  1000011001101  bit-reverse   +1 -1 +1 +1 -1 -1 +1 +1 -1 -1 -1 -1 +1
//                  1100100101101  bit-reverse   +1 -1 +1 +1 -1 +1 -1 -1 +1 -1 -1 +1 +1
//                  1010001101101  bit-reverse   +1 -1 +1 +1 -1 +1 +1 -1 -1 -1 +1 -1 +1
//       (28)       1110111101101  bit-reverse   +1 -1 +1 +1 -1 +1 +1 +1 +1 -1 +1 +1 +1
//                  0101010011101  bit-reverse   +1 -1 +1 +1 +1 -1 -1 +1 -1 +1 -1 +1 -1
//                  0011101011101  bit-reverse   +1 -1 +1 +1 +1 -1 +1 -1 +1 +1 +1 -1 -1
//                  1111000111101  bit-reverse   +1 -1 +1 +1 +1 +1 -1 -1 -1 +1 +1 +1 +1
// pi/4  (32)       0111110000011  bit-reverse   +1 +1 -1 -1 -1 -1 -1 +1 +1 +1 +1 +1 -1
//                  0000111000011  bit-reverse   +1 +1 -1 -1 -1 -1 +1 +1 +1 -1 -1 -1 -1
//                  1100010100011  bit-reverse   +1 +1 -1 -1 -1 +1 -1 +1 -1 -1 -1 +1 +1
//                  1010101100011  bit-reverse   +1 +1 -1 -1 -1 +1 +1 -1 +1 -1 +1 -1 +1
//       (36)       0001000010011  bit-reverse   +1 +1 -1 -1 +1 -1 -1 -1 -1 +1 -1 -1 -1
//                  0101110010011  bit-reverse   +1 +1 -1 -1 +1 -1 -1 +1 +1 +1 -1 +1 -1
//                  0011011010011  bit-reverse   +1 +1 -1 -1 +1 -1 +1 +1 -1 +1 +1 -1 -1
//                  0111100110011  bit-reverse   +1 +1 -1 -1 +1 +1 -1 -1 +1 +1 +1 +1 -1
//       (40)       1000101110011  bit-reverse   +1 +1 -1 -1 +1 +1 +1 -1 +1 -1 -1 -1 +1
//                  1010000001011  bit-reverse   +1 +1 -1 +1 -1 -1 -1 -1 -1 -1 +1 -1 +1
//                  1110110001011  bit-reverse   +1 +1 -1 +1 -1 -1 -1 +1 +1 -1 +1 +1 +1
//                  0101011001011  bit-reverse   +1 +1 -1 +1 -1 -1 +1 +1 -1 +1 -1 +1 -1
//       (44)       0011100101011  bit-reverse   +1 +1 -1 +1 -1 +1 -1 -1 +1 +1 +1 -1 -1
//                  0111001101011  bit-reverse   +1 +1 -1 +1 -1 +1 +1 -1 -1 +1 +1 +1 -1
//                  1000000011011  bit-reverse   +1 +1 -1 +1 +1 -1 -1 -1 -1 -1 -1 -1 +1
//                  1100110011011  bit-reverse   +1 +1 -1 +1 +1 -1 -1 +1 +1 -1 -1 +1 +1
// 3pi/8 (48)       1010011011011  bit-reverse   +1 +1 -1 +1 +1 -1 +1 +1 -1 -1 +1 -1 +1
//                  0001100111011  bit-reverse   +1 +1 -1 +1 +1 +1 -1 -1 +1 +1 -1 -1 -1
//                  0101001111011  bit-reverse   +1 +1 -1 +1 +1 +1 +1 -1 -1 +1 -1 +1 -1
//                  0111000000111  bit-reverse   +1 +1 +1 -1 -1 -1 -1 -1 -1 +1 +1 +1 -1
//       (52)       0000001000111  bit-reverse   +1 +1 +1 -1 -1 -1 +1 -1 -1 -1 -1 -1 -1
//                  0100111000111  bit-reverse   +1 +1 +1 -1 -1 -1 +1 +1 +1 -1 -1 +1 -1
//                  1010010100111  bit-reverse   +1 +1 +1 -1 -1 +1 -1 +1 -1 -1 +1 -1 +1
//                  1110101100111  bit-reverse   +1 +1 +1 -1 -1 +1 +1 -1 +1 -1 +1 +1 +1
//       (56)       1001000010111  bit-reverse   +1 +1 +1 -1 +1 -1 -1 -1 -1 +1 -1 -1 +1
//                  0011110010111  bit-reverse   +1 +1 +1 -1 +1 -1 -1 +1 +1 +1 +1 -1 -1
//                  0111011010111  bit-reverse   +1 +1 +1 -1 +1 -1 +1 +1 -1 +1 +1 +1 -1
//                  0000010110111  bit-reverse   +1 +1 +1 -1 +1 +1 -1 +1 -1 -1 -1 -1 -1
//       (60)       1100101110111  bit-reverse   +1 +1 +1 -1 +1 +1 +1 -1 +1 -1 -1 +1 +1
//                  1110000001111  bit-reverse   +1 +1 +1 +1 -1 -1 -1 -1 -1 -1 +1 +1 +1
//                  1001110001111  bit-reverse   +1 +1 +1 +1 -1 -1 -1 +1 +1 +1 -1 -1 +1
//                  0011011001111  bit-reverse   +1 +1 +1 +1 -1 -1 +1 +1 -1 +1 +1 -1 -1
// pi/2  (64)       0111100101111  bit-reverse   +1 +1 +1 +1 -1 +1 -1 -1 +1 +1 +1 +1 -1
//                                                 ]

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//This is a simple LUT which stores the Delta values for the Cordic
always @ (*)
   begin: Delta_Blk
      case (Index)
         4'd0   : Delta = DELTA_0[ITERATION - 1:0];
         4'd1   : Delta = DELTA_1[ITERATION - 1:0];
         4'd2   : Delta = DELTA_2[ITERATION - 1:0];
         4'd3   : Delta = DELTA_3[ITERATION - 1:0];
         4'd4   : Delta = DELTA_4[ITERATION - 1:0];
         4'd5   : Delta = DELTA_5[ITERATION - 1:0];
         4'd6   : Delta = DELTA_6[ITERATION - 1:0];
         4'd7   : Delta = DELTA_7[ITERATION - 1:0];
         4'd8   : Delta = DELTA_8[ITERATION - 1:0];
         4'd9   : Delta = DELTA_9[ITERATION - 1:0];
         4'd10  : Delta = DELTA_10[ITERATION - 1:0];
         4'd11  : Delta = DELTA_11[ITERATION - 1:0];
         4'd12  : Delta = DELTA_12[ITERATION - 1:0];
         4'd13  : Delta = DELTA_13[ITERATION - 1:0];
         4'd14  : Delta = DELTA_14[ITERATION - 1:0];
         default: Delta = DELTA_15[ITERATION - 1:0];
      endcase
   end //Delta_Blk

endmodule //CordicROM

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
