//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 37172 $
// $Date: 2019-01-16 18:30:47 +0100 (Wed, 16 Jan 2019) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Cordic Top Level File
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/CordicTop.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module CordicTop #(parameter ITERATION = 13, // ITERATION : Number of Cordic iterations.
                   parameter DATAWIDTH = 13  // DATAWIDTH : Input data size.
                  )(

            ///////////////////////////////////////////////
            // Clock and reset
            ///////////////////////////////////////////////
            input   wire                                   nPhyRst, // Active LOW Reset.
            input   wire                                   PhyClk,  // PHY Clock.

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Control Signals
            input   wire                                   CordicEn, // Active HIGH Enable
            input   wire              [3:0]                Index,    // Index for Cordic Rotation
            input   wire              [1:0]                QuadRot,  // Quadrant fixing value

            //Data
            input   wire   signed     [DATAWIDTH-1:0]      ReDataIn, // Real part of Input
            input   wire   signed     [DATAWIDTH-1:0]      ImDataIn, // Imaginary part of Input

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  wire signed [DATAWIDTH-1:0]             ReDataOut, // Real part of Output
            output  wire signed [DATAWIDTH-1:0]             ImDataOut  // Imaginary part of Output
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire         [DATAWIDTH-1:0]     ReDataInPreRot_w;
wire         [DATAWIDTH-1:0]     ImDataInPreRot_w;
wire         [ITERATION-1:0]     Delta;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

CordicQuadRot #(
               .DATAWIDTH(DATAWIDTH)
               )
               U_CordicQuadRot (
                                //Inputs
                                .QuadRot(QuadRot),
                                .ReDataIn(ReDataIn),
                                .ImDataIn(ImDataIn),
                                //Outputs
                                .ReDataOut(ReDataInPreRot_w),
                                .ImDataOut(ImDataInPreRot_w)
                               );

CordicROM #(
           .ITERATION(ITERATION)
           )
            U_CordicROM (
                        //Input
                        .Index(Index),
                        //Output
                        .Delta(Delta)
                        );


CordicIndRot #(.ITERATION(ITERATION),
               .DATAWIDTH(DATAWIDTH)
               )
               U_CordicIndRot (
                              //Inputs
                              .PhyClk(PhyClk),
                              .nPhyRst(nPhyRst),
                              .Enable(CordicEn),
                              .ReDataIn($signed(ReDataInPreRot_w)),
                              .ImDataIn($signed(ImDataInPreRot_w)),
                              .DeltaIn(Delta),
                              //Outputs
                              .ReDataOut(ReDataOut),
                              .ImDataOut(ImDataOut)
                              );

endmodule //CordicTop

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
