//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// ---------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top Level of Channel Estimation and Smoothing Controller
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// ---------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/EstimController.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module EstimController #(parameter NSTS_PARAM    = 2  // Max Spatial Streams supported
                        )(

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                                   nPhyRst,  // Active Low Reset
            input   wire                                   PhyClk,   // Phy Clock

            ///////////////////////////////////////////////
            // Config register
            ///////////////////////////////////////////////
            input   wire              [1:0]                CfgSmoothFilterSet, // Smooth Filter Set
            
            ///////////////////////////////////////////////
            // Rx FD FSM Interface
            ///////////////////////////////////////////////
            input   wire              [1:0]                RxNsts,             // No. of Space Time Steams
            input   wire              [3:0]                NShiftLTF,          // No. of LTF to shift for Mu-MIMO
            input   wire              [3:0]                ReceptionMode,      // Mode of Current Pkt
            input   wire              [2:0]                SymbolType,         // Type of Symbol
            input   wire              [2:0]                RUType,             // Type of RU (0:26, 1:52, 2:106, 3:242, 4:484)
            input   wire              [5:0]                RUIndex,            // RU allocation index (up to 37)
            input   wire                                   FrameNDP,           // Indicates frame is NDP
            input   wire                                   FirstLTF,           // Indicates First LTF
            input   wire                                   LastLTF,            // Indicates Last LTF
            input   wire                                   SmoothEn,           // Enable smoothing
            input   wire                                   SmoothfromHP,       // Start Smoothing Only
            input   wire                                   StartSignalP,       // Start of a symbol
            input   wire                                   EstimEn,            // Enable Ch Est
`ifdef RW_MUMIMO_RX_EN
            input   wire                                   HEMuMIMOEn,         // Indicates frame is HE Mu-MIMO
`endif // RW_MUMIMO_RX_EN
            //
            output  wire                                   EstimDoneP,         // To Rx FD FSM
            output  wire                                   SmthDoneP,          // To Rx FD FSM
            output  wire                                   DataChannelEnOut,   // Enable G Matrix Comp

            ///////////////////////////////////////////////
            // FFT Memory Interface
            ///////////////////////////////////////////////
            output  wire       [9:0]                       FFTBufRdAddr,      // Read Address
            output  wire                                   FFTBufRdAddrEnOut, // Qualifies Address 

            ///////////////////////////////////////////////
            // H Memory interface
            ///////////////////////////////////////////////
            output  wire       [9:0]                       HBufWrAddr,       // Write Address
            output  wire       [1:0]                       HBufWrEn0,        // Write Enable Buffer 0
            output  wire       [1:0]                       HBufWrEn1,        // Write Enable Buffer 1
            output  wire       [1:0]                       HBufWrEn2,        // Write Enable Buffer 2
            output  wire       [1:0]                       HBufWrEn3,        // Write Enable Buffer 3
            output  wire                                   HBufWrAddrEnOut,  // Qualifies Address 
            //
            output  wire       [9:0]                       HBufRdAddr,       // Read Address
            output  wire                                   HBufRdAddrEnOut,  // Qualifies Address 

            ///////////////////////////////////////////////
            // Interface to ChannelEstStream Module
            ///////////////////////////////////////////////
            output  wire       [3:0]                       BlockEn,          // Block enable
            output  wire       [1:0]                       HDataMult,        // Shifting
            output  wire       [1:0]                       RoundLSB,         // Rounding  
            output  wire                                   PreambleCoeff,    // Preamble Value
            output  wire       [3:0]                       PtCoeff,          // Pt Matrix Value
            output  wire                                   ReadFromH,        // Read data from H
            output  wire                                   DCClear,          // Clear DC value
            output  wire                                   SelIQPhase,       // Select I or Q phase for filter
            output  wire                                   PilotStore,       // Store pilots
            output  wire                                   PilotRead,        // Read pilots

            ///////////////////////////////////////////////
            // Interface to Rotation Cordic Modules
            ///////////////////////////////////////////////
            output  wire       [3:0]                       RotIndex0,        // Cordic0 Index
            output  wire       [3:0]                       RotIndex1,        // Cordic1 Index
            output  wire       [3:0]                       RotIndex2,        // Cordic2 Index
            output  wire       [3:0]                       RotIndex3,        // Cordic3 Index
            output  wire       [1:0]                       RotQuad0,         // Cordic0 Quad
            output  wire       [1:0]                       RotQuad1,         // Cordic1 Quad
            output  wire       [1:0]                       RotQuad2,         // Cordic2 Quad
            output  wire       [1:0]                       RotQuad3,         // Cordic3 Quad
            //
            output  wire                                   RotDataEnIn,      // Qualifies Data In
            output  wire                                   RotDataEnOut,     // Qualifies Data Out
            output  wire                                   DivByJ,           // Division by j enabled when 1
            //
            output  wire                                   MultByJ,          // Multiplication by j when 1

            ///////////////////////////////////////////////
            // Interface to Pilot Averaging Block
            ///////////////////////////////////////////////
            output  wire                                   PilotAvEn,          // Enable Pilot Averaging
            output  wire       [9:0]                       PilotAvSCIndex,     // SC Index at Pilot Averaging input
            output  wire                                   PilotAvDataInValid, // Enable Pilot Averaging input

            ///////////////////////////////////////////////
            // Interface to Smoothing Block
            ///////////////////////////////////////////////
            output  wire                                   ShiftIn,        // Enables input to filter
            output  wire                                   SmoothFilterEn, // Enable smoothing filter
            output  wire signed [9:0]                      SmoothCoeff0,   // Smoothing Coeff 0
            output  wire signed [9:0]                      SmoothCoeff1,   // Smoothing Coeff 1
            output  wire signed [9:0]                      SmoothCoeff2,   // Smoothing Coeff 2
            output  wire signed [9:0]                      SmoothCoeff3,   // Smoothing Coeff 3
            output  wire signed [9:0]                      SmoothCoeff4,   // Smoothing Coeff 4
            output  wire signed [9:0]                      SmoothCoeff5,   // Smoothing Coeff 5
            output  wire signed [9:0]                      SmoothCoeff6,   // Smoothing Coeff 6
            output  wire signed [9:0]                      SmoothCoeff7,   // Smoothing Coeff 7
            output  wire signed [9:0]                      SmoothCoeff8,   // Smoothing Coeff 8
            output  wire signed [9:0]                      SmoothCoeff9,   // Smoothing Coeff 9
            output  wire signed [9:0]                      SmoothCoeff10,  // Smoothing Coeff 10
            output  wire signed [9:0]                      SmoothCoeff11,  // Smoothing Coeff 11
            output  wire        [1:0]                      SmoothCoeffRS   // Smoothing Right Shift
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
localparam CORDICLAT = 14; // Cordic Latency Value - 14 clocks

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                                   LastWriteP;
wire               [2:0]               SmoothStep;
wire    signed     [9:0]               LastPosIndex;
wire    signed     [9:0]               HWriteSCInd;
wire                                   HWriteDataEnOut;
wire                                   HWriteI;
wire                                   HWriteQ;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Instantiation of EstimRotCtrl
EstimRotCtrl # (
                   .CORDICLAT(CORDICLAT)
                  ) U_EstimRotCtrl (
                   //
                   .nPhyRst(            nPhyRst),
                   .PhyClk(             PhyClk),
                   //
                   .CfgSmoothFilterSet(    CfgSmoothFilterSet),
                   //
                   .RxNsts(             RxNsts),
                   .NShiftLTF(          NShiftLTF),
                   .ReceptionMode(      ReceptionMode),
                   .FirstLTF(           FirstLTF),
                   .StartSignalP(       StartSignalP),
                   .SymbolType(         SymbolType),
                   .RUType(             RUType),
                   .RUIndex(            RUIndex),
                   .SmoothEn(           SmoothEn),
                   .SmoothfromHP(       SmoothfromHP),
                   .EstimEn(            EstimEn),
                   .LastWriteP(         LastWriteP),
                   .FrameNDP(           FrameNDP),
`ifdef RW_MUMIMO_RX_EN
                   .HEMuMIMOEn(         HEMuMIMOEn),
`endif // RW_MUMIMO_RX_EN
                   //
                   .EstimDoneP(         EstimDoneP),
                   .SmthDoneP(          SmthDoneP),
                   .DataChannelEnOut(   DataChannelEnOut),
                   //
                   .BlockEn(            BlockEn),
                   .FFTBufRdAddrOut(    FFTBufRdAddr),
                   .FFTBufRdAddrEnOut(  FFTBufRdAddrEnOut),
                   .HBufRdAddrOut(      HBufRdAddr),
                   .HBufRdAddrEnOut(    HBufRdAddrEnOut),
                   //
                   .HDataMult(          HDataMult),
                   .RoundLSB(           RoundLSB),
                   .PreambleCoeff(      PreambleCoeff),
                   .PtCoeff(            PtCoeff),
                   .ReadFromH(          ReadFromH),
                   .DCClear(            DCClear),
                   .SelIQPhase(         SelIQPhase),
                   //
                   .DivByJ(             DivByJ),
                   .RotIndex0(          RotIndex0),
                   .RotIndex1(          RotIndex1),
                   .RotIndex2(          RotIndex2),
                   .RotIndex3(          RotIndex3),
                   .RotQuad0(           RotQuad0),
                   .RotQuad1(           RotQuad1),
                   .RotQuad2(           RotQuad2),
                   .RotQuad3(           RotQuad3),
                   .RotDataEnIn(        RotDataEnIn),
                   .RotDataEnOut(       RotDataEnOut),
                   .MultByJ(            MultByJ),
                   //
                   .PilotAvEn(          PilotAvEn),
                   .PilotAvSCIndex(     PilotAvSCIndex),
                   .PilotAvDataInValid( PilotAvDataInValid),
                   //
                   .PilotRead(          PilotRead),
                   //
                   .SmoothStep(         SmoothStep),
                   //
                   .LastPosIndex(       LastPosIndex),
                   .HWriteSCInd(        HWriteSCInd),
                   .HWriteDataEnOut(    HWriteDataEnOut),
                   .HWriteI(            HWriteI),
                   .HWriteQ(            HWriteQ),
                   //
                   .SmoothFilterEn(     SmoothFilterEn),
                   //
                   .ShiftIn(            ShiftIn),
                   .SmoothCoeff0(       SmoothCoeff0),
                   .SmoothCoeff1(       SmoothCoeff1),
                   .SmoothCoeff2(       SmoothCoeff2),
                   .SmoothCoeff3(       SmoothCoeff3),
                   .SmoothCoeff4(       SmoothCoeff4),
                   .SmoothCoeff5(       SmoothCoeff5),
                   .SmoothCoeff6(       SmoothCoeff6),
                   .SmoothCoeff7(       SmoothCoeff7),
                   .SmoothCoeff8(       SmoothCoeff8),
                   .SmoothCoeff9(       SmoothCoeff9),
                   .SmoothCoeff10(      SmoothCoeff10),
                   .SmoothCoeff11(      SmoothCoeff11),
                   .SmoothCoeffRS(      SmoothCoeffRS)
                   );

// Instantiation of HWriteCtrl
HWriteCtrl # (.NSTS_PARAM(NSTS_PARAM)
             ) U_HWriteCtrl (
                   //Inputs
                   .nPhyRst(             nPhyRst),
                   .PhyClk(              PhyClk),
                   .RxNsts(              RxNsts),
                   .ReceptionMode(       ReceptionMode),
                   .SymbolType(          SymbolType),
                   .RUType(              RUType),
                   .FrameNDP(            FrameNDP),
                   .SmoothStep(          SmoothStep),
                   .FirstLTF(            FirstLTF),
                   .LastLTF(             LastLTF),
                   .SCInd(               HWriteSCInd),
                   .HWriteDataEnOut(     HWriteDataEnOut),
                   .HWriteI(             HWriteI),
                   .HWriteQ(             HWriteQ),
                   .LastPosIndex(        LastPosIndex),
                   .EstimEn(             EstimEn),
                   .SmoothEn(            SmoothEn),

                   //Outputs
                   .LastWriteP(          LastWriteP),
                   .PilotStore(          PilotStore),
                   .HBufWrAddrOut(       HBufWrAddr),
                   .HBufWrEn0(           HBufWrEn0),
                   .HBufWrEn1(           HBufWrEn1),
                   .HBufWrEn2(           HBufWrEn2),
                   .HBufWrEn3(           HBufWrEn3),
                   .HBufWrAddrEnOut(     HBufWrAddrEnOut)
                   );

endmodule // EstimController

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
