////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top level Per Rx Chain - Up to 4 Streams instantiated
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/EstimSmoothRx.v $
// 
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module EstimSmoothRx #(parameter FFTBUFWIDTH   =  13, // Data width of the FFT memory
                       parameter HBUFDATAWIDTH =  13, // Data width of one channel coefficient
                       parameter NSTS          =   4  // Max Spatial Streams supported
                      )(

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                                  nPhyRst,  // Active Low Reset
            input   wire                                  PhyClk,   // Phy Clock

            ///////////////////////////////////////////////
            // Global Controls from RX FD FSM
            ///////////////////////////////////////////////
            input   wire              [1:0]               RxNsts,
            input   wire              [3:0]               ReceptionMode,      // Mode of Current Pkt
            input   wire              [2:0]               SymbolType,         // LTF of Current Pkt
            input   wire              [2:0]               RUType,             // Type of RU (0:26, 1:52, 2:106, 3:242, 4:484)
            input   wire                                  FirstLTF,           // Indicates First LTF
            input   wire                                  EstimEn,            // Enables Ch Est
            
            ///////////////////////////////////////////////
            // Controls from EstimRot controller
            ///////////////////////////////////////////////
            input   wire              [3:0]               BlockEn,            // Enable Block
            input   wire                                  DivByJ,             // Indicates upper 20 MHz
            input   wire                                  MultByJ,            // Indicates upper 20 MHz
            input   wire              [1:0]               HDataMult,          // Shifting
            input   wire              [1:0]               RoundLSB,           // Rounding
            input   wire              [3:0]               PtCoeff,            // Pt Matrix Value
            input   wire                                  PreambleCoeff,      // Preamble Value
            input   wire                                  ReadFromH,          // Read data from H
            input   wire                                  DCClear,            // Clear DC value
            input   wire                                  SelIQPhase,         // Select I or Q phase for filter
            input   wire                                  PilotStore,         // Store pilots in buffer
            input   wire                                  PilotRead,          // Read pilots from buffer

            ///////////////////////////////////////////////
            // Pilots Averaging Controls
            ///////////////////////////////////////////////
            input   wire                                  PilotAvEn,          // Enable Pilot Averaging
            input   wire              [9:0]               PilotAvSCIndex,     // SC Index at Pilot Averaging input
            input   wire                                  PilotAvDataInValid, // Enable Pilot Averaging input
            
            ///////////////////////////////////////////////
            // Cordic Controls
            ///////////////////////////////////////////////
            input   wire                                  RotCordicEnIn,      // Enable rotation
            input   wire              [1:0]               RotQuad0,           // Cordic0 Quad
            input   wire              [1:0]               RotQuad1,           // Cordic1 Quad
            input   wire              [1:0]               RotQuad2,           // Cordic2 Quad
            input   wire              [1:0]               RotQuad3,           // Cordic3 Quad
            input   wire              [3:0]               RotIndex0,          // Cordic0 Index
            input   wire              [3:0]               RotIndex1,          // Cordic1 Index
            input   wire              [3:0]               RotIndex2,          // Cordic2 Index
            input   wire              [3:0]               RotIndex3,          // Cordic3 Index

            ///////////////////////////////////////////////
            // Smoothing Filter interface
            ///////////////////////////////////////////////
            input   wire              [NSTS-1:0]          SmoothEnIn,    // Enable smoothing
            input   wire                                  ShiftIn,       // Enable input to filter
            input   wire   signed     [9:0]               SmoothCoeff0,  // Smoothing Coeff 0
            input   wire   signed     [9:0]               SmoothCoeff1,  // Smoothing Coeff 1
            input   wire   signed     [9:0]               SmoothCoeff2,  // Smoothing Coeff 2
            input   wire   signed     [9:0]               SmoothCoeff3,  // Smoothing Coeff 3
            input   wire   signed     [9:0]               SmoothCoeff4,  // Smoothing Coeff 4
            input   wire   signed     [9:0]               SmoothCoeff5,  // Smoothing Coeff 5
            input   wire   signed     [9:0]               SmoothCoeff6,  // Smoothing Coeff 6
            input   wire   signed     [9:0]               SmoothCoeff7,  // Smoothing Coeff 7
            input   wire   signed     [9:0]               SmoothCoeff8,  // Smoothing Coeff 8
            input   wire   signed     [9:0]               SmoothCoeff9,  // Smoothing Coeff 9
            input   wire   signed     [9:0]               SmoothCoeff10, // Smoothing Coeff 10
            input   wire   signed     [9:0]               SmoothCoeff11, // Smoothing Coeff 11
            input   wire              [1:0]               SmoothCoeffRS, // Smoothing Right Shift

            ///////////////////////////////////////////////
            // FFT Buffer
            ///////////////////////////////////////////////
            input   wire                [FFTBUFWIDTH-1:0] FFTBufReadDataRe, // FFT Memory Data Real
            input   wire                [FFTBUFWIDTH-1:0] FFTBufReadDataIm, // FFT Memory Data Imag

            ///////////////////////////////////////////////
            // H Buffer
            ///////////////////////////////////////////////
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataRe0,    // H Read Data Real buffer 0
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataIm0,    // H Read Data Imag buffer 0
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataRe1,    // H Read Data Real buffer 1
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataIm1,    // H Read Data Imag buffer 1
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataRe2,    // H Read Data Real buffer 2
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataIm2,    // H Read Data Imag buffer 2
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataRe3,    // H Read Data Real buffer 3
            input   wire              [HBUFDATAWIDTH-1:0] HBufRdDataIm3,    // H Read Data Imag buffer 3
            input   wire                                  HBufReadDataEnIn, // Qualifies Ip Data
            //
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataRe0,    // H Write Data Real buffer 0
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataIm0,    // H Write Data Imag buffer 0
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataRe1,    // H Write Data Real buffer 1
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataIm1,    // H Write Data Imag buffer 1
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataRe2,    // H Write Data Real buffer 2
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataIm2,    // H Write Data Imag buffer 2
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataRe3,    // H Write Data Real buffer 3
            output  reg               [HBUFDATAWIDTH-1:0] HBufWrDataIm3     // H Write Data Imag buffer 3
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////
// Mode
localparam [3:0] MODE_20MHZ_L     = 4'd0,
                 MODE_20MHZ_HT    = 4'd2,
                 MODE_40MHZ_HT    = 4'd3,
                 MODE_20MHZ_HE_SU = 4'd6,
                 MODE_20MHZ_HE_MU = 4'd7,
                 MODE_40MHZ_HE_SU = 4'd8,
                 MODE_40MHZ_HE_MU = 4'd9;

//Symbol Type
localparam [2:0] L_LTF    = 3'd0,
                 D_VHTLTF = 3'd1,
                 D_HTLTF  = 3'd2,
                 E_HTLTF  = 3'd3,
                 HE_1xLTF = 3'd4,
                 HE_2xLTF = 3'd5,
                 HE_4xLTF = 3'd6,
                 HE_LSIG  = 3'd7;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutRe0;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutIm0;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutRe1;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutIm1;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutRe2;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutIm2;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutRe3;
wire               [HBUFDATAWIDTH-1:0] SmoothDataOutIm3;
wire                                   PilotCopy;

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataRe0;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataIm0;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataRe1;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataIm1;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataRe2;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataIm2;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataRe3;
reg                [HBUFDATAWIDTH-1:0]   HBufReadDataIm3;

reg                [HBUFDATAWIDTH-1:0]   HBufWrDataRe0Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataIm0Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataRe1Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataIm1Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataRe2Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataIm2Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataRe3Int;
reg                [HBUFDATAWIDTH-1:0]   HBufWrDataIm3Int;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Muxing and Demuxing of FFT and H Memory Buses
// H Memory Read Bus
always @ (*)
   begin: HBuforyRead_Blk
      //Default Value
      HBufReadDataRe0 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataIm0 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataRe1 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataIm1 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataRe2 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataIm2 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataRe3 = {(HBUFDATAWIDTH){1'b0}};
      HBufReadDataIm3 = {(HBUFDATAWIDTH){1'b0}};

      case (SymbolType)

         L_LTF,HE_LSIG: begin //L_LTF always has one stream only
            HBufReadDataIm0 = HBufRdDataIm0;
            HBufReadDataRe0 = HBufRdDataRe0;
         end //L_LTF

         default: begin // D_HTLTF,D_VHTLTF
            HBufReadDataIm0 = HBufRdDataIm0;
            HBufReadDataRe0 = HBufRdDataRe0;

            if (NSTS > 32'd1) begin
               HBufReadDataIm1 = HBufRdDataIm1;
               HBufReadDataRe1 = HBufRdDataRe1;
            end

            if (NSTS > 32'd2) begin
               HBufReadDataIm2 = HBufRdDataIm2;
               HBufReadDataRe2 = HBufRdDataRe2;
            end

            if (NSTS > 32'd3) begin
               HBufReadDataIm3 = HBufRdDataIm3;
               HBufReadDataRe3 = HBufRdDataRe3;
            end
         end //D_HTLTF, D_VHTLTF

      endcase //SymbolType
   end //HBuforyRead_Blk

// Copy pilots from 1st sts to all
assign PilotCopy = PilotStore & ~RotCordicEnIn & ~SmoothEnIn[0];

generate
   if(NSTS < 32'd2) begin : NSTS1_GEN
     //H Memory Write Bus
     always @ (*)
     begin: HBufWrDataIntBlk

        HBufWrDataRe0Int = SmoothDataOutRe0;
        HBufWrDataIm0Int = SmoothDataOutIm0;
        HBufWrDataRe1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe3Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm3Int = {(HBUFDATAWIDTH){1'b0}};

     end //HBufWrDataIntBlk
   end

   else if (NSTS == 32'd2) begin : NSTS2_GEN

//H Memory Write Bus
     always @ (*)
     begin: HBufWrDataIntBlk

        HBufWrDataRe0Int = {(HBUFDATAWIDTH){1'b0}};//Default Value
        HBufWrDataIm0Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe3Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm3Int = {(HBUFDATAWIDTH){1'b0}};

        case (SymbolType)

           L_LTF,HE_LSIG: begin 
              //L_LTF always has only one stream
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;
           end //L_LTF

           default: begin // D_HTLTF, D_VHTLTF, D_HELTF
              //Write in to NSTS streams when FirstLTF is high
              //Else write in to RxNsts number of streams
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;

              if ((RxNsts > 2'b0) ) 
              begin
                 if (PilotCopy) begin
                   HBufWrDataRe1Int = SmoothDataOutRe0;
                   HBufWrDataIm1Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe1Int = SmoothDataOutRe1;
                   HBufWrDataIm1Int = SmoothDataOutIm1;
                 end
              end
           end //D_HTLTF, D_VHTLTF, D_HELTF

        endcase //SymbolType
     end //HBufWrDataIntBlk
   end

   else if (NSTS == 32'd3) begin : NSTS3_GEN

     //H Memory Write Bus
     always @ (*)
     begin: HBufWrDataIntBlk

        HBufWrDataRe0Int = {(HBUFDATAWIDTH){1'b0}};//Default Value
        HBufWrDataIm0Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe3Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm3Int = {(HBUFDATAWIDTH){1'b0}};

        case (SymbolType)

           L_LTF,HE_LSIG: begin 
              //L_LTF always has only one stream
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;
           end //L_LTF

           default: begin // D_HTLTF, D_VHTLTF, D_HELTF
              //Write in to NSTS streams when FirstLTF is high
              //Else write in to RxNsts number of streams
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;

              if ((RxNsts > 2'b0) || (FirstLTF == 1'b1)) begin
                 if (PilotCopy) begin
                   HBufWrDataRe1Int = SmoothDataOutRe0;
                   HBufWrDataIm1Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe1Int = SmoothDataOutRe1;
                   HBufWrDataIm1Int = SmoothDataOutIm1;
                 end
              end

              if ((RxNsts > 2'b1) || (FirstLTF == 1'b1)) begin
                 if (PilotCopy) begin
                   HBufWrDataRe2Int = SmoothDataOutRe0;
                   HBufWrDataIm2Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe2Int = SmoothDataOutRe2;
                   HBufWrDataIm2Int = SmoothDataOutIm2;
                 end
              end
           end //D_HTLTF, D_VHTLTF, D_HELTF

        endcase //SymbolType
     end //HBufWrDataIntBlk
   end

   else if (NSTS == 32'd4) begin : NSTS4_GEN

     //H Memory Write Bus
     always @ (*)
     begin: HBufWrDataIntBlk

        HBufWrDataRe0Int = {(HBUFDATAWIDTH){1'b0}};//Default Value
        HBufWrDataIm0Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm1Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm2Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataRe3Int = {(HBUFDATAWIDTH){1'b0}};
        HBufWrDataIm3Int = {(HBUFDATAWIDTH){1'b0}};

        case (SymbolType)

           L_LTF,HE_LSIG: begin 
              //L_LTF always has only one stream
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;
           end //L_LTF

           default: begin // D_HTLTF, D_VHTLTF, D_HELTF
              //Write in to NSTS streams when FirstLTF is high
              //Else write in to RxNsts number of streams
              HBufWrDataRe0Int = SmoothDataOutRe0;
              HBufWrDataIm0Int = SmoothDataOutIm0;

              if ((RxNsts > 2'b0) || (FirstLTF == 1'b1)) begin
                 if (PilotCopy) begin
                   HBufWrDataRe1Int = SmoothDataOutRe0;
                   HBufWrDataIm1Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe1Int = SmoothDataOutRe1;
                   HBufWrDataIm1Int = SmoothDataOutIm1;
                 end
              end

              if ((RxNsts > 2'b1) || (FirstLTF == 1'b1)) begin
                 if (PilotCopy) begin
                   HBufWrDataRe2Int = SmoothDataOutRe0;
                   HBufWrDataIm2Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe2Int = SmoothDataOutRe2;
                   HBufWrDataIm2Int = SmoothDataOutIm2;
                 end
              end

              if ((RxNsts > 2'd2) || (FirstLTF == 1'b1)) begin
                 if (PilotCopy) begin
                   HBufWrDataRe3Int = SmoothDataOutRe0;
                   HBufWrDataIm3Int = SmoothDataOutIm0;
                 end
                 else begin
                   HBufWrDataRe3Int = SmoothDataOutRe3;
                   HBufWrDataIm3Int = SmoothDataOutIm3;
                 end
              end
           end //D_HTLTF, D_VHTLTF, D_HELTF

        endcase //SymbolType
     end //HBufWrDataIntBlk
   end

endgenerate


// This data is registered to ensure that the latency on the Address, 
// Data and Enable lines are identical
always @ (posedge PhyClk or negedge nPhyRst)
   begin: HBufWriteData_Blk
      if (nPhyRst == 1'b0) begin
         HBufWrDataRe0 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm0 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe1 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm1 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe2 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm2 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe3 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm3 <= {HBUFDATAWIDTH{1'b0}};
      end
      else if ((EstimEn == 1'b0) || DCClear) begin
         HBufWrDataRe0 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm0 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe1 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm1 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe2 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm2 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataRe3 <= {HBUFDATAWIDTH{1'b0}};
         HBufWrDataIm3 <= {HBUFDATAWIDTH{1'b0}};
      end
      else begin
         HBufWrDataRe0 <= HBufWrDataRe0Int;
         HBufWrDataIm0 <= HBufWrDataIm0Int;
         HBufWrDataRe1 <= HBufWrDataRe1Int;
         HBufWrDataIm1 <= HBufWrDataIm1Int;
         HBufWrDataRe2 <= HBufWrDataRe2Int;
         HBufWrDataIm2 <= HBufWrDataIm2Int;
         HBufWrDataRe3 <= HBufWrDataRe3Int;
         HBufWrDataIm3 <= HBufWrDataIm3Int;
      end
   end //HBufWriteData_Blk

//Instantiation of up to NSTS spatial stream blocks

//Instantiate EstimSmoothStream0 - Always instantiated
EstimSmoothStream # (
                     .FFTBUFWIDTH(FFTBUFWIDTH),
                     .HBUFDATAWIDTH(HBUFDATAWIDTH)
                    ) U_EstimSmoothStream0 (
                              //Inputs
                              .nPhyRst(nPhyRst),
                              .PhyClk(PhyClk),
                              .SmoothEnIn(SmoothEnIn[0]),
                              .ShiftIn(ShiftIn),
                              .BlockEn(BlockEn[0]),
                              .DivByJ(DivByJ),
                              .MultByJ(MultByJ),
                              .ReceptionMode(ReceptionMode),
                              .SymbolType(SymbolType),
                              .RUType(RUType),
                              .PilotAvEn(PilotAvEn),
                              .PilotAvSCIndex(PilotAvSCIndex),
                              .PilotAvDataInValid(PilotAvDataInValid),
                              .RotCordicEnIn(RotCordicEnIn),
                              .RotQuad(RotQuad0),
                              .RotIndex(RotIndex0),
                              .ReadFromH(ReadFromH),
                              .SelIQPhase(SelIQPhase),
                              .PilotStore(PilotStore),
                              .PilotRead(PilotRead),
                              .HDataMult(HDataMult),
                              .RoundLSB(RoundLSB),
                              .PtCoeff(PtCoeff[0]),
                              .PreambleCoeff(PreambleCoeff),
                              .FFTBufReadDataRe(FFTBufReadDataRe),
                              .FFTBufReadDataIm(FFTBufReadDataIm),
                              .HBufReadDataRe(HBufReadDataRe0),
                              .HBufReadDataIm(HBufReadDataIm0),
                              .HBufReadDataEnIn(HBufReadDataEnIn),
                              .SmoothCoeff0(SmoothCoeff0),
                              .SmoothCoeff1(SmoothCoeff1),
                              .SmoothCoeff2(SmoothCoeff2),
                              .SmoothCoeff3(SmoothCoeff3),
                              .SmoothCoeff4(SmoothCoeff4),
                              .SmoothCoeff5(SmoothCoeff5),
                              .SmoothCoeff6(SmoothCoeff6),
                              .SmoothCoeff7(SmoothCoeff7),
                              .SmoothCoeff8(SmoothCoeff8),
                              .SmoothCoeff9(SmoothCoeff9),
                              .SmoothCoeff10(SmoothCoeff10),
                              .SmoothCoeff11(SmoothCoeff11),
                              .SmoothCoeffRS(SmoothCoeffRS),

                              //Outputs
                              .SmoothDataOutRe(SmoothDataOutRe0),
                              .SmoothDataOutIm(SmoothDataOutIm0)
                              );

//Instantiate ChannelEstimStream if NSTS > 1
generate
   if (NSTS > 32'd1)
      begin: EstimSmoothStream1Gen

         EstimSmoothStream # (
                              .FFTBUFWIDTH(FFTBUFWIDTH),
                              .HBUFDATAWIDTH(HBUFDATAWIDTH)
                             ) U_EstimSmoothStream1 (
                                       //Inputs
                                       .nPhyRst(nPhyRst),
                                       .PhyClk(PhyClk),
                                       .SmoothEnIn(SmoothEnIn[1]),
                                       .ShiftIn(ShiftIn),
                                       .BlockEn(BlockEn[1]),
                                       .DivByJ(DivByJ),
                                       .MultByJ(MultByJ),
                                       .ReceptionMode(ReceptionMode),
                                       .SymbolType(SymbolType),
                                       .RUType(RUType),
                                       .PilotAvEn(PilotAvEn),
                                       .PilotAvSCIndex(PilotAvSCIndex),
                                       .PilotAvDataInValid(PilotAvDataInValid),
                                       .RotCordicEnIn(RotCordicEnIn),
                                       .RotQuad(RotQuad1),
                                       .RotIndex(RotIndex1),
                                       .ReadFromH(ReadFromH),
                                       .SelIQPhase(SelIQPhase),
                                       .PilotStore(1'b0),
                                       .PilotRead(1'b0),
                                       .HDataMult(HDataMult),
                                       .RoundLSB(RoundLSB),
                                       .PtCoeff(PtCoeff[1]),
                                       .PreambleCoeff(PreambleCoeff),
                                       .FFTBufReadDataRe(FFTBufReadDataRe),
                                       .FFTBufReadDataIm(FFTBufReadDataIm),
                                       .HBufReadDataRe(HBufReadDataRe1),
                                       .HBufReadDataIm(HBufReadDataIm1),
                                       .HBufReadDataEnIn(HBufReadDataEnIn),
                                       .SmoothCoeff0(SmoothCoeff0),
                                       .SmoothCoeff1(SmoothCoeff1),
                                       .SmoothCoeff2(SmoothCoeff2),
                                       .SmoothCoeff3(SmoothCoeff3),
                                       .SmoothCoeff4(SmoothCoeff4),
                                       .SmoothCoeff5(SmoothCoeff5),
                                       .SmoothCoeff6(SmoothCoeff6),
                                       .SmoothCoeff7(SmoothCoeff7),
                                       .SmoothCoeff8(SmoothCoeff8),
                                       .SmoothCoeff9(SmoothCoeff9),
                                       .SmoothCoeff10(SmoothCoeff10),
                                       .SmoothCoeff11(SmoothCoeff11),
                                       .SmoothCoeffRS(SmoothCoeffRS),

                                       //Outputs
                                       .SmoothDataOutRe(SmoothDataOutRe1),
                                       .SmoothDataOutIm(SmoothDataOutIm1)
                                       );

      end //EstimSmoothStream1Gen
      else begin
        assign SmoothDataOutRe1 = {HBUFDATAWIDTH{1'b0}};
        assign SmoothDataOutIm1 = {HBUFDATAWIDTH{1'b0}};
      end
endgenerate

//Instantiate EstimSmoothStream2 if NSTS > 32'd2
generate
   if (NSTS > 32'd2)
      begin: EstimSmoothStream2Gen

         EstimSmoothStream # (
                              .FFTBUFWIDTH(FFTBUFWIDTH),
                              .HBUFDATAWIDTH(HBUFDATAWIDTH)
                             ) U_EstimSmoothStream2 (
                                       //Inputs
                                       .nPhyRst(nPhyRst),
                                       .PhyClk(PhyClk),
                                       .SmoothEnIn(SmoothEnIn[2]),
                                       .ShiftIn(ShiftIn),
                                       .BlockEn(BlockEn[2]),
                                       .DivByJ(DivByJ),
                                       .MultByJ(MultByJ),
                                       .ReceptionMode(ReceptionMode),
                                       .SymbolType(SymbolType),
                                       .RUType(RUType),
                                       .PilotAvEn(PilotAvEn),
                                       .PilotAvSCIndex(PilotAvSCIndex),
                                       .PilotAvDataInValid(PilotAvDataInValid),
                                       .RotCordicEnIn(RotCordicEnIn),
                                       .RotQuad(RotQuad2),
                                       .RotIndex(RotIndex2),
                                       .ReadFromH(ReadFromH),
                                       .SelIQPhase(SelIQPhase),
                                       .PilotStore(1'b0),
                                       .PilotRead(1'b0),
                                       .HDataMult(HDataMult),
                                       .RoundLSB(RoundLSB),
                                       .PtCoeff(PtCoeff[2]),
                                       .PreambleCoeff(PreambleCoeff),
                                       .FFTBufReadDataRe(FFTBufReadDataRe),
                                       .FFTBufReadDataIm(FFTBufReadDataIm),
                                       .HBufReadDataRe(HBufReadDataRe2),
                                       .HBufReadDataIm(HBufReadDataIm2),
                                       .HBufReadDataEnIn(HBufReadDataEnIn),
                                       .SmoothCoeff0(SmoothCoeff0),
                                       .SmoothCoeff1(SmoothCoeff1),
                                       .SmoothCoeff2(SmoothCoeff2),
                                       .SmoothCoeff3(SmoothCoeff3),
                                       .SmoothCoeff4(SmoothCoeff4),
                                       .SmoothCoeff5(SmoothCoeff5),
                                       .SmoothCoeff6(SmoothCoeff6),
                                       .SmoothCoeff7(SmoothCoeff7),
                                       .SmoothCoeff8(SmoothCoeff8),
                                       .SmoothCoeff9(SmoothCoeff9),
                                       .SmoothCoeff10(SmoothCoeff10),
                                       .SmoothCoeff11(SmoothCoeff11),
                                       .SmoothCoeffRS(SmoothCoeffRS),

                                       //Outputs
                                       .SmoothDataOutRe(SmoothDataOutRe2),
                                       .SmoothDataOutIm(SmoothDataOutIm2)
                                       );

      end //EstimSmoothStream2Gen
      else begin
        assign SmoothDataOutRe2 = {HBUFDATAWIDTH{1'b0}};
        assign SmoothDataOutIm2 = {HBUFDATAWIDTH{1'b0}};
      end
endgenerate

//Instantiate EstimSmoothStream3 if NSTS > 32'd3
generate
   if (NSTS > 32'd3)
      begin: EstimSmoothStream3Gen

         EstimSmoothStream # (
                              .FFTBUFWIDTH(FFTBUFWIDTH),
                              .HBUFDATAWIDTH(HBUFDATAWIDTH)
                             ) U_EstimSmoothStream3 (
                                       //Inputs
                                       .nPhyRst(nPhyRst),
                                       .PhyClk(PhyClk),
                                       .SmoothEnIn(SmoothEnIn[3]),
                                       .ShiftIn(ShiftIn),
                                       .BlockEn(BlockEn[3]),
                                       .DivByJ(DivByJ),
                                       .MultByJ(MultByJ),
                                       .ReceptionMode(ReceptionMode),
                                       .SymbolType(SymbolType),
                                       .RUType(RUType),
                                       .PilotAvEn(PilotAvEn),
                                       .PilotAvSCIndex(PilotAvSCIndex),
                                       .PilotAvDataInValid(PilotAvDataInValid),
                                       .RotCordicEnIn(RotCordicEnIn),
                                       .RotQuad(RotQuad3),
                                       .RotIndex(RotIndex3),
                                       .ReadFromH(ReadFromH),
                                       .SelIQPhase(SelIQPhase),
                                       .PilotStore(1'b0),
                                       .PilotRead(1'b0),
                                       .HDataMult(HDataMult),
                                       .RoundLSB(RoundLSB),
                                       .PtCoeff(PtCoeff[3]),
                                       .PreambleCoeff(PreambleCoeff),
                                       .FFTBufReadDataRe(FFTBufReadDataRe),
                                       .FFTBufReadDataIm(FFTBufReadDataIm),
                                       .HBufReadDataRe(HBufReadDataRe3),
                                       .HBufReadDataIm(HBufReadDataIm3),
                                       .HBufReadDataEnIn(HBufReadDataEnIn),
                                       .SmoothCoeff0(SmoothCoeff0),
                                       .SmoothCoeff1(SmoothCoeff1),
                                       .SmoothCoeff2(SmoothCoeff2),
                                       .SmoothCoeff3(SmoothCoeff3),
                                       .SmoothCoeff4(SmoothCoeff4),
                                       .SmoothCoeff5(SmoothCoeff5),
                                       .SmoothCoeff6(SmoothCoeff6),
                                       .SmoothCoeff7(SmoothCoeff7),
                                       .SmoothCoeff8(SmoothCoeff8),
                                       .SmoothCoeff9(SmoothCoeff9),
                                       .SmoothCoeff10(SmoothCoeff10),
                                       .SmoothCoeff11(SmoothCoeff11),
                                       .SmoothCoeffRS(SmoothCoeffRS),

                                       //Outputs
                                       .SmoothDataOutRe(SmoothDataOutRe3),
                                       .SmoothDataOutIm(SmoothDataOutIm3)
                                       );

      end //EstimSmoothStream3Gen
      else begin
        assign SmoothDataOutRe3 = {HBUFDATAWIDTH{1'b0}};
        assign SmoothDataOutIm3 = {HBUFDATAWIDTH{1'b0}};
      end
endgenerate


endmodule // EstimSmoothRx

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
