////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top level-Channel Est & Smoothing per chain per stream
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/ChEstSmth/verilog/rtl/EstimSmoothStream.v $
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
module EstimSmoothStream #(parameter FFTBUFWIDTH   = 13, // Data width of the FFT memory
                           parameter HBUFDATAWIDTH = 13, // Data width of one channel coefficient
                           parameter POSTCORDICEN  = 1   // Enable post Cordic instance
                          )(

            ///////////////////////////////////////////////
            // Clock and Reset
            ///////////////////////////////////////////////
            input   wire                                  nPhyRst,  // Active Low Reset
            input   wire                                  PhyClk,   // Phy Clock

            ///////////////////////////////////////////////
            // Controls
            ///////////////////////////////////////////////
            input   wire                                  BlockEn,       // Enable Block
            input   wire              [3:0]               ReceptionMode, // Mode of Current Pkt
            input   wire              [2:0]               SymbolType,    // LTF of Current Pkt
            input   wire              [2:0]               RUType,        // Type of RU (0:26, 1:52, 2:106, 3:242, 4:484)
            input   wire                                  MultByJ,       // Indicates upper 20 MHz
            //
            input   wire                                  PilotAvEn,          // Enable Pilot Averaging
            input   wire              [9:0]               PilotAvSCIndex,     // SC Index at Pilot Averaging input
            input   wire                                  PilotAvDataInValid, // Enable Pilot Averaging input
            //
            input   wire                                  RotCordicEnIn,     // Enable Prerotation
            input   wire              [1:0]               RotQuad,           // Rotation Quadrant
            input   wire              [3:0]               RotIndex,          // Rotation Index
            input   wire                                  DivByJ,            // Indicates upper 20 MHz
            //
            input   wire                                  ReadFromH,         // Read data from H
            input   wire                                  SelIQPhase,        // Select I or Q phase for filter
            //
            input   wire                                  PilotStore,        // Store pilots in buffer
            input   wire                                  PilotRead,         // Read pilots from buffer

            ///////////////////////////////////////////////
            // Data Related
            ///////////////////////////////////////////////
            input   wire              [1:0]               HDataMult,        // Shifting
            input   wire              [1:0]               RoundLSB,         // Rounding
            input   wire                                  PtCoeff,          // Pt Matrix Value
            input   wire                                  PreambleCoeff,    // Preamble Value
            //
            input   wire   signed     [FFTBUFWIDTH-1:0]   FFTBufReadDataRe, // Real Comp of Data
            input   wire   signed     [FFTBUFWIDTH-1:0]   FFTBufReadDataIm, // Imag Comp of Data
            //
            input   wire   signed     [HBUFDATAWIDTH-1:0] HBufReadDataRe,   // Real Comp of Data
            input   wire   signed     [HBUFDATAWIDTH-1:0] HBufReadDataIm,   // Imag Comp of Data
            input   wire                                  HBufReadDataEnIn, // Qualifies Ip Data

            ///////////////////////////////////////////////
            // Filter interface
            ///////////////////////////////////////////////
            input   wire                                  SmoothEnIn,    // Enable smoothing
            input   wire                                  ShiftIn,       // Enable input to filter
            //
            input   wire   signed     [9:0]               SmoothCoeff0,  // Smoothing Coeff 0
            input   wire   signed     [9:0]               SmoothCoeff1,  // Smoothing Coeff 1
            input   wire   signed     [9:0]               SmoothCoeff2,  // Smoothing Coeff 2
            input   wire   signed     [9:0]               SmoothCoeff3,  // Smoothing Coeff 3
            input   wire   signed     [9:0]               SmoothCoeff4,  // Smoothing Coeff 4
            input   wire   signed     [9:0]               SmoothCoeff5,  // Smoothing Coeff 5
            input   wire   signed     [9:0]               SmoothCoeff6,  // Smoothing Coeff 6
            input   wire   signed     [9:0]               SmoothCoeff7,  // Smoothing Coeff 7
            input   wire   signed     [9:0]               SmoothCoeff8,  // Smoothing Coeff 8
            input   wire   signed     [9:0]               SmoothCoeff9,  // Smoothing Coeff 9
            input   wire   signed     [9:0]               SmoothCoeff10, // Smoothing Coeff 10
            input   wire   signed     [9:0]               SmoothCoeff11, // Smoothing Coeff 11
            input   wire              [1:0]               SmoothCoeffRS, // Smoothing Right Shift

            ///////////////////////////////////////////////
            // Data outputs
            ///////////////////////////////////////////////
            output wire signed     [HBUFDATAWIDTH-1:0]    SmoothDataOutRe, // Real Component
            output wire signed     [HBUFDATAWIDTH-1:0]    SmoothDataOutIm  // Imag Component
            );

//////////////////////////////////////////////////////////////////////////////
// Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire    signed     [HBUFDATAWIDTH-1:0] EstDataOutRe;
wire    signed     [HBUFDATAWIDTH-1:0] EstDataOutIm;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// This module instantiates ChannelEstimStream and SmoothTop modules.

// Instantiation of ChannelEstimStream
ChannelEstimStream # (
  .FFTBUFWIDTH(FFTBUFWIDTH),
  .HBUFDATAWIDTH(HBUFDATAWIDTH)
   ) U_ChannelEstimStream (
  //Inputs
  .PhyClk(PhyClk),
  .nPhyRst(nPhyRst),
  .ReadFromH(ReadFromH),
  .HDataMult(HDataMult),
  .RoundLSB(RoundLSB),
  .PtCoeff(PtCoeff),
  .PreambleCoeff(PreambleCoeff),
  .FFTBufReadDataRe(FFTBufReadDataRe),
  .FFTBufReadDataIm(FFTBufReadDataIm),
  .HBufReadDataRe(HBufReadDataRe),
  .HBufReadDataIm(HBufReadDataIm),
  .HBufReadDataEnIn(HBufReadDataEnIn),
  //Outputs
  .EstDataOutRe(EstDataOutRe),
  .EstDataOutIm(EstDataOutIm)
  );

// Instantiation of SmoothTop
SmoothTop # (
  .DATAWIDTH(HBUFDATAWIDTH)
  ) U_SmoothTop (
  //Inputs
  .nPhyRst(nPhyRst),
  .PhyClk(PhyClk),
  .BlockEn(BlockEn),
  .SmoothEnIn(SmoothEnIn),
  .ShiftIn(ShiftIn),
  .SelIQPhase(SelIQPhase),
  .PilotStore(PilotStore),
  .PilotRead(PilotRead),
  .DivByJ(DivByJ),
  .MultByJ(MultByJ),
  .ReceptionMode(ReceptionMode),
  .SymbolType(SymbolType),
  .RUType(RUType),
  .PilotAvEn(PilotAvEn),
  .PilotAvSCIndex(PilotAvSCIndex),
  .PilotAvDataInValid(PilotAvDataInValid),
  .RotQuad(RotQuad),
  .RotIndex(RotIndex),
  .RotCordicEnIn(RotCordicEnIn),
  .SmoothDataInRe(EstDataOutRe),
  .SmoothDataInIm(EstDataOutIm),
  .SmoothCoeff0(SmoothCoeff0),
  .SmoothCoeff1(SmoothCoeff1),
  .SmoothCoeff2(SmoothCoeff2),
  .SmoothCoeff3(SmoothCoeff3),
  .SmoothCoeff4(SmoothCoeff4),
  .SmoothCoeff5(SmoothCoeff5),
  .SmoothCoeff6(SmoothCoeff6),
  .SmoothCoeff7(SmoothCoeff7),
  .SmoothCoeff8(SmoothCoeff8),
  .SmoothCoeff9(SmoothCoeff9),
  .SmoothCoeff10(SmoothCoeff10),
  .SmoothCoeff11(SmoothCoeff11),
  .SmoothCoeffRS(SmoothCoeffRS),

  //Outputs
  .SmoothDataOutRe(SmoothDataOutRe),
  .SmoothDataOutIm(SmoothDataOutIm)
  );

endmodule // EstimSmoothStream

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
