///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39601 $
// $Date: 2019-08-06 13:09:10 +0200 (Tue, 06 Aug 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Calculates theta based on equalised pilot.                                                      
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/EqPilotPhase.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
module  EqPilotPhase (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input   wire                                   nPhyRst, //Active LOW Reset
            input   wire                                   PhyClk,  //PHY Clock

            // Data and Control
            // Clear control
            input    wire                                  FDReset,
            // Reference Pilot.
            input   wire                                   RefPilot,
            input   wire                                   EqPilotValid,
            input   wire             [19:0]                EqPilotRe,
            input   wire             [19:0]                EqPilotIm,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output  reg signed       [11:0]                Theta,
            output  reg                                    ThetaDone
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
//Compensated Pilot
reg    signed         [19:0]    CompensatePilotRe[5:0];
reg    signed         [19:0]    CompensatePilotIm[5:0];
reg                   [5:0]     DEqPilotValid;
reg                             CordicOutValid;
reg                             ThetaDone_1t;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires & Vars Declarations
//////////////////////////////////////////////////////////////////////////////
//Angle out and done signal from Cordic.
wire  signed          [11:0]    AngleOut[5:0];
wire                            CordicDone[5:0];

integer                         count;
integer                         i;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
//This statements checks reference pilot.If it is -1 then takes two's
//complement of Equalised pilot otherwise calculates angle on same equalised
//pilot as received from MIMO equaliser.
//----------------------------------------------------------------------------
always @(*)
begin 
 for (i=0;i<6;i=i+1) begin
   CompensatePilotRe[i] = $signed({20{1'b0}});
   CompensatePilotIm[i] = $signed({20{1'b0}});
   DEqPilotValid[i]     = 1'b0;
 end
 CompensatePilotRe[count] = (RefPilot) ? $signed(EqPilotRe) : $signed(-(EqPilotRe));
 CompensatePilotIm[count] = (RefPilot) ? $signed(EqPilotIm) : $signed(-(EqPilotIm));
 DEqPilotValid[count]     = EqPilotValid;
end

//----------------------------------------------------------------------------
//Counter to keep a track of subcarriers.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)
    count <= 0;
  else if (EqPilotValid)
    count <= count + 1;
  else
    count <= 0;
end

//----------------------------------------------------------------------------
//Enable Cordic outputs.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)
    CordicOutValid <= 1'b0;
  else if (FDReset || (ThetaDone_1t && !ThetaDone))
    CordicOutValid <= 1'b0;
  else if (EqPilotValid)
    CordicOutValid <= 1'b1;
end

//----------------------------------------------------------------------------
//Registering outputs from Cordics.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    Theta        <= 12'b0;
    ThetaDone    <= 1'b0;
    ThetaDone_1t <= 1'b0;
  end
  else begin
    ThetaDone_1t <= ThetaDone;
    if (CordicOutValid) // Safeguard in case of abnormal rx ending
    begin
      if (CordicDone[0]) begin 
        Theta     <= AngleOut[0];
        ThetaDone <= CordicDone[0];
      end
      else if (CordicDone[1]) begin
        Theta     <= AngleOut[1];
        ThetaDone <= CordicDone[1];
      end
      else if (CordicDone[2]) begin
        Theta     <= AngleOut[2];
        ThetaDone <= CordicDone[2];
      end
      else if (CordicDone[3]) begin
        Theta     <= AngleOut[3];
        ThetaDone <= CordicDone[3];
      end
      else if (CordicDone[4]) begin
        Theta     <= AngleOut[4];
        ThetaDone <= CordicDone[4];
      end
      else if (CordicDone[5]) begin
        Theta     <= AngleOut[5];
        ThetaDone <= CordicDone[5];
      end
      else begin
        Theta     <= 12'b0;
        ThetaDone <= 1'b0;
      end
    end
    else begin
      Theta     <= 12'b0;
      ThetaDone <= 1'b0;
    end
  end
end

//Cordic Instantiations depending on number of pilot subcarriers.
 CordicVectTop  # (
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1)
 )
 U1_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[0]),
                               .ReDataIn(CompensatePilotRe[0]),
                               .ImDataIn(CompensatePilotIm[0]),
                               // Outputs
                               .AngleOut(AngleOut[0]),
                               .CordicDone(CordicDone[0])
                               );

CordicVectTop  # (
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1)
 )
 U2_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[1]),
                               .ReDataIn(CompensatePilotRe[1]),
                               .ImDataIn(CompensatePilotIm[1]),
                               // Outputs
                               .AngleOut(AngleOut[1]),
                               .CordicDone(CordicDone[1])
                               );

CordicVectTop  # ( 
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1)
 )
 U3_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[2]),
                               .ReDataIn(CompensatePilotRe[2]),
                               .ImDataIn(CompensatePilotIm[2]),
                               // Outputs
                               .AngleOut(AngleOut[2]),
                               .CordicDone(CordicDone[2])
                               );

CordicVectTop  # (
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1)
 )
 U4_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[3]),
                               .ReDataIn(CompensatePilotRe[3]),
                               .ImDataIn(CompensatePilotIm[3]),
                               // Outputs
                               .AngleOut(AngleOut[3]),
                               .CordicDone(CordicDone[3])
                               );

CordicVectTop  # (
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1) 
 )
 U5_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[4]),
                               .ReDataIn(CompensatePilotRe[4]),
                               .ImDataIn(CompensatePilotIm[4]),
                               // Outputs
                               .AngleOut(AngleOut[4]),
                               .CordicDone(CordicDone[4])
                               );

CordicVectTop  # (
                    .DATAWIDTH(20),
                    .ANGLEWIDTH(12),
                    .SCALING(1)
 )
 U6_CordicVectTop(
                               //Inputs
                               .PhyClk(PhyClk),
                               .nPhyRst(nPhyRst),
                               .DataInEn(DEqPilotValid[5]),
                               .ReDataIn(CompensatePilotRe[5]),
                               .ImDataIn(CompensatePilotIm[5]),
                               // Outputs
                               .AngleOut(AngleOut[5]),
                               .CordicDone(CordicDone[5])
                               );

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
