///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 34754 $
// $Date: 2018-08-03 13:41:25 +0200 (Fri, 03 Aug 2018) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Calculates Gamma using modulus of H+/H-                                                       
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/EquCoefMod.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module  EquCoefMod (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, //Active LOW Reset
            input    wire                                  PhyClk,  //PHY Clock

            // Data and Control
            // Reference Pilots for STS = 1 & STS =2.
            input    wire                                  RefPilotSTS1,
            input    wire                                  RefPilotSTS2,

            //HMatrix from Equaliser STS = 1 & STS =2.
            input    wire                   [12:0]         HMatSTS1Re,
            input    wire                   [12:0]         HMatSTS1Im,
            input    wire                   [12:0]         HMatSTS2Re,
            input    wire                   [12:0]         HMatSTS2Im,

                 //Number of Spatial Stream.
            input    wire                                  RxNsts,

            //Start signal
            //ECMStart should be high continuously not a pulse.
            input    wire                                  ECMStart,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   reg                                   GammaDone,
            output   wire          [13:0]                  Gamma
            );


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
//Registers for H+/H-
reg             signed [13:0]               HResultantRe;
reg             signed [13:0]               HResultantIm;
//Registers for H Enable for ModApprox module
reg                                         HEnable;
//Delay of H Enable for Output
reg                                         HEnableDelay;
//Wire for ready signal to Modulus block.
wire                                        ComputeMod;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
//Enable Signal for Mod Approx Module.
assign ComputeMod = HEnable | HEnableDelay;

//----------------------------------------------------------------------------
//Calculation of H+/H- depending on ref.pilots.
//If Reference pilot are equal then H1+H2 otherwise H1-H2.
//If Nsts=1 then take H as it is.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin: HplusORHminus
  if (nPhyRst == 1'b0)begin
     HResultantRe <= $signed({14{1'b0}});
     HResultantIm <= $signed({14{1'b0}});
     HEnable      <= 1'b0;
  end
  else begin
    HEnable <= ECMStart;
    if (ECMStart) begin
      if (RxNsts ==1'b1) begin
        if (RefPilotSTS1 == RefPilotSTS2) begin
          HResultantRe <= $signed({HMatSTS1Re[12],HMatSTS1Re}) + $signed({HMatSTS2Re[12],HMatSTS2Re});
          HResultantIm <= $signed({HMatSTS1Im[12],HMatSTS1Im}) + $signed({HMatSTS2Im[12],HMatSTS2Im});
        end
        else begin
          HResultantRe <= $signed({HMatSTS1Re[12],HMatSTS1Re}) - $signed({HMatSTS2Re[12],HMatSTS2Re});
          HResultantIm <= $signed({HMatSTS1Im[12],HMatSTS1Im}) - $signed({HMatSTS2Im[12],HMatSTS2Im});
        end
      end
      else begin
        HResultantRe <=  $signed({HMatSTS1Re[12],HMatSTS1Re});
        HResultantIm <=  $signed({HMatSTS1Im[12],HMatSTS1Im});
      end
    end
    else begin
      HResultantRe <= $signed({14{1'b0}});
      HResultantIm <= $signed({14{1'b0}});
    end
  end
end //End of HplusORHminus

//----------------------------------------------------------------------------
//Delay of Enable signal.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin: DelayHEnable
  if (nPhyRst == 1'b0)begin
    HEnableDelay  <= 1'b0;
    GammaDone     <= 1'b0;
  end
  else begin
    HEnableDelay  <= HEnable;
    GammaDone     <= HEnableDelay;
  end
end //End of DelayHEnable Block

 //Instantiation of Modulus module.
ModApprox #(.SUM_WIDTH(14),
            .CORRVAL_WIDTH(14))
       U_ModApprox( 
                  .PhyClk(PhyClk),
                  .nPhyRst(nPhyRst),
                  .ISum(HResultantRe),
                  .QSum(HResultantIm),
                  .ComputeOn(ComputeMod),
                  .CorrVal(Gamma)
                 );

endmodule //EquCoefMod Ends here

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
