///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 36675 $
// $Date: 2018-12-14 10:56:17 +0100 (Fri, 14 Dec 2018) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Top file for EquCoefMod module                         
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/EquCoefModTop.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module  EquCoefModTop #(parameter NSTS_PARAM    = 2,
`ifdef RW_NX_DERIV_NESS_EN
                        parameter NESS_PARAM    = 0,
`endif
                        parameter HMEMDATAWIDTH = 13, // Data width of one channel coefficient
                        parameter HMEMWIDTH     = 52  // Width per SC
                       )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, // Active LOW Reset
            input    wire                                  PhyClk,  // PHY Clock

            // Data and Control
            // Reference Pilots for STS = 1 & STS =2.
            input    wire                                  RefPilotSTS1,
            input    wire                                  RefPilotSTS2,
            //HMatrix from Equaliser.
            input    wire      [HMEMWIDTH-1:0]             HMatrix,
            // No. of Rx Ant for Cur Pkt
            input    wire      [1:0]                       CfgNrx,           
            //Number of Spatial Stream.
            input    wire                                  RxNsts,
            //Start FDOffset from RxFSM
            input    wire                                  ECMStart,
            input    wire      [2:0]                       Nsp,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Enable and Gamma Outputs
            output   reg                                   ChannelMagDone,
            output   reg       [5:0]                       ChannelMagWeight
            );

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declaration
//////////////////////////////////////////////////////////////////////////////
`ifdef RW_NX_DERIV_NESS_EN
localparam HMEM_NSEL       = ((NSTS_PARAM+NESS_PARAM) < 4) ?
                              (NSTS_PARAM+NESS_PARAM) : 4;
`else
localparam HMEM_NSEL       = NSTS_PARAM;
`endif

`ifdef RW_NX_DERIV_PATH1
localparam HMEMRXPATHWIDTH = HMEMWIDTH/2; // Width of 1 Rx Path
`else
localparam HMEMRXPATHWIDTH = HMEMWIDTH;   // Width of 1 Rx Path
`endif


//////////////////////////////////////////////////////////////////////////////
//  Internal Registers Declarations
//////////////////////////////////////////////////////////////////////////////
//Gammma before truncation and Saturation.
reg                   [15:0]                   Gamma[5:0];
reg                    [5:0]                   GammaDone;
//Truncated channel magnitude weight.
reg                   [15:0]                   TrncChannelMagWeight;
//Max value of gamma among NSp gammas with enable signal.
reg                   [15:0]                   MaxGamma;
reg                                            MaxGammaDone;
reg                                            FlagMaxDone;
//Delay og Gamma done signals.
reg                                            GammaDoneD1;
reg                                            GammaDoneD2;
reg                   [2:0]                    index;
reg                   [2:0]                    indexD;
reg                   [2:0]                    MaxIndex;

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
//Channel Coefficient from each Rx chain.
wire                  [13:0]                   GammaNrx0;
`ifdef RW_NX_DERIV_PATH1
wire                  [13:0]                   GammaNrx1;
wire                  [13:0]                   GammaNrx1Mux;
`endif

//Added outputs
wire                  [14:0]                   Gamma1;
wire                  [2:0]                    EnGamma;

//Saturated Channel Magnitude Weight.
wire                  [5:0]                    SatChannelMagWeight;

wire                  [HMEMWIDTH-1:0]          HMatrix_aux; // To Avoid Lint Prob


integer                                        i,j;


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign HMatrix_aux = HMatrix;  // To Avoid Lint Prob

//Addition of Gamma Outputs
`ifdef RW_NX_DERIV_PATH1
    assign GammaNrx1Mux = (CfgNrx==2'd0) ? 14'b0 : GammaNrx1;
    assign Gamma1       = {1'b0,GammaNrx0} + {1'b0,GammaNrx1Mux};
`else
    assign Gamma1       = {1'b0,GammaNrx0};
    assign EnGamma[1]   = 1'b0;
`endif

assign EnGamma[2] = EnGamma[0] | EnGamma[1];

//----------------------------------------------------------------------------
//Adding Gamma  from different receive chains.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    for (i=0;i<=5;i=i+1) begin
      GammaDone[i] <= 1'b0;
    end
    GammaDoneD1 <= 1'b0;
    GammaDoneD2 <= 1'b0;
    index       <= 3'b0;
    indexD      <= 3'b0;
    FlagMaxDone <= 1'b0;
  end
  else begin
    indexD       <= index;
    GammaDone[0] <= EnGamma[2];
    GammaDoneD1  <= GammaDone[Nsp-3'b1];
    GammaDoneD2  <= GammaDoneD1;
    for (i=0;i<5;i=i+1) begin
      GammaDone[i+1] <= GammaDone[i];
    end
    if(index == (Nsp-3'b1) && GammaDone[0] )begin
      index       <= 3'b0;
      FlagMaxDone <= 1'b1;
    end
    else if (EnGamma[2]) begin
      FlagMaxDone <= 1'b0;
      index       <= index + 3'b1;
    end
    else begin
      index       <= 3'b0;
      FlagMaxDone <=1'b0;
    end
  end
end

//----------------------------------------------------------------------------
//Addition of Gamma1 from Rx chain 1&2
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    for (j=0;j<6;j=j+1) begin
      Gamma[j] <= 16'b0;
    end
  end
  else if (EnGamma[2]) begin
    Gamma[index] <= {1'b0,Gamma1};
  end
end

//----------------------------------------------------------------------------
//Selection of maximum gamma for truncating bits depending on MSB 1.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    MaxGamma     <= 16'b0;
    MaxGammaDone <= 1'b0;
  end
  else begin
    MaxGammaDone <= FlagMaxDone;
    if (GammaDone[0]) begin
      if (indexD == 3'b0)
        MaxGamma <= Gamma[0] ;
      else if ((indexD > 3'b0) && (indexD < Nsp) && (Gamma[indexD] > MaxGamma))
        MaxGamma <= Gamma[indexD];
    end
  end
end

//----------------------------------------------------------------------------
//Locate maximum gamma position.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin 
  if (nPhyRst == 1'b0)
    MaxIndex <= 3'b0;
  else if (GammaDoneD2 && GammaDoneD1)
    MaxIndex <= MaxIndex+3'd1;
  else
    MaxIndex <= 3'b0;
end

//----------------------------------------------------------------------------
//Registering Outputs
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    ChannelMagDone   <= 1'b0;
    ChannelMagWeight <= 6'b0;
  end
  else begin
    ChannelMagDone   <= GammaDoneD2;
    ChannelMagWeight <= SatChannelMagWeight;
  end
end

//----------------------------------------------------------------------------
//Truncation of LSB depending on first 1 from MSB.
//Truncate (Max FSB Position -5)LSB.
//If I one lies after between 0-5 bits no truncation.
//----------------------------------------------------------------------------
always @(*)
begin
  casex (MaxGamma)
    16'b1xxx_xxxx_xxxx_xxxx  :  TrncChannelMagWeight   = {{10{1'b0}},{Gamma[MaxIndex][15:10]}};
    16'b01xx_xxxx_xxxx_xxxx  :  TrncChannelMagWeight   = {{9{1'b0}},{Gamma[MaxIndex][15:9]}};
    16'b001x_xxxx_xxxx_xxxx  :  TrncChannelMagWeight   = {{8{1'b0}},{Gamma[MaxIndex][15:8]}};
    16'b0001_xxxx_xxxx_xxxx  :  TrncChannelMagWeight   = {{7{1'b0}},{Gamma[MaxIndex][15:7]}};
    16'b0000_1xxx_xxxx_xxxx  :  TrncChannelMagWeight   = {{6{1'b0}},{Gamma[MaxIndex][15:6]}};
    16'b0000_01xx_xxxx_xxxx  :  TrncChannelMagWeight   = {{5{1'b0}},{Gamma[MaxIndex][15:5]}};
    16'b0000_001x_xxxx_xxxx  :  TrncChannelMagWeight   = {{4{1'b0}},{Gamma[MaxIndex][15:4]}};
    16'b0000_0001_xxxx_xxxx  :  TrncChannelMagWeight   = {{3{1'b0}},{Gamma[MaxIndex][15:3]}};
    16'b0000_0000_1xxx_xxxx  :  TrncChannelMagWeight   = {{2{1'b0}},{Gamma[MaxIndex][15:2]}};
    16'b0000_0000_01xx_xxxx  :  TrncChannelMagWeight   = {{1'b0},{Gamma[MaxIndex][15:1]}};
    default                  :  TrncChannelMagWeight   = Gamma[MaxIndex];
  endcase
end

 //Instantiation of SatSymSigned component
SatUnsigned #(
               .INPUT_WIDTH(16),
               .OUTPUT_WIDTH(6)
              )
               U_SAT(
                        .InputData(TrncChannelMagWeight),
                        .SatData(SatChannelMagWeight)
                        );

//Instantiation of EquCoefMod
generate
  if(HMEM_NSEL==1)
     begin:Nrx0_0
       EquCoefMod EquCoefModNrx0 (
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 .RefPilotSTS1(RefPilotSTS1),
                 .RefPilotSTS2(RefPilotSTS2),
                 .HMatSTS1Re(HMatrix[(1*HMEMRXPATHWIDTH-1-HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                 .HMatSTS1Im(HMatrix[(1*HMEMRXPATHWIDTH-1)-:HMEMDATAWIDTH]),
                 .HMatSTS2Re(13'd0),
                 .HMatSTS2Im(13'd0),
                 .RxNsts(RxNsts),
                 .ECMStart(ECMStart),
                 .GammaDone(EnGamma[0]),
                 .Gamma(GammaNrx0)
                 );
     end //Nrx0_0
endgenerate
generate
  if(HMEM_NSEL>1)
     begin:Nrx0_1
       EquCoefMod EquCoefModNrx0 (
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 .RefPilotSTS1(RefPilotSTS1),
                 .RefPilotSTS2(RefPilotSTS2),
                 .HMatSTS1Re(HMatrix[(1*HMEMRXPATHWIDTH-1-HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                 .HMatSTS1Im(HMatrix[(1*HMEMRXPATHWIDTH-1)-:HMEMDATAWIDTH]),
                 .HMatSTS2Re(HMatrix[(1*HMEMRXPATHWIDTH-1-3*HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                 .HMatSTS2Im(HMatrix[(1*HMEMRXPATHWIDTH-1-2*HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                 .RxNsts(RxNsts),
                 .ECMStart(ECMStart),
                 .GammaDone(EnGamma[0]),
                 .Gamma(GammaNrx0)
                 );
     end //Nrx0_1
endgenerate

//Instantiation of EquCoefMod
`ifdef RW_NX_DERIV_PATH1
        EquCoefMod EquCoefModNrx1 (
                    .PhyClk(PhyClk),
                    .nPhyRst(nPhyRst),
                    .RefPilotSTS1(RefPilotSTS1),
                    .RefPilotSTS2(RefPilotSTS2),
                    .HMatSTS1Re(HMatrix[(2*HMEMRXPATHWIDTH-1-HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                    .HMatSTS1Im(HMatrix[(2*HMEMRXPATHWIDTH-1)-:HMEMDATAWIDTH]]),
                    .HMatSTS2Re(HMatrix[(2*HMEMRXPATHWIDTH-1-3*HMEMDATAWIDTH)-:HMEMDATAWIDTH]),
                    .HMatSTS2Im(HMatrix[(2*HMEMRXPATHWIDTH-1-2*HMEMDATAWIDTH))-:HMEMDATAWIDTH]]),
                    
                    .RxNsts(RxNsts),
                    .ECMStart(ECMStart),
                    .GammaDone(EnGamma[1]),
                    .Gamma(GammaNrx1)
                    );
`endif

endmodule //End of EquCoefModTop Module.

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////

