///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Multiplication of Gamma with index.                    
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/KMulGamma.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module KMulGamma #(parameter  INPUTWIDTH = 13
                  )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input   wire                                   nPhyRst, //Active LOW Reset
            input   wire                                   PhyClk,  //PHY Clock

            // Input Gamma & Count from MNMatrix.
            input   wire   signed [(INPUTWIDTH-1):0]       Gamma,

            //Index from Equaliser.
            input    wire       signed     [9:0]           SubCarrierIndex,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Multiplied Output.
            output  reg   signed [(INPUTWIDTH+7):0]        KGamma
            );


//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
//Multiply gamma by subcarrier index.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin:AddKMul
  if (nPhyRst == 1'b0)begin
     KGamma <= $signed({{(INPUTWIDTH+8)}{1'b0}});
  end
  else begin
     KGamma <= $signed(SubCarrierIndex) * $signed(Gamma);
  end
end//AddKMul

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
