//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 37040 $
// $Date: 2019-01-11 10:13:14 +0100 (Fri, 11 Jan 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Calculation of determinant M.                                                    
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/MDet.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
`default_nettype none
module MDet
(
  input  wire               PhyClk,                   
  input  wire               nPhyRst,                  

  input  wire signed [20:0] M22,                      
  input  wire signed [21:0] M21,                      
  input  wire        [24:0] M11,                      
  input  wire               EnableInMMatrix,          
  input  wire [2:0]         Nsp,

  output wire signed [21:0] DetM,                     
  output wire               EnableOutMDet             
);

  wire signed [50:0] DetMShift;
  wire signed [46:0] DetMInt;
  reg  signed [20:0] M22_1t;
  reg  signed [21:0] M21_1t;
  reg         [24:0] M11_1t;
  reg                Enable_1t;
 
  reg signed [46:0]  M21Square_2t,M11MultM22_2t;
  reg                Enable_2t;
  
  reg [50:0]         DetMShift_3t;
  reg                Enable_3t;

  always @(posedge PhyClk or negedge nPhyRst)
  begin: Det
    if (nPhyRst == 1'b0)
    begin
      
      M21_1t         <= 22'b0;
      M11_1t         <= 25'b0;
      M22_1t         <= 21'b0;
      Enable_1t      <= 1'b0;
      
      M21Square_2t   <= 47'd0;
      M11MultM22_2t  <= 47'sd0;
      Enable_2t      <= 1'b0;
      
      DetMShift_3t   <= 51'b0;
      Enable_3t      <= 1'b0;
    
    end
    else 
    begin

      M21_1t         <= M21;
      M11_1t         <= M11;
      M22_1t         <= M22;
      Enable_1t      <= EnableInMMatrix;

      M21Square_2t   <= M21_1t*M21_1t;
      M11MultM22_2t  <= M11_1t*{{4{M22_1t[20]}},M22_1t};
      Enable_2t      <= Enable_1t;
  
      DetMShift_3t   <= DetMShift;
      Enable_3t      <= Enable_2t;
    
    end
  end

  assign DetMInt       = M11MultM22_2t - M21Square_2t;
  assign DetMShift     = (Nsp <= 3'd4) ? (DetMInt<<<3'd4) : {{4{DetMInt[46]}},DetMInt};
 
  assign EnableOutMDet = Enable_3t;

  //----------------------------------------------------------------------------
  //Truncation & Saturation for DetM
  //----------------------------------------------------------------------------
  SatSigned 
  #(
    .INPUT_WIDTH(41),
    .OUTPUT_WIDTH(22)
  )
  U_SAT
  (
    .InputData($signed(DetMShift_3t[50:10])),
    .SatData(DetM)
  );

endmodule
`default_nettype wire

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
