///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: agrunert $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 36778 $
// $Date: 2018-12-19 11:32:44 +0100 (Wed, 19 Dec 2018) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Row of N Matrix                                                      
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/NShiftBank.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

module  NShiftBank #(parameter WIDTH    = 14
            )(
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, //Active LOW Reset
            input    wire                                  PhyClk,  //PHY Clock

            // Data and Control
            // Input Gamma & Enable from EquCoefModTop.
            input    wire                                  EnableIn,
            input    wire                  [WIDTH-1:0]     GammaIn,
            input    wire                  [2:0]           Nsp,

                 //Enable if M and N to be multiplied.
            input    wire                                  MNMulEn,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Enable and Gamma Outputs
            output      reg                                EnableOut,
            output      reg       [WIDTH-1:0]              NRegOut
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers, Wires & vars Declarations
//////////////////////////////////////////////////////////////////////////////
//Internal Shift Register for storing N Matrix.
reg              [WIDTH-1:0]    NShiftReg[5:0];


integer                         i;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
//Shift Register
//Shifting GammaIn into register.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin: NShift
  if (nPhyRst == 1'b0)begin
    for (i = 0; i <= 5; i=i+1) begin
      NShiftReg[i] <= {WIDTH{1'b0}};
    end
  end
  else begin
    if (EnableIn) begin
      NShiftReg[0]  <= GammaIn;
      for (i = 1; i <=5; i=i+1) begin
        NShiftReg[i] <= NShiftReg[i-1];
      end
    end
    else if (MNMulEn) begin
      for (i = 5; i>=1; i=i-1) begin
          NShiftReg[i] <= NShiftReg[i-1];
      end
    end
  end
end //NShift

//----------------------------------------------------------------------------
//Reading out from shift register when MNMulEn=1.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin: NOutput
  if (nPhyRst == 1'b0)begin
    EnableOut <= 1'b0;
    NRegOut   <= {WIDTH{1'b0}};
  end
  else begin
    EnableOut <=MNMulEn;
    if (MNMulEn) begin
      NRegOut   <=NShiftReg[(Nsp-3'd1)];
    end
  end
end //NOutput

endmodule //End of NShiftBank Module.

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
