///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: agrunert $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 36778 $
// $Date: 2018-12-19 11:32:44 +0100 (Wed, 19 Dec 2018) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Top module of N Matrix with 2 rows                                                      
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/NShiftBankTop.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
module  NShiftBankTop (

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, //Active LOW Reset
            input    wire                                  PhyClk,  //PHY Clock

            // Data and Control
            // Input Gamma & Enable from EquCoefModTop.
            input    wire                                  EnableIn,
            input    wire                 [14:0]           NMatrixInRow1,
            input    wire                 [13:0]           NMatrixInRow2,
            input    wire                 [2:0]            Nsp,

            //Enable if M and N to be multiplied.
            input    wire                                  MNMulEn,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Enable and Gamma Outputs
            output   wire                                  EnableOut,
            output   wire         [14:0]                   NMatrixOutRow1,
            output   wire         [13:0]                   NMatrixOutRow2
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                            EnableOutRow1;
wire                            EnableOutRow2;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

assign  EnableOut = EnableOutRow1 || EnableOutRow2;

// N Reg Instantiation for Row1 of N Matrix.
NShiftBank #(.WIDTH(15)) U_NShiftBankRow1 (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 // Data and Control
                 // Input Gamma & Enable from EquCoefModTop.
                 .EnableIn(EnableIn),
                 .GammaIn(NMatrixInRow1),
                 .Nsp(Nsp),
                 //Enable if M and N to be multiplied.
                 .MNMulEn(MNMulEn),
                 //Outputs
                 //Enable and Gamma Outputs
                 .EnableOut(EnableOutRow1),
                 .NRegOut(NMatrixOutRow1)
                    );

//N Reg Instantiation for Row2 of N Matrix.
NShiftBank #(.WIDTH(14)) U_NShiftBankRow2 (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 // Data and Control
                 // Input Gamma & Enable from EquCoefModTop.
                 .EnableIn(EnableIn),
                 .GammaIn(NMatrixInRow2),
                 .Nsp(Nsp),
                 //Enable if M and N to be multiplied.
                 .MNMulEn(MNMulEn),
                 //Outputs
                 //Enable and Gamma Outputs
                 .EnableOut(EnableOutRow2),
                 .NRegOut(NMatrixOutRow2)
                    );

endmodule //End of NShiftBankTop Module.

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
