//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 36911 $
// $Date: 2019-01-04 11:47:02 +0100 (Fri, 04 Jan 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Multiplication of M matrix with N matrix.[M X N].
//                   Output is P Matrix with dimension 2 X Nsp.                                                    
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/PMatrix.v $
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
module PMatrix (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, //Active LOW Reset
            input    wire                                  PhyClk,  //PHY Clock

            // Data and control
            //Input N Matrix and enable.
            input    wire                                  EnableInNMatrix,
            // Gamma
            input    wire     signed    [14:0]             NMatrixInRow1,
            //KGamma
            input    wire     signed    [13:0]             NMatrixInRow2,
            //Input M Matrix and enable.
            input    wire               [24:0]             M11,
            input    wire     signed    [20:0]             M22,
            input    wire     signed    [21:0]             M21,
            input    wire                [2:0]             Nsp,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            //Output P Matrix with enable
            output  reg                                    EnableOut,
            output  reg     signed          [21:0]         P11, //First Row  of P Matrix.
            output  reg     signed          [21:0]         P21  //Second Row of P Matrix.
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Registers & Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg             signed          [35:0]               P11mul_1;
reg             signed          [35:0]               P11mul_2;
reg                             [38:0]               P21mul_1;
reg             signed          [35:0]               P21mul_2;
reg                                                  EnableD;

wire            signed          [21:0]               P11Reg;
wire            signed          [21:0]               P21Reg;
wire            signed          [38:0]               P11Shift;
wire            signed          [41:0]               P21Shift;

wire            signed          [35:0]               P11mul;
wire            signed          [38:0]               P21mul;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

// Matrix Coeff Mult
always@(posedge PhyClk or negedge nPhyRst)
begin:MatrixP
  if (nPhyRst == 1'b0)begin
     P11mul_1 <= $signed({36{1'b0}});
     P11mul_2 <= $signed({36{1'b0}});
     P21mul_1 <= $signed({39{1'b0}});
     P21mul_2 <= $signed({36{1'b0}});
     EnableD  <= 1'b0;
  end
  else if (EnableInNMatrix)  begin
     P11mul_1 <= M22 * $signed({{6{NMatrixInRow1[14]}},NMatrixInRow1});
     P11mul_2 <= M21 * $signed({{8{NMatrixInRow2[13]}},NMatrixInRow2});
     P21mul_1 <= M11 * $signed({{11{NMatrixInRow2[13]}},NMatrixInRow2});
     P21mul_2 <= M21 * $signed({{6{NMatrixInRow1[14]}},NMatrixInRow1});
     EnableD  <= 1'b1;
  end
  else begin
     P11mul_1 <= $signed({36{1'b0}});
     P11mul_2 <= $signed({36{1'b0}});
     P21mul_1 <= $signed({39{1'b0}});
     P21mul_2 <= $signed({36{1'b0}});
     EnableD  <= 1'b0;
  end
end//MatrixP

//----------------------------------------------------------------------------
//Calculation of P Matrix=Matrix M X Matrix N.
//----------------------------------------------------------------------------
assign P11mul = P11mul_1 - P11mul_2; // ((M22 * NMatrixInRow1) - (M21 * NMatrixInRow2));
assign P21mul = P21mul_1 - {{3{P21mul_2[35]}},P21mul_2}; // ((M11 * NMatrixInRow2) - (M21 * NMatrixInRow1));

//Shift by 3 bits if 20 MHz else same.
//----------------------------------------------------------------------------
assign P11Shift = (Nsp <= 3'd4) ? (P11mul<<<2'd3) : $signed({{3{P11mul[35]}},P11mul});
assign P21Shift = (Nsp <= 3'd4) ? (P21mul<<<2'd3) : $signed({{3{P21mul[38]}},P21mul});

//Truncation & Saturation for P11
SatSigned #(
               .INPUT_WIDTH(30),
               .OUTPUT_WIDTH(22)
              )
               UP11_SAT(
                        .InputData($signed(P11Shift[38:9])),
                        .SatData(P11Reg)
                        );

//Truncation & Saturation for P21
SatSigned #(
               .INPUT_WIDTH(33),
               .OUTPUT_WIDTH(22)
              )
               UP21_SAT(
                        .InputData($signed(P21Shift[41:9])),
                        .SatData(P21Reg)
                        );

//----------------------------------------------------------------------------
//Registering Outputs
//----------------------------------------------------------------------------
always@(posedge PhyClk or negedge nPhyRst)
begin:RegOutput
  if (nPhyRst == 1'b0)begin
     P11       <= $signed({22{1'b0}});
     P21       <= $signed({22{1'b0}});
     EnableOut <= 1'b0;
  end
  else begin
      P11       <= P11Reg;
      P21       <= P21Reg;
      EnableOut <= EnableD;
  end
end//RegOutput

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
