///////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Calculates Reference theta based on 
//                   previous symbol theta value.                                                      
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/RefPhase.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
module  RefPhase (
            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input  wire               nPhyRst, //Active LOW Reset
            input  wire               PhyClk,  //PHY Clock

            // Reference Pilot.
            // Previous symbol fine values.
            input  wire               EqPilotValid,
            input  wire signed [23:0] STOfine,
            input  wire signed [21:0] CPEfine,

            //Index from Equaliser.
            input  wire signed [9:0]  SubCarrierIndex,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output reg  signed [14:0] RefTheta,
            output reg                RefThetaDone
           );


//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
reg                             EqPilotValid_1t;
reg          signed   [23:0]    STOfine_1t;
reg          signed   [33:0]    Theta;

wire         signed   [33:0]    STOfineMult;

//Saturated theta.
wire                  [14:0]    SatTheta;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------
// Delay signals for timing relax.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    EqPilotValid_1t <= 1'b0;
    STOfine_1t      <= 24'b0;
  end
  else begin
    EqPilotValid_1t <= EqPilotValid;
    STOfine_1t      <= STOfine;
  end
end

//----------------------------------------------------------------------------
// Multiplication of STO Fine with Subcarrier index.
//----------------------------------------------------------------------------
assign STOfineMult = $signed(SubCarrierIndex) * $signed(STOfine_1t);

//----------------------------------------------------------------------------
// Addition of CPE fine value with STO Fine.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    Theta <= $signed({34{1'b0}});
  end
  else begin
    Theta <= $signed(STOfineMult) + $signed({{11{CPEfine[21]}},CPEfine});
  end
end

//Instantiation of Saturation Component.
SatSigned #(
               .INPUT_WIDTH(29),
               .OUTPUT_WIDTH(15)
              )
               U_SAT(
                        .InputData($signed(Theta[33:5])),
                        .SatData(SatTheta)
                        );

//----------------------------------------------------------------------------
//Registering outputs.
//----------------------------------------------------------------------------
always @(posedge PhyClk or negedge nPhyRst)
begin
  if (nPhyRst == 1'b0)begin
    RefTheta     <= $signed({15{1'b0}});
    RefThetaDone <= 1'b0;

  end
  else  begin
    RefTheta     <= $signed(SatTheta);
    RefThetaDone <= EqPilotValid_1t;
  end
end

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
