//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: cvandeburie $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 39740 $
// $Date: 2019-09-09 18:42:06 +0200 (Mon, 09 Sep 2019) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      :Top file for calculating WLS Matrix                                                     
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :                                                       
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $HeadURL: https://dpereira@svn.frso.rivierawaves.com/svn/rw_wlan_nx/branches/Projects/WLAN_HE_REF_IP/HW/WLAN_HE_REF_IP_20_40MHZ/IPs/HW/TOP11ax/PHYSUBSYS/HDMCORE/OFDMACORE/OFDMRXCORE/OFDMRXFD/FDOffset/verilog/rtl/WLSCoefCompTop.v $
// 
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
module  WLSCoefCompTop #(parameter NSTS_PARAM    = 2,
`ifdef RW_NX_DERIV_NESS_EN
                         parameter NESS_PARAM    = 0,
`endif
                         parameter HMEMDATAWIDTH = 13, // Data width of one channel coefficient
                         parameter HMEMWIDTH     = 416 // Width per SC
                        )(

            ///////////////////////////////////////////////
            // Inputs
            ///////////////////////////////////////////////
            //Clock and Reset
            input    wire                                  nPhyRst, //Active LOW Reset
            input    wire                                  PhyClk,  //PHY Clock

            // Global Control
            // No. of Rx Ant for Cur Pkt
            input    wire             [1:0]                CfgNrx,           
            //Number of Spatial Stream.
            input    wire                                  RxNsts,
            //Number of Pilot Subcarriers.
            input   wire              [2:0]                Nsp,

            // Data
            // Reference Pilots for STS = 1 & STS =2.
            input    wire                                  RefPilotSTS1,
            input    wire                                  RefPilotSTS2,

            //Valid Signals for Pilot Bits
            input    wire                                  PilotEn,
            //HMatrix from Equaliser.
            input    wire             [HMEMWIDTH-1:0]      HMatrix,

            //Index from Equaliser.
            input    wire  signed     [9:0]                SubCarrierIndex,

            ///////////////////////////////////////////////
            // Outputs
            ///////////////////////////////////////////////
            output   wire  signed     [9:0]                SubCarrierIndexOut,
            output   wire  signed     [21:0]               P11,
            output   wire  signed     [21:0]               P21,
            output   wire                                  EnableOutPMatrix,
            output   wire  signed     [21:0]               DetM,
            output   wire                                  EnableOutMDet
            );

//////////////////////////////////////////////////////////////////////////////
//  Internal Wires Declarations
//////////////////////////////////////////////////////////////////////////////
wire                            GammaDone;
wire                   [5:0]    Gamma;
wire                            EnableOutMMatrix;
wire                            EnableNMatrix;
wire                            EnableOutNMatrix;
wire                  [14:0]    NMatrixRow1;
wire                  [13:0]    NMatrixRow2;
wire                  [24:0]    M11;
wire                  [20:0]    M22;
wire                  [21:0]    M21;
wire                  [14:0]    NMatrixOutRow1;
wire                  [13:0]    NMatrixOutRow2;

//////////////////////////////////////////////////////////////////////////////
// Begining of Logic part
//////////////////////////////////////////////////////////////////////////////

//Gamma Calculation Instantiation
EquCoefModTop # (.NSTS_PARAM(NSTS_PARAM),
`ifdef RW_NX_DERIV_NESS_EN
                 .NESS_PARAM(NESS_PARAM),
`endif
                 .HMEMDATAWIDTH(HMEMDATAWIDTH),
                 .HMEMWIDTH(HMEMWIDTH))
U_EquCoefModTop (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 // Data and Control
                 // Reference Pilots for STS = 1 & STS =2.
                 .RefPilotSTS1(RefPilotSTS1),
                 .RefPilotSTS2(RefPilotSTS2),
                 //HMatrix from Equaliser.
                 .HMatrix(HMatrix),
                 //No. of Rx Ant for Cur Pkt
                 .CfgNrx(CfgNrx),
                 //Number of Spatial Stream.
                 .RxNsts(RxNsts),
                 //Number of Pilots Subcarriers.
                 .Nsp(Nsp),
                 //Start FDOffset from RxFSM
                 .ECMStart(PilotEn),
                 //Outputs
                 //Enable and Gamma Outputs
                 .ChannelMagDone(GammaDone),
                 .ChannelMagWeight(Gamma)
                 );

//M & N Matrix Generation Instantiation
MNMatrix U_MNMatrix (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 // Input Gamma & Enable from EquCoefModTop.
                 .EnableIn(GammaDone),
                 .GammaIn(Gamma),
                 .Nsp(Nsp),
                 .SubCarrierIndex(SubCarrierIndex),
                 //Enable and M & N Outputs
                 .SubCarrierIndexOut(SubCarrierIndexOut),
                 .EnableOut(EnableOutMMatrix),
                 .EnableNMatrix(EnableNMatrix),
                 .NMatrixRow1(NMatrixRow1),
                 .NMatrixRow2(NMatrixRow2),
                 .M11(M11),
                 .M22(M22),
                 .M21(M21)
                 );

// Instanciation of fix2fp
// Name of the instance : u_fix2fp
// Name of the file containing this module : fix2fp.v
// fix2fp # (.size(25))
//   u_fix2fp_M11 (
//     .d            (M11),
//     .fp_e         (),
//     .fp_m         ()
//     );
// 
// fix2fp # (.size(21))
//   u_fix2fp_M22 (
//     .d            (M22),
//     .fp_e         (),
//     .fp_m         ()
//     );
// 
// fix2fp # (.size(22))
//   u_fix2fp_M21 (
//     .d            (M21),
//     .fp_e         (),
//     .fp_m         ()
//     );

//N Matrix Register
NShiftBankTop U_NShiftBank (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 // Input Gamma,KGamma & Enable from MNMatrix.
                 .EnableIn(EnableNMatrix),
                 .NMatrixInRow1(NMatrixRow1),
                 .NMatrixInRow2(NMatrixRow2),
                 .Nsp(Nsp),
                 //Enable if N Matrix reqd as output.
                 .MNMulEn(EnableOutMMatrix),
                 //Enable and Gamma Outputs
                 .EnableOut(EnableOutNMatrix),
                 .NMatrixOutRow1(NMatrixOutRow1),
                 .NMatrixOutRow2(NMatrixOutRow2)
                 );

//M X N Multiplication Instantiation
PMatrix U_PMatrix (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 //Input N Matrix and enable.
                 .EnableInNMatrix(EnableOutNMatrix),
                 .NMatrixInRow1(NMatrixOutRow1),
                 .NMatrixInRow2(NMatrixOutRow2),
                 .Nsp(Nsp),
                 //Input M Matrix and enable.
                 .M11(M11),
                 .M22(M22),
                 .M21(M21),
                 //Output P Matrix with enable
                 .EnableOut(EnableOutPMatrix),
                 .P11(P11),
                 .P21(P21)
                 );

//Determinant M Calculation Instantiation
MDet U_MDet       (
                 //Inputs
                 .PhyClk(PhyClk),
                 .nPhyRst(nPhyRst),
                 //Input M Matrix and enable.
                 .EnableInMMatrix(EnableOutMMatrix),
                 .Nsp(Nsp),
                 .M11(M11),
                 .M22(M22),
                 .M21(M21),
                 //Output Det M with enable
                 .EnableOutMDet(EnableOutMDet),
                 .DetM(DetM)
                 );

endmodule

//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
