////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//--------------------------------------------------------------------------
// $Author: oringot $
// Company          : RivieraWaves
//--------------------------------------------------------------------------
// $Revision: 17694 $
// $Date: 2015-01-14 12:18:47 +0100 (Wed, 14 Jan 2015) $
// -------------------------------------------------------------------------
// Dependencies     :                                                       
// Description      : Top level of Rx Frequency Domain module
// Simulation Notes :                                                       
// Synthesis Notes  :                                                       
// Application Note :                                                       
// Simulator        :                                                       
// Parameters       :  
// Terms & concepts :                                                       
// Bugs             :                                                       
// Open issues and future enhancements :                                    
// References       :                                                       
// Revision History :                                                       
// -------------------------------------------------------------------------
//                                                                          
// $Source: 
//
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
`default_nettype none
module RxFDTop 
#(   
  parameter NRX_PARAM     =  1, // Max number of Rx chains supported (1 to 2)
  parameter NSTS_PARAM    =  1, // Max Space Time Streams supported
  parameter HMEMWIDTH     = 26*NSTS_PARAM*NRX_PARAM // Width per SC
)
(
  /*****************************************************************************
  * system                                                               
  *****************************************************************************/
  input  wire                 nPhyRst,                                              
  input  wire                 PhyClk,                                               
  input  wire                 ChannelEstGClk,                                       
  input  wire                 EquGClk,                                              
  input  wire                 FDOGClk,                                              
`ifdef RW_BFMEE_EN
  input  wire                 SVDClk, 
  input  wire                 SVDGClk,
`endif // RW_BFMEE_EN
                                                                                                                
  /*****************************************************************************
  * CRM for clock gating                                                                                       
  *****************************************************************************/
  output wire                 ChEstGClkEn,                                           
  output wire                 EquGClkEn,                                             
  output wire                 FDOGClkEn,                                             
`ifdef RW_BFMEE_EN
  output wire                 SVDGClkEn,
`endif // RW_BFMEE_EN
 
  /*****************************************************************************
  * global control                                                                                             
  *****************************************************************************/
  input  wire                 FDEnable,                                                           
  output wire                 FDDone,                                                           
                                                                                                                
  /*****************************************************************************
  * Configuration registers                                                                                                  
  *****************************************************************************/
  // To Frequency Domain FSM
  input  wire [2:0]           CfgRegPrimary,
  input  wire [1:0]           CfgRegNrx,
  input  wire                 CfgRegMUSmoothForce,
  input  wire                 CfgRegBFSmoothForce,
  input  wire                 CfgRegSkipMidamble1x,    // Skip midamble HE-LTF 1x
  input  wire                 CfgRegSkipMidamble2x,    // Skip midamble HE-LTF 2x
  input  wire                 CfgRegSkipMidamble4x,    // Skip midamble HE-LTF 4x

  // To Channel Estimation and Smoothing                                                                        
  input  wire                 CfgRegSmoothEn,                                                                      
  input  wire                 CfgRegSmoothForce,                                                                   
  input  wire [1:0]           CfgRegSmoothFilterSet,                                  
  input  wire [7:0]           CfgRegSmoothSNRThrHigh,                                                              
  input  wire [7:0]           CfgRegSmoothSNRThrMid,                                                               

  // To Frequency Offset Compensation                                                                           
  input  wire                 CfgRegStoTdCompEn,                                                                   
  input  wire [5:0]           CfgRegMaxPtdSyncOff,                                                                 
  input  wire [5:0]           CfgRegMaxNtdSyncOff,                                                                 
  input  wire                 CfgRegStoFdCompEn,                                                                   
  input  wire                 CfgRegStoMode,                                                                       
  input  wire [4:0]           CfgRegSTOCompTime,
  input  wire                 CfgRegCpeFdCompEn,                                                                   
  input  wire                 CfgRegCpeMode,                                                                       
  input  wire                 CfgRegStoSlopeEstEn,                                                                 
  input  wire [21:0]          CfgRegStoSlopeForced,                                                                
  input  wire                 CfgRegCpeSlopeEstEn,                                                                 
  input  wire [21:0]          CfgRegCpeSlopeForced,                                                                
  input  wire                 CfgRegStoSlopeLgHt,
  input  wire                 CfgRegCpeSlopeLgHt,
  input  wire                 CfgRegCpeRef,                                                                        
  input  wire                 CfgRegStoRef,                                                                        
  input  wire                 CfgRegCpeWalk,                                                                       
  input  wire                 CfgRegSTO4TDComp,                                                                    

  // To Equaliser                                                                                               
  input  wire                 CfgRegForce20,
  input  wire [7:0]           CfgRegFddcSnrThreshold,                                                                 
  input  wire                 CfgRegFddcCompEn,                                                                       
  input  wire [2:0]           CfgRegFddcWeightM2,                                                                     
  input  wire [2:0]           CfgRegFddcWeightM1,                                                                     
  input  wire [2:0]           CfgRegFddcWeightP1,                                                                     
  input  wire [2:0]           CfgRegFddcWeightP2,                                                                     
  input  wire [2:0]           CfgRegSatSbLDPCNSTS1,
  input  wire [2:0]           CfgRegSatSbBCCNSTS1,
  input  wire [2:0]           CfgRegSatSbLDPCNSTS0,
  input  wire [2:0]           CfgRegSatSbBCCNSTS0,
  input  wire [2:0]           CfgRegMhShiftVal,
  input  wire [7:0]           CfgRegMhShiftThr,
  input  wire [7:0]           CfgRegNoiseVarAdjustdB,
`ifdef RW_MUMIMO_RX_EN
  input  wire [2:0]           CfgRegSatSbMULDPCNSTS1,
  input  wire [2:0]           CfgRegSatSbMUBCCNSTS1,
  input  wire [2:0]           CfgRegSatSbMULDPCNSTS0,
  input  wire [2:0]           CfgRegSatSbMUBCCNSTS0,
`endif // RW_MUMIMO_RX_EN

`ifdef RW_NX_LDPC_DEC
  // To RXFD LDPC fifo
  input  wire [8:0]           mdmcfg_ldpcdec_fifo_thr,
`endif // RW_NX_LDPC_DEC

  // To status register
  output wire [5:0]           StatusTdSynchOff,
  output wire [21:0]          StatusStoSlope,
  output wire [21:0]          StatusCpeSlope,
  output reg  [21:0]          StatusFDOPreamb,
  output reg  [21:0]          StatusFDOData,
  output wire [27:0]          StatusMh,
  output wire [19:0]          StatusMhscMax,

  /*****************************************************************************
  * frame parameters
  *****************************************************************************/
  input  wire                 FrameParam1Update,
  input  wire [ 1:0]          FrameParam1NSD,
  input  wire [ 2:0]          FrameParam1NBPSC0,
  input  wire [ 2:0]          FrameParam1NBPSC1,
  input  wire [ 2:0]          FrameParam1NSS,
  input  wire [ 2:0]          FrameParam1NSTS,
  input  wire [ 1:0]          FrameParam1NESS,
  input  wire                 FrameParam1STBC,
  input  wire                 FrameParam1FEC,
  input  wire                 FrameParam1Smoothing,
  input  wire                 FrameParam1HTNDP,
`ifdef RW_MUMIMO_RX_EN
  input  wire                 FrameParam1MuMIMO,
  input  wire [ 2:0]          FrameParam1MuNSTS,
  input  wire [ 2:0]          FrameParam1MuPreUserNSTS,
  input  wire                 FrameParam1MuFEC,
  input  wire [ 1:0]          FrameParam1MuPosID,
`endif // RW_MUMIMO_RX_EN
  input  wire [ 2:0]          FrameParam1NHeltf,
  input  wire [ 2:0]          FrameParam1NBPSCHeSigB,
  input  wire [1:0]           FrameParam1CBW,
  input  wire [1:0]           FrameParam1HeltfType, // 0-3.2us / 1-6.4us / 2-12.8us
  input  wire                 FrameParam1Doppler,
  input  wire                 FrameParam1Midamble,
  input  wire                 FrameParam1DCM,
  input  wire [ 2:0]          FrameParam1HESIGBMCS,
  input  wire                 FrameParam1HESIGBDCM,
 
  input  wire                 FrameParam2Update,
  input  wire [ 2:0]          FrameParam2RUType,
  input  wire [ 5:0]          FrameParam2RUIndex,
  input  wire [ 2:0]          FrameParam2MuNBPSC,
  input  wire                 FrameParam2HEMUFEC,
  input  wire                 FrameParam2HEMUDCM,
  
`ifdef RW_MUMIMO_RX_EN
  input  wire [ 2:0]          FrameParam2HEMUNSTS,
  input  wire [ 2:0]          FrameParam2HEMUNSTSTot,
  input  wire [ 2:0]          FrameParam2HEMUPreUserNSTS,
  input  wire [ 3:0]          FrameParam2HEMURUNUser,
  input  wire [ 2:0]          FrameParam2HEMURUUser,
`endif // RW_MUMIMO_RX_EN

  input  wire                 FrameParam3Update,
  input  wire                 FrameParam3RLSIG,

  input  wire                 FrameParam4Update,
  input  wire                 FrameParam4LSIG6M,
  
  input  wire                 FrameParam6Update,
  input  wire                 FrameParam6HeSu,      // If frame is HE, frame is HE-SU or HE-TB
  
  input  wire                 FrameParam7Update,
  input  wire [ 7:0]          FrameParam7NHeSigB,

  input  wire                 FrameParam8Update,
  input  wire [15:0]          FrameParam8NSym,
  input  wire [ 8:0]          FrameParam8NMA,

  /*****************************************************************************
  * AGC                                                                                              
  *****************************************************************************/
  input  wire [7:0]           SNR,
  input  wire [7:0]           NoiseVardB,

  /*****************************************************************************
  * Buffer managment                                                                                 
  *****************************************************************************/
  /* TD-FD */
  input  wire [1:0]           FFTBufPtr,
  output wire [1:0]           FDFFTBufRdPtr,
  
  /* BDFD */
  input  wire                 bdfd_rdptr,
  output wire                 bdfd_wrptr,
  output wire                 bdfd_qbpsk,
  
  input  wire [2:0]           bdfd_ch0_rdptr,
  output wire [2:0]           bdfd_ch0_wrptr,
  input  wire [2:0]           bdfd_ch1_rdptr,
  output wire [2:0]           bdfd_ch1_wrptr,

  output wire [2:0]           bdfd_row_fifo_wrptr,
  input  wire [2:0]           bdfd_row_fifo_rdptr,

  /*****************************************************************************
  * BD
  *****************************************************************************/
  input  wire                 BDDone,

  /*****************************************************************************
  * TD                                                                                 
  *****************************************************************************/
  output wire [3:0]           TDFormatMod,
  output wire [5:0]           TDSynchSkip,

  /* FFT buffer read port */
  input  wire [12:0]          FFT0MemRdDataRe,
  input  wire [12:0]          FFT0MemRdDataIm,
  input  wire                 FFT0MemRdDataValid,
  output wire [8:0]           FFTMemRdAddr,
  output wire                 FFTMemRdEn,
  output wire                 FFTMemRdPS,

  /*****************************************************************************
  * H
  *****************************************************************************/
  /* read port  */
  input  wire [12:0]          HMemRdDataRe0,
  input  wire [12:0]          HMemRdDataIm0,
  input  wire [12:0]          HMemRdDataRe1,
  input  wire [12:0]          HMemRdDataIm1,
  input  wire [12:0]          HMemRdDataRe2,
  input  wire [12:0]          HMemRdDataIm2,
  input  wire [12:0]          HMemRdDataRe3,
  input  wire [12:0]          HMemRdDataIm3,
  input  wire                 HMemRdDataValid,
  output wire [8:0]           HMemRdAddr,
  output wire                 HMemRdEn0,
  output wire                 HMemRdEn1,
  output wire                 HMemRdEn2,
  output wire                 HMemRdEn3,
    
  /* write port */
  output wire [8:0]           HMemWrAddr,
  output wire [1:0]           HMemWrEn0,
  output wire [12:0]          HMemWrDataRe0,
  output wire [12:0]          HMemWrDataIm0,
  output wire [1:0]           HMemWrEn1,
  output wire [12:0]          HMemWrDataRe1,
  output wire [12:0]          HMemWrDataIm1,
  output wire [1:0]           HMemWrEn2,
  output wire [12:0]          HMemWrDataRe2,
  output wire [12:0]          HMemWrDataIm2,
  output wire [1:0]           HMemWrEn3,
  output wire [12:0]          HMemWrDataRe3,
  output wire [12:0]          HMemWrDataIm3,
  
  /*****************************************************************************
  * bdfd ports
  *****************************************************************************/
  /* bcc write port */
  output wire                 bdfd_bcc_wsel,
  output wire                 bdfd_bcc_wen,
  output wire [ 8:0]          bdfd_bcc_waddr,
  output wire [39:0]          bdfd_bcc_wdata,
 
  /*****************************************************************************
  * stbc ports
  *****************************************************************************/
  output wire                 stbc_wen,
  output wire [ 8:0]          stbc_waddr,
  output wire [75:0]          stbc_wdata,
  output wire                 stbc_ren,     
  output wire [ 8:0]          stbc_raddr,   
  input  wire [75:0]          stbc_rdata,   

`ifdef RW_NX_LDPC_DEC
  /* ldpc read/write ports */
  output wire                 bdfd_ldpc_wen,
  output wire [ 6:0]          bdfd_ldpc_waddr,
  output wire [59:0]          bdfd_ldpc_wdata,
  output wire                 bdfd_ldpc_ren,
  output wire [ 6:0]          bdfd_ldpc_raddr,
  input  wire [59:0]          bdfd_ldpc_rdata,
  
  /* to bd */
  input  wire                 bdfd_ldpc_ready,
  output wire [59:0]          bdfd_ldpc_data,
  output wire [ 3:0]          bdfd_ldpc_len,
  output wire                 bdfd_ldpc_last,
  output wire                 bdfd_ldpc_valid,
`endif

`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * Bemformee report
  *****************************************************************************/
  // controls
  input  wire                 bfmeeBFRStart,             // Control input, a rising edge indicates a request to start.
  output wire                 bfmeeSVDDone,
  // mpif config
  input  wire [1:0]           bfmeeCfgNg,
  input  wire [1:0]           bfmeeCfgChBw,
  input  wire                 bfmeeCfgFeedbackType,
  input  wire                 bfmeeCfgCodebook,
  input  wire [1:0]           bfmeeCfgNr,
  input  wire [1:0]           bfmeeCfgNc,             
  input  wire                 bfmeeCfgHe,             
  input  wire [5:0]           bfmeeCfgHeRUStartIndex, 
  input  wire [5:0]           bfmeeCfgHeRUEndIndex,   
  // phy config
  input  wire [3:0]           bfmeeCfgRxAntSel,
  input  wire [9:0]           bfmeeCfgSnrScaling,     
  // data
  input  wire                 bfmeeDataReady,
  output wire [31:0]          bfmeeData,
  output wire [ 3:0]          bfmeeDataValid,
  // bfmee memory
  output wire [`RW_BFMEE_RAM_AWIDTH-1:0] bfmeeMemAddr,
  output wire                 bfmeeMemWrEn,
  output wire [31:0]          bfmeeMemWrData,
  output wire                 bfmeeMemEn,
  input  wire [31:0]          bfmeeMemRdData,
  // H memory clock gating
  output wire                 bfmeeHMemIfActive,
`endif // RW_BFMEE_EN

  /*****************************************************************************
  * Diag and Debug
  *****************************************************************************/
`ifdef RW_BFMEE_EN
  output wire [15:0]          DiagBfmee0,                                                                      
`endif // RW_BFMEE_EN
  output wire [15:0]          DiagFDO0,                                                                      
  output wire [15:0]          DiagFDO1,                                                                      
  output wire [15:0]          DiagFDO2,                                                                      
  output wire [15:0]          DiagFDO3,                                                                      
  output wire [15:0]          DiagEq,                                                                        
  output wire [31:0]          DiagFSM                                                                      
);

//////////////////////////////////////////////////////////////////////////////
// Local Parameters Declarations
//////////////////////////////////////////////////////////////////////////////

// SymbolType definition
localparam [2:0] L_LTF    = 3'd0,
                 VHT_LTF  = 3'd1,
                 HT_LTF   = 3'd2,
                 HE_1xLTF = 3'd4,
                 HE_2xLTF = 3'd5,
                 HE_4xLTF = 3'd6,
                 HE_LSIG  = 3'd7;

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg          CfgSmoothEn_1t;
  reg [ 1:0]   SmoothFilterSetMux;
  
  reg          EqPilotValid_1t;
  reg [19:0]   EqPilotRe_1t,EqPilotIm_1t;
  reg          EqPilotValid_2t;
  reg [19:0]   EqPilotRe_2t,EqPilotIm_2t;
  reg          EqPilotValid_3t;
  reg [19:0]   EqPilotRe_3t,EqPilotIm_3t;
  reg          EqPilotValid_4t;          
  reg [19:0]   EqPilotRe_4t,EqPilotIm_4t;
  reg          EqPilotValid_5t;
  reg [19:0]   EqPilotRe_5t,EqPilotIm_5t;
  reg          EqPilotValid_6t;
  reg [19:0]   EqPilotRe_6t,EqPilotIm_6t;
  reg          EqPilotValid_7t;
  reg [19:0]   EqPilotRe_7t,EqPilotIm_7t;
 
  reg [ 9:0]   FDOCarrierNb_1t;
  reg [ 9:0]   FDOCarrierNb_2t;
 
  wire [19:0]  EqPilotReMEq,EqPilotImMEq;
  wire         EqPilotValidMEq;
 
  wire [12:0]  FDODataRe1,FDODataIm1;
  wire         FDODataValid;

  wire         ChEstSmoothEn;
  wire         SmoothEn;
  wire         ChEstEstimEn;
  wire         ChEstDataEn;
  wire [ 3:0]  ChEstReceptionMode;
  wire [ 2:0]  ChEstRxNsts;
`ifdef RW_NX_DERIV_NESS_EN
  wire [ 1:0]  ChEstRxNess;
`endif
  wire         ChEstSmoothFromH;
  wire         ChEstFirstLTF,ChEstLastLTF;
  wire [ 3:0]  ChEstNShiftLTF;
  wire [ 2:0]  ChEstSymbolType;
  wire [ 2:0]  ChEstRUType;
  wire [ 5:0]  ChEstRUIndex;
  wire         ChEstFrameNDP;
  wire         ChEstStartP;
  wire         ChEstDoneP;
  wire         ChEstSmthDoneP;
`ifdef RW_MUMIMO_RX_EN
  wire         ChEstHEMuMIMOEn;
`endif // RW_MUMIMO_RX_EN
  wire         FD2DEn;
`ifdef RW_MUMIMO_RX_EN
  wire [1:0]   HMuMIMOSel;
`endif // RW_MUMIMO_RX_EN
  wire [9:0]   FDHEMUOffset;
  wire [9:0]   FDHEMUOffsetMux;

  wire         EqStride;
  wire         EqHeSigBPAPREn;
`ifdef RW_MUMIMO_RX_EN
  wire         EqMuMIMOEn;
  wire         EqVHTSIGBInv;
`endif // RW_MUMIMO_RX_EN
  wire [ 2:0]  EqModTypeSS1;
  wire         EqMHUpdate;
  wire         EqDoneP;
  wire         EqPilotDoneP;
  wire         EqStartP;
  wire         EqModeIs2040;
  wire         EqCompStartP;
  wire         EqCompDoneP;
  wire [ 3:0]  EqReceptionMode;
  wire         EqDiscEn;
  wire [ 2:0]  EqRxNsts;
  wire [ 2:0]  EqRxNss;
  wire         EqSTBCEn;
  wire         EqSTBCSymOdd;
  wire         EqSTBCFlush;
  wire         EqSTBCFlushDone;
  wire         EqLDPCEn;
  wire         EqDCMEn;
  wire         EqQbpskDet;
  wire         EqQbpskDetDoneP;
  wire         EqPilotData;
  wire [ 9:0]  CarrierNb;
  wire         EqPipeFlushDoneP;
  wire [ 2:0]  EqRUType;
  wire [ 5:0]  EqRUIndex; 
  wire [24:0]  SigmaSquared;
  
  wire         DcmSBValid;

  wire [ 4:0]  DcmSS1SB0,DcmSS1SB1,DcmSS1SB2,DcmSS1SB3;
  wire [ 4:0]  DcmSS1SB4,DcmSS1SB5,DcmSS1SB6,DcmSS1SB7;
  wire [ 4:0]  DcmSS1SB8,DcmSS1SB9;
  
  wire         SBValid;
  wire         SBLast;
  wire         SBOdd;
  wire [ 4:0]  SS1SB0,SS1SB1,SS1SB2,SS1SB3;
  wire [ 4:0]  SS1SB4,SS1SB5,SS1SB6,SS1SB7;
  wire [ 4:0]  SS1SB8,SS1SB9;
 
  wire         FDOFFTRxDataValid;
  wire         FDOEstStartP;
  wire         FDOCompDoneP;
  wire [ 1:0]  FDOMode; //0-LM,1-VHT,2-Mixed Mode;3-GF Mode                   
  wire [ 3:0]  FDOReceptionMode;
  wire [ 2:0]  FDORUType;
  wire         FDOInitPilotShRegP;
  wire         FDOInitKalmanRegP;
  wire         FDOInitKalmanSlopeRegP;
  wire         FDORxNsts;
  wire [16:0]  FDOSymCount;                                                   
`ifdef RW_NX_DERIV_NESS_EN
  wire [ 2:0]  FDNELTF;
`endif
  wire [ 3:0]  FDNDLTF;
  wire         FDReset;
  wire         FDOSTOFineMuxSel;
  wire         FDOStorePreamb;
  wire         FDOStoreData;
  wire [ 3:0]  FDOMidMulSlope;
  wire [ 1:0]  FDOMidRShiftSlope;

  wire         deintlv_start;
  wire         deintlv_busy;
  wire         deintlv_chsel;
  wire         deintlv_row_fifo_en;
  wire         deintlv_bcc_enable;                                       
  wire         deintlv_ldpc_enable;                                       
  wire         deintlv_fec;                                       
  wire [ 1:0]  deintlv_nsd;
  wire [ 2:0]  deintlv_nbpsc;
  wire         deintlv_ruen;
  wire [ 2:0]  deintlv_rulen;
  wire         deintlv_dcm;
  wire [ 1:0]  deintlv_iss;
  wire         deintlv_sigen;
  wire [ 1:0]  deintlv_sigsel;
 
  wire         ldpc_fifo_ready;
 
  wire [9:0]   HMemWrAddrEqu;
  wire         HMemWrAddrEnChEst;
  wire [9:0]   HMemWrAddrChEst;
  wire [1:0]   HMemWrBEnChEst0;
  wire [12:0]  HMemWrDataChEstRe0;
  wire [12:0]  HMemWrDataChEstIm0;
  wire [1:0]   HMemWrBEnChEst1;
  wire [12:0]  HMemWrDataChEstRe1;
  wire [12:0]  HMemWrDataChEstIm1;
  wire [1:0]   HMemWrBEnChEst2;
  wire [12:0]  HMemWrDataChEstRe2;
  wire [12:0]  HMemWrDataChEstIm2;
  wire [1:0]   HMemWrBEnChEst3;
  wire [12:0]  HMemWrDataChEstRe3;
  wire [12:0]  HMemWrDataChEstIm3;
  wire         HMemWrAddrEn;
  wire [9:0]   HMemWrAddrMux;
  
  wire         HMemRdAddrEnChEst;
  wire [ 9:0]  HMemRdAddrChEst;
  wire [ 9:0]  HMemRdAddrMEq;
  wire         HMemRdAddrEnMEq;
  wire [ 8:0]  HMemRdAddrMux;
 
  wire         FFTMemRdAddrEnMEq;
  wire [ 9:0]  FFTMemRdAddrMEq;
  wire         FFTMemRdAddrEnChEst;
  wire [ 9:0]  FFTMemRdAddrChEst;
  wire [ 8:0]  FFTMemRdAddrMux;
  
  wire [ 1:0]  FDOBW;

`ifdef RW_BFMEE_EN
  wire         bfmeeHMemIfRdEn;
  wire [8:0]   bfmeeHMemIfRdAddr;
  wire [103:0] bfmeeHMemIfRdData;
  wire         bfmeeHMemIfRdDataVld;
`endif // RW_BFMEE_EN

  //////////////////////////////////////////////////////////////////////////////
  // Begining of Logic part
  //////////////////////////////////////////////////////////////////////////////

  /*****************************************************************************
  * RxFreqDomainStMc
  *****************************************************************************/
  RxFreqDomainStMc U_RxFreqDomainStMc
  (
    /***************************************************************************
    * system 
    ****************************************************************************/
    .PhyClk(                     PhyClk),                                
    .nPhyRst(                    nPhyRst),                               
    
    /***************************************************************************
    * gated clock enables      
    ****************************************************************************/
    .ChEstGClkEn(                ChEstGClkEn),                           
    .EquGClkEn(                  EquGClkEn),
    .FDOGClkEn(                  FDOGClkEn),
    
    /***************************************************************************
    * Global Control 
    ****************************************************************************/
    .FDEnable(                   FDEnable),
    .FDDone(                     FDDone),                          
    
    /***************************************************************************
    * Config register
    ****************************************************************************/
    .CfgRegNrx(                  CfgRegNrx),                                                      
    .CfgRegMUSmoothForce(        CfgRegMUSmoothForce),
    .CfgRegBFSmoothForce(        CfgRegBFSmoothForce),
    .CfgRegSTOCompTime(          CfgRegSTOCompTime),
    .CfgRegForce20(              CfgRegForce20),
    .CfgRegPrimary(              CfgRegPrimary),
    .CfgRegSkipMidamble1x(       CfgRegSkipMidamble1x),
    .CfgRegSkipMidamble2x(       CfgRegSkipMidamble2x),
    .CfgRegSkipMidamble4x(       CfgRegSkipMidamble4x),
    
    /*****************************************************************************
    * frame parameters
    *****************************************************************************/
    .FrameParam1Update(          FrameParam1Update),    
    .FrameParam1NSD(             FrameParam1NSD),       
    .FrameParam1NBPSC0(          FrameParam1NBPSC0),   
    .FrameParam1NBPSC1(          FrameParam1NBPSC1),   
    .FrameParam1NSS(             FrameParam1NSS),       
    .FrameParam1NSTS(            FrameParam1NSTS),      
`ifdef RW_NX_DERIV_NESS_EN
    .FrameParam1NESS(            FrameParam1NESS),      
`endif
    .FrameParam1STBC(            FrameParam1STBC),      
    .FrameParam1FEC(             FrameParam1FEC),     
    .FrameParam1Smoothing(       FrameParam1Smoothing),            
    .FrameParam1HTNDP(           FrameParam1HTNDP),
`ifdef RW_MUMIMO_RX_EN
    .FrameParam1MuMIMO(          FrameParam1MuMIMO),
    .FrameParam1MuNSTS(          FrameParam1MuNSTS),
    .FrameParam1MuPreUserNSTS(   FrameParam1MuPreUserNSTS),
    .FrameParam1MuFEC(           FrameParam1MuFEC),
    .FrameParam1MuPosID(         FrameParam1MuPosID),
`endif // RW_MUMIMO_RX_EN
    .FrameParam1NHeltf(          FrameParam1NHeltf),
    .FrameParam1NBPSCHeSigB(     FrameParam1NBPSCHeSigB),
    .FrameParam1CBW(             FrameParam1CBW),
    .FrameParam1HeltfType(       FrameParam1HeltfType),
    .FrameParam1Doppler(         FrameParam1Doppler),
    .FrameParam1Midamble(        FrameParam1Midamble),
    .FrameParam1DCM(             FrameParam1DCM),
    .FrameParam1HESIGBMCS(       FrameParam1HESIGBMCS),
    .FrameParam1HESIGBDCM(       FrameParam1HESIGBDCM),
     
    .FrameParam2Update(          FrameParam2Update),
    .FrameParam2MuNBPSC(         FrameParam2MuNBPSC),
    .FrameParam2RUType(          FrameParam2RUType),
    .FrameParam2RUIndex(         FrameParam2RUIndex),
    .FrameParam2HEMUFEC(         FrameParam2HEMUFEC),
    .FrameParam2HEMUDCM(         FrameParam2HEMUDCM),
`ifdef RW_MUMIMO_RX_EN
    .FrameParam2HEMUNSTS(        FrameParam2HEMUNSTS),
    .FrameParam2HEMUNSTSTot(     FrameParam2HEMUNSTSTot),
    .FrameParam2HEMUPreUserNSTS( FrameParam2HEMUPreUserNSTS),
    .FrameParam2HEMURUNUser(     FrameParam2HEMURUNUser),
    .FrameParam2HEMURUUser(      FrameParam2HEMURUUser),
`endif // RW_MUMIMO_RX_EN
  
    .FrameParam3Update(          FrameParam3Update),
    .FrameParam3RLSIG(           FrameParam3RLSIG),
  
    .FrameParam4Update(          FrameParam4Update),    
    .FrameParam4LSIG6M(          FrameParam4LSIG6M),

    .FrameParam6Update(          FrameParam6Update),    
    .FrameParam6HeSu(            FrameParam6HeSu),
    
    .FrameParam7Update(          FrameParam7Update),
    .FrameParam7NHeSigB(         FrameParam7NHeSigB),
    
    .FrameParam8Update(          FrameParam8Update),
    .FrameParam8NSym(            FrameParam8NSym),
    .FrameParam8NMA(             FrameParam8NMA),

    /*****************************************************************************
    * Buffer management                                                                                     
    *****************************************************************************/
    .FFTBufPtr(                  FFTBufPtr),
    .FDFFTBufRdPtr(              FDFFTBufRdPtr),
    
    .bdfd_rdptr(                 bdfd_rdptr),       
    .bdfd_wrptr(                 bdfd_wrptr),       
    .bdfd_qbpsk(                 bdfd_qbpsk),      
    
    .bdfd_ch0_rdptr(             bdfd_ch0_rdptr),
    .bdfd_ch0_wrptr(             bdfd_ch0_wrptr),
    .bdfd_ch1_rdptr(             bdfd_ch1_rdptr),
    .bdfd_ch1_wrptr(             bdfd_ch1_wrptr),
   
    /*****************************************************************************
    * BD
    *****************************************************************************/
    .BDDone(                     BDDone),

    /*****************************************************************************
    * FD
    *****************************************************************************/
    .FDReset(                    FDReset),                                               
`ifdef RW_NX_DERIV_NESS_EN
    .FDNELTF(                    FDNELTF),
`endif
    .FDNDLTF(                    FDNDLTF),
    .FD2DEn(                     FD2DEn),
    .FDHEMUOffset(               FDHEMUOffset),
`ifdef RW_MUMIMO_RX_EN
    .HMuMIMOSel(                 HMuMIMOSel),
`endif
    
    /*****************************************************************************
    * TD
    *****************************************************************************/
    .TDFormatMod(                TDFormatMod),

    /*****************************************************************************
    * Channel Estimate    
    *****************************************************************************/
    .ChEstStartP(                ChEstStartP),                           
    .ChEstReceptionMode(         ChEstReceptionMode),                    
    .ChEstRxNsts(                ChEstRxNsts),                           
`ifdef RW_NX_DERIV_NESS_EN
    .ChEstRxNess(                ChEstRxNess),                           
`endif
    .ChEstSmoothEn(              ChEstSmoothEn),                         
    .ChEstSmoothFromH(           ChEstSmoothFromH),                      
    .ChEstNShiftLTF(             ChEstNShiftLTF),                         
    .ChEstFirstLTF(              ChEstFirstLTF),                         
    .ChEstLastLTF(               ChEstLastLTF),                          
    .ChEstSymbolType(            ChEstSymbolType),                       
    .ChEstRUType(                ChEstRUType),                       
    .ChEstRUIndex(               ChEstRUIndex),                       
    .ChEstFrameNDP(              ChEstFrameNDP),                       
    .ChEstDoneP(                 ChEstDoneP),                            
    .ChEstSmthDoneP(             ChEstSmthDoneP),                            
`ifdef RW_MUMIMO_RX_EN
    .ChEstHEMuMIMOEn(            ChEstHEMuMIMOEn),
`endif // RW_MUMIMO_RX_EN
 
    /*****************************************************************************
    * Equalizer                                                              
    *****************************************************************************/
    .EqStartP(                   EqStartP),                              
    .EqCompStartP(               EqCompStartP),                          
    .EqReceptionMode(            EqReceptionMode),                       
    .EqStride(                   EqStride),
    .EqHeSigBPAPREn(             EqHeSigBPAPREn),
`ifdef RW_MUMIMO_RX_EN
    .EqMuMIMOEn(                 EqMuMIMOEn),
    .EqVHTSIGBNss2(              ),
    .EqVHTSIGBSub(               ),
    .EqVHTSIGBInv(               EqVHTSIGBInv),
    .EqMuMIMOICEn(               ),
`endif // RW_MUMIMO_RX_EN
    .EqSTBCEn(                   EqSTBCEn),                              
    .EqSTBCSymOdd(               EqSTBCSymOdd),                              
    .EqSTBCFlush(                EqSTBCFlush),                              
    .EqSTBCFlushDone(            EqSTBCFlushDone),                              
    .EqLDPCEn(                   EqLDPCEn),                              
    .EqDCMEn(                    EqDCMEn),                              
    .EqPilotData(                EqPilotData),                           
    .EqRxNsts(                   EqRxNsts),                              
    .EqRxNss(                    EqRxNss),                               
    .EqDiscEn(                   EqDiscEn),                              
    .EqModTypeSS1(               EqModTypeSS1),                          
    .EqMHUpdate(                 EqMHUpdate),                          
    .EqPipeFlushDoneP(           EqPipeFlushDoneP),                                  
    .EqDoneP(                    EqDoneP),                                  
    .EqPilotDoneP(               EqPilotDoneP),                                      
    .EqCompDoneP(                EqCompDoneP), 
    .EqQbpskDet(                 EqQbpskDet),                                 
    .EqQbpskDetDoneP(            EqQbpskDetDoneP),
    .EqRUType(                   EqRUType),
    .EqRUIndex(                  EqRUIndex),
   
    /*****************************************************************************
    * FDO                                                              
    *****************************************************************************/
    .FDOEstStartP(               FDOEstStartP),
    .FDOBW(                      FDOBW),
    .FDOMode(                    FDOMode),                           
    .FDOSymCount(                FDOSymCount),                       
    .FDOReceptionMode(           FDOReceptionMode),                  
    .FDORUType(                  FDORUType),                  
    .FDOSTOFineMuxSel(           FDOSTOFineMuxSel),
    .FDORxNsts(                  FDORxNsts),
    .FDOInitPilotShP(            FDOInitPilotShRegP),                     
    .FDOInitKalmanP(             FDOInitKalmanRegP),                      
    .FDOInitKalmanSlopeP(        FDOInitKalmanSlopeRegP),
    .FDOCompDoneP(               FDOCompDoneP),                        
    .FDOStorePreamb(             FDOStorePreamb),
    .FDOStoreData(               FDOStoreData),
    .FDOMidMulSlope(             FDOMidMulSlope),
    .FDOMidRShiftSlope(          FDOMidRShiftSlope),
   
    /*****************************************************************************
    * Deinterleaver
    *****************************************************************************/
    .deintlv_start(              deintlv_start),
    .deintlv_busy(               deintlv_busy),
    .deintlv_row_fifo_en(        deintlv_row_fifo_en),
    .deintlv_chsel(              deintlv_chsel),                           
    .deintlv_fec(                deintlv_fec),
    .deintlv_nsd(                deintlv_nsd),
    .deintlv_dcm(                deintlv_dcm),
    .deintlv_iss(                deintlv_iss),
    .deintlv_nbpsc(              deintlv_nbpsc),
    .deintlv_ruen(               deintlv_ruen),
    .deintlv_rulen(              deintlv_rulen),
    .deintlv_sigen(              deintlv_sigen),
    .deintlv_sigsel(             deintlv_sigsel),

    /*****************************************************************************
    * Diag
    *****************************************************************************/
    .Diag(                       DiagFSM)
  );

  assign EqModeIs2040 = ~CfgRegForce20;

  /*****************************************************************************
  * FFT port sharing
  *****************************************************************************/
  /* FFT read port muxing */
  assign FFTMemRdAddrMux = (FFTMemRdAddrEnChEst) ? FFTMemRdAddrChEst[8:0] : FFTMemRdAddrMEq;
  // Divide HE-MU-40 offset by 2 when ChEstSmthTop is reading FFT of HE-LTF 2x
  assign FDHEMUOffsetMux = (FFTMemRdAddrEnChEst && ChEstSymbolType==HE_2xLTF) ? {FDHEMUOffset[9],FDHEMUOffset[9:1]} :
                                                                                 FDHEMUOffset;
  assign FFTMemRdAddr    = FFTMemRdAddrMux + $signed(FDHEMUOffsetMux);

  assign FFTMemRdEn   = FFTMemRdAddrEnChEst | FFTMemRdAddrEnMEq;
  assign FFTMemRdPS   = FD2DEn & FFTMemRdEn;
  
  assign FDOFFTRxDataValid = FFT0MemRdDataValid & ~EqPilotData;         
 
  always @(posedge PhyClk,negedge nPhyRst)
    if(!nPhyRst) 
    begin
      FDOCarrierNb_1t <= 10'b0;                     
      FDOCarrierNb_2t <= 10'b0;                     
    end
    else 
    begin
      FDOCarrierNb_1t <= $signed(CarrierNb) + $signed(FDHEMUOffset);
      FDOCarrierNb_2t <= FDOCarrierNb_1t;
    end
 
  /*****************************************************************************
  * H ports sharing
  *****************************************************************************/
  assign HMemRdAddrMux =
`ifdef RW_BFMEE_EN
   (bfmeeHMemIfActive) ? 
                          bfmeeHMemIfRdAddr :
`endif // RW_BFMEE_EN
    // todo review address for secondary
   ( (HMemRdAddrEnChEst) ? {HMemRdAddrChEst[8:6],(HMemRdAddrChEst[5]^FD2DEn),HMemRdAddrChEst[4:0]} :
                           {HMemRdAddrMEq[8:6],(HMemRdAddrMEq[5]^FD2DEn),HMemRdAddrMEq[4:0]});
  assign HMemRdAddr  = HMemRdAddrMux + $signed(FDHEMUOffset);
  assign HMemRdEn0   = HMemRdAddrEnChEst | HMemRdAddrEnMEq
`ifdef RW_BFMEE_EN
   | bfmeeHMemIfRdEn
`endif // RW_BFMEE_EN
   ;
  assign HMemRdEn1   = (HMemRdAddrEnChEst & (|ChEstRxNsts 
`ifdef RW_MUMIMO_RX_EN
   | ChEstHEMuMIMOEn
`endif // RW_MUMIMO_RX_EN
  )) | (HMemRdAddrEnMEq & (EqRxNsts[0]
`ifdef RW_MUMIMO_RX_EN
   | (HMuMIMOSel[0] & ~HMuMIMOSel[1])
`endif // RW_MUMIMO_RX_EN
  ))
`ifdef RW_BFMEE_EN
   | bfmeeHMemIfRdEn
`endif // RW_BFMEE_EN
   ;
  assign HMemRdEn2   = (HMemRdAddrEnChEst & (|ChEstRxNsts[2:1]
`ifdef RW_MUMIMO_RX_EN
   | ChEstHEMuMIMOEn
`endif // RW_MUMIMO_RX_EN
  )) | (~EqSTBCEn & HMemRdAddrEnMEq & (EqRxNsts[0]
`ifdef RW_MUMIMO_RX_EN
   | (~HMuMIMOSel[0] & HMuMIMOSel[1])
`endif // RW_MUMIMO_RX_EN
  ))
`ifdef RW_BFMEE_EN
   | bfmeeHMemIfRdEn
`endif // RW_BFMEE_EN
   ;
  assign HMemRdEn3   = (HMemRdAddrEnChEst & (|ChEstRxNsts[2:1]
`ifdef RW_MUMIMO_RX_EN
   | ChEstHEMuMIMOEn
`endif // RW_MUMIMO_RX_EN
  )) | (~EqSTBCEn & HMemRdAddrEnMEq & (EqRxNsts[0]
`ifdef RW_MUMIMO_RX_EN
   | (HMuMIMOSel[0] & HMuMIMOSel[1])
`endif // RW_MUMIMO_RX_EN
  ))
`ifdef RW_BFMEE_EN
   | bfmeeHMemIfRdEn
`endif // RW_BFMEE_EN
   ;
  
  /*****************************************************************************
  * FDO
  *****************************************************************************/
  /* EQU->FDO pilot pipelining */
  always @(posedge PhyClk,negedge nPhyRst)
    if(!nPhyRst) 
    begin
      {EqPilotValid_1t,EqPilotRe_1t,EqPilotIm_1t} <= 41'b0;
      {EqPilotValid_2t,EqPilotRe_2t,EqPilotIm_2t} <= 41'b0;
      {EqPilotValid_3t,EqPilotRe_3t,EqPilotIm_3t} <= 41'b0;
      {EqPilotValid_4t,EqPilotRe_4t,EqPilotIm_4t} <= 41'b0;
      {EqPilotValid_5t,EqPilotRe_5t,EqPilotIm_5t} <= 41'b0;
      {EqPilotValid_6t,EqPilotRe_6t,EqPilotIm_6t} <= 41'b0;
      {EqPilotValid_7t,EqPilotRe_7t,EqPilotIm_7t} <= 41'b0;
    end
    else 
    begin
      {EqPilotValid_1t,EqPilotRe_1t,EqPilotIm_1t} <= {EqPilotValidMEq,EqPilotReMEq,EqPilotImMEq};
      {EqPilotValid_2t,EqPilotRe_2t,EqPilotIm_2t} <= {EqPilotValid_1t,EqPilotRe_1t,EqPilotIm_1t};
      {EqPilotValid_3t,EqPilotRe_3t,EqPilotIm_3t} <= {EqPilotValid_2t,EqPilotRe_2t,EqPilotIm_2t};
      {EqPilotValid_4t,EqPilotRe_4t,EqPilotIm_4t} <= {EqPilotValid_3t,EqPilotRe_3t,EqPilotIm_3t};
      {EqPilotValid_5t,EqPilotRe_5t,EqPilotIm_5t} <= {EqPilotValid_4t,EqPilotRe_4t,EqPilotIm_4t};
      {EqPilotValid_6t,EqPilotRe_6t,EqPilotIm_6t} <= {EqPilotValid_5t,EqPilotRe_5t,EqPilotIm_5t};
      {EqPilotValid_7t,EqPilotRe_7t,EqPilotIm_7t} <= {EqPilotValid_6t,EqPilotRe_6t,EqPilotIm_6t};
    end

  FDOffsetTop 
  #(
    .NSTS_PARAM        (NSTS_PARAM),
    .HMEMDATAWIDTH     (13),
    .HMEMWIDTH         (HMEMWIDTH)
  )
  U_FDOffsetTop 
  (
    .PhyClk            (FDOGClk),                
    .nPhyRst           (nPhyRst),                
    //
    .FDReset           (FDReset),                 
    .WLSStartP         (FDOEstStartP),         
    .SubCarrierIndex   (FDOCarrierNb_2t),
    .ReceptionMode     (FDOReceptionMode),
    .RUType            (FDORUType),
    .MidMulSlope       (FDOMidMulSlope),
    .MidRShiftSlope    (FDOMidRShiftSlope),
    .Mode              (FDOMode),              
    .STOFineMuxSel     (FDOSTOFineMuxSel),
    .Bandwidth         (FDOBW),                   
    .InitPilotShRegP   (FDOInitPilotShRegP),        
    .InitKalmanRegP    (FDOInitKalmanRegP),
    .InitKalmanSlopeRegP(FDOInitKalmanSlopeRegP),
    //
    .EqPilotValid      (EqPilotValid_7t),        
    .EqPilotRe         (EqPilotRe_7t),           
    .EqPilotIm         (EqPilotIm_7t),
    //
`ifdef RW_BFMEE_EN
    .HMatrix           ({HMemRdDataIm0,HMemRdDataRe0,HMemRdDataIm1,HMemRdDataRe1,HMemRdDataIm2,HMemRdDataRe2,HMemRdDataIm3,HMemRdDataRe3}),
`else
    .HMatrix           ({HMemRdDataIm0,HMemRdDataRe0}),
`endif // RW_BFMEE_EN
    //
    .RxDataInRe1       (FFT0MemRdDataRe),      
    .RxDataInIm1       (FFT0MemRdDataIm),      
`ifdef RW_NX_DERIV_PATH1
    .RxDataInRe2       (13'b0),      
    .RxDataInIm2       (13'b0),      
`endif
    .RxDataInValid     (FDOFFTRxDataValid),          
    .SymCount          (FDOSymCount),          
    .RxNsts            (FDORxNsts),     
    .Dltf              (FDNDLTF[2:0]),                   
`ifdef RW_NX_DERIV_NESS_EN
    .Eltf              (FDNELTF),                   
`endif
    .CfgNrx            (CfgRegNrx),                                        
    .CfgStoTdCompEn    (CfgRegStoTdCompEn),         
    .CfgMaxPtdSyncOff  (CfgRegMaxPtdSyncOff),       
    .CfgMaxNtdSyncOff  (CfgRegMaxNtdSyncOff),       
    .CfgStoFdCompEn    (CfgRegStoFdCompEn),         
    .CfgStoMode        (CfgRegStoMode),             
    .CfgCpeFdCompEn    (CfgRegCpeFdCompEn),         
    .CfgCpeMode        (CfgRegCpeMode),             
    .CfgStoSlopeEstEn  (CfgRegStoSlopeEstEn),       
    .CfgStoSlopeForced (CfgRegStoSlopeForced),      
    .CfgCpeSlopeEstEn  (CfgRegCpeSlopeEstEn),       
    .CfgCpeSlopeForced (CfgRegCpeSlopeForced),
    .CfgStoSlopeLgHt   (CfgRegStoSlopeLgHt),
    .CfgCpeSlopeLgHt   (CfgRegCpeSlopeLgHt),
    .CfgCpeRef         (CfgRegCpeRef),              
    .CfgStoRef         (CfgRegStoRef),              
    .CfgCpeWalk        (CfgRegCpeWalk),             
    .CfgSTO4TDComp     (CfgRegSTO4TDComp),
    //
    .CfgTdSynchOffStat (StatusTdSynchOff),
    .CfgStoSlopeStat   (StatusStoSlope),
    .CfgCpeSlopeStat   (StatusCpeSlope),
    //
    .SynchSkip         (TDSynchSkip),              
    //
    .RxDataOutRe1      (FDODataRe1),
    .RxDataOutIm1      (FDODataIm1),
`ifdef RW_NX_DERIV_PATH1
    .RxDataOutRe2      (),
    .RxDataOutIm2      (),
`endif
    .RxDataOutValid    (FDODataValid),
    //
    .FDOCompDoneP      (FDOCompDoneP)
  );


  // Register CPE slope at end of data and end of Preamble.
  // In later versions of the modem, the values may be averaged over several packets.
  always @(negedge nPhyRst,posedge PhyClk)
    if(!nPhyRst)
    begin
      StatusFDOPreamb <= 22'd0;
      StatusFDOData   <= 22'd0;
    end
    else
    begin
      if (FDOStorePreamb==1'b1)
        StatusFDOPreamb <= StatusCpeSlope;
      if (FDOStoreData==1'b1)
        StatusFDOData   <= StatusCpeSlope;
    end

  /*****************************************************************************
  * Equalizer
  *****************************************************************************/

  /* Noise variance Linear conversion */
  RxFDNoiseVarLin U_RxFDNoiseVarLin (
    .nPhyRst                (nPhyRst),
    .PhyClk                 (EquGClk),
    .CfgRegNoiseVarAdjustdB (CfgRegNoiseVarAdjustdB),
    .NoiseVardB             (NoiseVardB),
    .SigmaSquared           (SigmaSquared)
    );
  
  /*************************************
  // Equalizer SS1
  *************************************/
  reg [12:0]  H11Q,H11I,H12Q,H12I;
  reg [12:0]  ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I;

  always @(*)
  begin:g_bus_unpacking
    /* H unpacking */
`ifdef RW_MUMIMO_RX_EN
    if (~EqPilotData && HMuMIMOSel == 2'd1)
      {H11Q,H11I,H12Q,H12I} = {HMemRdDataIm1,HMemRdDataRe1, 26'b0};
    else if (~EqPilotData && HMuMIMOSel == 2'd2)
      {H11Q,H11I,H12Q,H12I} = {HMemRdDataIm2,HMemRdDataRe2, 26'b0};
    else if (~EqPilotData && HMuMIMOSel == 2'd3)
      {H11Q,H11I,H12Q,H12I} = {HMemRdDataIm3,HMemRdDataRe3, 26'b0};
    else
`endif // RW_MUMIMO_RX_EN
    if (NSTS_PARAM==1)
      {H11Q,H11I,H12Q,H12I} = {HMemRdDataIm0,HMemRdDataRe0,26'b0};
    else
      {H11Q,H11I,H12Q,H12I} = {HMemRdDataIm0,HMemRdDataRe0,HMemRdDataIm1,HMemRdDataRe1};

    /* ChEst unpacking */
`ifdef RW_MUMIMO_RX_EN
    if (HMuMIMOSel == 2'd1)
      {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I} = {HMemWrDataIm1,HMemWrDataRe1, 26'b0};
    else if (HMuMIMOSel == 2'd2)
      {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I} = {HMemWrDataIm2,HMemWrDataRe2, 26'b0};
    else if (HMuMIMOSel == 2'd3)
      {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I} = {HMemWrDataIm3,HMemWrDataRe3, 26'b0};
    else
`endif // RW_MUMIMO_RX_EN
    if (NSTS_PARAM==1)
      {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I} = {HMemWrDataIm0,HMemWrDataRe0,26'b0};
    else
      {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I} = {HMemWrDataIm0,HMemWrDataRe0,HMemWrDataIm1,HMemWrDataRe1};
  end
 
  /* R unpacking */
  wire [12:0]  R1Q,R1I;
  assign {R1Q,R1I} = (EqPilotData) ? {FFT0MemRdDataIm,FFT0MemRdDataRe} : {FDODataIm1,FDODataRe1};
  
  wire equ_enable;
  assign equ_enable = ~FDReset;

  EqualizerRX1SS1 U_EqualizerRX1SS1
  (
    /*****************************************************************************
    * system 
    *****************************************************************************/
    .nPhyRst(             nPhyRst), 
    .PhyClk(              EquGClk), 

    /*****************************************************************************
    * control
    *****************************************************************************/
    .enable(              equ_enable),

    /*****************************************************************************
    * config registers
    *****************************************************************************/
    .FddcSnrThreshold(    CfgRegFddcSnrThreshold),
    .FddcCompEn(          CfgRegFddcCompEn),
    .FddcWeightM2(        CfgRegFddcWeightM2),
    .FddcWeightM1(        CfgRegFddcWeightM1),
    .FddcWeightP1(        CfgRegFddcWeightP1),
    .FddcWeightP2(        CfgRegFddcWeightP2),
    .MhShiftVal(          CfgRegMhShiftVal),
    .MhShiftThr(          CfgRegMhShiftThr),
    .SatSbLDPCNSTS1(      CfgRegSatSbLDPCNSTS1),
    .SatSbBCCNSTS1(       CfgRegSatSbBCCNSTS1),
    .SatSbLDPCNSTS0(      CfgRegSatSbLDPCNSTS0),
    .SatSbBCCNSTS0(       CfgRegSatSbBCCNSTS0),
`ifdef RW_MUMIMO_RX_EN
    .SatSbMULDPCNSTS1(    CfgRegSatSbMULDPCNSTS1),
    .SatSbMUBCCNSTS1(     CfgRegSatSbMUBCCNSTS1),
    .SatSbMULDPCNSTS0(    CfgRegSatSbMULDPCNSTS0),
    .SatSbMUBCCNSTS0(     CfgRegSatSbMUBCCNSTS0),
`endif // RW_MUMIMO_RX_EN

    /*****************************************************************************
    * status registers
    ***************************************************************************/
    .StatusMh(            StatusMh),
    .StatusDMax(          StatusMhscMax),

    /*****************************************************************************
    * frame parameters
    *****************************************************************************/
    .ModeIs2040(          EqModeIs2040),
    .SnrEst(              SNR),
    .SigmaSquared(        SigmaSquared),
  
    /*****************************************************************************
    * symbol parameters 
    *****************************************************************************/
    .Stride(              EqStride),
    .HeSigBPAPREn(        EqHeSigBPAPREn),
    .ModTypeSS1(          EqModTypeSS1),
    .StbcEn(              EqSTBCEn),
    .StbcSymOdd(          EqSTBCSymOdd),
    .DcmEn(               EqDCMEn),
    .LdpcEn(              EqLDPCEn),
    .DiscEn(              EqDiscEn),
    .ReceptionMode(       EqReceptionMode),
    .NSTS(                EqRxNsts[0]),
    .RUType(              EqRUType),
    .RUIndex(             EqRUIndex),
`ifdef RW_MUMIMO_RX_EN
    .MuMIMOEn(            EqMuMIMOEn),
    .VHTSIGBInv(          EqVHTSIGBInv),
`endif // RW_MUMIMO_RX_EN
  
    /*****************************************************************************
    * mh computation from channel estimate 
    *****************************************************************************/
    .EqMHUpdate(          EqMHUpdate),
    /* control status */
    .EqCompStart(         EqCompStartP),
    .EqCompDone(          EqCompDoneP),
  
    /* channel estimate */
    .EstimDoneP(          ChEstSmthDoneP),
    .ChEstDataEn(         ChEstDataEn), 
    .HWrEn(               HMemWrAddrEn),    
    .HWrAddr(             HMemWrAddrEqu),
    .HWrData(             {ChEstH11Q,ChEstH11I,ChEstH12Q,ChEstH12I}),
  
    /*****************************************************************************
    * sig/data symbols equalization
    *****************************************************************************/
    /* control/status */
    .EqStbcFlush(         EqSTBCFlush),
    .EqStbcFlushDone(     EqSTBCFlushDone),
    .EqStart(             EqStartP),
    .PilotData(           EqPilotData), 
    .Eq2DEn(              FD2DEn),
    .EqDone(              EqDoneP),
    .EqPilotDone(         EqPilotDoneP),
    .EqDataDone(          EqPipeFlushDoneP),
    .QbpskDet(            EqQbpskDet),
    .QbpskDetDone(        EqQbpskDetDoneP),

    /* row flow control */
    .ldpc_fifo_en(        deintlv_fec),
    .ldpc_fifo_ready(     ldpc_fifo_ready),
    .row_fifo_en(         deintlv_row_fifo_en),
    .row_fifo_rdptr(      bdfd_row_fifo_rdptr),

    .RI(                  R1I),
    .RQ(                  R1Q),
  
    .H1Q(                 H11Q),
    .H1I(                 H11I),
    .H2Q(                 H12Q),
    .H2I(                 H12I),
 
    /* softbit outputs */
    .SBValid(             SBValid),
    .SBLast(              SBLast),
    .SBOdd(               SBOdd),
    .SB0(                 SS1SB0),
    .SB1(                 SS1SB1),
    .SB2(                 SS1SB2),
    .SB3(                 SS1SB3),
    .SB4(                 SS1SB4),
    .SB5(                 SS1SB5),
    .SB6(                 SS1SB6),
    .SB7(                 SS1SB7),
    .SB8(                 SS1SB8),
    .SB9(                 SS1SB9),

    /* equalized pilot */
    .FDOEEn(              EqPilotValidMEq),
    .FDOEI(               EqPilotReMEq),
    .FDOEQ(               EqPilotImMEq),
  
    /* FFT(H addressing and sub-carrier indexing */
    .FFTAddrEn(           FFTMemRdAddrEnMEq),
    .FFTAddr(             FFTMemRdAddrMEq),
    .HAddrEn(             HMemRdAddrEnMEq),
    .HAddr(               HMemRdAddrMEq),
    .CarrierNb(           CarrierNb),
  
  
    /*****************************************************************************
    * STBC memory ports 
    *****************************************************************************/
    .stbc_wen(            stbc_wen),
    .stbc_waddr(          stbc_waddr),
    .stbc_wdata(          stbc_wdata),
    .stbc_ren(            stbc_ren),
    .stbc_raddr(          stbc_raddr),
    .stbc_rdata(          stbc_rdata),
  
    /*****************************************************************************
    * diag 
    *****************************************************************************/
    .Debug0(              )
  );

  rx_fd_dcm u_rx_fd_dcm (
    //System
    .clk      (PhyClk),
    .rst_n    (nPhyRst),
    //parameters
    .enable   (equ_enable),
    .dcm      (EqDCMEn),
    .nbpsc    (deintlv_nbpsc),
    //Data path
    .in_sb0   (SS1SB0),
    .in_sb1   (SS1SB1),
    .in_sb2   (SS1SB2),
    .in_sb3   (SS1SB3),
    .in_sb4   (SS1SB4),
    .in_sb5   (SS1SB5),
    .in_sb6   (SS1SB6),
    .in_sb7   (SS1SB7),
    .in_sb8   (SS1SB8),
    .in_sb9   (SS1SB9),
    .in_odd   (SBOdd),
    .in_last  (SBLast),
    .in_valid (SBValid),
    .out_sb0  (DcmSS1SB0), 
    .out_sb1  (DcmSS1SB1), 
    .out_sb2  (DcmSS1SB2), 
    .out_sb3  (DcmSS1SB3), 
    .out_sb4  (DcmSS1SB4), 
    .out_sb5  (DcmSS1SB5), 
    .out_sb6  (DcmSS1SB6), 
    .out_sb7  (DcmSS1SB7), 
    .out_sb8  (DcmSS1SB8), 
    .out_sb9  (DcmSS1SB9), 
    .out_valid(DcmSBValid)
  );
  
  /*****************************************************************************
  * FD de-interleavers
  ******************************************************************************
  * SoftBit position convention
  *            SB0  SB1  SB2  SB3     SB4  SB5  SB6  SB7         
  * NBPSC1     I0   -    -    -       -    -    -    -
  * NBPSC2     I0   -    -    -       Q0   -    -    -
  * NBPSC4     I0   I1   -    -       Q0   Q1   -    -
  * NBPSC6     I0   I1   I2   -       Q0   Q1   Q2   -
  * NBPSC8     I0   I1   I2   I3      Q0   Q1   Q2   Q3
  *****************************************************************************/
  assign deintlv_bcc_enable = ~FDReset & ~deintlv_fec;
  assign bdfd_bcc_waddr[8] = deintlv_chsel;

  rx_fd_deinterleaver2 u_deinterleaver
  (
    /* system */
    .clk(                  PhyClk),
    .rst_n(                nPhyRst),

    /* symbol/control */
    .enable(               deintlv_bcc_enable),
    .start(                deintlv_start),
    .busy(                 deintlv_busy),
   
   
    .nsd(                  deintlv_nsd),
    .nbpsc(                deintlv_nbpsc),
    .ruen(                 deintlv_ruen),
    .rulen(                deintlv_rulen),
    .dcm(                  deintlv_dcm),
    .iss(                  deintlv_iss),
    
    .sigen(                deintlv_sigen),
    .sigsel(               deintlv_sigsel),

    .fifo(                 deintlv_row_fifo_en),
    .fifo_wrptr(           bdfd_row_fifo_wrptr),

    /* equalizer interface */
    .sb0(                  DcmSS1SB0),
    .sb1(                  DcmSS1SB1),
    .sb2(                  DcmSS1SB2),
    .sb3(                  DcmSS1SB3),
    .sb4(                  DcmSS1SB4), // also SS1SB0 Qbpsk during discrimination
    .sb5(                  DcmSS1SB5),
    .sb6(                  DcmSS1SB6),
    .sb7(                  DcmSS1SB7),
    .valid(                DcmSBValid),
  
    /* sram interface */
    .wen(                  bdfd_bcc_wen),
    .waddr(                bdfd_bcc_waddr[7:0]),
    .wdata(                bdfd_bcc_wdata)
  );

  /* select symbol memory or row fifo */
  assign bdfd_bcc_wsel = deintlv_row_fifo_en;

`ifdef RW_NX_LDPC_DEC
  /*****************************************************************************
  * LDPC fifo
  *****************************************************************************/
  wire [ 4:0] bdfd_ldpc_sb11,bdfd_ldpc_sb10, bdfd_ldpc_sb9, bdfd_ldpc_sb8;
  wire [ 4:0] bdfd_ldpc_sb7, bdfd_ldpc_sb6, bdfd_ldpc_sb5, bdfd_ldpc_sb4;
  wire [ 4:0] bdfd_ldpc_sb3, bdfd_ldpc_sb2, bdfd_ldpc_sb1, bdfd_ldpc_sb0;

  assign deintlv_ldpc_enable = ~FDReset & deintlv_fec;

  rx_fd_ldpc_fifo u_rx_fd_ldpc_fifo
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .clk(                   PhyClk),
    .rst_n(                 nPhyRst),
    
    /*****************************************************************************
    * system
    *****************************************************************************/
    .enable(                deintlv_ldpc_enable),
    .fifo_threshold(        mdmcfg_ldpcdec_fifo_thr),
    .nsd(                   deintlv_nsd),
    .dcm(                   deintlv_dcm),
    .ruen(                  deintlv_ruen),
    .rulen(                 deintlv_rulen),
    .nbpsc(                 deintlv_nbpsc),
    
    /*****************************************************************************
    * sc stream
    *****************************************************************************/
    .in_ready(              ldpc_fifo_ready),
    .in_sb0(                DcmSS1SB0),
    .in_sb1(                DcmSS1SB1),
    .in_sb2(                DcmSS1SB2),
    .in_sb3(                DcmSS1SB3),
    .in_sb4(                DcmSS1SB4),
    .in_sb5(                DcmSS1SB5),
    .in_sb6(                DcmSS1SB6),
    .in_sb7(                DcmSS1SB7),
    .in_sb8(                DcmSS1SB8),            
    .in_sb9(                DcmSS1SB9),
    .in_valid(              DcmSBValid),
    
    /*****************************************************************************
    * sb stream
    *****************************************************************************/
    .out_ready(             bdfd_ldpc_ready),
    .out_sb0(               bdfd_ldpc_sb0),
    .out_sb1(               bdfd_ldpc_sb1),
    .out_sb2(               bdfd_ldpc_sb2),
    .out_sb3(               bdfd_ldpc_sb3),
    .out_sb4(               bdfd_ldpc_sb4),
    .out_sb5(               bdfd_ldpc_sb5),
    .out_sb6(               bdfd_ldpc_sb6),
    .out_sb7(               bdfd_ldpc_sb7),
    .out_sb8(               bdfd_ldpc_sb8),
    .out_sb9(               bdfd_ldpc_sb9),
    .out_sb10(              bdfd_ldpc_sb10),
    .out_sb11(              bdfd_ldpc_sb11),
    .out_len(               bdfd_ldpc_len),
    .out_last(              bdfd_ldpc_last), 
    .out_valid(             bdfd_ldpc_valid),
    
    /*****************************************************************************
    * 
    *****************************************************************************/
    .wen(                   bdfd_ldpc_wen), 
    .waddr(                 bdfd_ldpc_waddr),
    .wdata(                 bdfd_ldpc_wdata),
    .ren(                   bdfd_ldpc_ren),
    .raddr(                 bdfd_ldpc_raddr),
    .rdata(                 bdfd_ldpc_rdata)
  );
  
  assign bdfd_ldpc_data = {bdfd_ldpc_sb11,bdfd_ldpc_sb10, bdfd_ldpc_sb9, bdfd_ldpc_sb8,
                            bdfd_ldpc_sb7, bdfd_ldpc_sb6, bdfd_ldpc_sb5, bdfd_ldpc_sb4,
                            bdfd_ldpc_sb3, bdfd_ldpc_sb2, bdfd_ldpc_sb1, bdfd_ldpc_sb0};
`endif

  /*****************************************************************************
  * Channel Estimate
  *****************************************************************************/
  /* Smoothing control from config register, let's re-register it
     because its fanout is pretty large in ChEstSmthTop. */
  always @(negedge nPhyRst,posedge PhyClk)
    if(!nPhyRst)
      CfgSmoothEn_1t <= 1'b0;
    else
      CfgSmoothEn_1t <= CfgRegSmoothEn;
  
  assign SmoothEn = ChEstSmoothEn & CfgSmoothEn_1t;
 
  // Channel Estimate enable
  assign ChEstEstimEn = ~FDReset;

  // Automatic Smoothing coefficient set according to SNR
  always @(negedge nPhyRst,posedge PhyClk)
    if(!nPhyRst)
      SmoothFilterSetMux <= 2'b0;
    else if (CfgRegSmoothForce == 1'b1)
      SmoothFilterSetMux <= CfgRegSmoothFilterSet;
    else if (SNR >= CfgRegSmoothSNRThrHigh)
      SmoothFilterSetMux <= 2'b00;
    else if (SNR > CfgRegSmoothSNRThrMid)
      SmoothFilterSetMux <= 2'b01;
    else
      SmoothFilterSetMux <= 2'b10;
  
  ChEstSmthTop
  #(
    .FFTBUFWIDTH   (13),
    .HBUFDATAWIDTH (13),
    .NSTS_PARAM    (NSTS_PARAM)
  )
  U_ChEstSmthTop
  (
    .nPhyRst            (nPhyRst),
    .PhyClk             (ChannelEstGClk),
    //
    .CfgSmoothFilterSet (SmoothFilterSetMux),
    //
    .ReceptionMode      (ChEstReceptionMode),
    .SymbolType         (ChEstSymbolType),
    .RUType             (ChEstRUType),
    .RUIndex            (ChEstRUIndex),
    .NShiftLTF          (ChEstNShiftLTF),
    .FirstLTF           (ChEstFirstLTF),
    .LastLTF            (ChEstLastLTF),
    .FrameNDP           (ChEstFrameNDP),
`ifdef RW_MUMIMO_RX_EN
    .HEMuMIMOEn         (ChEstHEMuMIMOEn),
`endif // RW_MUMIMO_RX_EN
    //
    .RxNsts             (ChEstRxNsts[1:0]),
    //
    .EstimEn            (ChEstEstimEn),
    .SmoothEn           (SmoothEn),
    .SmoothfromHP       (ChEstSmoothFromH),
    .StartSignalP       (ChEstStartP),
    .EstimDoneP         (ChEstDoneP),
    .SmthDoneP          (ChEstSmthDoneP),
    .DataChannelEnOut   (ChEstDataEn),
    //
    .FFTBufRdDataReRx0  (FFT0MemRdDataRe),
    .FFTBufRdDataImRx0  (FFT0MemRdDataIm),
    .FFTBufRdAddrEnOut  (FFTMemRdAddrEnChEst),
    .FFTBufRdAddr       (FFTMemRdAddrChEst),
    //
    .HBufRdDataRe0      (HMemRdDataRe0),
    .HBufRdDataIm0      (HMemRdDataIm0),
    .HBufRdDataRe1      (HMemRdDataRe1),
    .HBufRdDataIm1      (HMemRdDataIm1),
    .HBufRdDataRe2      (HMemRdDataRe2),
    .HBufRdDataIm2      (HMemRdDataIm2),
    .HBufRdDataRe3      (HMemRdDataRe3),
    .HBufRdDataIm3      (HMemRdDataIm3),
    .HBufRdDataEnIn     (HMemRdDataValid),
    .HBufRdAddr         (HMemRdAddrChEst),
    .HBufRdEn           (HMemRdAddrEnChEst),
    //
    .HBufWrAddr         (HMemWrAddrChEst),
    .HBufWrAddrEn       (HMemWrAddrEnChEst),
    .HBufWrEn0          (HMemWrBEnChEst0),
    .HBufWrDataRe0      (HMemWrDataChEstRe0),
    .HBufWrDataIm0      (HMemWrDataChEstIm0),
    .HBufWrEn1          (HMemWrBEnChEst1),
    .HBufWrDataRe1      (HMemWrDataChEstRe1),
    .HBufWrDataIm1      (HMemWrDataChEstIm1),
    .HBufWrEn2          (HMemWrBEnChEst2),
    .HBufWrDataRe2      (HMemWrDataChEstRe2),
    .HBufWrDataIm2      (HMemWrDataChEstIm2),
    .HBufWrEn3          (HMemWrBEnChEst3),
    .HBufWrDataRe3      (HMemWrDataChEstRe3),
    .HBufWrDataIm3      (HMemWrDataChEstIm3)
    );
  
`ifdef RW_BFMEE_EN
  /*****************************************************************************
  * Singular Value Decomposition Module
  * used to compress the report on the Beamformee side
  *****************************************************************************/
  assign bfmeeHMemIfRdData = { HMemRdDataIm0, HMemRdDataRe0,
                               HMemRdDataIm1, HMemRdDataRe1,
                               HMemRdDataIm2, HMemRdDataRe2,
                               HMemRdDataIm3, HMemRdDataRe3};
                               
  assign bfmeeHMemIfRdDataVld = HMemRdDataValid & bfmeeHMemIfActive;
  
  // Memory must be enabled for read and for write
  wire    bfmeeMemRdEn;
  assign  bfmeeMemEn = bfmeeMemRdEn | bfmeeMemWrEn;

`ifdef RW_NX_DERIV_CHBW20ONLY
  assign bfmeeHMemIfRdAddr[8] = bfmeeHMemIfRdAddr[7];
`endif  
  svdtop
  #(
    .SNR_BASE_ADDR(`RW_BFMEE_SNR_ADDR),
`ifdef RW_NX_DERIV_CHBW20ONLY
    .HAWIDTH  (8), // 20 MHz configuration
`else
    .HAWIDTH  (9), // up to 40 MHz configuration
`endif    
    .AWIDTH   (`RW_BFMEE_RAM_AWIDTH)  
  )
  U_svdtop (
    //$port_g Modem Clock and reset
    .nBFRModemRst     (nPhyRst),
    .BFRModemClk      (SVDClk),
    .BFRModemGClk     (SVDGClk),
    .BFRModemGClkEn   (SVDGClkEn),
    //$port_g Control interface.
    .BFRStart         (bfmeeBFRStart), 
    .SVDDone          (bfmeeSVDDone),
    //$port_g MPIF Configuration interface.
    .cfgNg            (bfmeeCfgNg), 
    .cfgChBw          (bfmeeCfgChBw),
    .cfgFeedbackType  (bfmeeCfgFeedbackType),
    .cfgCodebook      (bfmeeCfgCodebook),
    .cfgNr            (bfmeeCfgNr), 
    .cfgNc            (bfmeeCfgNc), 
    .cfgHe            (bfmeeCfgHe), 
    .cfgHeRUStartIndex(bfmeeCfgHeRUStartIndex), 
    .cfgHeRUEndIndex  (bfmeeCfgHeRUEndIndex), 
    //$port_g Data interface.
    .MacDataOutReady  (bfmeeDataReady),
    .MacDataOut       (bfmeeData),
    .MacDataOutValid  (bfmeeDataValid),
    //$port_g PHY control interface.
    .cfgRxAntSel      (bfmeeCfgRxAntSel),
    .cfgSigmadB       (NoiseVardB), 
    .cfgSnrScaling    (bfmeeCfgSnrScaling),
    //$port_g Hmem interface.
    .HMemRData        (bfmeeHMemIfRdData),
    .HMemRDataVld     (bfmeeHMemIfRdDataVld),
`ifdef RW_NX_DERIV_CHBW20ONLY
    .HMemRAddr        (bfmeeHMemIfRdAddr[7:0]),
`else
    .HMemRAddr        (bfmeeHMemIfRdAddr),
`endif
    .HMemREn          (bfmeeHMemIfRdEn),
    .HMemActive       (bfmeeHMemIfActive),
    //$port_g dual port Ram interface
    .RamAddress       (bfmeeMemAddr),
    .RamWe            (bfmeeMemWrEn),
    .RamWData         (bfmeeMemWrData),
    .RamRe            (bfmeeMemRdEn),
    .RamRData         (bfmeeMemRdData),
    // Diagnostic ports
    .Dbg0             (DiagBfmee0)
    );

`endif // RW_BFMEE_EN

  /*****************************************************************************
  * H memory write access 
  *****************************************************************************/
  assign {HMemWrEn0,
          HMemWrEn1,
          HMemWrEn2,
          HMemWrEn3}  = 
                        (HMemWrAddrEnChEst) ? {HMemWrBEnChEst0,
                                               HMemWrBEnChEst1,
                                               HMemWrBEnChEst2,
                                               HMemWrBEnChEst3} : 8'b0;
  assign HMemWrAddrEn = HMemWrAddrEnChEst;

  assign HMemWrAddrEqu = HMemWrAddrChEst;

  assign HMemWrAddrMux   = // Sent to memory: patched for secondary
                        {HMemWrAddrEqu[9:6],(HMemWrAddrEqu[5]^FD2DEn),HMemWrAddrEqu[4:0]};
  assign HMemWrAddr   = HMemWrAddrMux + $signed(FDHEMUOffset);
  assign {HMemWrDataIm0, HMemWrDataRe0,
          HMemWrDataIm1, HMemWrDataRe1,
          HMemWrDataIm2, HMemWrDataRe2,
          HMemWrDataIm3, HMemWrDataRe3}
                      = 
                        {HMemWrDataChEstIm0, HMemWrDataChEstRe0,
                         HMemWrDataChEstIm1, HMemWrDataChEstRe1,
                         HMemWrDataChEstIm2, HMemWrDataChEstRe2,
                         HMemWrDataChEstIm3, HMemWrDataChEstRe3};

  /*****************************************************************************
  * debug and diag
  *****************************************************************************/
  // Rx FDO
  assign DiagFDO0 = {FDOEstStartP,FDOInitPilotShRegP,FDOFFTRxDataValid,FFT0MemRdDataRe};
  assign DiagFDO1 = {EqDoneP,EqPilotValid_7t,FDOInitKalmanRegP,FFT0MemRdDataIm};
  assign DiagFDO2 = {FDOBW,FDOCompDoneP,FDODataRe1};
  assign DiagFDO3 = {FDOMode,FDODataValid,FDODataIm1};

  // Rx Equaliser
  assign DiagEq   = {FFTMemRdAddrEnMEq,EqPilotValidMEq,EqPipeFlushDoneP,EqQbpskDet,1'b0,SBValid,SS1SB4,SS1SB0};

endmodule
`default_nettype wire
//////////////////////////////////////////////////////////////////////////////
// End of file
//////////////////////////////////////////////////////////////////////////////
