/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/

`default_nettype none

module EqualizerRX1SS1 
(
  /*****************************************************************************
  * system 
  *****************************************************************************/
  input  wire        nPhyRst, 
  input  wire        PhyClk,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire        enable,
  
  /*****************************************************************************
  * config registers
  *****************************************************************************/
  input  wire [ 7:0] FddcSnrThreshold,
  input  wire        FddcCompEn,
  input  wire [ 2:0] FddcWeightM2,
  input  wire [ 2:0] FddcWeightM1,
  input  wire [ 2:0] FddcWeightP1,
  input  wire [ 2:0] FddcWeightP2,
  input  wire [ 2:0] SatSbLDPCNSTS1,
  input  wire [ 2:0] SatSbBCCNSTS1,
  input  wire [ 2:0] SatSbLDPCNSTS0,
  input  wire [ 2:0] SatSbBCCNSTS0,
`ifdef RW_MUMIMO_RX_EN
  input  wire [ 2:0] SatSbMULDPCNSTS1,
  input  wire [ 2:0] SatSbMUBCCNSTS1,
  input  wire [ 2:0] SatSbMULDPCNSTS0,
  input  wire [ 2:0] SatSbMUBCCNSTS0,
`endif // RW_MUMIMO_RX_EN
  input  wire [ 2:0] MhShiftVal,
  input  wire [ 7:0] MhShiftThr,

  /*****************************************************************************
  * status registers
  *****************************************************************************/
  output wire [27:0]  StatusMh,
  output wire [19:0]  StatusDMax,
  
  /*****************************************************************************
  * frame parameters
  *****************************************************************************/
  input  wire        Eq2DEn,
  input  wire        ModeIs2040,
  input  wire [ 7:0] SnrEst,
  input  wire [24:0] SigmaSquared,
  
  /*****************************************************************************
  * symbol parameters 
  *****************************************************************************/
  input  wire        Stride,
  input  wire        HeSigBPAPREn,
  input  wire [ 2:0] ModTypeSS1,
  input  wire        StbcEn,
  input  wire        StbcSymOdd,
  input  wire        LdpcEn,
  input  wire        DiscEn, 
  input  wire        DcmEn,
  input  wire [ 3:0] ReceptionMode,
  input  wire        NSTS,
  input  wire [ 2:0] RUType,
  input  wire [ 5:0] RUIndex,
`ifdef RW_MUMIMO_RX_EN
  input  wire        MuMIMOEn,
  input  wire        VHTSIGBInv,
`endif // RW_MUMIMO_RX_EN
  
  /*****************************************************************************
  * mh computation from channel estimate 
  *****************************************************************************/
  input  wire        EqMHUpdate,
  /* control status */
  input  wire        EqCompStart,
  output reg         EqCompDone,
  
  /* channel estimate */
  input  wire        EstimDoneP,
  input  wire        ChEstDataEn,  // redudant with HWriteEnIn
  input  wire        HWrEn,    
  input  wire [ 9:0] HWrAddr,
  input  wire [51:0] HWrData,
  
  /*****************************************************************************
  * sig/data symbols equalization
  *****************************************************************************/
  /* control/status */
  input  wire        EqStbcFlush,
  output reg         EqStbcFlushDone,
  input  wire        EqStart,
  input  wire        PilotData, 
  output reg         EqPilotDone,
  output reg         EqDataDone,
  output reg         EqDone, // attention misnomer, for BD clock gating, not related to end of processing
  output reg         QbpskDet,
  output reg         QbpskDetDone,

  /* row flow control */
  input  wire        ldpc_fifo_en,
  input  wire        ldpc_fifo_ready,
  input  wire        row_fifo_en,
  input  wire [ 2:0] row_fifo_rdptr,

  /* RX and H input */
  input  wire [12:0] RI,
  input  wire [12:0] RQ,
  
  input  wire [12:0] H1I,
  input  wire [12:0] H1Q,
  input  wire [12:0] H2I,
  input  wire [12:0] H2Q,
 
  /* softbit outputs */
  output wire        SBValid,
  output wire        SBOdd,
  output wire        SBLast,
  output wire [4:0]  SB0,
  output wire [4:0]  SB1,
  output wire [4:0]  SB2,
  output wire [4:0]  SB3,
  output wire [4:0]  SB4,
  output wire [4:0]  SB5,
  output wire [4:0]  SB6,
  output wire [4:0]  SB7,
  output wire [4:0]  SB8,
  output wire [4:0]  SB9,
  
  /* equalized pilot */
  output wire        FDOEEn,
  output wire [19:0] FDOEI,
  output wire [19:0] FDOEQ,
  
  /* FFT,H addressing and sub-carrier indexing */
  output wire        FFTAddrEn,
  output wire [9:0]  FFTAddr,
  output wire [9:0]  HAddr,
  output wire        HAddrEn,
  output wire [9:0]  CarrierNb,

  /* STBC ports */
  output wire        stbc_wen,
  output wire [ 8:0] stbc_waddr,
  output wire [75:0] stbc_wdata,
  output wire        stbc_ren,
  output wire [ 8:0] stbc_raddr,
  input  wire [75:0] stbc_rdata,
  
  /*****************************************************************************
  * diag 
  *****************************************************************************/
  output wire [15:0] Debug0
);

  /*****************************************************************************
  * declarations
  *****************************************************************************/
  /* constants */
  localparam   NBPSC_BPSK  = 3'd0, NBPSC_QPSK  = 3'd1,
               NBPSC_QAM16 = 3'd2, NBPSC_QAM64 = 3'd3, 
               NBPSC_QAM256= 3'd4, NBPSC_QAM1024= 3'd5;
  
  localparam   MHZ20_LEG   = 4'd0, MHZ40_DUP   = 4'd1,
               MHZ20_HT    = 4'd2, MHZ40_HT    = 4'd3,
               MHZ40_DUP2  = 4'd4, MHZ80_VHT   = 4'd5,
               MHZ20_HESU  = 4'd6, MHZ20_HEMU  = 4'd7,
               MHZ40_HESU  = 4'd8, MHZ40_HEMU  = 4'd9,
               MHZ80_HESU  = 4'd10,MHZ80_HEMU  = 4'd11;
  
  localparam   IDLE        = 2'd0, EQU_COMP    = 2'd1,
               EQU_PILOT   = 2'd2, EQU_DATA    = 2'd3;
  
  // RU type
  localparam [2:0] RU26  = 3'd0,
                   RU52  = 3'd1,
                   RU106 = 3'd2,
                   RU242 = 3'd3,
                   RU484 = 3'd4;

  /* misc */
  reg   [ 1:0] state;
  
  reg          qbpsk_detect_en,qbpsk_detect_clr;
  wire  [25:0] qbpsk_accu_i,qbpsk_accu_q;
  
  reg          static_nsts;
  reg   [ 2:0] static_nbpsc;
  reg   [ 8:0] static_nsd;
  reg   [ 3:0] static_reception_mode;
  reg          static_fddc_en;
  reg   [ 2:0] static_fddc_weight_m2,static_fddc_weight_m1;
  reg   [ 2:0] static_fddc_weight_p1,static_fddc_weight_p2;
  reg   [ 2:0] static_modtypess1;
`ifdef RW_MUMIMO_RX_EN
  reg          static_mumimoen;
  reg          static_vhtsigbinv;
`endif // RW_MUMIMO_RX_EN
  
  reg   [ 2:0] satsb;
  wire  [27:0] mh_x_satsb;       
  wire  [15:0] mh_x_satsb_rnd12; 
  wire         mh_done;
  
  /* GENINDEX */
  wire         index_valid,index_last,index_odd,index_papr;
  reg   [9:0]  index_1t;
  reg          index_odd_1t,index_last_1t,index_valid_1t;
  reg          index_papr_1t, index_papr_2t;
  reg   [9:0]  index_2t;
  reg          index_odd_2t,index_last_2t,index_valid_2t;
  wire  [2:0]  index_pilot_count;
  reg   [2:0]  index_pilot_count_1t;
  reg   [2:0]  index_pilot_count_2t;
  reg   [7:0]  pilot_polarity;
 
  /* MH */
  reg          mh_clr;
  wire  [27:0] all_mh_x_satsb;
  wire  [15:0] all_mh_x_satsb_rnd12;
  wire  [25:0] status_pri_mh;
  wire  [18:0] status_pri_dmax;
 
  /* S0 */
  reg   [ 1:0] s0_pilot_sel;
  reg          s0_valid;
  reg          s0_last;
  reg   [ 9:0] s0_index;
  reg          s0_odd;
  reg          s0_papr;
  reg   [ 9:0] s0_haddr;
  reg   [12:0] s0_r_i,s0_r_q;
  wire  [12:0] s0_r_i_neg,s0_r_q_neg;
  wire  [12:0] s0_r_i_papr,s0_r_q_papr;
  reg   [12:0] s0_h1_i,s0_h1_q;
  reg   [12:0] s0_h2_i,s0_h2_q;
  reg          s0_mh_valid;
  reg          s0_mh_last;
  
  /* S1 */
  reg          s1_valid;
  reg   [ 9:0] s1_index;
  reg          s1_odd;
  reg          s1_mh_valid;
  reg          s1_last;
  reg          s1_mh_last;
  
  /* S2 */
  reg          s2_valid;
  reg   [ 9:0] s2_index;
  reg          s2_odd;
  reg          s2_mh_valid;
  reg          s2_last;
  reg          s2_mh_last;
  wire  [18:0] s2_d;
  
  /* S3 */
  reg          s3_valid;
  reg   [ 9:0] s3_index;
  reg          s3_odd;
  reg          s3_last;
  reg   [18:0] s3_d;
  wire         s3_pilot_valid;
  wire  [19:0] s3_pilot_i;
  wire  [19:0] s3_pilot_q;
  
  /* S4 */
  reg          s4_valid;
  reg   [ 9:0] s4_index;
  reg          s4_odd;
  reg          s4_last;
  reg   [18:0] s4_d;
  
  /* S5 */
  reg          s5_valid;
  reg   [ 9:0] s5_index;
  reg          s5_odd;
  reg          s5_last;
  reg   [18:0] s5_d;
  
  /* S6 */
  reg          s6_valid;
  reg   [ 9:0] s6_index;
  reg          s6_odd;
  wire  [19:0] s6_x0_i,s6_x0_q;
  wire  [19:0] s6_x1_i,s6_x1_q;
  reg          s6_last;
  reg   [18:0] s6_d;
  
  /* S7 */
  reg          s7_valid;
  reg   [ 9:0] s7_index;
  reg          s7_odd;
  reg   [18:0] s7_d;
  reg          s7_last;
  
  /* S8 */
  reg          s8_valid;
  reg   [ 9:0] s8_index;
  reg          s8_odd;
  reg   [18:0] s8_d;
  reg          s8_last;
  wire  [23:0] s8_dmap0_sb0_i,s8_dmap0_sb0_q;
  wire  [23:0] s8_dmap0_sb1_i,s8_dmap0_sb1_q;
  wire  [23:0] s8_dmap0_sb2_i,s8_dmap0_sb2_q;
  wire  [23:0] s8_dmap0_sb3_i,s8_dmap0_sb3_q;
  wire  [23:0] s8_dmap0_sb4_i,s8_dmap0_sb4_q;
  reg   [23:0] s8_dmap0_sb0,s8_dmap0_sb1,s8_dmap0_sb2,s8_dmap0_sb3;
  reg   [23:0] s8_dmap0_sb4,s8_dmap0_sb5,s8_dmap0_sb6,s8_dmap0_sb7;
  reg   [23:0] s8_dmap0_sb8,s8_dmap0_sb9;
  wire  [23:0] s8_dmap1_sb0_i,s8_dmap1_sb0_q;
  wire  [23:0] s8_dmap1_sb1_i,s8_dmap1_sb1_q;
  wire  [23:0] s8_dmap1_sb2_i,s8_dmap1_sb2_q;
  wire  [23:0] s8_dmap1_sb3_i,s8_dmap1_sb3_q;
  wire  [23:0] s8_dmap1_sb4_i,s8_dmap1_sb4_q;
  reg   [23:0] s8_dmap1_sb0,s8_dmap1_sb1,s8_dmap1_sb2,s8_dmap1_sb3;
  reg   [23:0] s8_dmap1_sb4,s8_dmap1_sb5,s8_dmap1_sb6,s8_dmap1_sb7;
  reg   [23:0] s8_dmap1_sb8,s8_dmap1_sb9;
  
  /* S9 */
  reg          s9_valid;
  reg          s9_last;
  reg          s9_odd;
  reg   [18:0] s9_d;
  wire         s9_ss0_sb0_sgn,s9_ss0_sb1_sgn,s9_ss0_sb2_sgn,s9_ss0_sb3_sgn;
  wire         s9_ss0_sb4_sgn,s9_ss0_sb5_sgn,s9_ss0_sb6_sgn,s9_ss0_sb7_sgn;
  wire         s9_ss0_sb8_sgn,s9_ss0_sb9_sgn;
  wire [22:0]  s9_ss0_sb0_abs,s9_ss0_sb1_abs,s9_ss0_sb2_abs,s9_ss0_sb3_abs;
  wire [22:0]  s9_ss0_sb4_abs,s9_ss0_sb5_abs,s9_ss0_sb6_abs,s9_ss0_sb7_abs;
  wire [22:0]  s9_ss0_sb8_abs,s9_ss0_sb9_abs;
  wire         s9_ss1_sb0_sgn,s9_ss1_sb1_sgn,s9_ss1_sb2_sgn,s9_ss1_sb3_sgn;
  wire         s9_ss1_sb4_sgn,s9_ss1_sb5_sgn,s9_ss1_sb6_sgn,s9_ss1_sb7_sgn;
  wire         s9_ss1_sb8_sgn,s9_ss1_sb9_sgn;
  wire [22:0]  s9_ss1_sb0_abs,s9_ss1_sb1_abs,s9_ss1_sb2_abs,s9_ss1_sb3_abs;
  wire [22:0]  s9_ss1_sb4_abs,s9_ss1_sb5_abs,s9_ss1_sb6_abs,s9_ss1_sb7_abs;
  wire [22:0]  s9_ss1_sb8_abs,s9_ss1_sb9_abs;
  
  /* S10-S14 */
  reg          s10_last,s10_odd;
  reg          s11_last,s11_odd;
  reg          s12_last,s12_odd;
  reg          s13_last,s13_odd;
  reg          s14_last,s14_odd;

  /* S15 */
  wire         s15_valid;
  reg          s15_last;
  reg          s15_odd;
  wire [ 4:0]  s15_ss0_sbc0,s15_ss0_sbc1,s15_ss0_sbc2,s15_ss0_sbc3;
  wire [ 4:0]  s15_ss0_sbc4,s15_ss0_sbc5,s15_ss0_sbc6,s15_ss0_sbc7;
  wire [ 4:0]  s15_ss0_sbc8,s15_ss0_sbc9;
  wire [ 4:0]  s15_ss1_sbc0,s15_ss1_sbc1,s15_ss1_sbc2,s15_ss1_sbc3;
  wire [ 4:0]  s15_ss1_sbc4,s15_ss1_sbc5,s15_ss1_sbc6,s15_ss1_sbc7;
  wire [ 4:0]  s15_ss1_sbc8,s15_ss1_sbc9;

  /* stbc peq ports */
  wire         stbc_peq_wen;
  wire         stbc_peq_ren;
  wire [ 8:0]  stbc_peq_addr;
  wire [75:0]  stbc_peq_wdata;

  /* stbc sb ports */
  reg          stbc_sb_wen;
  reg  [ 8:0]  stbc_sb_addr;
  wire         stbc_sb_ren;
  reg  [50:0]  stbc_sb_wdata;

  reg          stbc_sb_mux;
  reg          stbc_sb_ren_1t,stbc_sb_ren_2t,stbc_sb_ren_3t;
  reg  [ 4:0]  stbc_sb_sb0,stbc_sb_sb1,stbc_sb_sb2,stbc_sb_sb3,stbc_sb_sb4;
  reg  [ 4:0]  stbc_sb_sb5,stbc_sb_sb6,stbc_sb_sb7,stbc_sb_sb8,stbc_sb_sb9;
  reg          stbc_sb_last;

  /* excludes pilots and DC sub-carriers, based on reception mode          */
  always @(*)
    if(state==EQU_COMP)
    begin
      case(static_reception_mode)
        MHZ20_LEG,MHZ20_HT:
          case(s0_haddr)
           -10'd21:   s0_mh_valid = 1'b0;     /* -21 */
           -10'd7:    s0_mh_valid = 1'b0;     /* -7  */
            10'd7:    s0_mh_valid = 1'b0;     /* +7  */
            10'd21:   s0_mh_valid = 1'b0;     /* +21 */
            default: s0_mh_valid = s0_valid; 
          endcase
        MHZ40_HT:
          case(s0_haddr)
           -10'd53:   s0_mh_valid = 1'b0;     /* -53 */
           -10'd25:   s0_mh_valid = 1'b0;     /* -25 */
           -10'd11:   s0_mh_valid = 1'b0;     /* -11 */
            10'd11:   s0_mh_valid = 1'b0;     /* +11 */
            10'd25:   s0_mh_valid = 1'b0;     /* +25 */
            10'd53:   s0_mh_valid = 1'b0;     /* +53 */
            default: s0_mh_valid = s0_valid; 
          endcase
        MHZ20_HESU:
          case(s0_haddr)
           -10'sd22:  s0_mh_valid = 1'b0;     
           -10'sd48:  s0_mh_valid = 1'b0;     
           -10'sd90:  s0_mh_valid = 1'b0;     
           -10'sd116: s0_mh_valid = 1'b0;     
            10'd22:   s0_mh_valid = 1'b0;     
            10'd48:   s0_mh_valid = 1'b0;     
            10'd90:   s0_mh_valid = 1'b0;     
            10'd116:  s0_mh_valid = 1'b0;     
            default: s0_mh_valid = s0_valid; 
          endcase
        MHZ20_HEMU:
          case (RUType)
            RU26, RU52 : 
              case(s0_haddr)
               -10'd10:   s0_mh_valid = 1'b0;    
               -10'd22:   s0_mh_valid = 1'b0;    
               -10'd36:   s0_mh_valid = 1'b0;    
               -10'd48:   s0_mh_valid = 1'b0;    
               -10'd62:   s0_mh_valid = 1'b0;    
               -10'd76:   s0_mh_valid = 1'b0;    
               -10'd90:   s0_mh_valid = 1'b0;    
               -10'd102:  s0_mh_valid = 1'b0;    
               -10'd116:  s0_mh_valid = 1'b0;    
                10'd10:   s0_mh_valid = 1'b0;    
                10'd22:   s0_mh_valid = 1'b0;    
                10'd36:   s0_mh_valid = 1'b0;    
                10'd48:   s0_mh_valid = 1'b0;    
                10'd62:   s0_mh_valid = 1'b0;    
                10'd76:   s0_mh_valid = 1'b0;    
                10'd90:   s0_mh_valid = 1'b0;    
                10'd102:  s0_mh_valid = 1'b0;    
                10'd116:  s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
            default    : // RU106 or RU242
              case(s0_haddr)
               -10'd22:   s0_mh_valid = 1'b0;    
               -10'd48:   s0_mh_valid = 1'b0;    
               -10'd90:   s0_mh_valid = 1'b0;    
               -10'd116:  s0_mh_valid = 1'b0;    
                10'd22:   s0_mh_valid = 1'b0;    
                10'd48:   s0_mh_valid = 1'b0;    
                10'd90:   s0_mh_valid = 1'b0;    
                10'd116:  s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
          endcase
`ifndef RW_NX_DERIV_CHBW20ONLY
        MHZ40_HESU:
          case(s0_haddr)
           -10'sd10:  s0_mh_valid = 1'b0;     
           -10'sd36:  s0_mh_valid = 1'b0;     
           -10'sd78:  s0_mh_valid = 1'b0;     
           -10'sd104: s0_mh_valid = 1'b0;     
           -10'sd144: s0_mh_valid = 1'b0;     
           -10'sd170: s0_mh_valid = 1'b0;     
           -10'sd212: s0_mh_valid = 1'b0;     
           -10'sd238: s0_mh_valid = 1'b0;     
            10'd10:   s0_mh_valid = 1'b0;    
            10'd36:   s0_mh_valid = 1'b0;    
            10'd78:   s0_mh_valid = 1'b0;    
            10'd104:  s0_mh_valid = 1'b0;    
            10'd144:  s0_mh_valid = 1'b0;    
            10'd170:  s0_mh_valid = 1'b0;    
            10'd212:  s0_mh_valid = 1'b0;    
            10'd238:  s0_mh_valid = 1'b0;    
            default: s0_mh_valid = s0_valid; 
          endcase
`endif
        MHZ40_HEMU:
          case (RUType)
            RU26, RU52 : 
              case(s0_haddr)
               -10'd10:   s0_mh_valid = 1'b0;    
               -10'd24:   s0_mh_valid = 1'b0;    
               -10'd36:   s0_mh_valid = 1'b0;    
               -10'd50:   s0_mh_valid = 1'b0;    
               -10'd64:   s0_mh_valid = 1'b0;    
               -10'd78:   s0_mh_valid = 1'b0;    
               -10'd90:   s0_mh_valid = 1'b0;    
               -10'd104:  s0_mh_valid = 1'b0;    
               -10'd116:  s0_mh_valid = 1'b0;    
               -10'd130:  s0_mh_valid = 1'b0;    
               -10'd144:  s0_mh_valid = 1'b0;    
               -10'd158:  s0_mh_valid = 1'b0;    
               -10'd170:  s0_mh_valid = 1'b0;    
               -10'd184:  s0_mh_valid = 1'b0;    
               -10'd198:  s0_mh_valid = 1'b0;    
               -10'd212:  s0_mh_valid = 1'b0;    
               -10'd224:  s0_mh_valid = 1'b0;    
               -10'd238:  s0_mh_valid = 1'b0;    
                10'd10:   s0_mh_valid = 1'b0;    
                10'd24:   s0_mh_valid = 1'b0;    
                10'd36:   s0_mh_valid = 1'b0;    
                10'd50:   s0_mh_valid = 1'b0;    
                10'd64:   s0_mh_valid = 1'b0;    
                10'd78:   s0_mh_valid = 1'b0;    
                10'd90:   s0_mh_valid = 1'b0;    
                10'd104:  s0_mh_valid = 1'b0;    
                10'd116:  s0_mh_valid = 1'b0;    
                10'd130:  s0_mh_valid = 1'b0;    
                10'd144:  s0_mh_valid = 1'b0;    
                10'd158:  s0_mh_valid = 1'b0;    
                10'd170:  s0_mh_valid = 1'b0;    
                10'd184:  s0_mh_valid = 1'b0;    
                10'd198:  s0_mh_valid = 1'b0;    
                10'd212:  s0_mh_valid = 1'b0;    
                10'd224:  s0_mh_valid = 1'b0;    
                10'd238:  s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
            default    : // RU106 or RU242 or RU484
              case(s0_haddr)
               -10'sd10:  s0_mh_valid = 1'b0;    
               -10'sd36:  s0_mh_valid = 1'b0;    
               -10'sd78:  s0_mh_valid = 1'b0;    
               -10'sd104: s0_mh_valid = 1'b0;    
               -10'sd144: s0_mh_valid = 1'b0;    
               -10'sd170: s0_mh_valid = 1'b0;    
               -10'sd212: s0_mh_valid = 1'b0;    
               -10'sd238: s0_mh_valid = 1'b0;    
                10'd10:   s0_mh_valid = 1'b0;    
                10'd36:   s0_mh_valid = 1'b0;    
                10'd78:   s0_mh_valid = 1'b0;    
                10'd104:  s0_mh_valid = 1'b0;    
                10'd144:  s0_mh_valid = 1'b0;    
                10'd170:  s0_mh_valid = 1'b0;    
                10'd212:  s0_mh_valid = 1'b0;    
                10'd238:  s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
          endcase
        MHZ80_HEMU:
          case (RUType)
            RU26 : 
              case(s0_haddr)
              -10'sd494: s0_mh_valid = 1'b0;    
              -10'sd480: s0_mh_valid = 1'b0;    
              -10'sd468: s0_mh_valid = 1'b0;    
              -10'sd454: s0_mh_valid = 1'b0;    
              -10'sd440: s0_mh_valid = 1'b0;    
              -10'sd426: s0_mh_valid = 1'b0;    
              -10'sd414: s0_mh_valid = 1'b0;    
              -10'sd400: s0_mh_valid = 1'b0;    
              -10'sd386: s0_mh_valid = 1'b0;    
              -10'sd372: s0_mh_valid = 1'b0;    
              -10'sd360: s0_mh_valid = 1'b0;    
              -10'sd346: s0_mh_valid = 1'b0;    
              -10'sd334: s0_mh_valid = 1'b0;    
              -10'sd320: s0_mh_valid = 1'b0;    
              -10'sd306: s0_mh_valid = 1'b0;    
              -10'sd292: s0_mh_valid = 1'b0;    
              -10'sd280: s0_mh_valid = 1'b0;    
              -10'sd266: s0_mh_valid = 1'b0;    
              -10'sd252: s0_mh_valid = 1'b0;    
              -10'sd238: s0_mh_valid = 1'b0;    
              -10'sd226: s0_mh_valid = 1'b0;    
              -10'sd212: s0_mh_valid = 1'b0;    
              -10'sd198: s0_mh_valid = 1'b0;    
              -10'sd184: s0_mh_valid = 1'b0;    
              -10'sd172: s0_mh_valid = 1'b0;    
              -10'sd158: s0_mh_valid = 1'b0;    
              -10'sd144: s0_mh_valid = 1'b0;    
              -10'sd130: s0_mh_valid = 1'b0;    
              -10'sd118: s0_mh_valid = 1'b0;    
              -10'sd104: s0_mh_valid = 1'b0;    
              -10'sd92:  s0_mh_valid = 1'b0;    
              -10'sd78:  s0_mh_valid = 1'b0;    
              -10'sd64:  s0_mh_valid = 1'b0;    
              -10'sd50:  s0_mh_valid = 1'b0;    
              -10'sd38:  s0_mh_valid = 1'b0;    
              -10'sd24:  s0_mh_valid = 1'b0;    
              -10'sd10:  s0_mh_valid = 1'b0;    
               10'sd10:  s0_mh_valid = 1'b0;    
               10'sd24:  s0_mh_valid = 1'b0;    
               10'sd38:  s0_mh_valid = 1'b0;    
               10'sd50:  s0_mh_valid = 1'b0;    
               10'sd64:  s0_mh_valid = 1'b0;    
               10'sd78:  s0_mh_valid = 1'b0;    
               10'sd92:  s0_mh_valid = 1'b0;    
               10'sd104: s0_mh_valid = 1'b0;    
               10'sd118: s0_mh_valid = 1'b0;    
               10'sd130: s0_mh_valid = 1'b0;    
               10'sd144: s0_mh_valid = 1'b0;    
               10'sd158: s0_mh_valid = 1'b0;    
               10'sd172: s0_mh_valid = 1'b0;    
               10'sd184: s0_mh_valid = 1'b0;    
               10'sd198: s0_mh_valid = 1'b0;    
               10'sd212: s0_mh_valid = 1'b0;    
               10'sd226: s0_mh_valid = 1'b0;    
               10'sd238: s0_mh_valid = 1'b0;    
               10'sd252: s0_mh_valid = 1'b0;    
               10'sd266: s0_mh_valid = 1'b0;    
               10'sd280: s0_mh_valid = 1'b0;    
               10'sd292: s0_mh_valid = 1'b0;    
               10'sd306: s0_mh_valid = 1'b0;    
               10'sd320: s0_mh_valid = 1'b0;    
               10'sd334: s0_mh_valid = 1'b0;    
               10'sd346: s0_mh_valid = 1'b0;    
               10'sd360: s0_mh_valid = 1'b0;    
               10'sd372: s0_mh_valid = 1'b0;    
               10'sd386: s0_mh_valid = 1'b0;    
               10'sd400: s0_mh_valid = 1'b0;    
               10'sd414: s0_mh_valid = 1'b0;    
               10'sd426: s0_mh_valid = 1'b0;    
               10'sd440: s0_mh_valid = 1'b0;    
               10'sd454: s0_mh_valid = 1'b0;    
               10'sd468: s0_mh_valid = 1'b0;    
               10'sd480: s0_mh_valid = 1'b0;    
               10'sd494: s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
            RU52 : 
              case(s0_haddr)
              -10'd494: s0_mh_valid = 1'b0;    
              -10'd480: s0_mh_valid = 1'b0;    
              -10'd468: s0_mh_valid = 1'b0;    
              -10'd454: s0_mh_valid = 1'b0;    
              -10'd440: s0_mh_valid = 1'b0;    
              -10'd426: s0_mh_valid = 1'b0;    
              -10'd414: s0_mh_valid = 1'b0;    
              -10'd400: s0_mh_valid = 1'b0;    
              -10'd360: s0_mh_valid = 1'b0;    
              -10'd346: s0_mh_valid = 1'b0;    
              -10'd334: s0_mh_valid = 1'b0;    
              -10'd320: s0_mh_valid = 1'b0;    
              -10'd306: s0_mh_valid = 1'b0;    
              -10'd292: s0_mh_valid = 1'b0;    
              -10'd280: s0_mh_valid = 1'b0;    
              -10'd266: s0_mh_valid = 1'b0;    
              -10'd252: s0_mh_valid = 1'b0;    
              -10'd238: s0_mh_valid = 1'b0;    
              -10'd226: s0_mh_valid = 1'b0;    
              -10'd212: s0_mh_valid = 1'b0;    
              -10'd198: s0_mh_valid = 1'b0;    
              -10'd184: s0_mh_valid = 1'b0;    
              -10'd172: s0_mh_valid = 1'b0;    
              -10'd158: s0_mh_valid = 1'b0;    
              -10'd118: s0_mh_valid = 1'b0;    
              -10'd104: s0_mh_valid = 1'b0;    
              -10'd92:  s0_mh_valid = 1'b0;    
              -10'd78:  s0_mh_valid = 1'b0;    
              -10'd64:  s0_mh_valid = 1'b0;    
              -10'd50:  s0_mh_valid = 1'b0;    
              -10'd38:  s0_mh_valid = 1'b0;    
              -10'd24:  s0_mh_valid = 1'b0;    
               10'd24:  s0_mh_valid = 1'b0;    
               10'd38:  s0_mh_valid = 1'b0;    
               10'd50:  s0_mh_valid = 1'b0;    
               10'd64:  s0_mh_valid = 1'b0;    
               10'd78:  s0_mh_valid = 1'b0;    
               10'd92:  s0_mh_valid = 1'b0;    
               10'd104: s0_mh_valid = 1'b0;    
               10'd118: s0_mh_valid = 1'b0;    
               10'd158: s0_mh_valid = 1'b0;    
               10'd172: s0_mh_valid = 1'b0;    
               10'd184: s0_mh_valid = 1'b0;    
               10'd198: s0_mh_valid = 1'b0;    
               10'd212: s0_mh_valid = 1'b0;    
               10'd226: s0_mh_valid = 1'b0;    
               10'd238: s0_mh_valid = 1'b0;    
               10'd252: s0_mh_valid = 1'b0;    
               10'd266: s0_mh_valid = 1'b0;    
               10'd280: s0_mh_valid = 1'b0;    
               10'd292: s0_mh_valid = 1'b0;    
               10'd306: s0_mh_valid = 1'b0;    
               10'd320: s0_mh_valid = 1'b0;    
               10'd334: s0_mh_valid = 1'b0;    
               10'd346: s0_mh_valid = 1'b0;    
               10'd360: s0_mh_valid = 1'b0;    
               10'd400: s0_mh_valid = 1'b0;    
               10'd414: s0_mh_valid = 1'b0;    
               10'd426: s0_mh_valid = 1'b0;    
               10'd440: s0_mh_valid = 1'b0;    
               10'd454: s0_mh_valid = 1'b0;    
               10'd468: s0_mh_valid = 1'b0;    
               10'd480: s0_mh_valid = 1'b0;    
               10'd494: s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
            default    : // RU106 or RU242 or RU484
              case(s0_haddr)
               -10'd494: s0_mh_valid = 1'b0;    
               -10'd468: s0_mh_valid = 1'b0;    
               -10'd426: s0_mh_valid = 1'b0;    
               -10'd400: s0_mh_valid = 1'b0;    
               -10'd360: s0_mh_valid = 1'b0;    
               -10'd334: s0_mh_valid = 1'b0;    
               -10'd292: s0_mh_valid = 1'b0;    
               -10'd266: s0_mh_valid = 1'b0;    
               -10'd252: s0_mh_valid = 1'b0;    
               -10'd226: s0_mh_valid = 1'b0;    
               -10'd184: s0_mh_valid = 1'b0;    
               -10'd158: s0_mh_valid = 1'b0;    
               -10'd118: s0_mh_valid = 1'b0;    
               -10'd92:  s0_mh_valid = 1'b0;    
               -10'd50:  s0_mh_valid = 1'b0;    
               -10'd24:  s0_mh_valid = 1'b0;    
                10'd24:  s0_mh_valid = 1'b0;    
                10'd50:  s0_mh_valid = 1'b0;    
                10'd92:  s0_mh_valid = 1'b0;    
                10'd118: s0_mh_valid = 1'b0;    
                10'd158: s0_mh_valid = 1'b0;    
                10'd184: s0_mh_valid = 1'b0;    
                10'd226: s0_mh_valid = 1'b0;    
                10'd252: s0_mh_valid = 1'b0;    
                10'd266: s0_mh_valid = 1'b0;    
                10'd292: s0_mh_valid = 1'b0;    
                10'd334: s0_mh_valid = 1'b0;    
                10'd360: s0_mh_valid = 1'b0;    
                10'd400: s0_mh_valid = 1'b0;    
                10'd426: s0_mh_valid = 1'b0;    
                10'd468: s0_mh_valid = 1'b0;    
                10'd494: s0_mh_valid = 1'b0;    
                default: s0_mh_valid = s0_valid;
              endcase
          endcase
        default: /* MHZ80_VHT */
          case(s0_haddr)
           -10'd103:  s0_mh_valid = 1'b0;     /* -103 */
           -10'd75 :  s0_mh_valid = 1'b0;     /* -75  */
           -10'd39:   s0_mh_valid = 1'b0;     /* -39  */
           -10'd11:   s0_mh_valid = 1'b0;     /* -11  */
            10'd11:   s0_mh_valid = 1'b0;     /* +11  */
            10'd39:   s0_mh_valid = 1'b0;     /* +39  */
            10'd75:   s0_mh_valid = 1'b0;     /* +75  */
            10'd103:  s0_mh_valid = 1'b0;     /* +103 */
            default: s0_mh_valid = s0_valid; 
          endcase
      endcase
    end
    else
    begin
      s0_mh_valid       = 1'b0;  
    end

  /*****************************************************************************
  * address generation
  * note: never assign static_xxx params on this instance, use the top ones only 
  *****************************************************************************/
  wire stbc_sb_peq_dist;
  
  equalizer_genindex u_equalizer_genindex
  (
    /*****************************************************************************
    * system
    *****************************************************************************/
    .clk(                PhyClk),
    .rst_n(              nPhyRst),
    
    /*****************************************************************************
    * control
    *****************************************************************************/
    .enable(             enable),
    .stride(             Stride),
    .hesigb_PAPR_en(     HeSigBPAPREn),
    .reception_mode(     ReceptionMode),
    .ru_type(            RUType),
    .ru_index(           RUIndex),
    .pilot(              PilotData),
    .stbc(               StbcEn),
    .stbc_sym_odd(       StbcSymOdd),
    .dcm_en(             DcmEn),
    .ldpc_fifo_en(       ldpc_fifo_en),
    .ldpc_fifo_ready(    ldpc_fifo_ready),
    .row_fifo_en(        row_fifo_en),
    .row_fifo_rdptr(     row_fifo_rdptr),
    
    .start(              EqStart),
    .stbc_flush(         EqStbcFlush),
    
    /*****************************************************************************
    * fft address generation
    *****************************************************************************/
    .f_index(            FFTAddr),
    .f_last(             ),
    .f_valid(            FFTAddrEn),
    
    /*****************************************************************************
    * h address generation
    *****************************************************************************/
    .h_index(            HAddr),
    .h_odd(              index_odd),
    .h_papr(             index_papr),
    .h_pilot_count(      index_pilot_count),
    .h_last(             index_last),
    .h_valid(            index_valid),
    
    /*****************************************************************************
    * stbc
    *****************************************************************************/
    .stbc_sb_ren(        stbc_sb_ren),
    .stbc_sb_peq_dist(   stbc_sb_peq_dist)
  );

  assign stbc_sb_peq_dist = stbc_sb_mux && (stbc_sb_addr<(stbc_peq_addr+9'd24));


  assign HAddrEn         = index_valid;
  assign CarrierNb       = FFTAddr;
  
  /* start address generation depending of the FD latencies */
  always @(posedge PhyClk, negedge nPhyRst)
    if(!nPhyRst)
    begin
      index_1t             <= 10'b0;
      index_pilot_count_1t <= 3'b0;
      index_pilot_count_2t <= 3'b0;
      index_odd_1t         <= 1'b0;
      index_odd_2t         <= 1'b0;
      index_papr_1t        <= 1'b0;
      index_last_1t        <= 1'b0;
      index_valid_1t       <= 1'b0;
      index_2t             <= 10'b0;
      index_last_2t        <= 1'b0;
      index_valid_2t       <= 1'b0;                                     
      index_papr_2t        <= 1'b0;
    end
    else if(!enable)
    begin
      index_1t             <= 10'b0;
      index_pilot_count_1t <= 3'b0;
      index_pilot_count_2t <= 3'b0;
      index_odd_1t         <= 1'b0;
      index_odd_2t         <= 1'b0;
      index_papr_1t        <= 1'b0;
      index_last_1t        <= 1'b0;
      index_valid_1t       <= 1'b0;
      index_2t             <= 10'b0;
      index_last_2t        <= 1'b0;
      index_valid_2t       <= 1'b0;                                     
      index_papr_2t        <= 1'b0;
    end
    else
    begin
      /* delay */
      index_1t             <= HAddr;
      index_pilot_count_1t <= index_pilot_count;
      index_pilot_count_2t <= index_pilot_count_1t;
      index_odd_1t         <= index_odd;
      index_odd_2t         <= index_odd_1t;
      index_papr_1t        <= index_papr;
      index_last_1t        <= index_last;
      index_valid_1t       <= index_valid;
      index_2t             <= index_1t;
      index_last_2t        <= index_last_1t;
      index_valid_2t       <= index_valid_1t;
      index_papr_2t        <= index_papr_1t;
    end

  /*****************************************************************************
  * control/address generation
  *
  *  EQU_COMP : no address generated, we integrate H from channel estimate by
  *             peeking H memory write port, excluding pilots/DC gap
  *
  *  EQU_PILOT:
  *  
  *    EqStart
  *    |    FFTAddrEn
  *    |    |   FFTAddr
  *    |    |   |    HAddr
  *    |    |   |    |    CarrierNb 
  *    |    |   |    |    |
  *    0    0   x    x    x
  *    1    0   x    x    x
  *    0    1   A0   x    x
  *    0    1   A1   A0   A0
  *    0    1   A2   A1   A1
  *    0    1   A3   A2   A2
  *   etc...
  *
  *  EQU_DATA:
  *
  *    EqStart
  *    |    FFTAddrEn
  *    |    |   FFTAddr
  *    |    |   |    HAddr
  *    |    |   |    |    CarrierNb 
  *    |    |   |    |    |
  *    0    0   x    x    x
  *    1    0   x    x    x
  *    0    1   A0   x    x
  *    0    1   A1   x    A0
  *    0    1   A2   x    A1
  *    0    1   A3   x    A2
  *    0    1   A4   x    A3
  *    0    1   A5   x    A4
  *    0    1   A6   x    A5
  *    0    1   A7   x    A6
  *    0    1   A8   x    A7
  *    0    1   A9   x    A8
  *    0    1   A10  x    A9
  *    0    1   A11  x    A10
  *    0    1   A12  x    A11
  *    0    1   A13  A0   A12
  *    0    1   A14  A1   A13
  *    0    1   A15  A2   A14
  *   etc...
  *
  *****************************************************************************/
  always @(posedge PhyClk, negedge nPhyRst)
    if(!nPhyRst)
    begin
      static_nsts           <= 1'b0;
      static_nsd            <= 9'b0;
      static_nbpsc          <= 3'b0;  
      static_modtypess1     <= 3'b0;  
      static_reception_mode <= 4'd0;
      static_fddc_en        <= 1'b0;    
      static_fddc_weight_m2 <= 3'b0;
      static_fddc_weight_m1 <= 3'b0; 
      static_fddc_weight_p1 <= 3'b0; 
      static_fddc_weight_p2 <= 3'b0; 
`ifdef RW_MUMIMO_RX_EN
      static_mumimoen       <= 1'b0;
      static_vhtsigbinv     <= 1'b0;
`endif // RW_MUMIMO_RX_EN
      
      qbpsk_detect_en       <= 1'b0;
      qbpsk_detect_clr      <= 1'b0;
      mh_clr                <= 1'b0;
      s0_valid              <= 1'b0;
      s0_pilot_sel          <= 2'b0;
      s0_r_i                <= 13'b0;
      s0_r_q                <= 13'b0;
      s0_h1_i               <= 13'b0; 
      s0_h1_q               <= 13'b0;
      s0_h2_i               <= 13'b0; 
      s0_h2_q               <= 13'b0;
      s0_index              <= 9'd0;
      s0_papr               <= 1'b0;
      s0_odd                <= 1'b0;
      s0_haddr              <= 10'd0;
      s0_last               <= 1'd0; 
      s0_mh_last            <= 1'd0; 
      state                 <= IDLE;
      EqCompDone            <= 1'b0;
      EqPilotDone           <= 1'b0;
      EqDataDone            <= 1'b0;
      EqDone                <= 1'b0;
      QbpskDetDone          <= 1'b0;                     
      pilot_polarity        <= 8'b0;
    end
    else if(!enable)
    begin
      static_nsts           <= 1'b0;
      static_nsd            <= 9'b0;
      static_nbpsc          <= 3'b0;  
      static_modtypess1     <= 3'b0;  
      static_reception_mode <= 4'd0;
      static_fddc_en        <= 1'b0;    
      static_fddc_weight_m2 <= 3'b0;
      static_fddc_weight_m1 <= 3'b0; 
      static_fddc_weight_p1 <= 3'b0; 
      static_fddc_weight_p2 <= 3'b0; 
`ifdef RW_MUMIMO_RX_EN
      static_mumimoen       <= 1'b0;
      static_vhtsigbinv     <= 1'b0;
`endif // RW_MUMIMO_RX_EN
      
      qbpsk_detect_en       <= 1'b0;
      qbpsk_detect_clr      <= 1'b0;
      mh_clr                <= 1'b0;
      s0_valid              <= 1'b0;
      s0_pilot_sel          <= 2'b0;
      s0_r_i                <= 13'b0;
      s0_r_q                <= 13'b0;
      s0_h1_i               <= 13'b0; 
      s0_h1_q               <= 13'b0;
      s0_h2_i               <= 13'b0; 
      s0_h2_q               <= 13'b0;
      s0_index              <= 10'd0;
      s0_odd                <= 1'b0;
      s0_papr               <= 1'b0;
      s0_haddr              <= 10'd0;
      s0_last               <= 1'd0; 
      s0_mh_last            <= 1'd0; 
      state                 <= IDLE;
      EqCompDone            <= 1'b0;
      EqPilotDone           <= 1'b0;
      EqDataDone            <= 1'b0;
      EqDone                <= 1'b0;
      QbpskDetDone          <= 1'b0;                     
      pilot_polarity        <= 8'b0;
    end
    else
    begin
      /* RTZ */
      mh_clr              <= 1'b0;
      s0_valid            <= 1'b0;
      s0_r_i              <= 13'b0;
      s0_r_q              <= 13'b0;
      s0_h1_i             <= 13'b0; 
      s0_h1_q             <= 13'b0;
      s0_h2_i             <= 13'b0; 
      s0_h2_q             <= 13'b0;
      s0_index            <= 10'd0;
      s0_odd              <= 1'b0;
      s0_papr             <= 1'b0;
      s0_haddr            <= 10'd0;
      s0_last             <= 1'd0; 
      EqCompDone          <= 1'b0;
      EqPilotDone         <= 1'b0;
      EqDataDone          <= 1'b0;
      EqDone              <= 1'b0;
      QbpskDetDone        <= 1'b0;

`ifdef RW_MUMIMO_RX_EN
      /* parameter pipeline */
      static_mumimoen     <= MuMIMOEn;
      static_vhtsigbinv   <= VHTSIGBInv;
`endif // RW_MUMIMO_RX_EN

      /* FSM */
      case(state)
        /***********************************************************************
        * IDLE
        * note: never read static_xxx params in IDLE state, use the top ones
        ***********************************************************************/
        IDLE:
        begin
          /* RTZ */
          qbpsk_detect_en <= 1'b0; 
          /* state transition */
          if(EqCompStart)
          begin
            mh_clr    <= 1'b1;
            state     <= EQU_COMP;
          end  
          else if(EqStart)
          begin
            if(PilotData)
              state <= EQU_PILOT;
            else 
            begin
              qbpsk_detect_clr <= 1'b1;
              qbpsk_detect_en  <= DiscEn;
              state            <= EQU_DATA;
            end
          end
          
          /* latch parameters */
          if(EqStart || EqCompStart)
          begin
            
            case(ModTypeSS1)
              3'd0:    static_nbpsc <= NBPSC_BPSK;    /* BPSK   */
              3'd1:    static_nbpsc <= NBPSC_BPSK;    /* QBPSK  */ 
              3'd2:    static_nbpsc <= NBPSC_QPSK;    /* QPSK   */ 
              3'd3:    static_nbpsc <= NBPSC_QAM16;   /* QAM16  */
              3'd4:    static_nbpsc <= NBPSC_QAM64;   /* QAM64  */
              default: static_nbpsc <= NBPSC_QAM256;  /* QAM256  */
`ifdef RW_NX_DERIV_EQU_1024QAM
              3'd6:    static_nbpsc <= NBPSC_QAM1024; /* QAM1024 */
`endif // RW_NX_DERIV_EQU_1024QAM
            endcase
  
            case(ReceptionMode)
              MHZ20_LEG:   static_nsd <=  9'd48; 
              MHZ20_HT:    static_nsd <=  9'd52; 
              MHZ40_HT:    static_nsd <= 9'd108; 
              MHZ20_HEMU: begin
                case (RUType)
                  RU26    : static_nsd <=  9'd24;
                  RU52    : static_nsd <=  9'd48;
                  RU106   : static_nsd <= 9'd102;
                  default : static_nsd <= 9'd234;
                endcase
              end
`ifndef RW_NX_DERIV_CHBW20ONLY
              MHZ40_HESU:   static_nsd <= 9'd468;
`endif
              MHZ40_HEMU,MHZ80_HEMU: begin
                case (RUType)
                  RU26    : static_nsd <=  9'd24;
                  RU52    : static_nsd <=  9'd48;
                  RU106   : static_nsd <= 9'd102;
                  RU242   : static_nsd <= 9'd234;
                  default : static_nsd <= 9'd468;
                endcase
              end
              default:     static_nsd <= 9'd234; 
            endcase
    
            static_nsts           <= NSTS;
            static_modtypess1     <= ModTypeSS1;
            static_reception_mode <= ReceptionMode;
      
            static_fddc_en        <= (SnrEst>FddcSnrThreshold) && 
                                     FddcCompEn && 
                                     !ModeIs2040 &&
                                     (ReceptionMode==MHZ20_LEG || ReceptionMode==MHZ20_HT) ;
            
            static_fddc_weight_m2 <= FddcWeightM2;       
            static_fddc_weight_m1 <= FddcWeightM1;       
            static_fddc_weight_p1 <= FddcWeightP1;       
            static_fddc_weight_p2 <= FddcWeightP2;       
          end
          
        end
      
        /***********************************************************************
        * EQU_COMP
        ***********************************************************************/
        EQU_COMP:
        begin
          /* registered inputs */
          s0_pilot_sel <= 2'b0;
          s0_haddr     <= HWrAddr; 
          s0_last      <= EstimDoneP;
          s0_mh_last   <= EstimDoneP;
          if(ChEstDataEn && HWrEn)
          begin
            s0_h1_q  <= HWrData[51:39]; 
            s0_h1_i  <= HWrData[38:26]; 
            s0_valid <= 1'b1;
            if(static_nsts)
            begin
              s0_h2_q  <= HWrData[25:13]; 
              s0_h2_i  <= HWrData[12: 0];         
            end
          end
         
          /* eqcomp done */
          if(mh_done)
          begin
            EqCompDone <= 1'b1;
            state      <= IDLE;
          end
            
          /* because a data symbol is never preceeded by a EQU_COMP during nsts=2  */
          /* (no smooth from H), we use EQU_COMP to reset the pilot polarity       */
          /* shift register                                                        */
          /*                                                                       */
          /* note: polarity refers to the polarity difference between pilots from  */
          /* different space time streams, see tables 20-19/20-20 of Chapter 20    */
          case({static_nsts,static_reception_mode})
            {1'b1,MHZ20_HT}: pilot_polarity <= 8'b11_001010; // note: 2msb are don't care
            {1'b1,MHZ40_HT}: pilot_polarity <= 8'b11_110100;
            default:         pilot_polarity <= 8'b11_000000;
          endcase
          
        end
       
        /***********************************************************************
        * EQU_PILOT
        ***********************************************************************/
        EQU_PILOT:
        begin
          s0_valid        <= index_valid_2t;
          /* registered inputs */
          if(index_valid_2t)
          begin
            s0_index     <= index_2t;
            s0_papr      <= 1'b0;
            s0_last      <= index_last_2t;
            s0_r_i       <= RI;
            s0_r_q       <= RQ;       
            s0_h1_i      <= H1I;
            s0_h1_q      <= H1Q;
            s0_pilot_sel <= 2'b01;
            if(static_nsts)
            begin
              s0_pilot_sel <= {1'b1,pilot_polarity[index_pilot_count_2t]};
              s0_h2_i <= H2I;
              s0_h2_q <= H2Q;
            end
          end
                   
          /* pilot equalization done */
          if(s3_last)
          begin
            /* update pilot polarity pattern for nsts=2 */
            if(static_reception_mode==MHZ40_HT) 
              pilot_polarity <= {2'b0, pilot_polarity[0],pilot_polarity[5:1]};      // note: 2msb are don't care
            else
              pilot_polarity <= {2'b0, 2'b0,pilot_polarity[0],pilot_polarity[3:1]}; // note: 2msb are don't care
           
            EqPilotDone <= 1'b1;
            state       <= IDLE;
          end
        end
        
        /***********************************************************************
        * EQU_DATA
        ***********************************************************************/
        default:
        begin
          qbpsk_detect_clr <= 1'b0; 
          /* registered inputs */
          s0_valid     <= index_valid_2t;
          if(index_valid_2t)
          begin
            s0_index   <= index_2t;
            s0_odd     <= index_odd_2t;
            s0_papr    <= index_papr_2t;
            s0_last    <= index_last_2t;
            s0_r_i     <= RI;
            s0_r_q     <= RQ;       
            s0_h1_i    <= H1I;
            s0_h1_q    <= H1Q;
            s0_pilot_sel <= 2'b00;
            if(static_nsts)
            begin
              s0_h2_i <= H2I;
              s0_h2_q <= H2Q;
            end
          end
        
          /* arbitrary delay before EqlzrPipeFlushDoneP,
             use to turn on the clock of the bit domain */
          if(s1_last && s1_valid)
            EqDone <= 1'b1;
          
          /* QbpskDet qualifier */
          if(s6_last && s6_valid)
            QbpskDetDone <= 1'b1;
          
          /* Data equalization finished on last soft bit pushed out (s15_last) */
          /* 1) in case of stbc, no soft bit produced during even symbol, processing ends at pequ output (s5_last) */
          /* 2) in case of non-stbc/ stbc odd symbol, last soft bits is output in s15  */
          if(StbcEn && !StbcSymOdd && s5_valid && s5_last ||  // see 1)
             s15_last && s15_valid)                           // see 2)
          begin
            EqDataDone <= 1'b1;
            state      <= IDLE;
          end
        end
      endcase
    end 
  
  /*****************************************************************************
  * S1-S6
  *****************************************************************************/
  always @(posedge PhyClk, negedge nPhyRst)
    if(!nPhyRst)
    begin 
      /* s1 */
      s1_last            <= 1'b0;
      s1_mh_valid        <= 1'b0;
      s1_index           <= 10'b0;
      s1_odd             <= 1'b0;
      s1_valid           <= 1'b0;
      s1_mh_last         <= 1'b0;
      /* s2 */
      s2_last            <= 1'b0;
      s2_mh_valid        <= 1'b0;
      s2_mh_last         <= 1'b0;
      s2_index           <= 10'b0;
      s2_odd             <= 1'b0;
      s2_valid           <= 1'b0;
      /* s3 */
      s3_last            <= 1'b0;
      s3_d               <= 19'd0;
      s3_index           <= 10'b0;
      s3_odd             <= 1'b0;
      s3_valid           <= 1'b0;
      /* s4 */
      s4_last            <= 1'b0;
      s4_d               <= 10'b0;
      s4_index           <= 9'b0;
      s4_odd             <= 1'b0;
      s4_valid           <= 1'b0;
      /* s5 */
      s5_last            <= 1'b0;
      s5_d               <= 10'b0;
      s5_index           <= 9'b0;
      s5_odd             <= 1'b0;
      s5_valid           <= 1'b0;
      /* s6 */
      s6_d               <= 19'd0;
      s6_last            <= 1'b0;
      s6_index           <= 10'b0;
      s6_odd             <= 1'b0;
      s6_valid           <= 1'b0;
      /* s7 */
      s7_d               <= 19'd0;
      s7_last            <= 1'b0;
      s7_index           <= 10'b0;
      s7_odd             <= 1'b0;
      s7_valid           <= 1'b0;
      /* s8 */
      s8_d               <= 19'd0;
      s8_last            <= 1'b0;
      s8_index           <= 10'b0;
      s8_odd             <= 1'b0;
      s8_valid           <= 1'b0;
      /* s9 */
      s9_d               <= 19'd0;
      s9_odd             <= 1'b0;
      s9_last            <= 1'b0;
      s9_valid           <= 1'b0;
      /* s10 */
      s10_last           <= 1'b0;
      s10_odd            <= 1'b0;
      /* s11 */
      s11_last           <= 1'b0;
      s11_odd            <= 1'b0;
      /* s12 */
      s12_last           <= 1'b0;
      s12_odd            <= 1'b0;
      /* s13 */
      s13_last           <= 1'b0;
      s13_odd            <= 1'b0;
      /* s14 */
      s14_last           <= 1'b0;
      s14_odd            <= 1'b0;
      /* s15 */
      s15_last           <= 1'b0;
      s15_odd            <= 1'b0;
    end
    else if(!enable)
    begin
      /* s1 */
      s1_last            <= 1'b0;
      s1_mh_valid        <= 1'b0;
      s1_index           <= 10'b0;
      s1_odd             <= 1'b0;
      s1_valid           <= 1'b0;
      s1_mh_last         <= 1'b0;
      /* s2 */
      s2_last            <= 1'b0;
      s2_mh_valid        <= 1'b0;
      s2_mh_last         <= 1'b0;
      s2_index           <= 10'b0;
      s2_odd             <= 1'b0;
      s2_valid           <= 1'b0;
      /* s3 */
      s3_last            <= 1'b0;
      s3_d               <= 10'b0;
      s3_index           <= 9'b0;
      s3_odd             <= 1'b0;
      s3_valid           <= 1'b0;
      /* s4 */
      s4_last            <= 1'b0;
      s4_d               <= 19'd0;
      s4_index           <= 10'b0;
      s4_odd             <= 1'b0;
      s4_valid           <= 1'b0;
      /* s5 */
      s5_last            <= 1'b0;
      s5_d               <= 19'd0;
      s5_index           <= 10'b0;
      s5_odd             <= 1'b0;
      s5_valid           <= 1'b0;
      /* s6 */
      s6_d               <= 19'd0;
      s6_last            <= 1'b0;
      s6_index           <= 10'b0;
      s6_odd             <= 1'b0;
      s6_valid           <= 1'b0;
      /* s7 */
      s7_d               <= 19'd0;
      s7_last            <= 1'b0;
      s7_index           <= 10'b0;
      s7_odd             <= 1'b0;
      s7_valid           <= 1'b0;
      /* s8 */
      s8_d               <= 19'd0;
      s8_last            <= 1'b0;
      s8_index           <= 9'b0;
      s8_odd             <= 1'b0;
      s8_valid           <= 1'b0;
      /* s9 */
      s9_d               <= 19'd0;
      s9_odd             <= 1'b0;
      s9_last            <= 1'b0;
      s9_valid           <= 1'b0;
      /* s10 */
      s10_last           <= 1'b0;
      s10_odd            <= 1'b0;
      /* s11 */
      s11_last           <= 1'b0;
      s11_odd            <= 1'b0;
      /* s12 */
      s12_last           <= 1'b0;
      s12_odd            <= 1'b0;
      /* s13 */
      s13_last           <= 1'b0;
      s13_odd            <= 1'b0;
      /* s14 */
      s14_last           <= 1'b0;
      s14_odd            <= 1'b0;
      /* s15 */
      s15_last           <= 1'b0;
      s15_odd            <= 1'b0;
    end
    else
    begin
      /* s1 */
      s1_valid           <= s0_valid;
      s1_index           <= s0_index;
      s1_odd             <= s0_odd;
      s1_last            <= s0_last;
      s1_mh_valid        <= s0_mh_valid;
      s1_mh_last         <= s0_mh_last;
      /* s2 */
      s2_valid           <= s1_valid;
      s2_index           <= s1_index;
      s2_odd             <= s1_odd;
      s2_last            <= s1_last;
      s2_mh_valid        <= s1_mh_valid;
      s2_mh_last         <= s1_mh_last;
      /* s3  */
      s3_valid           <= s2_valid;
      s3_index           <= s2_index;
      s3_odd             <= s2_odd;
      s3_last            <= s2_last;
      s3_d               <= s2_d;
      /* s4 */
      if(state==EQU_DATA)
      begin
        s4_d       <= s3_d;
        s4_index   <= s3_index;
        s4_odd     <= s3_odd;
        s4_last    <= s3_last;
        s4_valid   <= s3_valid;
      end
      else
      begin
        /* s4 */
        s4_d       <= 19'd0;
        s4_index   <= 10'b0;
        s4_odd     <= 1'b0;
        s4_last    <= 1'b0;
        s4_valid   <= 1'b0;
      end
      /* s5 */
      s5_d       <= s4_d;        
      s5_index   <= s4_index;  
      s5_odd     <= s4_odd;
      s5_last    <= s4_last;     
      s5_valid   <= s4_valid;    
      /* s6 */                   
      if(!StbcEn || StbcSymOdd)
      begin
        s6_odd     <= s5_odd;
        s6_d       <= s5_d;        
        s6_index   <= s5_index;
        s6_last    <= s5_last;     
        s6_valid   <= s5_valid; 
      end
      else
      begin
        s6_odd     <= 1'b0;
        s6_index   <= 10'b0;
        s6_last    <= 1'b0;     
        s6_valid   <= 1'b0; 
      end   
      /* s7 */                   
      s7_d       <= s6_d;        
      s7_index   <= s6_index;
      s7_odd     <= s6_odd;
      s7_last    <= s6_last;     
      s7_valid   <= s6_valid;    
      /* s8 */                  
      s8_d       <= s7_d;        
      s8_index   <= s7_index;
      s8_odd     <= s7_odd;
      s8_last    <= s7_last;     
      s8_valid   <= s7_valid;    
      /* s9 */                  
      s9_d       <= s8_d;   
      s9_odd     <= s8_odd;     
      s9_last    <= s8_last;  
      s9_valid   <= s8_valid;    
      /* s10 */                  
      s10_last   <= s9_last;   
      s10_odd    <= s9_odd;  
      /* s11 */                  
      s11_last   <= s10_last; 
      s11_odd    <= s10_odd;    
      /* s12 */                  
      s12_last   <= s11_last; 
      s12_odd    <= s11_odd;    
      /* s13 */                  
      s13_last   <= s12_last;  
      s13_odd    <= s12_odd;   
      /* s14 */                  
      s14_last   <= s13_last;
      s14_odd    <= s13_odd;     
      /* s15 */                  
      s15_last   <= s14_last;  
      s15_odd    <= s14_odd;   
    end

  /*****************************************************************************
  * d
  *****************************************************************************/
  equalizer_d
  #(
    .g_arch(            1)
  )
  u_equalizer_d
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
   
    /* operands */
    .t0_h1_i(           s0_h1_i),
    .t0_h1_q(           s0_h1_q),
    .t0_h2_i(           s0_h2_i),
    .t0_h2_q(           s0_h2_q),
    /* product */
    .t2_d(              s2_d)
  );
  
  /*****************************************************************************
  * mh 
  *****************************************************************************/

  /* Select SatSb register from current symbol parameters */
  always @(*)                                                          
`ifdef RW_MUMIMO_RX_EN
    if (static_mumimoen)
    begin
      if (LdpcEn && static_nsts)
        satsb = SatSbMULDPCNSTS1;
      else if (LdpcEn && !static_nsts)
        satsb = SatSbMULDPCNSTS0;
      else if (static_nsts)
        satsb = SatSbMUBCCNSTS1;
      else
        satsb = SatSbMUBCCNSTS0;
    end
    else
    begin
`endif // RW_MUMIMO_RX_EN
      if (LdpcEn && static_nsts)
        satsb = SatSbLDPCNSTS1;
      else if (LdpcEn && !static_nsts)
        satsb = SatSbLDPCNSTS0;
      else if (static_nsts)
        satsb = SatSbBCCNSTS1;
      else
        satsb = SatSbBCCNSTS0;
`ifdef RW_MUMIMO_RX_EN
    end
`endif // RW_MUMIMO_RX_EN

  equalizer_mh u_mh
  (
    // system 
    .rst_n(                  nPhyRst),
    .clk(                    PhyClk),
   
    // control
    .mh_clr(                 mh_clr),
    .eq2d_en(                Eq2DEn),
    .mh3_update(             EqMHUpdate),
    // parameters
    .mh_nsd(                 static_nsd),
    .mh_shift_val(           MhShiftVal),
    .mh_shift_thr(           MhShiftThr),
    .mh2_sigma_squared(      SigmaSquared),
    .mh3_ldpc(               LdpcEn),           // do not use static_* value as can change for mh3_update
    .mh3_mod_type(           ModTypeSS1),       // do not use static_* value as can change for mh3_update
    .mh3_satsb(              satsb),            // can change for mh3_update
   
    // status registers
    .status_pri_mh(          status_pri_mh),
    .status_pri_dmax(        status_pri_dmax),
    
    // operands for mh computation
    .t0_valid(               s2_mh_valid),
    .t0_d(                   s2_d),
    .t0_last(                s2_mh_last),
    
    // product
    .mh_x_satsb(             all_mh_x_satsb),
    .mh_x_satsb_rnd12(       all_mh_x_satsb_rnd12),
    .mh_done(                mh_done)
  );
 
  assign  StatusMh           = {2'b0,status_pri_mh};
  assign  StatusDMax         = {1'b0,status_pri_dmax};

  assign  mh_x_satsb       = all_mh_x_satsb;        
  assign  mh_x_satsb_rnd12 = all_mh_x_satsb_rnd12;  

  /*****************************************************************************
  * partial equalization
  *****************************************************************************/
  // HE-SIGB PAPR reduction
  assign s0_r_i_neg  = ~s0_r_i + 13'd1;
  assign s0_r_q_neg  = ~s0_r_q + 13'd1;
  assign s0_r_i_papr = s0_papr ? s0_r_i_neg : s0_r_i;
  assign s0_r_q_papr = s0_papr ? s0_r_q_neg : s0_r_q;
  
  equalizer_pequ
  #(
    .g_arch(            1)
  )
  u_pequ
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    /* control */
    .enable(            enable),
    .stbc(              StbcEn),
    .odd(               StbcSymOdd),
    .qbpsk_detect_en(   qbpsk_detect_en),
    .qbpsk_detect_clr(  qbpsk_detect_clr),
    /* operands */
    .t0_valid(          s0_valid),
    .t0_pilot_sel(      s0_pilot_sel),
    .t0_last(           s0_last),
    .t0_r_i(            s0_r_i_papr),
    .t0_r_q(            s0_r_q_papr),
    .t0_h1_i(           s0_h1_i),
    .t0_h1_q(           s0_h1_q),
    .t0_h2_i(           s0_h2_i),
    .t0_h2_q(           s0_h2_q),
    /* x data*/
    .t6_valid(          /* do not connect */),
    .t6_x0_i(           s6_x0_i), 
    .t6_x0_q(           s6_x0_q), 
    .t6_x1_i(           s6_x1_i), 
    .t6_x1_q(           s6_x1_q), 
    /* x pilot */
    .t3_pilot_valid(    s3_pilot_valid),
    .t3_pilot_i(        s3_pilot_i),    
    .t3_pilot_q(        s3_pilot_q),    
    /* qbpsk detection */
    .qbpsk_accu_i(      qbpsk_accu_i),
    .qbpsk_accu_q(      qbpsk_accu_q),
    /* stbc memory ports */
    .stbc_wen(          stbc_peq_wen),
    .stbc_ren(          stbc_peq_ren),
    .stbc_addr(         stbc_peq_addr),
    .stbc_wdata(        stbc_peq_wdata),
    .stbc_rdata(        stbc_rdata)
  );
  
  always @(posedge PhyClk, negedge nPhyRst)
    if(!nPhyRst)
      QbpskDet <= 1'b0;
    else
      QbpskDet <= qbpsk_accu_q>qbpsk_accu_i;

  assign FDOEEn = s3_pilot_valid;
  assign FDOEI  = s3_pilot_i;
  assign FDOEQ  = s3_pilot_q;
 
  /*****************************************************************************
  * demapper
  *****************************************************************************/
  /* ss0 i */
  equalizer_dmap u_dmap0_i
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    
    /* control */
    .enable(            enable),

    /* parameter */
    .nbpsc(             static_nbpsc),
    
    /* d and x */
    .t0_d(              s6_d),
    .t0_x(              s6_x0_i),
    
    /* sb */
    .t2_sb0(            s8_dmap0_sb0_i),
    .t2_sb1(            s8_dmap0_sb1_i),
    .t2_sb2(            s8_dmap0_sb2_i),
    .t2_sb3(            s8_dmap0_sb3_i),
    .t2_sb4(            s8_dmap0_sb4_i)
  );
 
  /* ss0 q */
  equalizer_dmap u_dmap0_q
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    
    /* control */
    .enable(            enable),

    /* parameter */
    .nbpsc(             static_nbpsc),
    
    /* d and x */
    .t0_d(              s6_d),
    .t0_x(              s6_x0_q),
    
    /* sb */
    .t2_sb0(            s8_dmap0_sb0_q),
    .t2_sb1(            s8_dmap0_sb1_q),
    .t2_sb2(            s8_dmap0_sb2_q),
    .t2_sb3(            s8_dmap0_sb3_q),
    .t2_sb4(            s8_dmap0_sb4_q)
  );
  
  /* group soft bits */
  always @(*)
  begin
    case(static_modtypess1)
      3'd0,3'd1,3'd2: /* BPSK / QBPSK / QPSK */
      begin
        s8_dmap0_sb0 = s8_dmap0_sb0_i;
        s8_dmap0_sb1 = 24'b0;
        s8_dmap0_sb2 = 24'b0;
        s8_dmap0_sb3 = 24'b0;
        s8_dmap0_sb4 = s8_dmap0_sb0_q;
        s8_dmap0_sb5 = 24'b0;
        s8_dmap0_sb6 = 24'b0;
        s8_dmap0_sb7 = 24'b0;
        s8_dmap0_sb8 = 24'b0;
        s8_dmap0_sb9 = 24'b0;
      end
      3'd3: /* QAM16  */
      begin
        s8_dmap0_sb0 = s8_dmap0_sb0_i;
        s8_dmap0_sb1 = s8_dmap0_sb1_i;
        s8_dmap0_sb2 = 24'b0;
        s8_dmap0_sb3 = 24'b0;
        s8_dmap0_sb4 = s8_dmap0_sb0_q;
        s8_dmap0_sb5 = s8_dmap0_sb1_q;
        s8_dmap0_sb6 = 24'b0;
        s8_dmap0_sb7 = 24'b0;
        s8_dmap0_sb8 = 24'b0;
        s8_dmap0_sb9 = 24'b0;
      end
      3'd4: /* QAM64  */
      begin
        s8_dmap0_sb0 = s8_dmap0_sb0_i;
        s8_dmap0_sb1 = s8_dmap0_sb1_i;
        s8_dmap0_sb2 = s8_dmap0_sb2_i;
        s8_dmap0_sb3 = 24'b0;
        s8_dmap0_sb4 = s8_dmap0_sb0_q;
        s8_dmap0_sb5 = s8_dmap0_sb1_q;
        s8_dmap0_sb6 = s8_dmap0_sb2_q;
        s8_dmap0_sb7 = 24'b0;
        s8_dmap0_sb8 = 24'b0;
        s8_dmap0_sb9 = 24'b0;
      end
      default: /* QAM256 */
      begin
        s8_dmap0_sb0 = s8_dmap0_sb0_i;
        s8_dmap0_sb1 = s8_dmap0_sb1_i;
        s8_dmap0_sb2 = s8_dmap0_sb2_i;
        s8_dmap0_sb3 = s8_dmap0_sb3_i;
        s8_dmap0_sb4 = s8_dmap0_sb0_q;
        s8_dmap0_sb5 = s8_dmap0_sb1_q;
        s8_dmap0_sb6 = s8_dmap0_sb2_q;
        s8_dmap0_sb7 = s8_dmap0_sb3_q;
        s8_dmap0_sb8 = 24'b0;
        s8_dmap0_sb9 = 24'b0;
      end
`ifdef RW_NX_DERIV_EQU_1024QAM
      3'd6: /* QAM1024 */
      begin
        s8_dmap0_sb0 = s8_dmap0_sb0_i;
        s8_dmap0_sb1 = s8_dmap0_sb1_i;
        s8_dmap0_sb2 = s8_dmap0_sb2_i;
        s8_dmap0_sb3 = s8_dmap0_sb3_i;
        s8_dmap0_sb4 = s8_dmap0_sb4_i;
        s8_dmap0_sb5 = s8_dmap0_sb0_q;
        s8_dmap0_sb6 = s8_dmap0_sb1_q;
        s8_dmap0_sb7 = s8_dmap0_sb2_q;
        s8_dmap0_sb8 = s8_dmap0_sb3_q;
        s8_dmap0_sb9 = s8_dmap0_sb4_q;
      end
`endif // RW_NX_DERIV_EQU_1024QAM
    endcase
  end

  /* ss1 i */
  equalizer_dmap u_dmap1_i
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    
    /* control */
    .enable(            enable),

    /* parameter */
    .nbpsc(             static_nbpsc),
    
    /* d and x */
    .t0_d(              s6_d),
    .t0_x(              s6_x1_i),
    
    /* sb */
    .t2_sb0(            s8_dmap1_sb0_i),
    .t2_sb1(            s8_dmap1_sb1_i),
    .t2_sb2(            s8_dmap1_sb2_i),
    .t2_sb3(            s8_dmap1_sb3_i),
    .t2_sb4(            s8_dmap1_sb4_i)
  );
 
  /* ss1 q */
  equalizer_dmap u_dmap1_q
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    
    /* control */
    .enable(            enable),

    /* parameter */
    .nbpsc(             static_nbpsc),
    
    /* d and x */
    .t0_d(              s6_d),
    .t0_x(              s6_x1_q),
    
    /* sb */
    .t2_sb0(            s8_dmap1_sb0_q),
    .t2_sb1(            s8_dmap1_sb1_q),
    .t2_sb2(            s8_dmap1_sb2_q),
    .t2_sb3(            s8_dmap1_sb3_q),
    .t2_sb4(            s8_dmap1_sb4_q)
  );

  
  always @(*)
  begin
    case(static_modtypess1)
      3'd0,3'd1,3'd2: /* BPSK / QBPSK / QPSK */
      begin
        s8_dmap1_sb0 = s8_dmap1_sb0_i;
        s8_dmap1_sb1 = 24'b0;
        s8_dmap1_sb2 = 24'b0;
        s8_dmap1_sb3 = 24'b0;
        s8_dmap1_sb4 = s8_dmap1_sb0_q;
        s8_dmap1_sb5 = 24'b0;
        s8_dmap1_sb6 = 24'b0;
        s8_dmap1_sb7 = 24'b0;
        s8_dmap1_sb8 = 24'b0;
        s8_dmap1_sb9 = 24'b0;
      end
      3'd3: /* QAM16  */
      begin
        s8_dmap1_sb0 = s8_dmap1_sb0_i;
        s8_dmap1_sb1 = s8_dmap1_sb1_i;
        s8_dmap1_sb2 = 24'b0;
        s8_dmap1_sb3 = 24'b0;
        s8_dmap1_sb4 = s8_dmap1_sb0_q;
        s8_dmap1_sb5 = s8_dmap1_sb1_q;
        s8_dmap1_sb6 = 24'b0;
        s8_dmap1_sb7 = 24'b0;
        s8_dmap1_sb8 = 24'b0;
        s8_dmap1_sb9 = 24'b0;
      end
      3'd4: /* QAM64  */
      begin
        s8_dmap1_sb0 = s8_dmap1_sb0_i;
        s8_dmap1_sb1 = s8_dmap1_sb1_i;
        s8_dmap1_sb2 = s8_dmap1_sb2_i;
        s8_dmap1_sb3 = 24'b0;
        s8_dmap1_sb4 = s8_dmap1_sb0_q;
        s8_dmap1_sb5 = s8_dmap1_sb1_q;
        s8_dmap1_sb6 = s8_dmap1_sb2_q;
        s8_dmap1_sb7 = 24'b0;
        s8_dmap1_sb8 = 24'b0;
        s8_dmap1_sb9 = 24'b0;
      end
      default: /* QAM256 */
      begin
        s8_dmap1_sb0 = s8_dmap1_sb0_i;
        s8_dmap1_sb1 = s8_dmap1_sb1_i;
        s8_dmap1_sb2 = s8_dmap1_sb2_i;
        s8_dmap1_sb3 = s8_dmap1_sb3_i;
        s8_dmap1_sb4 = s8_dmap1_sb0_q;
        s8_dmap1_sb5 = s8_dmap1_sb1_q;
        s8_dmap1_sb6 = s8_dmap1_sb2_q;
        s8_dmap1_sb7 = s8_dmap1_sb3_q;
        s8_dmap1_sb8 = 24'b0;
        s8_dmap1_sb9 = 24'b0;
      end
`ifdef RW_NX_DERIV_EQU_1024QAM
      3'd6: /* QAM1024 */
      begin
        s8_dmap1_sb0 = s8_dmap1_sb0_i;
        s8_dmap1_sb1 = s8_dmap1_sb1_i;
        s8_dmap1_sb2 = s8_dmap1_sb2_i;
        s8_dmap1_sb3 = s8_dmap1_sb3_i;
        s8_dmap1_sb4 = s8_dmap1_sb4_i;
        s8_dmap1_sb5 = s8_dmap1_sb0_q;
        s8_dmap1_sb6 = s8_dmap1_sb1_q;
        s8_dmap1_sb7 = s8_dmap1_sb2_q;
        s8_dmap1_sb8 = s8_dmap1_sb3_q;
        s8_dmap1_sb9 = s8_dmap1_sb4_q;
      end
`endif // RW_NX_DERIV_EQU_1024QAM
    endcase
  end
    
  /*****************************************************************************
  * ss0 fddc
  *****************************************************************************/
  equalizer_fddc u_fddc0_0
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb0),
    .t1_sb_sgn(         s9_ss0_sb0_sgn),
    .t1_sb_abs(         s9_ss0_sb0_abs)
  );

  equalizer_fddc u_fddc0_1
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb1),
    .t1_sb_sgn(         s9_ss0_sb1_sgn),
    .t1_sb_abs(         s9_ss0_sb1_abs)
  );
  
  equalizer_fddc u_fddc0_2
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb2),
    .t1_sb_sgn(         s9_ss0_sb2_sgn),
    .t1_sb_abs(         s9_ss0_sb2_abs)
  );

`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_fddc u_fddc0_3
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb3),
    .t1_sb_sgn(         s9_ss0_sb3_sgn),
    .t1_sb_abs(         s9_ss0_sb3_abs)
  );
`else
  assign s9_ss0_sb3_sgn =  1'b0;
  assign s9_ss0_sb3_abs = 23'b0;
`endif
  
  equalizer_fddc u_fddc0_4
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb4),
    .t1_sb_sgn(         s9_ss0_sb4_sgn),
    .t1_sb_abs(         s9_ss0_sb4_abs)
  );

  equalizer_fddc u_fddc0_5
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb5),
    .t1_sb_sgn(         s9_ss0_sb5_sgn),
    .t1_sb_abs(         s9_ss0_sb5_abs)
  );
  
  equalizer_fddc u_fddc0_6
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb6),
    .t1_sb_sgn(         s9_ss0_sb6_sgn),
    .t1_sb_abs(         s9_ss0_sb6_abs)
  );

`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_fddc u_fddc0_7
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb7),
    .t1_sb_sgn(         s9_ss0_sb7_sgn),
    .t1_sb_abs(         s9_ss0_sb7_abs)
  );
`else
  assign s9_ss0_sb7_sgn =  1'b0;
  assign s9_ss0_sb7_abs = 23'b0;
`endif 
 
`ifdef RW_NX_DERIV_EQU_1024QAM
  equalizer_fddc u_fddc0_8
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb8),
    .t1_sb_sgn(         s9_ss0_sb8_sgn),
    .t1_sb_abs(         s9_ss0_sb8_abs)
  );

  equalizer_fddc u_fddc0_9
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap0_sb9),
    .t1_sb_sgn(         s9_ss0_sb9_sgn),
    .t1_sb_abs(         s9_ss0_sb9_abs)
  );

`endif // RW_NX_DERIV_EQU_1024QAM

  /*****************************************************************************
  * ss1 fddc
  *****************************************************************************/
  equalizer_fddc u_fddc1_0
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb0),
    .t1_sb_sgn(         s9_ss1_sb0_sgn),
    .t1_sb_abs(         s9_ss1_sb0_abs)
  );

  equalizer_fddc u_fddc1_1
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb1),
    .t1_sb_sgn(         s9_ss1_sb1_sgn),
    .t1_sb_abs(         s9_ss1_sb1_abs)
  );
  
  equalizer_fddc u_fddc1_2
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb2),
    .t1_sb_sgn(         s9_ss1_sb2_sgn),
    .t1_sb_abs(         s9_ss1_sb2_abs)
  );

`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_fddc u_fddc1_3
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb3),
    .t1_sb_sgn(         s9_ss1_sb3_sgn),
    .t1_sb_abs(         s9_ss1_sb3_abs)
  );
`else
  assign s9_ss1_sb3_sgn =  1'b0;
  assign s9_ss1_sb3_abs = 23'b0;
`endif
  
  equalizer_fddc u_fddc1_4
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb4),
    .t1_sb_sgn(         s9_ss1_sb4_sgn),
    .t1_sb_abs(         s9_ss1_sb4_abs)
  );

  equalizer_fddc u_fddc1_5
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb5),
    .t1_sb_sgn(         s9_ss1_sb5_sgn),
    .t1_sb_abs(         s9_ss1_sb5_abs)
  );
  
  equalizer_fddc u_fddc1_6
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb6),
    .t1_sb_sgn(         s9_ss1_sb6_sgn),
    .t1_sb_abs(         s9_ss1_sb6_abs)
  );

`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_fddc u_fddc1_7
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb7),
    .t1_sb_sgn(         s9_ss1_sb7_sgn),
    .t1_sb_abs(         s9_ss1_sb7_abs)
  );
`else
  assign s9_ss1_sb7_sgn =  1'b0;
  assign s9_ss1_sb7_abs = 23'b0;
`endif 
 
`ifdef RW_NX_DERIV_EQU_1024QAM
  equalizer_fddc u_fddc1_8
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb8),
    .t1_sb_sgn(         s9_ss1_sb8_sgn),
    .t1_sb_abs(         s9_ss1_sb8_abs)
  );

  equalizer_fddc u_fddc1_9
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),

    /* configuration */
    .fddc_en(           static_fddc_en),
    .fddc_weight_p1(    static_fddc_weight_p1),
    .fddc_weight_p2(    static_fddc_weight_p2),
    .fddc_weight_m1(    static_fddc_weight_m1),
    .fddc_weight_m2(    static_fddc_weight_m2),
  
    /* sb */
    .t0_index(          s8_index),
    .t0_sb(             s8_dmap1_sb9),
    .t1_sb_sgn(         s9_ss1_sb9_sgn),
    .t1_sb_abs(         s9_ss1_sb9_abs)
  );

`endif // RW_NX_DERIV_EQU_1024QAM

  /*****************************************************************************
  * soft bit compression ss0
  *****************************************************************************/
  equalizer_sbc u_ss0_sbc0
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb0_sgn),
    .t0_sb_abs(         s9_ss0_sb0_abs),
  
    /* sb */
    .t6_valid(          s15_valid),
    .t6_sbc(            s15_ss0_sbc0)
  );
  
  equalizer_sbc u_ss0_sbc1
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN

    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb1_sgn),
    .t0_sb_abs(         s9_ss0_sb1_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc1)
  );
 
  equalizer_sbc u_ss0_sbc2
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb2_sgn),
    .t0_sb_abs(         s9_ss0_sb2_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc2)
  );
  
`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_sbc u_ss0_sbc3
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb3_sgn),
    .t0_sb_abs(         s9_ss0_sb3_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc3)
  );
`else
  assign s15_ss0_sbc3 = 5'b0;
`endif
  
  equalizer_sbc u_ss0_sbc4
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb4_sgn),
    .t0_sb_abs(         s9_ss0_sb4_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc4)
  );
  
  equalizer_sbc u_ss0_sbc5
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb5_sgn),
    .t0_sb_abs(         s9_ss0_sb5_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc5)
  );
 
  equalizer_sbc u_ss0_sbc6
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb6_sgn),
    .t0_sb_abs(         s9_ss0_sb6_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc6)
  );
  
`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_sbc u_ss0_sbc7
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb7_sgn),
    .t0_sb_abs(         s9_ss0_sb7_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc7)
  );
`else
  assign s15_ss0_sbc7 = 5'b0;
`endif
    
`ifdef RW_NX_DERIV_EQU_1024QAM
  equalizer_sbc u_ss0_sbc8
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb8_sgn),
    .t0_sb_abs(         s9_ss0_sb8_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc8)
  );

  equalizer_sbc u_ss0_sbc9
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss0_sb9_sgn),
    .t0_sb_abs(         s9_ss0_sb9_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss0_sbc9)
  );

`else
  assign s15_ss0_sbc8 = 5'b0;
  assign s15_ss0_sbc9 = 5'b0;
`endif // RW_NX_DERIV_EQU_1024QAM

  /*****************************************************************************
  * soft bit compression ss1
  *****************************************************************************/
  equalizer_sbc u_ss1_sbc0
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb0_sgn),
    .t0_sb_abs(         s9_ss1_sb0_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc0)
  );
  
  equalizer_sbc u_ss1_sbc1
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN

    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb1_sgn),
    .t0_sb_abs(         s9_ss1_sb1_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc1)
  );
 
  equalizer_sbc u_ss1_sbc2
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb2_sgn),
    .t0_sb_abs(         s9_ss1_sb2_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc2)
  );
  
`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_sbc u_ss1_sbc3
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb3_sgn),
    .t0_sb_abs(         s9_ss1_sb3_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc3)
  );
`else
  assign s15_ss1_sbc3 = 5'b0;
`endif
  
  equalizer_sbc u_ss1_sbc4
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb4_sgn),
    .t0_sb_abs(         s9_ss1_sb4_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc4)
  );
  
  equalizer_sbc u_ss1_sbc5
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb5_sgn),
    .t0_sb_abs(         s9_ss1_sb5_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc5)
  );
 
  equalizer_sbc u_ss1_sbc6
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb6_sgn),
    .t0_sb_abs(         s9_ss1_sb6_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc6)
  );
  
`ifdef RW_NX_DERIV_EQU_256QAM
  equalizer_sbc u_ss1_sbc7
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb7_sgn),
    .t0_sb_abs(         s9_ss1_sb7_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc7)
  );
`else
  assign s15_ss1_sbc7 = 5'b0;
`endif
    
`ifdef RW_NX_DERIV_EQU_1024QAM
  equalizer_sbc u_ss1_sbc8
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb8_sgn),
    .t0_sb_abs(         s9_ss1_sb8_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc8)
  );

  equalizer_sbc u_ss1_sbc9
  (
    /* system */
    .rst_n(             nPhyRst),
    .clk(               PhyClk),
    .enable(            enable),

    /* parameters */
    .nsd(               static_nsd),
    .mh_x_satsb(        mh_x_satsb),
    .mh_x_satsb_rnd12(  mh_x_satsb_rnd12),
`ifdef RW_MUMIMO_RX_EN
    .vht_sigb_inv(      static_vhtsigbinv),
`endif // RW_MUMIMO_RX_EN
  
    /* sb */
    .t0_valid(          s9_valid),
    .t0_d(              s9_d),
    .t0_accu_en(        1'b0),
    .t0_sb_sgn(         s9_ss1_sb9_sgn),
    .t0_sb_abs(         s9_ss1_sb9_abs),
  
    /* sb */
    .t6_valid(          ),
    .t6_sbc(            s15_ss1_sbc9)
  );

`else
  assign s15_ss1_sbc8 = 5'b0;
  assign s15_ss1_sbc9 = 5'b0;
`endif // RW_NX_DERIV_EQU_1024QAM
  
  /*****************************************************************************
  * write/read odd symbol sb to/from stbc memory
  *****************************************************************************/
  wire [ 8:0] n_stbc_sb_addr;
  assign n_stbc_sb_addr = stbc_sb_addr + 9'd1;
  
  always @(posedge PhyClk, negedge nPhyRst)
  begin
    if(!nPhyRst)
    begin
      stbc_sb_mux     <= 1'b0;
      stbc_sb_addr    <= 9'd0;
      stbc_sb_wen     <= 1'b0;
      stbc_sb_wdata   <= 51'd0;
      stbc_sb_ren_1t  <= 1'b0;
      stbc_sb_ren_2t  <= 1'b0;
      stbc_sb_ren_3t  <= 1'b0;
      stbc_sb_sb0     <= 5'b0;
      stbc_sb_sb1     <= 5'b0;
      stbc_sb_sb2     <= 5'b0;
      stbc_sb_sb3     <= 5'b0;
      stbc_sb_sb4     <= 5'b0;
      stbc_sb_sb5     <= 5'b0;
      stbc_sb_sb6     <= 5'b0;
      stbc_sb_sb7     <= 5'b0;
      stbc_sb_sb8     <= 5'b0;
      stbc_sb_sb9     <= 5'b0;
      stbc_sb_last    <= 1'b0;
      EqStbcFlushDone <= 1'b0;
    end
    else if(!enable)
    begin
      stbc_sb_mux     <= 1'b0;
      stbc_sb_addr    <= 9'd0;
      stbc_sb_wen     <= 1'b0;
      stbc_sb_ren_1t  <= 1'b0;
      stbc_sb_ren_2t  <= 1'b0;
      stbc_sb_ren_3t  <= 1'b0;
      EqStbcFlushDone <= 1'b0;
    end
    else
    begin
      /* wp */
      if(StbcEn && StbcSymOdd)
      begin
        stbc_sb_wen          <= s15_valid;
        stbc_sb_wdata[ 4: 0] <= s15_ss1_sbc0;
        stbc_sb_wdata[ 9: 5] <= s15_ss1_sbc1;
        stbc_sb_wdata[14:10] <= s15_ss1_sbc2;
        stbc_sb_wdata[19:15] <= s15_ss1_sbc3;
        stbc_sb_wdata[24:20] <= s15_ss1_sbc4;
        stbc_sb_wdata[29:25] <= s15_ss1_sbc5;
        stbc_sb_wdata[34:30] <= s15_ss1_sbc6;
        stbc_sb_wdata[39:35] <= s15_ss1_sbc7;
        stbc_sb_wdata[44:40] <= s15_ss1_sbc8;
        stbc_sb_wdata[49:45] <= s15_ss1_sbc9;
        stbc_sb_wdata[   50] <= s15_last;
        
        if(stbc_sb_wen)
        begin
          if(stbc_sb_wdata[50])
          begin
            stbc_sb_addr <= 9'd0;
            stbc_sb_mux  <= 1'b1;
          end
          else
          begin
            stbc_sb_addr <= n_stbc_sb_addr;
          end
        end
      end
      
      /* rp */
      stbc_sb_ren_1t <= stbc_sb_ren;
      stbc_sb_ren_2t <= stbc_sb_ren_1t;
      stbc_sb_ren_3t <= stbc_sb_ren_2t;
      
      if(stbc_sb_ren_2t)
      begin
        stbc_sb_sb0  <= stbc_rdata[ 4: 0];
        stbc_sb_sb1  <= stbc_rdata[ 9: 5];
        stbc_sb_sb2  <= stbc_rdata[14:10];
        stbc_sb_sb3  <= stbc_rdata[19:15];
        stbc_sb_sb4  <= stbc_rdata[24:20];
        stbc_sb_sb5  <= stbc_rdata[29:25];
        stbc_sb_sb6  <= stbc_rdata[34:30];
        stbc_sb_sb7  <= stbc_rdata[39:35];
        stbc_sb_sb8  <= stbc_rdata[44:40];
        stbc_sb_sb9  <= stbc_rdata[49:45];
        stbc_sb_last <= stbc_rdata[   50];
      end
      
      EqStbcFlushDone  <= 1'b0;
      if(stbc_sb_ren_3t && stbc_sb_last)
      begin
        stbc_sb_addr    <= 9'd0;
        stbc_sb_mux     <= 1'b0;
        EqStbcFlushDone <= 1'b1;
      end
      else if(stbc_sb_ren)
      begin
        stbc_sb_addr <= n_stbc_sb_addr;
      end
    end
  end
 
  /*****************************************************************************
  * stbc memory ports
  *****************************************************************************/
  assign stbc_ren   = stbc_peq_ren                        | stbc_sb_ren;
  assign stbc_raddr = stbc_peq_addr  & { 9{stbc_peq_ren}} | stbc_sb_addr          & { 9{stbc_sb_ren}};
  
  assign stbc_wen   = stbc_peq_wen                        | stbc_sb_wen;
  assign stbc_waddr = stbc_peq_addr  & { 9{stbc_peq_wen}} | stbc_sb_addr          & { 9{stbc_sb_wen}};
  assign stbc_wdata = stbc_peq_wdata & {76{stbc_peq_wen}} | {25'b0,stbc_sb_wdata} & {76{stbc_sb_wen}};
 
  /*****************************************************************************
  * output stage
  *****************************************************************************/
  assign SBValid = (!stbc_sb_mux) ? s15_valid    : stbc_sb_ren_3t;
  assign SB0     = (!stbc_sb_mux) ? s15_ss0_sbc0 : stbc_sb_sb0;
  assign SB1     = (!stbc_sb_mux) ? s15_ss0_sbc1 : stbc_sb_sb1;
  assign SB2     = (!stbc_sb_mux) ? s15_ss0_sbc2 : stbc_sb_sb2;
  assign SB3     = (!stbc_sb_mux) ? s15_ss0_sbc3 : stbc_sb_sb3;
  assign SB4     = (!stbc_sb_mux) ? s15_ss0_sbc4 : stbc_sb_sb4;
  assign SB5     = (!stbc_sb_mux) ? s15_ss0_sbc5 : stbc_sb_sb5;
  assign SB6     = (!stbc_sb_mux) ? s15_ss0_sbc6 : stbc_sb_sb6;
  assign SB7     = (!stbc_sb_mux) ? s15_ss0_sbc7 : stbc_sb_sb7;
  assign SB8     = (!stbc_sb_mux) ? s15_ss0_sbc8 : stbc_sb_sb8;
  assign SB9     = (!stbc_sb_mux) ? s15_ss0_sbc9 : stbc_sb_sb9;
  assign SBOdd   = (!stbc_sb_mux) ? s15_odd      : 1'b0;
  assign SBLast  = (!stbc_sb_mux) ? s15_last     : stbc_sb_last;
 
  /*****************************************************************************
  * debug ports
  *****************************************************************************/
  assign Debug0[15:12] = static_reception_mode;
  assign Debug0[   11] = static_nsts;
  assign Debug0[10: 9] = 2'd0;
  assign Debug0[ 8: 6] = static_nbpsc;
  assign Debug0[ 5: 4] = 2'd0;
  assign Debug0[ 3: 2] = state;
  assign Debug0[    1] = s3_valid;
  assign Debug0[    0] = s3_last;
/*  

  assign Debug1[15:12] = s5_x1_q[19:16];
  assign Debug1[11: 8] = s5_x1_i[19:16];
  assign Debug1[ 7: 4] = s5_pilot_q[19:16] | s5_x0_q[19:16];
  assign Debug1[ 3: 0] = s5_pilot_i[19:16] | s5_x0_i[19:16];
 
  assign Debug2[15: 0] = nonht_mh_x_satsb_rnd12;
 
  assign Debug3[15: 0] = all_mh_x_satsb_rnd12;
 
  assign Debug4[15: 0] = s5_d[15:0];   
 
  assign Debug5[15: 0] = s5_pilot_i[15: 0] | s5_x0_i[15: 0];     
 
  assign Debug6[15: 0] = s5_pilot_q[15: 0] | s5_x0_q[15: 0];     
 
  assign Debug7[15: 0] = s5_x1_i[15: 0];   
 
  assign Debug8[15: 0] = s5_x1_q[15: 0];       
 
  assign Debug9[15:12] = 4'b0;
  assign Debug9[11: 8] = {1'b0,s5_d[18:16]};
  assign Debug9[ 7: 0] = s5_index;
*/

`ifdef RW_SIMU_ON
  /*****************************************************************************
  * simulation
  *****************************************************************************/
  // pragma coverage block = off, expr = off, toggle = off
  reg [16*8-1:0] str_state;
  always @(*)
    case(state)
      IDLE:       str_state = "IDLE";
      EQU_COMP:   str_state = "EQU_COMP";
      EQU_PILOT:  str_state = "EQU_PILOT";
      EQU_DATA:   str_state = "EQU_DATA";
      default:    str_state = "XXXXXXXX";
    endcase
  // pragma coverage block = on, expr = on, toggle = on
`endif
    
endmodule
`default_nettype wire
