#!/usr/bin/perl
################################################################################
# Copyright (C) by RivieraWaves.
# This module is a confidential and proprietary property of RivieraWaves
# and a possession or use of this module requires written permission
# from RivieraWaves.
################################################################################
# Company: RivieraWaves
# $Author: $
################################################################################
# $Revision: $
# $Date: $
################################################################################
# Dependencies     : None
# Description      : 
# Simulation Notes : 
# Synthesis Notes  :
# Application Note :
# Simulator        :
# Parameters       :
# Terms & concepts :
# Bugs             :
# Open issues and future enhancements :
# References       :
# Revision History :
################################################################################
# $HeadURL: $
################################################################################
#
# just display sc index / H addr relation
#
use strict;
no strict 'refs';


my ($l,$k,$hg);                                           
my (@leg_index,@leg_hg);
my (@ht20_index,@ht20_hg);
my (@ht40_index,@ht40_hg);
my (@ht80_index,@ht80_hg);
my %ht40_hg_vs_index;
$hg = 2;                                                                     
$k  = 0;
for(my $sc=-26;$sc<=+26;$sc++)                                               
{                                                                            
  # skip dc                                                                  
  if($sc==0)                                                                 
  {                                                                          
    next;                                                                    
  }                                                                          
                                                                             
  # skip pilot                                                               
  if($sc==-21 || $sc==-7 || $sc==7 || $sc==21)                               
  {                                                                          
    $hg++;                                                                   
    next;                                                                    
  }                                                                          
                                                                             
  # display                                                                  
  @leg_index[$k] = $sc;                                                      
  @leg_hg[$k]    = $hg;                                                      
                                                                             
  # update                                                                   
  $hg++;                                                                     
  $k++;                                                                      
} 

$hg = 0;
$k  = 0;                                                                     
for(my $sc=-28;$sc<=+28;$sc++)                                               
{                                                                            
  # skip dc                                                                  
  if($sc==0)                                                                 
  {                                                                          
    next;                                                                    
  }                                                                          
                                                                             
  # skip pilot                                                               
  if($sc==-21 || $sc==-7 || $sc==7 || $sc==21)                               
  {                                                                          
    $hg++;                                                                   
    next;                                                                    
  }                                                                          
                                                                             
  # display                                                                  
  @ht20_index[$k] = $sc;                                                      
  @ht20_hg[$k]    = $hg;                                                      
  # update                                                                   
  $hg++;                                                                     
  $k++;                                                                      
}

$hg = 0; 
$k  = 0;                                                                    
for(my $sc=-58;$sc<=+58;$sc++)                                               
{                                                                            
  # skip dc                                                                  
  if($sc==0 || $sc==-1 || $sc==1 )                                           
  {                                                                          
    next;                                                                    
  }                                                                          
                                                                             
  # skip pilot                                                               
  if($sc==-53 || $sc==-25 || $sc==-11 ||                                     
     $sc== 11 || $sc== 25 || $sc== 53)                                       
  {                                                                          
    $hg++;                                                                   
    next;                                                                    
  }                                                                          
                                                                             
  # display                                                                  
  @ht40_index[$k] = $sc;                                                      
  @ht40_hg[$k]    = $hg;                                                      
  $ht40_hg_vs_index{$sc}=$hg;
                                                                             
  # update                                                                   
  $hg++;                                                                     
  $k++;                                                                      
}                                                                            

$hg = 0;
$k  = 0;
for(my $sc=-122;$sc<=+122;$sc++)                                             
{                                                                            
  # skip dc                                                                  
  if($sc==0 || $sc==-1 || $sc==1 )                                           
  {                                                                          
    next;                                                                    
  }                                                                          
                                                                             
  # skip pilot                                                               
  if($sc==-103 || $sc==-75 || $sc==-39 || $sc==-11 ||                        
     $sc==11 || $sc==39 || $sc==75 || $sc==103)                              
  {                                                                          
    $hg++;                                                                   
    next;                                                                    
  }                                                                          
                                                                             
  # display                                                                  
  @ht80_index[$k] = $sc;                                                      
  @ht80_hg[$k]    = $hg;                                                      
                                                                             
  # update                                                                   
  $hg++;                                                                     
  $k++;                                                                      
}                                                                            

printf "// MHZ20_LEG\n";                 
for(my $k=0;$k<48;$k++)                                               
{                                                                            
  #$l = (3*$k)%48 + int(3*$k/48);
  $l=$k;
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",$k,$l,@leg_index[$l],@leg_hg[$l];
}  

printf "// MHZ40_DUP\n";                 
for(my $k=0;$k<48;$k++)                                               
{                                                                            
  #$l = (3*$k)%48 + int(3*$k/48);
  $l=$k;
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",(2*$k),$l,(@leg_index[$l]-32),$ht40_hg_vs_index{(@leg_index[$l]-32)};
 
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",(2*$k+1),$l,(@leg_index[$l]+32),$ht40_hg_vs_index{(@leg_index[$l]+32)};

}  
printf "// MHZ20_HT\n";                 
for(my $k=0;$k<52;$k++)                                               
{                                                                            
  #$l = (4*$k)%52 + int(4*$k/52);
  $l=$k;
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",$k,$l,@ht20_index[$l],@ht20_hg[$l];
}  

printf "// MHZ40_HT */\n";                 
for(my $k=0;$k<108;$k++)                                               
{                                                                            
  #$l = (6*$k)%108 + int(6*$k/108);
  $l=$k;
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",$k,$l,@ht40_index[$l],@ht40_hg[$l];
}  

printf "// MHZ80_HT\n";                 
for(my $k=0;$k<234;$k++)                                               
{                                                                            
  #$l = (9*$k)%234 + int(9*$k/234);
  $l=$k;
  printf "// k=%4d  l=%4d sc=%4d hg=%4d\n",$k,$l,@ht80_index[$l],@ht80_hg[$l];
}  
