/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_d
#(
  /*****************************************************************************
  *  g_arch
  *  'd0     booth multiplier 
  *  'd1     behavioural model (synthesizable)
  *****************************************************************************/
  parameter g_arch=0
)
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         clk,
  input  wire         rst_n,
 
  /*****************************************************************************
  * operands
  *****************************************************************************/
  input  wire [12:0]  t0_h1_i,
  input  wire [12:0]  t0_h1_q,
  input  wire [12:0]  t0_h2_i,
  input  wire [12:0]  t0_h2_q,
  
  /*****************************************************************************
  * product
  *****************************************************************************/
  output reg  [18:0]  t2_d
);
 
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  /* S1 stage */
  wire [25:0]  t1_h1_i2,t1_h1_q2,t1_h2_i2,t1_h2_q2;
  
  /* S2 stage */
  wire [26:0]  n_t2_d;
  
  /*****************************************************************************
  * log2(d max)  = log2( (-4096)*(-4096)*4/256) = log2(262144) = 18 => 19 bits because we encode 262144 too
  *****************************************************************************/
  
  /*****************************************************************************
  * S1: compute all partial products
  *****************************************************************************/
  mult_13x13
  #(
    .g_arch(            g_arch)
  )
  u_h1_i2
  (
    .rst_n(             rst_n),
    .clk(               clk),
    .neg(               1'b0),
    .a(                 t0_h1_i),
    .b(                 t0_h1_i),
    .p(                 t1_h1_i2)
  );
  
  mult_13x13
  #(
    .g_arch(            g_arch)
  )
  u_h1_q2
  (
    .rst_n(             rst_n),
    .clk(               clk),
    .neg(               1'b0),
    .a(                 t0_h1_q),
    .b(                 t0_h1_q),
    .p(                 t1_h1_q2)
  );
  
  mult_13x13
  #(
    .g_arch(            g_arch)
  )
  u_h2_i2
  (
    .rst_n(             rst_n),
    .clk(               clk),
    .neg(               1'b0),
    .a(                 t0_h2_i),
    .b(                 t0_h2_i),
    .p(                 t1_h2_i2)
  );
  
  mult_13x13
  #(
    .g_arch(            g_arch)
  )
  u_h2_q2
  (
    .rst_n(             rst_n),
    .clk(               clk),
    .neg(               1'b0),
    .a(                 t0_h2_q),
    .b(                 t0_h2_q),
    .p(                 t1_h2_q2)
  );
  
  /*****************************************************************************
  * S2: compute sum squared components d
  *****************************************************************************/
  assign n_t2_d =  
     {{1{t1_h1_i2[25]}}, t1_h1_i2} +
     {{1{t1_h1_q2[25]}}, t1_h1_q2} +
     {{1{t1_h2_i2[25]}}, t1_h2_i2} +
     {{1{t1_h2_q2[25]}}, t1_h2_q2} +
     27'd128; // RND8 fix


  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      t2_d     <= 19'b0;
    else
      t2_d     <= n_t2_d[26:8];
 
endmodule
`default_nettype wire
