/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_dmap
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         clk,
  input  wire         rst_n,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire         enable,

  /*****************************************************************************
  * parameter
  *****************************************************************************/
  input  wire [ 2:0]  nbpsc,
  
  /*****************************************************************************
  * d and x
  *****************************************************************************/
  input  wire [18:0]  t0_d,
  input  wire [19:0]  t0_x,
  
  /*****************************************************************************
  * sb
  *****************************************************************************/
  output reg  [23:0]  t2_sb0,
  output reg  [23:0]  t2_sb1,
  output reg  [23:0]  t2_sb2,
  output reg  [23:0]  t2_sb3,
  output reg  [23:0]  t2_sb4
);
  /*****************************************************************************
  * declarations
  *****************************************************************************/
  reg  [18:0] t1_d;
  wire [23:0] t1_x;
  reg  [23:0] t1_d_th1,t1_d_th2,t1_d_th3;
  reg  [ 2:0] static_nbpsc;
  reg         static_en_sb1,static_en_sb2,static_en_sb3,static_en_sb4;
  wire [23:0] t1_sb0,t1_sb1,t1_sb2;
  wire        t1_sgn0,t1_sgn1;
  wire [23:0] t1_abs0,t1_abs1;
  localparam  BPSK=3'd0,QPSK=3'd1,QAM16=3'd2,QAM64=3'd3,QAM256=3'd4, QAM1024=3'd5;  

  /*****************************************************************************
  * static
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      static_nbpsc <= 3'b0;
    else
      static_nbpsc <= nbpsc;
    
  /*****************************************************************************
  * T1 quantized gain, thresholds on d
  *****************************************************************************/
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      t1_d     <= 19'd0;
    else if(!enable)
      t1_d     <= 19'd0;
    else
      t1_d     <= t0_d;
 
  equalizer_dmap_gain u_equalizer_dmap_gain
  (
    .rst_n(      rst_n),
    .clk(        clk),
    .nbpsc(      nbpsc),
    .i(          t0_x),
    .o(          t1_x)
  );
  
  /* thresholds definition */
  always @(*)
  begin
    case(static_nbpsc)
      BPSK,QPSK:
      begin
        static_en_sb4 = 1'b0;
        static_en_sb3 = 1'b0;
        static_en_sb2 = 1'b0;
        static_en_sb1 = 1'b0;
        t1_d_th3      = {4'b0,t1_d,1'b0};
        t1_d_th2      = {4'b0,t1_d,1'b0};
        t1_d_th1      = {4'b0,t1_d,1'b0};
      end
      QAM16:
      begin
        static_en_sb4 = 1'b0;
        static_en_sb3 = 1'b0;
        static_en_sb2 = 1'b0;
        static_en_sb1 = 1'b1;
        t1_d_th3      = {4'b0,t1_d,1'b0};
        t1_d_th2      = {4'b0,t1_d,1'b0};
        t1_d_th1      = {4'b0,t1_d,1'b0};
      end
      QAM64:
      begin
        static_en_sb4 = 1'b0;
        static_en_sb3 = 1'b0;
        static_en_sb2 = 1'b1;
        static_en_sb1 = 1'b1;
        t1_d_th3      = {4'b0,t1_d,1'b0};
        t1_d_th2      = {4'b0,t1_d,1'b0};
        t1_d_th1      = {3'b0,t1_d,2'b0};
      end
      default: /* QAM256 */
      begin
        static_en_sb4 = 1'b0;
        static_en_sb3 = 1'b1;
        static_en_sb2 = 1'b1;
        static_en_sb1 = 1'b1;
        t1_d_th3      = {4'b0,t1_d,1'b0};
        t1_d_th2      = {3'b0,t1_d,2'b0};
        t1_d_th1      = {2'b0,t1_d,3'b0};
      end
      QAM1024:
      begin
        static_en_sb4 = 1'b1;
        static_en_sb3 = 1'b1;
        static_en_sb2 = 1'b1;
        static_en_sb1 = 1'b1;
        t1_d_th3      = {3'b0,t1_d,2'b0};
        t1_d_th2      = {2'b0,t1_d,3'b0};
        t1_d_th1      = {1'b0,t1_d,4'b0};
      end
    endcase
  end
  
  /* sb0 */
  assign t1_sb0  = t1_x;
  assign t1_sgn0 = t1_sb0[23];
  assign t1_abs0 = t1_sb0^{24{t1_sgn0}};
 
  /* sb1 */
  assign t1_sb1  = t1_d_th1 - t1_abs0 - {23'b0,t1_sgn0};
  assign t1_abs1 = t1_sb1^{24{t1_sgn1}};
  assign t1_sgn1 = t1_sb1[23];
 
  /* sb2 */
  assign t1_sb2  = t1_d_th2 - t1_abs1 - {23'b0,t1_sgn1};

`ifdef RW_NX_DERIV_EQU_256QAM
  wire        t1_sgn2;
  wire [23:0] t1_abs2,t1_sb3;

  assign t1_sgn2 = t1_sb2[23];
  assign t1_abs2 = t1_sb2^{24{t1_sgn2}};
 
  /* sb3 */
  assign t1_sb3  = t1_d_th3 - t1_abs2  - {23'b0,t1_sgn2};
`endif
  
`ifdef RW_NX_DERIV_EQU_1024QAM
  wire        t1_sgn3;
  wire [23:0] t1_abs3,t1_sb4;

  assign t1_sgn3 = t1_sb3[23];
  assign t1_abs3 = t1_sb3^{24{t1_sgn3}};
 
  /* sb4 */
  assign t1_sb4  = {4'b0,t1_d,1'b0} - t1_abs3  - {23'b0,t1_sgn3};
`endif
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t2_sb0 <= 24'd0;
      t2_sb1 <= 24'd0;
      t2_sb2 <= 24'd0;
      t2_sb3 <= 24'd0;
      t2_sb4 <= 24'd0;
    end
    else if(!enable)
    begin
      t2_sb0 <= 24'd0;
      t2_sb1 <= 24'd0;
      t2_sb2 <= 24'd0;
      t2_sb3 <= 24'd0;
      t2_sb4 <= 24'd0;
    end
    else
    begin
      t2_sb0 <= t1_sb0; 
      t2_sb1 <= t1_sb1 & {24{static_en_sb1}}; 
      t2_sb2 <= t1_sb2 & {24{static_en_sb2}}; 
`ifdef RW_NX_DERIV_EQU_256QAM
      t2_sb3 <= t1_sb3 & {24{static_en_sb3}}; 
`else
      t2_sb3 <= t1_sb0; // dont't care
`endif
`ifdef RW_NX_DERIV_EQU_1024QAM
      t2_sb4 <= t1_sb4 & {24{static_en_sb4}}; 
`else
      t2_sb4 <= 24'd0; // dont't care
`endif
    end

endmodule
`default_nettype wire
