/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_dmap_gain
(
  input  wire         clk,
  input  wire         rst_n,
  
  input  wire [ 2:0]  nbpsc,
  
  input  wire [19:0]  i,
  output reg  [23:0]  o
);

  wire signed [33:0] p_signed;
  wire [33:0]        p,p_fix;                                         
  reg  [13:0]        en;                                              
                                                                      
  localparam  BPSK=3'd0,QPSK=3'd1,QAM16=3'd2,QAM64=3'd3,QAM256=3'd4,QAM1024=3'd5;  
  always @(*)                                                         
    case(nbpsc)                                                       
      BPSK:    en= 14'd512;                                            
      QPSK:    en= 14'd724;                                            
      QAM16:   en= 14'd1619;                                           
      default: en= 14'd3318; // QAM64                                          
`ifdef RW_NX_DERIV_EQU_256QAM
      QAM256:  en= 14'd6676;                                           
`endif
`ifdef RW_NX_DERIV_EQU_1024QAM
      QAM1024: en= 14'd13371;                                           
`endif
    endcase                                                           

  assign p_signed = $signed({1'b0,en}) * $signed(i);
  assign p        = $unsigned(p_signed);
  assign p_fix    = p + {25'b0,1'b1,8'b0};                               
                                                                      
  always @(posedge clk, negedge rst_n)                                
    if(!rst_n)                                                        
      o <= 24'b0;                                                 
    else                                                              
      o <= p_fix[32:9]; // todo one more bit QAM1024
  
  
// generate if(g_arch=='d0)
// begin:b_arch_0
//   /*****************************************************************************
//   *
//   *****************************************************************************/
//   wire [32:0]  pp0,pp1,pp2,pp4,pp5,pp6,pp7,pp9,pp10,pp11,pp12;
//   reg  [12:0]  en;
//   wire [ 3:0]  carry_l;
//   wire [15:0]  sum_l;
//   wire [16:0]  sum_h;
//   reg  [ 3:0]  carry_l_1t;
//   reg  [ 6:0]  sum_l_1t;
//   reg  [16:0]  sum_h_1t;     

//   /*****************************************************************************
//   * i range is [ -2**19 2**19-1] = [ -524288   524287]
//   * o range is [ -524288   524287]*6676/512 = [-6.8362e+06 6.8362e+06]
//   *   which fits 24 bits [-2**23 2**23-1]=[-8388608 8388607]
//   *
//   *   512   0 00+0 0000 0000  1
//   *   724   0 00+0 ++0+ 0+00  5
//   *  1619   0 0++0 0+0+ 00++  6
//   *  3318   0 ++00 ++++ 0++0  8
//   *  6676   + +0+0 000+ 0+00  5
//   *
//   *****************************************************************************/
//   localparam  BPSK=3'd0,QPSK=3'd1,QAM16=3'd2,QAM64=3'd3,QAM256=3'd4;
//   always @(*)
//     case(nbpsc)
//       BPSK:    en=13'd512;
//       QPSK:    en=13'd724;
//       QAM16:   en=13'd1619;
//       QAM64:   en=13'd3318;
//       default: en=13'd6676;
//     endcase
// 
//   assign pp0   = {11'b000000000000,   ~i[19],i[19],i                  } & {33{en[0] }};
//   assign pp1   = {11'b000000000011,         ~i[19],i             ,1'b0} & {33{en[1] }};
//   assign pp2   = {10'b0000000001,           ~i[19],i            ,2'b00} & {33{en[2] }};
//   assign pp4   = { 9'b000000001,            ~i[19],i          ,4'b0000} & {33{en[4] }};
//   assign pp5   = { 8'b00000001,             ~i[19],i         ,5'b00000} & {33{en[5] }};
//   assign pp6   = { 7'b0000001,              ~i[19],i        ,6'b000000} & {33{en[6] }};
//   assign pp7   = { 6'b000011,               ~i[19],i       ,7'b0000000} & {33{en[7] }};
//   assign pp9   = { 4'b0001,                 ~i[19],i     ,9'b000000000} & {33{en[9] }};
//   assign pp10  = { 3'b001,                  ~i[19],i   ,10'b0000000000} & {33{en[10]}};
//   assign pp11  = { 2'b01,                   ~i[19],i  ,11'b00000000000} & {33{en[11]}};
//   assign pp12  = {1 'b1,                    ~i[19],i ,12'b000000000000} & {33{en[12]}};

//   assign {carry_l,sum_l} = {4'b0,  pp0[15:0]} +
//                            {4'b0,  pp1[15:0]} +    
//                            {4'b0,  pp2[15:0]} +    
//                            {4'b0,  pp4[15:0]} +    
//                            {4'b0,  pp5[15:0]} +    
//                            {4'b0,  pp6[15:0]} +    
//                            {4'b0,  pp7[15:0]} +    
//                            {4'b0,  pp9[15:0]} +    
//                            {4'b0, pp10[15:0]} +    
//                            {4'b0, pp11[15:0]} +    
//                            {4'b0, pp12[15:0]} + 
//                            20'd256;     

//   assign sum_h         =  pp0[32:16] +   
//                           pp1[32:16] +   
//                           pp2[32:16] +   
//                           pp4[32:16] +   
//                           pp5[32:16] +   
//                           pp6[32:16] +   
//                           pp7[32:16] +   
//                           pp9[32:16] +   
//                          pp10[32:16] +   
//                          pp11[32:16] +   
//                          pp12[32:16];  

//   always @(posedge clk, negedge rst_n)
//     if(!rst_n)
//     begin
//       carry_l_1t <= 4'b0;
//       sum_l_1t   <= 7'b0;
//       sum_h_1t   <=17'b0;
//     end
//     else
//     begin
//       carry_l_1t <= carry_l;
//       sum_l_1t   <= sum_l[15:9];
//       sum_h_1t   <= sum_h;
//     end

//    assign o = {  sum_h_1t,  sum_l_1t} +
//               {carry_l_1t,      7'b0};


// end
// endgenerate

endmodule
`default_nettype wire
