/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_fddc
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         clk,
  input  wire         rst_n,

  /*****************************************************************************
  * configuration
  *****************************************************************************/
  input  wire         fddc_en,
  input  wire [2:0]   fddc_weight_p1,
  input  wire [2:0]   fddc_weight_p2,
  input  wire [2:0]   fddc_weight_m1,
  input  wire [2:0]   fddc_weight_m2,
  
  /*****************************************************************************
  * sb
  *****************************************************************************/
  input  wire [ 9:0]  t0_index,
  input  wire [23:0]  t0_sb,
  output reg          t1_sb_sgn,
  output reg  [22:0]  t1_sb_abs
);

  /* select round shift depending the sb index */
  reg [2:0]  rndsel;
  always @(*)
    if(fddc_en)
      case(t0_index)
        10'b1111111110: rndsel = fddc_weight_m2;
        10'b1111111111: rndsel = fddc_weight_m1;
        10'b0000000001: rndsel = fddc_weight_p1;
        10'b0000000010: rndsel = fddc_weight_p2;
        default:      rndsel = 3'd0;
      endcase
    else
      rndsel = 3'd0;
  
  /* shifter */
  wire [24:0]  sb_sh1,sb_sh2,sb_sh;
  wire [23:0]  n_t1_sb;
  wire         n_t1_sb_sgn;
  wire [23:0]  n_t1_sb_neg;
  wire [22:0]  n_t1_sb_neg_sat23;
  
  /* note: input operand is 1 bit left shifted in order to observe 
           the result bit of weight 2**0.5, for roundign purpose */
  assign sb_sh1            = rndsel[0]?{t0_sb[23],t0_sb}:{t0_sb,1'b0};  
  assign sb_sh2            = rndsel[1]?{{2{sb_sh1[24]}},sb_sh1[24:2]}:sb_sh1; 
  assign sb_sh             = rndsel[2]?{{4{sb_sh2[24]}},sb_sh2[24:4]}:sb_sh2; 
  assign n_t1_sb           = sb_sh[24:1] + {23'b0,sb_sh[0]};            
  assign n_t1_sb_sgn       = n_t1_sb[23];
  
  assign n_t1_sb_neg       = ~n_t1_sb + 24'd1;
  assign n_t1_sb_neg_sat23 = n_t1_sb_neg[22:0] | {23{n_t1_sb_neg[23]}};
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t1_sb_abs <= 23'b0;
      t1_sb_sgn <= 1'b0;
    end
    else
    begin
      t1_sb_sgn <= n_t1_sb_sgn;
      if(!n_t1_sb_sgn)
        t1_sb_abs <= n_t1_sb[22:0];
      else
        t1_sb_abs <= n_t1_sb_neg_sat23;
    end
endmodule
`default_nettype wire
