/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_sbc
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire        clk,
  input  wire        rst_n,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire        enable,

  /*****************************************************************************
  * parameters
  *****************************************************************************/
  input wire [ 8:0]  nsd,
  input wire [27:0]  mh_x_satsb,
  input wire [15:0]  mh_x_satsb_rnd12,
`ifdef RW_MUMIMO_RX_EN
  input wire         vht_sigb_inv,
`endif // RW_MUMIMO_RX_EN
  
  /*****************************************************************************
  * sb
  *****************************************************************************/
  input wire         t0_valid,
  input wire [18:0]  t0_d,
  input wire         t0_accu_en,
  input wire         t0_sb_sgn,
  input wire [22:0]  t0_sb_abs,
  
  /*****************************************************************************
  * sb
  *****************************************************************************/
  output reg         t6_valid,
  output reg [4:0]   t6_sbc
);
  /*****************************************************************************
  * declaration
  *****************************************************************************/
  /* t0 */
  wire [23:0] t0_dx2;
  wire        t0_sb_gt_dx2;
  wire [23:0] t0_strong_sb;
  wire [22:0] t0_sb_abs_minus_d;
  /* t1 */
  wire [23:0] n_t1_sbe_abs;
  reg         t1_valid;
  reg         t1_accu_en;
  reg         t1_sbe_sgn;
  reg  [23:0] t1_sbe_abs;
  
  /* t3 */
  wire        t3_valid;
  wire [32:0] t3_accu;
 
  reg [15:0] static_mh_x_satsb_rnd12;
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      static_mh_x_satsb_rnd12 <= 16'b0;
    else
      static_mh_x_satsb_rnd12 <= mh_x_satsb_rnd12;
    
  /*****************************************************************************
  * t0 strong softbit enhancement
  *
  * t0_sb          [-2**23      2**23-1] => 24 bits
  * abs(t0_sb)     [     0        2**23] => 24 bits (because bound is not 2**23-1)
  * 234*abs(t0_sb) [     0   1962934272] => 31 bits
  * accu           [     0 1962934272*2] => 32 bits
  *
  *****************************************************************************/
  assign t0_dx2        = {4'b0,t0_d,1'b0};
  assign t0_sb_gt_dx2  = {1'b0,t0_sb_abs} > t0_dx2;
  
  /* strong bit computation */
  assign t0_sb_abs_minus_d = t0_sb_abs - {4'b0,t0_d};
  assign t0_strong_sb  = {t0_sb_abs_minus_d,1'b0};
 
  /* sb/strong sb selection */
  assign n_t1_sbe_abs  = t0_sb_gt_dx2?t0_strong_sb:{1'b0,t0_sb_abs};
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t1_valid   <=  1'b0;
      t1_accu_en <=  1'b0;
      t1_sbe_sgn <=  1'b0;
      t1_sbe_abs <= 24'b0;
    end
    else if(!enable)
    begin
      t1_valid   <=  1'b0;
      t1_accu_en <=  1'b0;
      t1_sbe_sgn <=  1'b0;
      t1_sbe_abs <= 24'b0;
    end
    else
    begin
      t1_valid   <=  t0_valid;
      t1_accu_en <=  t0_accu_en;
      t1_sbe_sgn <=  t0_sb_sgn;
      t1_sbe_abs <=  n_t1_sbe_abs;
    end
  
  /*****************************************************************************
  * t1-t2  nsd product and accumulator
  *****************************************************************************/
  equalizer_sbc_accu u_equalizer_sbc_accu
  (
    /***************************************************************************
    * system
    ***************************************************************************/
    .rst_n(         rst_n),
    .clk(           clk),
    .enable(        enable),
  
    /***************************************************************************
    * operands
    ***************************************************************************/
    .nsd(           nsd),
    .t0_valid(      t1_valid),
    .t0_accu_en(    t1_accu_en),
    .t0_sgn(        t1_sbe_sgn),
    .t0_abs(        t1_sbe_abs),
  
    /***************************************************************************
    * result
    ***************************************************************************/
    .t2_valid(      t3_valid),
    .t2_accu(       t3_accu)
  );
    
  /* restore sgn/abs encoding */
  wire        t3_accu_gt_mhxsatsb;
  wire        t3_accu_sgn;
  wire [32:0] t3_accu_neg,t3_accu_abs;
  
  assign t3_accu_neg         = ~t3_accu+33'd1;
  assign t3_accu_sgn         = t3_accu[32];
  assign t3_accu_abs         = t3_accu_sgn?t3_accu_neg:t3_accu;
  assign t3_accu_gt_mhxsatsb = t3_accu_abs > {5'b0,mh_x_satsb};
  
  wire [19:0]  t3_accu_rnd12;
  assign t3_accu_rnd12 = t3_accu_abs[31:12] + {19'b0,t3_accu_abs[11]};

  /* round by 12 bits /saturate to 19 */
  wire [18:0]  t3_accu_rnd12_sat19;
  assign t3_accu_rnd12_sat19 = t3_accu_rnd12[18:0] | {19{t3_accu_rnd12[19]}};
  
  reg         t4_valid;
  reg         t4_accu_sgn;
  reg         t4_accu_gt_mhxsatsb;
  reg  [18:0] t4_accu_rnd12_sat19;
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t4_valid            <= 1'b0;
      t4_accu_sgn         <= 1'b0;
      t4_accu_gt_mhxsatsb <= 1'b0;
      t4_accu_rnd12_sat19 <= 19'b0;
    end
    else if(!enable)
    begin
      t4_valid            <= 1'b0;
      t4_accu_sgn         <= 1'b0;
      t4_accu_gt_mhxsatsb <= 1'b0;
      t4_accu_rnd12_sat19 <= 19'b0;
    end
    else
    begin
      t4_valid            <= t3_valid;
      t4_accu_sgn         <= t3_accu_sgn;
      t4_accu_gt_mhxsatsb <= t3_accu_gt_mhxsatsb;
      t4_accu_rnd12_sat19 <= t3_accu_rnd12_sat19;
    end
    
  wire [22:0]  t4_accu_x15;
  assign t4_accu_x15 = {t4_accu_rnd12_sat19,4'b0} - {4'b0,t4_accu_rnd12_sat19};
  
  /*****************************************************************************
  * euclidian divider 
  *****************************************************************************/
  wire [23:0]  t4_op_4,t4_op_3,t4_op_2;
  wire [23:0]  t4_dividend_4,t4_dividend_3;
  wire         t4_divisor_4,t4_divisor_3;
  
  assign t4_op_4       = {1'b0,t4_accu_x15};
  assign t4_dividend_4 = t4_op_4 - {5'b0,static_mh_x_satsb_rnd12,3'b0};
  assign t4_divisor_4  = ~t4_dividend_4[23];
  
  assign t4_op_3       = t4_dividend_4[23]?t4_op_4:t4_dividend_4;
  assign t4_dividend_3 = t4_op_3 - {6'b0,static_mh_x_satsb_rnd12,2'b0};
  assign t4_divisor_3  = ~t4_dividend_3[23];

  assign t4_op_2       = t4_dividend_3[23]?t4_op_3:t4_dividend_3;
  
  reg         t5_accu_gt_mhxsatsb,t5_accu_sgn;
  reg         t5_valid;
  reg         t5_divisor_4,t5_divisor_3;
  reg  [23:0] t5_op_2;
  wire [23:0] t5_op_1,t5_op_0;
  wire [23:0] t5_dividend_2,t5_dividend_1;
  wire        t5_divisor_2,t5_divisor_1,t5_divisor_0;
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t5_valid            <= 1'b0;  
      t5_accu_sgn         <= 1'b0;
      t5_accu_gt_mhxsatsb <= 1'b0;
      t5_divisor_4        <= 1'b0;  
      t5_divisor_3        <= 1'b0;  
      t5_op_2             <= 24'b0; 
    end
    else if(!enable)
    begin
      t5_valid            <= 1'b0;  
      t5_accu_sgn         <= 1'b0;
      t5_accu_gt_mhxsatsb <= 1'b0;
      t5_divisor_4        <= 1'b0;  
      t5_divisor_3        <= 1'b0;  
      t5_op_2             <= 24'b0; 
    end
    else
    begin
      t5_valid            <= t4_valid;
      t5_accu_sgn         <= t4_accu_sgn;
      t5_accu_gt_mhxsatsb <= t4_accu_gt_mhxsatsb;
      t5_divisor_4        <= t4_divisor_4;
      t5_divisor_3        <= t4_divisor_3;
      t5_op_2             <= t4_op_2;
    end
  
  assign t5_dividend_2 = t5_op_2 - {7'b0,static_mh_x_satsb_rnd12,1'b0};
  assign t5_divisor_2  = ~t5_dividend_2[23];

  assign t5_op_1       = t5_dividend_2[23]?t5_op_2:t5_dividend_2;
  assign t5_dividend_1 = t5_op_1 - {8'b0,static_mh_x_satsb_rnd12};
  assign t5_divisor_1  = ~t5_dividend_1[23];

  assign t5_op_0       = t5_dividend_1[23]?t5_op_1:t5_dividend_1;
  assign t5_divisor_0  = (static_mh_x_satsb_rnd12==16'd0) | ({t5_op_0,1'b0}>{9'b0,static_mh_x_satsb_rnd12});
  
  wire [4:0] n_t6_sbc,n_t6_sbc_sat5_pos,n_t6_sbc_sat5_neg;
  
  assign n_t6_sbc = 
    {1'b0,t5_divisor_4,t5_divisor_3,t5_divisor_2,t5_divisor_1} +
    {1'b0,        1'b0,        1'b0,        1'b0,t5_divisor_0};
  
  assign n_t6_sbc_sat5_pos = n_t6_sbc[4] ? 5'd0 : {1'b0,n_t6_sbc[3:0]};
  assign n_t6_sbc_sat5_neg = ~n_t6_sbc_sat5_pos + 5'd1;
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t6_valid <= 1'b0;
      t6_sbc   <= 5'b0;
    end
    else if(!enable)
    begin
      t6_valid <= 1'b0;
      t6_sbc   <= 5'b0;
    end
    else
    begin
      t6_valid <= 1'b0;       
      if(t5_valid)
      begin
        t6_valid <= 1'b1;
        if(t5_accu_gt_mhxsatsb)
        begin
          if(!t5_accu_sgn
`ifdef RW_MUMIMO_RX_EN
           ^ vht_sigb_inv   // In Mu-MIMO, user position 3, VHT-SIG-B softbits are inversed
`endif // RW_MUMIMO_RX_EN
          )
            t6_sbc <= 5'b01111;
          else
            t6_sbc <= 5'b10001;
        end
        else
        begin
          if(!t5_accu_sgn
`ifdef RW_MUMIMO_RX_EN
           ^ vht_sigb_inv   // In Mu-MIMO, user position 3, VHT-SIG-B softbits are inversed
`endif // RW_MUMIMO_RX_EN
          )
            t6_sbc <= n_t6_sbc_sat5_pos;
          else
            t6_sbc <= n_t6_sbc_sat5_neg;
        end
      end
    end
endmodule
`default_nettype wire
