/*******************************************************************************
* Copyright (C) by RivieraWaves.
* This module is a confidential and proprietary property of RivieraWaves
* and a possession or use of this module requires written permission
* from RivieraWaves.
********************************************************************************
* Company: RivieraWaves
* $Author: $
********************************************************************************
* $Revision: $
* $Date: $
********************************************************************************
* Dependencies     : None
* Description      : 
* Simulation Notes : 
* Synthesis Notes  :
* Application Note :
* Simulator        :
* Parameters       :
* Terms & concepts :
* Bugs             :
* Open issues and future enhancements :
* References       :
* Revision History :
********************************************************************************
* $HeadURL: $
*******************************************************************************/
`default_nettype none
module equalizer_sbc_accu
(
  /*****************************************************************************
  * system
  *****************************************************************************/
  input  wire         rst_n,
  input  wire         clk,

  /*****************************************************************************
  * control
  *****************************************************************************/
  input  wire         enable,
  
  /*****************************************************************************
  * operands
  *****************************************************************************/
  input  wire [ 8:0]  nsd,
  input  wire         t0_valid,
  input  wire         t0_accu_en,
  input  wire         t0_sgn,
  input  wire [23:0]  t0_abs,
  
  /*****************************************************************************
  * result
  *****************************************************************************/
  output reg          t2_valid,
  output reg  [32:0]  t2_accu
);
  
  reg  [8:0] static_nsd;
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
      static_nsd <= 9'b0; 
    else
      static_nsd <= nsd;

  /*****************************************************************************
  * t0 partial product low part
  *****************************************************************************/
  wire [2:0]  pp0l_gen,pp2l_gen,pp4l_gen,pp6l_gen,pp8l_gen;
  reg         pp0l_fix,pp2l_fix,pp4l_fix,pp6l_fix,pp8l_fix;
  reg  [15:0] pp0l;
  reg  [13:0] pp2l;
  reg  [11:0] pp4l;
  reg  [ 9:0] pp6l;
  reg  [ 7:0] pp8l;
  wire [ 2:0] n_t1_accu_carry;
  wire [15:0] n_t1_accu_15_0;
  reg         t1_valid,t1_accu_en;
  reg         t1_sgn;
  reg  [23-7:7-7] t1_abs;
  reg  [ 2:0] t1_accu_carry;
  reg  [15:0] t1_accu_15_0;
  
  /* booth recoding */
  assign pp0l_gen = {3{t0_sgn}}^{static_nsd[1:0],1'b0};
  assign pp2l_gen = {3{t0_sgn}}^{static_nsd[3:1]};
  assign pp4l_gen = {3{t0_sgn}}^{static_nsd[5:3]};
  assign pp6l_gen = {3{t0_sgn}}^{static_nsd[7:5]};
  assign pp8l_gen = {3{t0_sgn}}^{1'b0,static_nsd[8:7]};
 
  /* pp0l */
  always @(*)
    case(pp0l_gen)
      3'b000:  {pp0l_fix,pp0l} = {1'b0,                   16'b0}; /*  0 */   
      3'b001:  {pp0l_fix,pp0l} = {1'b0,            t0_abs[15:0]}; /* +1 */   
      3'b010:  {pp0l_fix,pp0l} = {1'b0,            t0_abs[15:0]}; /* +1 */   
      3'b011:  {pp0l_fix,pp0l} = {1'b0,       t0_abs[14:0],1'b0}; /* +2 */   
      3'b100:  {pp0l_fix,pp0l} = {1'b1,      ~t0_abs[14:0],1'b1}; /* -2 */   
      3'b101:  {pp0l_fix,pp0l} = {1'b1,           ~t0_abs[15:0]}; /* -1 */
      3'b110:  {pp0l_fix,pp0l} = {1'b1,           ~t0_abs[15:0]}; /* -1 */
      default: {pp0l_fix,pp0l} = {1'b0,                   16'b0}; /*  0 */   
    endcase   
 
  /* pp2l */
  always @(*)
    case(pp2l_gen)
      3'b000:  {pp2l_fix,pp2l} = {1'b0,                   14'b0}; /*  0 */   
      3'b001:  {pp2l_fix,pp2l} = {1'b0,            t0_abs[13:0]}; /* +1 */
      3'b010:  {pp2l_fix,pp2l} = {1'b0,            t0_abs[13:0]}; /* +1 */
      3'b011:  {pp2l_fix,pp2l} = {1'b0,       t0_abs[12:0],1'b0}; /* +2 */
      3'b100:  {pp2l_fix,pp2l} = {1'b1,      ~t0_abs[12:0],1'b1}; /* -2 */
      3'b101:  {pp2l_fix,pp2l} = {1'b1,           ~t0_abs[13:0]}; /* -1 */
      3'b110:  {pp2l_fix,pp2l} = {1'b1,           ~t0_abs[13:0]}; /* -1 */
      default: {pp2l_fix,pp2l} = {1'b0,                   14'b0}; /*  0 */   
    endcase   
    
  /* pp4l */
  always @(*)
    case(pp4l_gen)
      3'b000:  {pp4l_fix,pp4l} = {1'b0,                   12'b0}; /*  0 */   
      3'b001:  {pp4l_fix,pp4l} = {1'b0,            t0_abs[11:0]}; /* +1 */
      3'b010:  {pp4l_fix,pp4l} = {1'b0,            t0_abs[11:0]}; /* +1 */
      3'b011:  {pp4l_fix,pp4l} = {1'b0,       t0_abs[10:0],1'b0}; /* +2 */
      3'b100:  {pp4l_fix,pp4l} = {1'b1,      ~t0_abs[10:0],1'b1}; /* -2 */
      3'b101:  {pp4l_fix,pp4l} = {1'b1,           ~t0_abs[11:0]}; /* -1 */
      3'b110:  {pp4l_fix,pp4l} = {1'b1,           ~t0_abs[11:0]}; /* -1 */
      default: {pp4l_fix,pp4l} = {1'b0,                   12'b0}; /*  0 */   
    endcase   
 
  /* pp6l */
  always @(*)
    case(pp6l_gen)
      3'b000:  {pp6l_fix,pp6l} = {1'b0,                   10'b0}; /*  0 */   
      3'b001:  {pp6l_fix,pp6l} = {1'b0,            t0_abs[ 9:0]}; /* +1 */   
      3'b010:  {pp6l_fix,pp6l} = {1'b0,            t0_abs[ 9:0]}; /* +1 */   
      3'b011:  {pp6l_fix,pp6l} = {1'b0,       t0_abs[ 8:0],1'b0}; /* +2 */   
      3'b100:  {pp6l_fix,pp6l} = {1'b1,      ~t0_abs[ 8:0],1'b1}; /* -2 */   
      3'b101:  {pp6l_fix,pp6l} = {1'b1,           ~t0_abs[ 9:0]}; /* -1 */   
      3'b110:  {pp6l_fix,pp6l} = {1'b1,           ~t0_abs[ 9:0]}; /* -1 */
      default: {pp6l_fix,pp6l} = {1'b0,                   10'b0}; /*  0 */   
    endcase   
    
  /*pp8l */
  always @(*)
    case(pp8l_gen)
      3'b000:  {pp8l_fix,pp8l} = {1'b0,                    8'b0}; /*  0 */   
      3'b001:  {pp8l_fix,pp8l} = {1'b0,            t0_abs[ 7:0]}; /* +1 */   
      3'b010:  {pp8l_fix,pp8l} = {1'b0,            t0_abs[ 7:0]}; /* +1 */   
      3'b011:  {pp8l_fix,pp8l} = {1'b0,       t0_abs[ 6:0],1'b0}; /* +2 */   
      3'b100:  {pp8l_fix,pp8l} = {1'b1,      ~t0_abs[ 6:0],1'b1}; /* -2 */   
      3'b101:  {pp8l_fix,pp8l} = {1'b1,           ~t0_abs[ 7:0]}; /* -1 */   
      3'b110:  {pp8l_fix,pp8l} = {1'b1,           ~t0_abs[ 7:0]}; /* -1 */
      default: {pp8l_fix,pp8l} = {1'b0,                    8'b0}; /*  0 */   
    endcase   
  
  /* sum partial products/accu low part */
  assign {n_t1_accu_carry,n_t1_accu_15_0} =    
    ({3'b0, t1_accu_15_0}&{19{t1_accu_en}}) +   
    { 3'b0,                     pp0l}  +  
    { 3'b0,                pp2l,2'b0}  +  
    { 3'b0,                pp4l,4'b0}  +  
    { 3'b0,                pp6l,6'b0}  +  
    { 3'b0,                pp8l,8'b0}  +  
    {10'b0,pp8l_fix,1'b0,pp6l_fix,1'b0,pp4l_fix,1'b0,pp2l_fix,1'b0,pp0l_fix};
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t1_valid      <= 1'b0;
      t1_accu_en    <= 1'b0;
      t1_sgn        <= 1'b0;
      t1_abs        <= 17'b0;
      t1_accu_carry <= 3'b0;
      t1_accu_15_0  <= 16'b0; 
    end
    else if(!enable)
    begin
      t1_valid      <= 1'b0;
      t1_accu_en    <= 1'b0;
      t1_sgn        <= 1'b0;
      t1_abs        <= 17'b0;
      t1_accu_carry <= 3'b0;
      t1_accu_15_0  <= 16'b0; 
    end
    else
    begin
      t1_valid      <= t0_valid;
      t1_accu_en    <= t0_accu_en;
      t1_sgn        <= t0_sgn;
      t1_abs        <= t0_abs[23:7]; 
      t1_accu_carry <= n_t1_accu_carry;
      t1_accu_15_0  <= n_t1_accu_15_0; 
    end
 
  /*****************************************************************************
  * t1 partial product high part
  *****************************************************************************/
  wire [ 2:0] pp0h_gen,pp2h_gen,pp4h_gen,pp6h_gen,pp8h_gen;
  reg  [ 9:0] pp0h;
  reg  [11:0] pp2h;
  reg  [13:0] pp4h;
  reg  [15:0] pp6h;
  reg  [16:0] pp8h;
  wire [16:0] n_t2_accu_32_16;
  reg         t2_accu_en;
  
  /* booth recoding */
  assign  pp0h_gen = {3{t1_sgn}}^{static_nsd[1:0],1'b0};
  assign  pp2h_gen = {3{t1_sgn}}^{static_nsd[3:1]};
  assign  pp4h_gen = {3{t1_sgn}}^{static_nsd[5:3]};
  assign  pp6h_gen = {3{t1_sgn}}^{static_nsd[7:5]};
  assign  pp8h_gen = {3{t1_sgn}}^{1'b0,static_nsd[8:7]};
 
  /* pp0h */
  always @(*)
    case(pp0h_gen)
      3'b000:  pp0h = {                      10'b0}; /*  0 */    
      3'b001:  pp0h = {       2'b00, t1_abs[23-7:16-7]}; /* +1 */    
      3'b010:  pp0h = {       2'b00, t1_abs[23-7:16-7]}; /* +1 */    
      3'b011:  pp0h = {        1'b0, t1_abs[23-7:15-7]}; /* +2 */    
      3'b100:  pp0h = {        1'b1,~t1_abs[23-7:15-7]}; /* -2 */    
      3'b101:  pp0h = {       2'b11,~t1_abs[23-7:16-7]}; /* -1 */       
      3'b110:  pp0h = {       2'b11,~t1_abs[23-7:16-7]}; /* -1 */
      default: pp0h = {                      10'b0}; /*  0 */    
    endcase   
 
  /* pp2h */
  always @(*)
    case(pp2h_gen)
      3'b000:  pp2h = {                      12'b0}; /*  0 */   
      3'b001:  pp2h = {       2'b00, t1_abs[23-7:14-7]}; /* +1 */   
      3'b010:  pp2h = {       2'b00, t1_abs[23-7:14-7]}; /* +1 */   
      3'b011:  pp2h = {        1'b0, t1_abs[23-7:13-7]}; /* +2 */   
      3'b100:  pp2h = {        1'b1,~t1_abs[23-7:13-7]}; /* -2 */   
      3'b101:  pp2h = {       2'b11,~t1_abs[23-7:14-7]}; /* -1 */   
      3'b110:  pp2h = {       2'b11,~t1_abs[23-7:14-7]}; /* -1 */   
      default: pp2h = {                      12'b0}; /*  0 */   
    endcase   
    
  /* pp4h */
  always @(*)
    case(pp4h_gen)
      3'b000:  pp4h = {                      14'b0}; /*  0 */   
      3'b001:  pp4h = {       2'b00, t1_abs[23-7:12-7]}; /* +1 */   
      3'b010:  pp4h = {       2'b00, t1_abs[23-7:12-7]}; /* +1 */   
      3'b011:  pp4h = {        1'b0, t1_abs[23-7:11-7]}; /* +2 */   
      3'b100:  pp4h = {        1'b1,~t1_abs[23-7:11-7]}; /* -2 */   
      3'b101:  pp4h = {       2'b11,~t1_abs[23-7:12-7]}; /* -1 */   
      3'b110:  pp4h = {       2'b11,~t1_abs[23-7:12-7]}; /* -1 */   
      default: pp4h = {                      14'b0}; /*  0 */   
    endcase   
 
  /* pp6h */
  always @(*)
    case(pp6h_gen)
      3'b000:  pp6h = {                      16'b0}; /*  0 */   
      3'b001:  pp6h = {       2'b00, t1_abs[23-7:10-7]}; /* +1 */   
      3'b010:  pp6h = {       2'b00, t1_abs[23-7:10-7]}; /* +1 */   
      3'b011:  pp6h = {        1'b0, t1_abs[23-7: 9-7]}; /* +2 */   
      3'b100:  pp6h = {        1'b1,~t1_abs[23-7: 9-7]}; /* -2 */   
      3'b101:  pp6h = {       2'b11,~t1_abs[23-7:10-7]}; /* -1 */   
      3'b110:  pp6h = {       2'b11,~t1_abs[23-7:10-7]}; /* -1 */   
      default: pp6h = {                      16'b0}; /*  0 */   
    endcase   
    
  /*pp8h */
  always @(*)
    case(pp8h_gen)
      3'b000:  pp8h = {                      17'b0}; /*  0 */    
      3'b001:  pp8h = {        1'b0, t1_abs[23-7: 8-7]}; /* +1 */    
      3'b010:  pp8h = {        1'b0, t1_abs[23-7: 8-7]}; /* +1 */  
      3'b011:  pp8h = {              t1_abs[23-7: 7-7]}; /* +2 */  
      3'b100:  pp8h = {             ~t1_abs[23-7: 7-7]}; /* -2 */  
      3'b101:  pp8h = {        1'b1,~t1_abs[23-7: 8-7]}; /* -1 */  
      3'b110:  pp8h = {        1'b1,~t1_abs[23-7: 8-7]}; /* -1 */  
      default: pp8h = {                      17'b0}; /*  0 */    
    endcase   
  
  /* sum partial products/accu high part */
  assign n_t2_accu_32_16 =    
    (t2_accu[32:16]&{17{t2_accu_en}}) +   
    {4'b0000,     ~pp0h[9], pp0h[9],  pp0h[9], pp0h}  +    
    {4'b0001,                       ~pp2h[11], pp2h}  + 
    {2'b01,                         ~pp4h[13], pp4h}  + 
    {                               ~pp6h[15], pp6h}  + 
    {                                    pp8h[16:0]}  +
    {14'b0,                           t1_accu_carry};
  
  always @(posedge clk, negedge rst_n)
    if(!rst_n)
    begin
      t2_valid   <= 1'b0;
      t2_accu_en <= 1'b0;
      t2_accu    <= 33'b0;
    end
    else if(!enable)
    begin
      t2_valid   <= 1'b0;
      t2_accu_en <= 1'b0;
      t2_accu    <= 33'b0;
    end
    else
    begin
      t2_valid   <= 1'b0;
      t2_accu_en <= t1_accu_en;
      if(t1_valid)
      begin
        t2_valid <= ~t1_accu_en;
        t2_accu  <= {n_t2_accu_32_16,t1_accu_15_0};
      end
    end

endmodule
`default_nettype wire
