#!/usr/bin/perl
################################################################################
# Copyright (C) by RivieraWaves.
# This module is a confidential and proprietary property of RivieraWaves
# and a possession or use of this module requires written permission
# from RivieraWaves.
################################################################################
# Company: RivieraWaves
# $Author: $
################################################################################
# $Revision: $
# $Date: $
################################################################################
# Dependencies     : None
# Description      : 
# Simulation Notes : 
# Synthesis Notes  :
# Application Note :
# Simulator        :
# Parameters       :
# Terms & concepts :
# Bugs             :
# Open issues and future enhancements :
# References       :
# Revision History :
################################################################################
# $HeadURL: $
################################################################################
# generate the index/address tables for the equalizer_genindex.v module
use strict;
no strict 'refs';



my ($l,$k,$hg);                                           
my (@leg_index,@leg_hg);
my (@ht20_index,@ht20_hg);
my (@ht40_index,@ht40_hg);
my (@ht80_index,@ht80_hg);
my %ht40_hg_vs_index;
$hg = 2;                                                                     
$k  = 0;
for(my $stride=0;$stride<2;$stride++)
{
  for(my $sc=-26;$sc<=+26;$sc++)                                               
  {                                                                            
    # skip dc                                                                  
    if($sc==0)                                                                 
    {                                                                          
      next;                                                                    
    }                                                                          
                                                                               
    # skip pilot                                                               
    if($sc==-21 || $sc==-7 || $sc==7 || $sc==21)                               
    {                                                                          
      $hg++;                                                                   
      next;                                                                    
    }                                                                          
                                                                               
    # display                                                                  
    @leg_index[$k] = $sc;                                                      
    @leg_hg[$k]    = $hg;                                                      
                                                                               
    # update                                                                   
    $hg++;                                                                     
    $k++;                                                                      
  } 

  $hg = 0;
  $k  = 0;                                                                     
  for(my $sc=-28;$sc<=+28;$sc++)                                               
  {                                                                            
    # skip dc                                                                  
    if($sc==0)                                                                 
    {                                                                          
      next;                                                                    
    }                                                                          
                                                                               
    # skip pilot                                                               
    if($sc==-21 || $sc==-7 || $sc==7 || $sc==21)                               
    {                                                                          
      $hg++;                                                                   
      next;                                                                    
    }                                                                          
                                                                               
    # display                                                                  
    @ht20_index[$k] = $sc;                                                      
    @ht20_hg[$k]    = $hg;                                                      
    # update                                                                   
    $hg++;                                                                     
    $k++;                                                                      
  }

  $hg = 0; 
  $k  = 0;                                                                    
  for(my $sc=-58;$sc<=+58;$sc++)                                               
  {                                                                            
    # skip dc                                                                  
    if($sc==0 || $sc==-1 || $sc==1 )                                           
    {                                                                          
      next;                                                                    
    }                                                                          
                                                                               
    # skip pilot                                                               
    if($sc==-53 || $sc==-25 || $sc==-11 ||                                     
       $sc== 11 || $sc== 25 || $sc== 53)                                       
    {                                                                          
      $hg++;                                                                   
      next;                                                                    
    }                                                                          
                                                                               
    # display                                                                  
    @ht40_index[$k] = $sc;                                                      
    @ht40_hg[$k]    = $hg;                                                      
    $ht40_hg_vs_index{$sc}=$hg;
                                                                               
    # update                                                                   
    $hg++;                                                                     
    $k++;                                                                      
  }                                                                            

  $hg = 0;
  $k  = 0;
  for(my $sc=-122;$sc<=+122;$sc++)                                             
  {                                                                            
    # skip dc                                                                  
    if($sc==0 || $sc==-1 || $sc==1 )                                           
    {                                                                          
      next;                                                                    
    }                                                                          
                                                                               
    # skip pilot                                                               
    if($sc==-103 || $sc==-75 || $sc==-39 || $sc==-11 ||                        
       $sc==11 || $sc==39 || $sc==75 || $sc==103)                              
    {                                                                          
      $hg++;                                                                   
      next;                                                                    
    }                                                                          
                                                                               
    # display                                                                  
    @ht80_index[$k] = $sc;                                                      
    @ht80_hg[$k]    = $hg;                                                      
                                                                               
    # update                                                                   
    $hg++;                                                                     
    $k++;                                                                      
  }                                                                            

  printf "  /* MHZ20_LEG */\n";                 
  for(my $k=0;$k<48;$k++)                                               
  {                                                                            
    $l=$k;
    $l = (3*$k)%48 + int(3*$k/48) if($stride==1);
    printf "  assign data_mhz20_leg[%d][%3d] = 16'b",$stride,$k;
    print_bin(@leg_index[$l]);
    printf "_";
    print_bin(@leg_hg[$l]);
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",$k,$l,@leg_index[$l],@leg_hg[$l];
  }  

  for(my $k=48;$k<64;$k++)
  {
    printf  "  assign data_mhz20_leg[%d][%3d] = 16'b0;\n",$stride,$k;
  }

  printf "  /* MHZ40_DUP */\n";                 
  for(my $k=0;$k<48;$k++)                                               
  {                                                                            
    
    $l=$k;
    $l = (3*$k)%48 + int(3*$k/48) if($stride==1);
    printf "  assign data_mhz40_dup[%d][%3d] = 16'b",$stride,(2*$k);
    print_bin(@leg_index[$l]-32);
    printf "_";
    print_bin(@ht40_hg_vs_index{(@leg_index[$l]-32)});
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",(2*$k),$l,(@leg_index[$l]-32),$ht40_hg_vs_index{(@leg_index[$l]-32)};
   
    printf "  assign data_mhz40_dup[%d][%3d] = 16'b",$stride,(2*$k+1);
    print_bin(@leg_index[$l]+32);
    printf "_";
    print_bin($ht40_hg_vs_index{(@leg_index[$l]+32)});
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",(2*$k+1),$l,(@leg_index[$l]+32),$ht40_hg_vs_index{(@leg_index[$l]+32)};
  }  
  for(my $k=96;$k<128;$k++)
  {
    printf  "  assign data_mhz40_dup[%d][%3d] = 16'b0;\n",$stride,$k;
  }

  printf "  /* MHZ20_HT */\n";                 
  for(my $k=0;$k<52;$k++)                                               
  {                                                                            
    $l=$k;
    $l = (4*$k)%52 + int(4*$k/52) if($stride==1);
    printf "  assign data_mhz20_ht[%d][%3d] = 16'b",$stride,$k;
    print_bin(@ht20_index[$l]);
    printf "_";
    print_bin(@ht20_hg[$l]);
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",$k,$l,@ht20_index[$l],@ht20_hg[$l];
  }  
  for(my $k=52;$k<64;$k++)
  {
    printf  "  assign data_mhz20_ht[%d][%3d] = 16'b0;\n",$stride,$k;
  }

  printf "  /* MHZ40_HT */\n";                 
  for(my $k=0;$k<108;$k++)                                               
  {                                                                            
    $l=$k;
    $l = (6*$k)%108 + int(6*$k/108) if($stride==1);
    printf "  assign data_mhz40_ht[%d][%3d] = 16'b",$stride,$k;
    print_bin(@ht40_index[$l]);
    printf "_";
    print_bin(@ht40_hg[$l]);
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",$k,$l,@ht40_index[$l],@ht40_hg[$l];
  }  
  for(my $k=108;$k<128;$k++)
  {
    printf  "  assign data_mhz40_ht[%d][%3d] = 16'b0;\n",$stride,$k;
  }

  printf "`ifdef RW_NX_DERIV_EQU_VHT\n";                 
  printf "  /* MHZ80_HT */\n";                 
  for(my $k=0;$k<234;$k++)                                               
  {                                                                            
    $l=$k;
    $l = (9*$k)%234 + int(9*$k/234) if($stride==1);
    printf "  assign data_mhz80_vht[%d][%3d] = 16'b",$stride,$k;
    print_bin(@ht80_index[$l]);
    printf "_";
    print_bin(@ht80_hg[$l]);
    printf "; /*k=%4d  l=%4d sc=%4d hg=%4d */\n",$k,$l,@ht80_index[$l],@ht80_hg[$l];
  }  
  for(my $k=234;$k<256;$k++)
  {
    printf  "  assign data_mhz80_vht[%d][%3d] = 16'b0;\n",$stride,$k;
  }
  printf "`endif\n";                 
}

sub print_bin
{
  my $v = @_[0];
  for(my $k=0;$k<8;$k++)
  {
    if($v&(1<<(7-$k)))
    {
      printf "1";
    }
    else
    {
      printf "0";
    }
  }
}
